/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.AppInfo;
import com.sendbird.android.ApplicationStateHandler;
import com.sendbird.android.ApplicationUserListQuery;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BlockedUserListQuery;
import com.sendbird.android.ChannelManager;
import com.sendbird.android.Command;
import com.sendbird.android.Connection;
import com.sendbird.android.Emoji;
import com.sendbird.android.EmojiCategory;
import com.sendbird.android.EmojiContainer;
import com.sendbird.android.FriendListQuery;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelChangeLogsParams;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelTotalUnreadMessageCountParams;
import com.sendbird.android.IntRangeComparableUtils;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.JobTask;
import com.sendbird.android.LogLevel;
import com.sendbird.android.LoggerV2;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SocketManager;
import com.sendbird.android.ThreadInfoUpdateEvent;
import com.sendbird.android.User;
import com.sendbird.android.UserListQuery;
import com.sendbird.android.handlers.AllowFriendDiscoveryHandler;
import com.sendbird.android.handlers.GetAllowFriendDiscoveryHandler;
import com.sendbird.android.handlers.SessionHandler;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.conscrypt.Conscrypt;
import org.json.JSONException;
import org.json.JSONObject;

public final class SendBird {
    private static SendBird sInstance;
    private static final Handler sUIThreadHandler;
    private String mAppId;
    private final Context mAppContext;
    private String mPushToken;
    private User mCurrentUser;
    final ApplicationStateHandler applicationHandler = new ApplicationStateHandler();
    final Map<String, UserEventHandler> mUserEventHandlers = new ConcurrentHashMap<String, UserEventHandler>();
    private static boolean mIsTrackingApplicationState;
    private boolean mIsNetworkAwarenessReconnection = true;
    private ConnectivityManager mConnectivityManager;
    private static final AtomicReference<AppState> appState;
    private static final Map<ExtentionFrom, String> exUserAgent;
    private static String ekey;
    private SessionHandler sessionHandler;
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;
    public static final String PUSH_TEMPLATE_DEFAULT = "default";
    public static final String PUSH_TEMPLATE_ALTERNATIVE = "alternative";

    public static void addExtension(String key, String version) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)version)) {
            return;
        }
        ExtentionFrom type = ExtentionFrom.from(key);
        if (type != ExtentionFrom.None) {
            exUserAgent.put(type, version);
        }
    }

    static String getAdditionalData() {
        StringBuilder builder = new StringBuilder();
        builder.append("premium_feature_list").append(",");
        builder.append("file_upload_size_limit").append(",");
        builder.append("application_attributes").append(",");
        builder.append("emoji_hash");
        Logger.i("additionalData : " + builder.toString(), new Object[0]);
        return builder.toString();
    }

    static String makeExUserAgentString() {
        StringBuilder userAgentBuilder = new StringBuilder("Android");
        userAgentBuilder.append("/").append(ExtentionFrom.Core.getValue("3.0.153"));
        for (ExtentionFrom extention : exUserAgent.keySet()) {
            String value = exUserAgent.get((Object)extention);
            userAgentBuilder.append("/").append(extention.getValue(value));
        }
        return userAgentBuilder.toString();
    }

    static int getMaxUnreadMessageCountOnSuperGroup() {
        return Connection.getConnectionConfig().getMaxUnreadCountOnSuperGroup();
    }

    public static void runOnUIThread(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        switch (Options.mThreadOption) {
            case NEW_THREAD: {
                new Thread(){

                    @Override
                    public void run() {
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                }.start();
                break;
            }
            case HANDLER: {
                if (Options.mHandlerForThreadOption == null) break;
                Options.mHandlerForThreadOption.post(runnable);
                break;
            }
            default: {
                if (sUIThreadHandler == null) break;
                sUIThreadHandler.post(runnable);
            }
        }
    }

    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getSDKVersion() {
        return "3.0.153";
    }

    public static String getApplicationId() {
        return SendBird.getInstance().mAppId;
    }

    private boolean setNewApplicationId(String newAppId) {
        boolean result = false;
        if (SendBird.getConnectionState() == ConnectionState.CLOSED) {
            this.setAppId(newAppId);
            result = true;
        }
        return result;
    }

    public static void setLoggerLevel(int level) {
        Logger.setLoggerLevel(level);
    }

    public static void setLoggerLevel(LogLevel logLevel) {
        LoggerV2.setLogLevel(logLevel);
    }

    private void setAppId(String appId) {
        this.mAppId = appId;
    }

    private SendBird(String appId, Context context) {
        this.setAppId(appId);
        this.mAppContext = context;
        if (context != null) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkReceiver mNetworkReceiver = new NetworkReceiver();
            context.registerReceiver((BroadcastReceiver)mNetworkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        SendBird.initConscrypt();
    }

    private static void initConscrypt() {
        try {
            Security.insertProviderAt(Conscrypt.newProvider(), 1);
        }
        catch (NoClassDefFoundError error) {
            System.out.println("[SendBird] To enable TLS 1.3, do not exclude conscrypt from your build.gradle");
            error.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("[SendBird] TLS 1.3 might be disabled for some unknown reason.");
            throwable.printStackTrace();
        }
    }

    protected static SendBird getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    protected static synchronized boolean isInitialized() {
        return sInstance != null;
    }

    public static synchronized boolean init(String appId, Context context) {
        boolean result = true;
        if (sInstance == null) {
            sInstance = new SendBird(appId, context.getApplicationContext());
            APIClient.init(context.getApplicationContext());
            if (SendBird.sInstance.mAppContext instanceof Application) {
                ((Application)SendBird.sInstance.mAppContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)SendBird.sInstance.applicationHandler);
            }
        } else {
            if (appId != null && appId.length() > 0 && SendBird.getApplicationId() != null && appId.equals(SendBird.getApplicationId())) {
                return true;
            }
            result = sInstance.setNewApplicationId(appId);
            SocketManager.getInstance().disconnect(true, null);
        }
        mIsTrackingApplicationState = true;
        SendBird.sInstance.mIsNetworkAwarenessReconnection = true;
        return result;
    }

    public static synchronized boolean initFromForeground(String appId, Context context) {
        boolean result = SendBird.init(appId, context);
        SendBird.getInstance().applicationHandler.onActivityResumedInternal();
        return result;
    }

    static AppState getAppState() {
        return appState.get();
    }

    static synchronized boolean setAppState(AppState state) {
        Logger.d("setAppState. current : " + appState + ", set : " + (Object)((Object)state));
        return appState.compareAndSet(state == AppState.BACKGROUND ? AppState.FOREGROUND : AppState.BACKGROUND, state);
    }

    static boolean isActive() {
        Logger.d("tracking : %s, state : %s", mIsTrackingApplicationState, appState);
        if (mIsTrackingApplicationState) {
            return appState.get() == AppState.FOREGROUND;
        }
        return true;
    }

    @Deprecated
    public static void notifyActivityResumedForOldAndroids() {
    }

    @Deprecated
    public static void notifyActivityPausedForOldAndroids() {
    }

    public static void setAutoBackgroundDetection(boolean enable) {
        mIsTrackingApplicationState = enable;
    }

    public static boolean getAutoBackgroundDetection() {
        return mIsTrackingApplicationState;
    }

    public static void setNetworkAwarenessReconnection(boolean enable) {
        SendBird.getInstance().mIsNetworkAwarenessReconnection = enable;
    }

    public static boolean getNetworkAwarenessReconnection() {
        return SendBird.getInstance().mIsNetworkAwarenessReconnection;
    }

    public static ConnectionState getConnectionState() {
        if (!SendBird.isInitialized()) {
            return ConnectionState.CLOSED;
        }
        return SocketManager.getInstance().getConnectionState();
    }

    public static void connect(String userId, ConnectHandler handler) {
        SendBird._connect(userId, null, null, null, handler);
    }

    public static void connect(String userId, String accessToken, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, null, null, handler);
    }

    public static void connect(String userId, String accessToken, String apiHost, String wsHost, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, apiHost, wsHost, handler);
    }

    private static void _connect(String userId, String accessToken, String apiHost, String wsHost, ConnectHandler handler) {
        SocketManager.getInstance().connect(userId, accessToken, apiHost, wsHost, handler);
    }

    public static synchronized boolean reconnect() {
        return SocketManager.getInstance().reconnect(false);
    }

    public static void setSessionHandler(SessionHandler sessionHandler) {
        SendBird.getInstance().sessionHandler = sessionHandler;
    }

    static SessionHandler getSessionHandler() {
        return SendBird.getInstance().sessionHandler;
    }

    public static void addChannelHandler(String identifier, ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        ChannelManager.getInstance().addChannelHandler(identifier, handler);
    }

    public static ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return ChannelManager.getInstance().removeChannelHandler(identifier);
    }

    public static void removeAllChannelHandlers() {
        ChannelManager.getInstance().removeAllChannelHandlers();
    }

    public static void addUserEventHandler(String identifier, UserEventHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mUserEventHandlers.put(identifier, handler);
    }

    public static UserEventHandler removeUserEventHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mUserEventHandlers.remove(identifier);
    }

    public static void removeAllUserEventHandlers() {
        SendBird.getInstance().mUserEventHandlers.clear();
    }

    public static void addConnectionHandler(String identifier, ConnectionHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SocketManager.getInstance().addConnectionHandler(identifier, handler);
    }

    public static ConnectionHandler removeConnectionHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SocketManager.getInstance().removeConnectionHandler(identifier);
    }

    public static void removeAllConnectionHandlers() {
        SocketManager.getInstance().removeAllConnectionHandlers();
    }

    public static void disconnect(DisconnectHandler handler) {
        SocketManager.getInstance().disconnect(true, handler);
    }

    public static AppInfo getAppInfo() {
        return Connection.getAppInfo();
    }

    public static User getCurrentUser() {
        return SendBird.getInstance().mCurrentUser;
    }

    static void setCurrentUser(User user) {
        SendBird.getInstance().mCurrentUser = user;
    }

    public static long getLastConnectedAt() {
        if (SendBird.getConnectionState() == ConnectionState.OPEN) {
            return Connection.getConnectionConfig().getLastConnectedAt();
        }
        return 0L;
    }

    @Deprecated
    public static UserListQuery createUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.ALL_USER);
    }

    @Deprecated
    public static UserListQuery createUserListQuery(List<String> userIds) {
        return new UserListQuery(UserListQuery.QueryType.FILTERED_USER, userIds);
    }

    public static ApplicationUserListQuery createApplicationUserListQuery() {
        return new ApplicationUserListQuery();
    }

    public static BlockedUserListQuery createBlockedUserListQuery() {
        return new BlockedUserListQuery();
    }

    public static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfoWithProfileImage(nickname, profileImage, null, handler);
    }

    private static void updateCurrentUserInfoWithProfileImage(final String nickname, final File profileImage, final List<String> discoveryKeys, final UserInfoUpdateHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                JsonElement response = APIClient.getInstance().updateUserInfo(nickname, profileImage, discoveryKeys);
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                if (obj.has("require_auth_for_profile_image")) {
                    user.setRequireAuth(obj.get("require_auth_for_profile_image").getAsBoolean());
                }
                return response;
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onUpdated(e);
                }
            }
        });
    }

    public static void updateCurrentUserInfo(String nickname, String profileUrl, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfo(nickname, profileUrl, null, null, handler);
    }

    public static void updateCurrentUserInfo(List<String> preferredLanguages, final UserInfoUpdateHandler handler) {
        if (preferredLanguages == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.updateCurrentUserInfo(null, null, null, preferredLanguages, handler);
    }

    private static void updateCurrentUserInfo(final String nickname, final String profileUrl, final List<String> discoveryKeys, final List<String> preferredLanguages, final UserInfoUpdateHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                JsonElement response = APIClient.getInstance().updateUserInfo(nickname, profileUrl, discoveryKeys, preferredLanguages);
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                user.parsePreferredLanguages(obj);
                return response;
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onUpdated(e);
                }
            }
        });
    }

    public static String getPendingPushToken() {
        return SendBird.getInstance().mPushToken;
    }

    @Deprecated
    public static void registerPushTokenForCurrentUser(final String gcmRegToken, final RegisterPushTokenHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (gcmRegToken == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().registerPushToken(PushTokenType.GCM, gcmRegToken, false, false, false);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onRegistered(e);
                }
            }
        });
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(gcmRegToken, false, handler);
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, boolean unique, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(PushTokenType.GCM, gcmRegToken, unique, false, false, handler);
    }

    static void registerPushTokenForCurrentUserInternal(PushTokenType type, String token, boolean unique, boolean alwaysPushOn, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(type, token, unique, alwaysPushOn, true, handler);
    }

    static void registerPushTokenForCurrentUser(final PushTokenType type, final String token, final boolean unique, final boolean alwaysPushOn, final boolean isInternal, final RegisterPushTokenWithStatusHandler handler) {
        APITaskQueue.addTask(new JobResultTask<PushTokenRegistrationStatus>(){

            @Override
            public PushTokenRegistrationStatus call() throws Exception {
                if (token == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                if (SendBird.getCurrentUser() == null) {
                    SendBird.getInstance().mPushToken = token;
                    return PushTokenRegistrationStatus.PENDING;
                }
                APIClient.getInstance().registerPushToken(type, token, unique, alwaysPushOn, isInternal);
                SendBird.getInstance().mPushToken = null;
                return PushTokenRegistrationStatus.SUCCESS;
            }

            @Override
            public void onResultForUiThread(PushTokenRegistrationStatus result, SendBirdException e) {
                if (handler != null) {
                    handler.onRegistered(result, e);
                }
            }
        });
    }

    public static void unregisterPushTokenForCurrentUser(String gcmRegToken, UnregisterPushTokenHandler handler) {
        SendBird.unregisterPushTokenForCurrentUser(PushTokenType.GCM, gcmRegToken, handler);
    }

    static void unregisterPushTokenForCurrentUser(final PushTokenType type, final String token, final UnregisterPushTokenHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (token == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().unregisterPushToken(type, token);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onUnregistered(e);
                }
            }
        });
    }

    public static void unregisterPushTokenAllForCurrentUser(final UnregisterPushTokenHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                return APIClient.getInstance().unregisterPushTokenAll();
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onUnregistered(e);
                }
            }
        });
    }

    public static void getMyPushTokensByToken(final String token, final PushTokenType type, final GetPushTokensHandler handler) {
        final AtomicReference pushTokensRef = new AtomicReference();
        final AtomicReference tokenType = new AtomicReference();
        final AtomicReference tokenRef = new AtomicReference();
        final AtomicBoolean hasMore = new AtomicBoolean(false);
        APITaskQueue.addTask(new JobResultTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (type == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonObject result = APIClient.getInstance().getMyPushTokens(token, type).getAsJsonObject();
                tokenType.set(result.has("type") ? PushTokenType.from(result.get("type").getAsString()) : PushTokenType.GCM);
                tokenRef.set(result.has("token") ? result.get("token").getAsString() : "");
                hasMore.set(result.has("has_more") && result.get("has_more").getAsBoolean());
                ArrayList<String> pushTokens = new ArrayList<String>();
                JsonArray deviceTokenArray = result.get("device_tokens").getAsJsonArray();
                for (int i = 0; i < deviceTokenArray.size(); ++i) {
                    pushTokens.add(deviceTokenArray.get(i).getAsString());
                }
                pushTokensRef.set(pushTokens);
                return true;
            }

            @Override
            public void onResultForUiThread(Boolean result, SendBirdException e) {
                if (handler != null) {
                    if (e != null) {
                        handler.onResult(null, null, false, null, e);
                    } else {
                        handler.onResult((List)pushTokensRef.get(), (PushTokenType)((Object)tokenType.get()), hasMore.get(), (String)tokenRef.get(), null);
                    }
                }
            }
        });
    }

    public static void setDoNotDisturb(final boolean doNotDisturbOn, final int startHour, final int startMin, final int endHour, final int endMin, final String timezone, final SetDoNotDisturbHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (startHour < 0 || startHour > 23 || startMin < 0 || startMin > 59 || endHour < 0 || endHour > 23 || endMin < 0 || endMin > 59) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().setDoNotDisturb(doNotDisturbOn, startHour, startMin, endHour, endMin, timezone);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void getDoNotDisturb(final GetDoNotDisturbHandler handler) {
        APITaskQueue.addTask(new JobTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    JsonObject obj = APIClient.getInstance().getDoNotDisturb().getAsJsonObject();
                    final boolean isDisturbOn = obj.get("do_not_disturb").getAsBoolean();
                    final int startHour = obj.get("start_hour").getAsInt();
                    final int startMin = obj.get("start_min").getAsInt();
                    final int endHour = obj.get("end_hour").getAsInt();
                    final int endMin = obj.get("end_min").getAsInt();
                    final String timezone = obj.get("timezone").getAsString();
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(isDisturbOn, startHour, startMin, endHour, endMin, timezone, null);
                            }
                        });
                    }
                }
                catch (SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(false, 0, 0, 0, 0, null, e);
                        }
                    });
                }
                return true;
            }
        });
    }

    public static void setSnoozePeriod(final boolean snoozeOn, final long startTs, final long endTs, final SetSnoozePeriodHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (startTs >= endTs) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().setSnoozePeriod(snoozeOn, startTs, endTs);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void getSnoozePeriod(final GetSnoozePeriodHandler handler) {
        APITaskQueue.addTask(new JobTask<Boolean>(){

            @Override
            public Boolean call() {
                block3: {
                    try {
                        boolean isSnoozeOn;
                        JsonObject obj = APIClient.getInstance().getSnoozePeriod().getAsJsonObject();
                        String strStartTs = obj.has("snooze_start_ts") && !obj.get("snooze_start_ts").isJsonNull() ? obj.get("snooze_start_ts").getAsString() : "";
                        String strEndTs = obj.has("snooze_end_ts") && !obj.get("snooze_end_ts").isJsonNull() ? obj.get("snooze_end_ts").getAsString() : "";
                        final long startTs = strStartTs.isEmpty() ? 0L : Long.parseLong(strStartTs);
                        final long endTs = strEndTs.isEmpty() ? 0L : Long.parseLong(strEndTs);
                        boolean bl = isSnoozeOn = obj.has("snooze_enabled") && !obj.get("snooze_enabled").isJsonNull() && obj.get("snooze_enabled").getAsBoolean();
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(isSnoozeOn, startTs, endTs, null);
                                }
                            });
                        }
                    }
                    catch (SendBirdException e) {
                        if (handler == null) break block3;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, 0L, 0L, e);
                            }
                        });
                    }
                }
                return true;
            }
        });
    }

    public static void setPushSound(final String sound, final SetPushSoundHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (sound == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().setPushSound(sound);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void getPushSound(final GetPushSoundHandler handler) {
        APITaskQueue.addTask(new JobResultTask<String>(){

            @Override
            public String call() throws Exception {
                JsonObject obj = APIClient.getInstance().getPushSound().getAsJsonObject();
                return obj.has("push_sound") && !obj.get("push_sound").isJsonNull() ? obj.get("push_sound").getAsString() : "";
            }

            @Override
            public void onResultForUiThread(String sound, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(sound, e);
                }
            }
        });
    }

    public static void setPushTemplate(final String templateName, final SetPushTemplateHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (templateName == null) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                return APIClient.getInstance().setPushTemplate(templateName);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void getPushTemplate(final GetPushTemplateHandler handler) {
        APITaskQueue.addTask(new JobResultTask<String>(){

            @Override
            public String call() throws Exception {
                return APIClient.getInstance().getPushTemplate().getAsJsonObject().get("name").getAsString();
            }

            @Override
            public void onResultForUiThread(String name, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(name, e);
                }
            }
        });
    }

    public static void setPushTriggerOption(final PushTriggerOption pushTriggerOption, final SetPushTriggerOptionHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                return APIClient.getInstance().setPushTriggerOption(pushTriggerOption);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void getPushTriggerOption(final GetPushTriggerOptionHandler handler) {
        APITaskQueue.addTask(new JobResultTask<PushTriggerOption>(){

            @Override
            public PushTriggerOption call() throws Exception {
                JsonObject obj = APIClient.getInstance().getPushTriggerOption().getAsJsonObject();
                return obj.has("push_trigger_option") ? PushTriggerOption.from(obj.get("push_trigger_option").getAsString()) : PushTriggerOption.ALL;
            }

            @Override
            public void onResultForUiThread(PushTriggerOption pushTriggerOption, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(pushTriggerOption, e);
                }
            }
        });
    }

    public static void setChannelInvitationPreference(final boolean autoAccept, final SetChannelInvitationPreferenceHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                return APIClient.getInstance().setAutoAcceptInvitation(autoAccept);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void getChannelInvitationPreference(final GetChannelInvitationPreferenceHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return APIClient.getInstance().getAutoAcceptInvitation().getAsJsonObject().get("auto_accept").getAsBoolean();
            }

            @Override
            public void onResultForUiThread(Boolean result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result != null ? result : false, e);
                }
            }
        });
    }

    public static void blockUser(User userToBlock, final UserBlockHandler handler) {
        if (userToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.blockUserWithUserId(userToBlock.getUserId(), handler);
    }

    public static void blockUserWithUserId(final String userIdToBlock, final UserBlockHandler handler) {
        APITaskQueue.addTask(new JobResultTask<User>(){

            @Override
            public User call() throws Exception {
                if (userIdToBlock == null) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                JsonElement response = APIClient.getInstance().blockUser(userIdToBlock);
                return new User(response);
            }

            @Override
            public void onResultForUiThread(User user, SendBirdException e) {
                if (handler != null) {
                    handler.onBlocked(user, e);
                }
            }
        });
    }

    public static void unblockUser(User blockedUser, final UserUnblockHandler handler) {
        if (blockedUser == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.unblockUserWithUserId(blockedUser.getUserId(), handler);
    }

    public static void unblockUserWithUserId(final String blockedUserId, final UserUnblockHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (blockedUserId == null) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                return APIClient.getInstance().unblockUser(blockedUserId);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onUnblocked(e);
                }
            }
        });
    }

    public static void addFriends(final List<String> userIds, final AddFriendsHandler handler) {
        APITaskQueue.addTask(new JobResultTask<List<User>>(){

            @Override
            public List<User> call() throws Exception {
                JsonArray array;
                JsonObject obj;
                if (userIds == null || userIds.size() == 0) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                ArrayList<User> users = new ArrayList<User>();
                JsonElement response = APIClient.getInstance().addFriends(userIds);
                if (response != null && (obj = response.getAsJsonObject()) != null && obj.has("users") && (array = obj.getAsJsonArray("users")) != null) {
                    for (int i = 0; i < array.size(); ++i) {
                        users.add(new User(array.get(i)));
                    }
                }
                return users;
            }

            @Override
            public void onResultForUiThread(List<User> users, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(users, e);
                }
            }
        });
    }

    public static void deleteFriends(final List<String> userIds, final DeleteFriendsHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userIds == null || userIds.size() == 0) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                return APIClient.getInstance().deleteFriends(userIds);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void deleteFriend(final String userId, final DeleteFriendHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (userId == null || userId.length() == 0) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                return APIClient.getInstance().deleteFriend(userId);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void uploadFriendDiscoveries(final Map<String, String> discoveryMap, final UploadFriendDiscoveriesHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (discoveryMap == null || discoveryMap.size() == 0) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                return APIClient.getInstance().uploadFriendDiscoveries(discoveryMap);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void deleteFriendDiscoveries(final List<String> discoveryKeys, final DeleteFriendDiscoveriesHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (discoveryKeys == null || discoveryKeys.size() == 0) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                return APIClient.getInstance().deleteFriendDiscoveries(discoveryKeys);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void deleteFriendDiscovery(final String discoveryKey, final DeleteFriendDiscoveryHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws Exception {
                if (discoveryKey == null || discoveryKey.length() == 0) {
                    throw new SendBirdException("Invalid operation.", 800110);
                }
                return APIClient.getInstance().deleteFriendDiscovery(discoveryKey);
            }

            @Override
            public void onResultForUiThread(JsonElement result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    public static void getFriendChangeLogsByToken(final String token, final GetFriendChangeLogsByTokenHandler handler) {
        APITaskQueue.addTask(new JobTask<Boolean>(){

            @Override
            public Boolean call() {
                block5: {
                    try {
                        JsonObject result = APIClient.getInstance().getFriendChangeLogsByToken(token).getAsJsonObject();
                        JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                        final ArrayList<User> updatedUsers = new ArrayList<User>();
                        for (int i = 0; i < updatedJsonArray.size(); ++i) {
                            updatedUsers.add(new User(updatedJsonArray.get(i)));
                        }
                        JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                        final ArrayList<String> deletedUserIds = new ArrayList<String>();
                        for (int i = 0; i < deletedJsonArray.size(); ++i) {
                            deletedUserIds.add(deletedJsonArray.get(i).getAsString());
                        }
                        final boolean hasMore = result.get("has_more").getAsBoolean();
                        final String token2 = result.get("next").getAsString();
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(updatedUsers, deletedUserIds, hasMore, token2, null);
                                }
                            });
                        }
                    }
                    catch (SendBirdException e) {
                        if (handler == null) break block5;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                }
                return true;
            }
        });
    }

    public static FriendListQuery createFriendListQuery() {
        return new FriendListQuery();
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByToken(String token, List<String> customTypes, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(token, null, customTypes, true, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByTimestamp(long ts, List<String> customTypes, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(null, ts, customTypes, true, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByToken(String token, List<String> customTypes, boolean includeEmpty, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(token, null, customTypes, includeEmpty, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByTimestamp(long ts, List<String> customTypes, boolean includeEmpty, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(null, ts, customTypes, includeEmpty, true, handler);
    }

    public static void getMyGroupChannelChangeLogsByTokenWithParams(String token, GroupChannelChangeLogsParams params, final GetMyGroupChannelChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.getMyGroupChannelChangeLogs(token, null, params.customTypes, params.includeEmpty, params.includeFrozen, handler);
    }

    public static void getMyGroupChannelChangeLogsByTimestampWithParams(long ts, GroupChannelChangeLogsParams params, final GetMyGroupChannelChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.getMyGroupChannelChangeLogs(null, ts, params.customTypes, params.includeEmpty, params.includeFrozen, handler);
    }

    private static void getMyGroupChannelChangeLogs(final String token, final Long ts, final List<String> customTypes, final boolean includeEmpty, final boolean includeFrozen, final GetMyGroupChannelChangeLogsHandler handler) {
        APITaskQueue.addTask(new JobTask<Boolean>(){

            @Override
            public Boolean call() {
                block7: {
                    try {
                        if (ts != null && ts < 0L) {
                            throw new SendBirdException("Invalid Arguments.", 800110);
                        }
                        ArrayList customTypeList = customTypes;
                        if (customTypes != null) {
                            customTypeList = new ArrayList(new LinkedHashSet(customTypes));
                        }
                        GroupChannelChangeLogsParams params = new GroupChannelChangeLogsParams(customTypeList, includeEmpty, includeFrozen);
                        JsonObject result = APIClient.getInstance().getMyGroupChannelChangeLogs(token, ts, params).getAsJsonObject();
                        JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                        final ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
                        for (int i = 0; i < updatedJsonArray.size(); ++i) {
                            updatedChannels.add(GroupChannel.upsert(updatedJsonArray.get(i), false));
                        }
                        JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                        final ArrayList<String> deletedChannelUrls = new ArrayList<String>();
                        for (int i = 0; i < deletedJsonArray.size(); ++i) {
                            deletedChannelUrls.add(deletedJsonArray.get(i).getAsString());
                        }
                        final boolean hasMore = result.get("has_more").getAsBoolean();
                        final String token2 = result.get("next").getAsString();
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onResult(updatedChannels, deletedChannelUrls, hasMore, token2, null);
                                }
                            });
                        }
                    }
                    catch (SendBirdException e) {
                        if (handler == null) break block7;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                }
                return true;
            }
        });
    }

    public static void markAsDelivered(String channelUrl) {
        Logger.d(">> markAsDelivered()");
        GroupChannel.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

            @Override
            public void onResult(GroupChannel channel, SendBirdException e) {
                if (channel != null) {
                    channel.markAsDelivered();
                }
            }
        });
    }

    public static void markAsDelivered(Map<String, String> data) {
        String channelUrl;
        Logger.d(">> markAsDelivered(). data : " + data);
        if (!data.containsKey("sendbird")) {
            Logger.d("Payload does not contain sendbird payload.");
            return;
        }
        JSONObject sendBird = null;
        try {
            sendBird = new JSONObject(data.get("sendbird"));
        }
        catch (JSONException e) {
            Logger.d(e);
        }
        if (sendBird == null) {
            Logger.d("Payload does not contain sendbird payload.");
            return;
        }
        final JSONObject objSendbird = sendBird;
        JSONObject channel = objSendbird.optJSONObject("channel");
        String string = channelUrl = channel == null ? null : channel.optString("channel_url");
        if (channelUrl == null) {
            Logger.d("Payload does not contain channelUrl.");
            return;
        }
        GroupChannel.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

            @Override
            public void onResult(GroupChannel channel, SendBirdException e) {
                if (channel != null) {
                    String tempSessionKey = null;
                    JSONObject sessionKey = objSendbird.optJSONObject("session_key");
                    if (sessionKey != null) {
                        tempSessionKey = sessionKey.optString("key");
                    }
                    channel.markAsDelivered(0L, 0L, tempSessionKey);
                }
            }
        });
    }

    public static void markAsReadAll(MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadAll(null, handler);
    }

    public static void markAsReadWithChannelUrls(List<String> channelUrls, MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadWithChannelUrls(channelUrls, handler);
    }

    public static void getAllEmoji(final GetAllEmojiHandler handler) {
        APITaskQueue.addTask(new JobResultTask<EmojiContainer>(){

            @Override
            public EmojiContainer call() throws Exception {
                JsonElement response = APIClient.getInstance().getAllEmoji();
                return new EmojiContainer(response);
            }

            @Override
            public void onResultForUiThread(EmojiContainer result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static void getEmojiCategory(final long emojiCategoryId, final GetEmojiCategoryHandler handler) {
        APITaskQueue.addTask(new JobResultTask<EmojiCategory>(){

            @Override
            public EmojiCategory call() throws Exception {
                if (emojiCategoryId < 0L) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().getEmojiCategory(emojiCategoryId);
                return new EmojiCategory(response);
            }

            @Override
            public void onResultForUiThread(EmojiCategory result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static void getEmoji(final String key, final GetEmojiHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Emoji>(){

            @Override
            public Emoji call() throws Exception {
                if (key == null || key.length() == 0) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonElement response = APIClient.getInstance().getEmoji(key);
                return new Emoji(response);
            }

            @Override
            public void onResultForUiThread(Emoji result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    void sendCommand(Command cmd, boolean lazy, Command.SendCommandHandler handler) {
        SocketManager.getInstance().sendCommand(cmd, lazy, handler);
    }

    public static void getTotalUnreadMessageCount(GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, null, handler);
    }

    public static void getTotalUnreadMessageCount(List<String> channelCustomTypes, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, channelCustomTypes, handler);
    }

    public static void getTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams params, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(params.mSuperChannelFilter, params.mChannelCustomTypes, handler);
    }

    static void localGetTotalUnreadMessageCount(final GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter superChannelFilter, final List<String> channelCustomTypes, final GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Integer>(){

            @Override
            public Integer call() throws Exception {
                return APIClient.getInstance().getTotalUnreadMessageCount(superChannelFilter, channelCustomTypes).getAsJsonObject().get("unread_count").getAsInt();
            }

            @Override
            public void onResultForUiThread(Integer unreadCount, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(unreadCount != null ? unreadCount : 0, e);
                }
            }
        });
    }

    public static int getSubscribedTotalUnreadMessageCount() {
        return ChannelManager.getInstance().getUnReadMessageCount().getTotalCount();
    }

    public static int getSubscribedCustomTypeTotalUnreadMessageCount() {
        return ChannelManager.getInstance().getUnReadMessageCount().getTotalCountByCustomTypes();
    }

    public static int getSubscribedCustomTypeUnreadMessageCount(String customType) {
        return ChannelManager.getInstance().getUnReadMessageCount().getCustomTypeUnreadMessageCount(customType);
    }

    public static void getUnreadItemCount(final Collection<GroupChannel.UnreadItemKey> keys, final GroupChannel.GroupChannelGetUnreadItemCountHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Map<GroupChannel.UnreadItemKey, Integer>>(){

            @Override
            public Map<GroupChannel.UnreadItemKey, Integer> call() throws Exception {
                if (keys == null || keys.size() <= 0) {
                    throw new SendBirdException("Invalid arguments.", 800110);
                }
                JsonObject obj = APIClient.getInstance().getUnreadItemCount(keys).getAsJsonObject();
                HashMap<GroupChannel.UnreadItemKey, Integer> result = new HashMap<GroupChannel.UnreadItemKey, Integer>();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    GroupChannel.UnreadItemKey unreadItemKey = null;
                    String key = (String)entry.getKey();
                    if (key.equals("group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MENTION_COUNT;
                    } else if (key.equals("group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_INVITATION_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("non_super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_INVITATION_COUNT;
                    } else if (key.equals("super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_INVITATION_COUNT;
                    }
                    if (unreadItemKey == null) continue;
                    result.put(unreadItemKey, ((JsonElement)entry.getValue()).getAsInt());
                }
                return result;
            }

            @Override
            public void onResultForUiThread(Map<GroupChannel.UnreadItemKey, Integer> result, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static void getTotalUnreadChannelCount(final GroupChannel.GroupChannelTotalUnreadChannelCountHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Integer>(){

            @Override
            public Integer call() throws Exception {
                JsonElement response = APIClient.getInstance().getTotalUnreadChannelCount();
                return response.getAsJsonObject().get("unread_count").getAsInt();
            }

            @Override
            public void onResultForUiThread(Integer unreadCount, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(unreadCount != null ? unreadCount : 0, e);
                }
            }
        });
    }

    public static void getGroupChannelCount(GroupChannelListQuery.MemberStateFilter memberStateFilter, GroupChannel.GroupChannelChannelCountHandler handler) {
        String state;
        switch (memberStateFilter) {
            case ALL: {
                state = "all";
                break;
            }
            case INVITED: {
                state = "invited";
                break;
            }
            case INVITED_BY_FRIEND: {
                state = "invited_by_friend";
                break;
            }
            case INVITED_BY_NON_FRIEND: {
                state = "invited_by_non_friend";
                break;
            }
            case JOINED: {
                state = "joined";
                break;
            }
            default: {
                state = null;
            }
        }
        SendBird.localGetGroupChannelCount(state, handler);
    }

    static void localGetGroupChannelCount(final String state, final GroupChannel.GroupChannelChannelCountHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Integer>(){

            @Override
            public Integer call() throws Exception {
                JsonElement response = APIClient.getInstance().getChannelCount(state);
                return response.getAsJsonObject().get("group_channel_count").getAsInt();
            }

            @Override
            public void onResultForUiThread(Integer myChannelCount, SendBirdException e) {
                if (handler != null) {
                    handler.onResult(myChannelCount != null ? myChannelCount : 0, e);
                }
            }
        });
    }

    static void setEkey(String ekey) {
        SendBird.ekey = ekey;
    }

    public static String getEkey() {
        return ekey;
    }

    public static void allowFriendDiscovery(final boolean allow, final AllowFriendDiscoveryHandler handler) {
        APITaskQueue.addTask(new JobResultTask<JsonElement>(){

            @Override
            public JsonElement call() throws SendBirdException {
                return APIClient.getInstance().allowFriendDiscovery(SendBird.getCurrentUser().getUserId(), allow);
            }

            @Override
            void onResultForUiThread(JsonElement ignored, SendBirdException e) {
                if (null != handler) {
                    handler.onComplete(e);
                }
            }
        });
    }

    public static void getAllowFriendDiscovery(final GetAllowFriendDiscoveryHandler handler) {
        APITaskQueue.addTask(new JobResultTask<Boolean>(){

            @Override
            public Boolean call() throws SendBirdException {
                APIClient api = APIClient.getInstance();
                JsonElement result = api.getAllowFriendDiscovery(SendBird.getCurrentUser().getUserId());
                return result.getAsJsonObject().get("allow_friend_discovery").getAsBoolean();
            }

            @Override
            void onResultForUiThread(Boolean result, SendBirdException e) {
                if (null != handler) {
                    handler.onComplete(result, e);
                }
            }
        });
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
        mIsTrackingApplicationState = true;
        appState = new AtomicReference<AppState>(AppState.BACKGROUND);
        exUserAgent = new ConcurrentHashMap<ExtentionFrom, String>();
        ekey = "";
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private boolean mNeedReconnect = false;

        private NetworkReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            NetworkInfo networkInfo = null;
            try {
                networkInfo = SendBird.this.mConnectivityManager.getActiveNetworkInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (networkInfo != null && networkInfo.isConnected()) {
                boolean disconnected = !SocketManager.getInstance().isConnected();
                boolean isActive = SendBird.isActive();
                Logger.d("needReconnect %s, isActive : %s, disconnected : %s", this.mNeedReconnect, isActive, disconnected);
                if (this.mNeedReconnect && isActive && disconnected) {
                    this.mNeedReconnect = false;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (SendBird.getNetworkAwarenessReconnection()) {
                                    SocketManager.getInstance().reconnect(true);
                                }
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            } else if (networkInfo == null) {
                this.mNeedReconnect = true;
                if (SendBird.getConnectionState() == ConnectionState.OPEN) {
                    SocketManager.getInstance().disconnect(false, null);
                }
            }
        }
    }

    public static interface GetEmojiHandler {
        public void onResult(Emoji var1, SendBirdException var2);
    }

    public static interface GetEmojiCategoryHandler {
        public void onResult(EmojiCategory var1, SendBirdException var2);
    }

    public static interface GetAllEmojiHandler {
        public void onResult(EmojiContainer var1, SendBirdException var2);
    }

    static interface MarkAsDeliveredHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MarkAsReadHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetMyGroupChannelChangeLogsHandler {
        public void onResult(List<GroupChannel> var1, List<String> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface GetFriendChangeLogsByTokenHandler {
        public void onResult(List<User> var1, List<String> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface DeleteFriendDiscoveryHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UploadFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendsHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface AddFriendsHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }

    public static interface UserUnblockHandler {
        public void onUnblocked(SendBirdException var1);
    }

    public static interface UserBlockHandler {
        public void onBlocked(User var1, SendBirdException var2);
    }

    public static interface GetChannelInvitationPreferenceHandler {
        public void onResult(boolean var1, SendBirdException var2);
    }

    public static interface SetChannelInvitationPreferenceHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UserInfoUpdateHandler {
        public void onUpdated(SendBirdException var1);
    }

    public static interface GetPushTriggerOptionHandler {
        public void onResult(PushTriggerOption var1, SendBirdException var2);
    }

    public static interface SetPushTriggerOptionHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushTemplateHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushTemplateHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushSoundHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushSoundHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetSnoozePeriodHandler {
        public void onResult(boolean var1, long var2, long var4, SendBirdException var6);
    }

    public static interface SetSnoozePeriodHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetDoNotDisturbHandler {
        public void onResult(boolean var1, int var2, int var3, int var4, int var5, String var6, SendBirdException var7);
    }

    public static interface SetDoNotDisturbHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushTokensHandler {
        public void onResult(List<String> var1, PushTokenType var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface UnregisterPushTokenHandler {
        public void onUnregistered(SendBirdException var1);
    }

    public static interface RegisterPushTokenWithStatusHandler {
        public void onRegistered(PushTokenRegistrationStatus var1, SendBirdException var2);
    }

    @Deprecated
    public static interface RegisterPushTokenHandler {
        @Deprecated
        public void onRegistered(SendBirdException var1);
    }

    public static enum PushTokenRegistrationStatus {
        SUCCESS,
        PENDING,
        ERROR;

    }

    public static class HMS {
        public static String getPendingPushToken() {
            return SendBird.getInstance().mPushToken;
        }

        public static void registerPushTokenForCurrentUser(String token, RegisterPushTokenWithStatusHandler handler) {
            HMS.registerPushTokenForCurrentUser(token, false, handler);
        }

        public static void registerPushTokenForCurrentUser(String token, boolean unique, RegisterPushTokenWithStatusHandler handler) {
            SendBird.registerPushTokenForCurrentUser(PushTokenType.HMS, token, unique, false, false, handler);
        }

        public static void unregisterPushTokenForCurrentUser(String token, UnregisterPushTokenHandler handler) {
            SendBird.unregisterPushTokenForCurrentUser(PushTokenType.HMS, token, handler);
        }

        public static void unregisterPushTokenAllForCurrentUser(UnregisterPushTokenHandler handler) {
            SendBird.unregisterPushTokenAllForCurrentUser(handler);
        }

        public static void getMyPushTokensByToken(String token, PushTokenType type, GetPushTokensHandler handler) {
            SendBird.getMyPushTokensByToken(token, type, handler);
        }

        public static void setDoNotDisturb(boolean doNotDisturbOn, int startHour, int startMin, int endHour, int endMin, String timezone, SetDoNotDisturbHandler handler) {
            SendBird.setDoNotDisturb(doNotDisturbOn, startHour, startMin, endHour, endMin, timezone, handler);
        }

        public static void getDoNotDisturb(GetDoNotDisturbHandler handler) {
            SendBird.getDoNotDisturb(handler);
        }

        public static void setSnoozePeriod(boolean snoozeOn, long startTs, long endTs, SetSnoozePeriodHandler handler) {
            SendBird.setSnoozePeriod(snoozeOn, startTs, endTs, handler);
        }

        public static void getSnoozePeriod(GetSnoozePeriodHandler handler) {
            SendBird.getSnoozePeriod(handler);
        }

        public static void setPushSound(String sound, SetPushSoundHandler handler) {
            SendBird.setPushSound(sound, handler);
        }

        public static void getPushSound(GetPushSoundHandler handler) {
            SendBird.getPushSound(handler);
        }

        public static void setPushTemplate(String templateName, SetPushTemplateHandler handler) {
            SendBird.setPushTemplate(templateName, handler);
        }

        public static void getPushTemplate(GetPushTemplateHandler handler) {
            SendBird.getPushTemplate(handler);
        }

        public static void setPushTriggerOption(PushTriggerOption pushTriggerOption, SetPushTriggerOptionHandler handler) {
            SendBird.setPushTriggerOption(pushTriggerOption, handler);
        }

        public static void getPushTriggerOption(GetPushTriggerOptionHandler handler) {
            SendBird.getPushTriggerOption(handler);
        }
    }

    public static enum PushTriggerOption {
        ALL("all"),
        OFF("off"),
        MENTION_ONLY("mention_only");

        private String value;

        private PushTriggerOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PushTriggerOption from(String value) {
            for (PushTriggerOption option : PushTriggerOption.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return ALL;
        }
    }

    public static enum PushTokenType {
        GCM("gcm"),
        APNS("apns"),
        APNS_VOIP("apns_voip"),
        HMS("huawei");

        private String value;

        private PushTokenType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PushTokenType from(String value) {
            for (PushTokenType type : PushTokenType.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            return GCM;
        }
    }

    public static interface DisconnectHandler {
        public void onDisconnected();
    }

    public static interface ConnectionHandler {
        public void onReconnectStarted();

        public void onReconnectSucceeded();

        public void onReconnectFailed();
    }

    public static abstract class UserEventHandler {
        public abstract void onFriendsDiscovered(List<User> var1);

        public void onTotalUnreadMessageCountChanged(int totalCount, Map<String, Integer> totalCountByCustomType) {
        }
    }

    public static abstract class ChannelHandler {
        public abstract void onMessageReceived(BaseChannel var1, BaseMessage var2);

        public void onMentionReceived(BaseChannel channel, BaseMessage message) {
        }

        public void onMessageDeleted(BaseChannel channel, long msgId) {
        }

        public void onMessageUpdated(BaseChannel channel, BaseMessage message) {
        }

        public void onChannelChanged(BaseChannel channel) {
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
        }

        public void onReactionUpdated(BaseChannel channel, ReactionEvent reactionEvent) {
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
        }

        public void onDeliveryReceiptUpdated(GroupChannel channel) {
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
        }

        public void onUserReceivedInvitation(GroupChannel channel, User inviter, List<User> invitees) {
        }

        public void onUserJoined(GroupChannel channel, User user) {
        }

        public void onUserDeclinedInvitation(GroupChannel channel, User inviter, User invitee) {
        }

        public void onUserLeft(GroupChannel channel, User user) {
        }

        public void onUserEntered(OpenChannel channel, User user) {
        }

        public void onUserExited(OpenChannel channel, User user) {
        }

        public void onUserMuted(BaseChannel channel, User user) {
        }

        public void onUserUnmuted(BaseChannel channel, User user) {
        }

        public void onUserBanned(BaseChannel channel, User user) {
        }

        public void onUserUnbanned(BaseChannel channel, User user) {
        }

        public void onChannelFrozen(BaseChannel channel) {
        }

        public void onChannelUnfrozen(BaseChannel channel) {
        }

        public void onMetaDataCreated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataUpdated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onMetaCountersCreated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersUpdated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onChannelHidden(GroupChannel channel) {
        }

        public void onOperatorUpdated(BaseChannel channel) {
        }

        public void onThreadInfoUpdated(BaseChannel channel, ThreadInfoUpdateEvent threadInfoUpdateEvent) {
        }
    }

    public static interface ConnectHandler {
        public void onConnected(User var1, SendBirdException var2);
    }

    public static class Options {
        static boolean useMemberAsMessageSender = true;
        static ThreadOption mThreadOption = ThreadOption.UI_THREAD;
        static Handler mHandlerForThreadOption;
        static int connectionTimeout;
        static int authenticationTimeout;
        static int typingIndicatorThrottle;
        static int wsResponseTimeoutSec;

        static void init() {
            useMemberAsMessageSender = true;
            mThreadOption = ThreadOption.UI_THREAD;
            connectionTimeout = 10;
            authenticationTimeout = 10;
            typingIndicatorThrottle = 1000;
        }

        public static void useMemberAsMessageSender(boolean tf) {
            useMemberAsMessageSender = tf;
        }

        @Deprecated
        public static void useUiThreadForCallbacks(boolean tf) {
            mThreadOption = tf ? ThreadOption.UI_THREAD : ThreadOption.NEW_THREAD;
        }

        @Deprecated
        public static void setHandlerForCallbacks(Handler handler) {
            if (handler != null) {
                mThreadOption = ThreadOption.HANDLER;
                mHandlerForThreadOption = handler;
            } else {
                mThreadOption = ThreadOption.UI_THREAD;
            }
        }

        public static void setThreadOption(ThreadOption threadOption, Handler handler) {
            if (threadOption != null) {
                mThreadOption = threadOption;
                if (threadOption == ThreadOption.HANDLER) {
                    mHandlerForThreadOption = handler;
                }
            }
        }

        public static void setConnectionTimeout(int connectionTimeout) {
            Options.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 10;
        }

        public static void setAuthenticationTimeout(int authenticationTimeout) {
            Options.authenticationTimeout = authenticationTimeout > 0 ? authenticationTimeout : 10;
        }

        public static void setTypingIndicatorThrottle(int msec) {
            if (msec >= 1000 && msec <= 9000) {
                typingIndicatorThrottle = msec;
            }
        }

        public static void setWebSocketResponseTimeout(int webSocketResponseTimeoutSec) {
            int MIN_TIMEOUT_SEC = 5;
            int MAX_TIMEOUT_SEC = 300;
            wsResponseTimeoutSec = IntRangeComparableUtils.coerceIn(webSocketResponseTimeoutSec, 5, 300);
        }

        static {
            connectionTimeout = 10;
            authenticationTimeout = 10;
            typingIndicatorThrottle = 1000;
            wsResponseTimeoutSec = 10;
        }

        public static enum ThreadOption {
            UI_THREAD,
            NEW_THREAD,
            HANDLER;

        }
    }

    static enum AppState {
        FOREGROUND,
        BACKGROUND;

    }

    static enum ExtentionFrom {
        None("none", ""),
        Core("core", "c"),
        SyncManager("sb_syncmanager", "s"),
        UIKit("sb_uikit", "u");

        private String key;
        private String shortCut;

        private ExtentionFrom(String key, String shortCut) {
            this.key = key;
            this.shortCut = shortCut;
        }

        public String getValue(String value) {
            return this.shortCut + value;
        }

        public static ExtentionFrom from(String key) {
            for (ExtentionFrom value : ExtentionFrom.values()) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return None;
        }
    }

    public static enum ConnectionState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

