/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class OperatorListQuery {
    private BaseChannel mChannel;
    private String mToken = "";
    private int mLimit = 20;
    private boolean mHasNext = true;
    private boolean mLoading = false;

    OperatorListQuery(BaseChannel channel) {
        this.mChannel = channel;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final OperatorListQueryResultHandler handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<User>>(){

            @Override
            public List<User> call() throws Exception {
                JsonArray userObjs;
                if (!OperatorListQuery.this.hasNext()) {
                    return new ArrayList<User>();
                }
                JsonElement response = APIClient.getInstance().loadOperatorList(OperatorListQuery.this.mChannel instanceof OpenChannel, OperatorListQuery.this.mChannel.getUrl(), OperatorListQuery.this.mToken, OperatorListQuery.this.mLimit);
                JsonObject result = response.getAsJsonObject();
                OperatorListQuery.this.mToken = result.get("next").getAsString();
                if (OperatorListQuery.this.mToken == null || OperatorListQuery.this.mToken.length() <= 0) {
                    OperatorListQuery.this.mHasNext = false;
                }
                ArrayList<User> users = new ArrayList<User>();
                JsonArray jsonArray = userObjs = result.has("operators") ? result.get("operators").getAsJsonArray() : null;
                if (userObjs != null) {
                    for (int i = 0; i < userObjs.size(); ++i) {
                        users.add(new User(userObjs.get(i)));
                    }
                }
                return users;
            }

            @Override
            public void onResultForUiThread(List<User> result, SendBirdException e) {
                OperatorListQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static interface OperatorListQueryResultHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }
}

