/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.User;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OpenChannelParams {
    String name;
    String channelUrl;
    Object coverUrlOrImage;
    String data;
    String customType;
    List<String> operatorUserIds;

    public OpenChannelParams() {
    }

    public OpenChannelParams(String userId) {
        this.operatorUserIds = new ArrayList<String>();
        this.operatorUserIds.add(userId);
    }

    public OpenChannelParams setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
        return this;
    }

    public OpenChannelParams setName(String name) {
        this.name = name;
        return this;
    }

    public OpenChannelParams setCoverUrl(String coverImageUrl) {
        this.coverUrlOrImage = coverImageUrl;
        return this;
    }

    public OpenChannelParams setCoverImage(File coverImageFile) {
        this.coverUrlOrImage = coverImageFile;
        return this;
    }

    public OpenChannelParams setData(String data) {
        this.data = data;
        return this;
    }

    public OpenChannelParams setCustomType(String customType) {
        this.customType = customType;
        return this;
    }

    @Deprecated
    public OpenChannelParams addOperator(User operator) {
        return this.setOperators(Collections.singletonList(operator));
    }

    @Deprecated
    public OpenChannelParams addOperators(List<User> operators) {
        return this.setOperators(operators);
    }

    @Deprecated
    public OpenChannelParams addOperatorId(String operatorUserId) {
        return this.setOperatorUserIds(Collections.singletonList(operatorUserId));
    }

    @Deprecated
    public OpenChannelParams addOperatorIds(List<String> operatorUserIds) {
        return this.setOperatorUserIds(operatorUserIds);
    }

    public OpenChannelParams setOperators(List<User> operators) {
        if (this.operatorUserIds == null) {
            this.operatorUserIds = new ArrayList<String>();
        }
        this.operatorUserIds.clear();
        if (operators != null) {
            for (User user : operators) {
                if (user == null || user.getUserId() == null || user.getUserId().length() <= 0) continue;
                this.operatorUserIds.add(user.getUserId());
            }
        }
        return this;
    }

    public OpenChannelParams setOperatorUserIds(List<String> operatorUserIds) {
        if (this.operatorUserIds == null) {
            this.operatorUserIds = new ArrayList<String>();
        }
        this.operatorUserIds.clear();
        if (operatorUserIds != null) {
            for (String userId : operatorUserIds) {
                if (userId == null || userId.length() <= 0) continue;
                this.operatorUserIds.add(userId);
            }
        }
        return this;
    }

    public static OpenChannelParams clone(OpenChannelParams params) {
        if (params == null) {
            return null;
        }
        OpenChannelParams clonedParmas = new OpenChannelParams();
        clonedParmas.setChannelUrl(params.channelUrl).setCustomType(params.customType).setData(params.data).setName(params.name);
        if (params.operatorUserIds != null) {
            clonedParmas.setOperatorUserIds(params.operatorUserIds);
        }
        if (params.coverUrlOrImage instanceof File) {
            clonedParmas.setCoverImage((File)params.coverUrlOrImage);
        } else if (params.coverUrlOrImage instanceof String) {
            clonedParmas.setCoverUrl((String)params.coverUrlOrImage);
        }
        return clonedParmas;
    }

    public String toString() {
        return "OpenChannelParams{name='" + this.name + '\'' + ", channelUrl='" + this.channelUrl + '\'' + ", coverUrlOrImage=" + this.coverUrlOrImage + ", data='" + this.data + '\'' + ", customType='" + this.customType + '\'' + ", operatorUserIds=" + this.operatorUserIds + '}';
    }
}

