/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class FriendListQuery {
    private String mToken = "";
    private int mLimit = 20;
    private boolean mHasNext = true;
    private boolean mLoading = false;

    FriendListQuery() {
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final FriendListQueryResultHandler handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        if (!this.hasNext()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(new ArrayList<User>(), null);
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<User>>(){

            @Override
            public List<User> call() throws Exception {
                JsonElement response = APIClient.getInstance().loadFriendList(FriendListQuery.this.mToken, FriendListQuery.this.mLimit);
                JsonObject result = response.getAsJsonObject();
                FriendListQuery.this.mToken = result.get("next").getAsString();
                if (FriendListQuery.this.mToken == null || FriendListQuery.this.mToken.length() <= 0) {
                    FriendListQuery.this.mHasNext = false;
                }
                JsonArray usersArray = result.get("users").getAsJsonArray();
                ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i < usersArray.size(); ++i) {
                    users.add(new User(usersArray.get(i)));
                }
                return users;
            }

            @Override
            public void onResultForUiThread(List<User> users, SendBirdException e) {
                FriendListQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(users, e);
                }
            }
        });
    }

    public static interface FriendListQueryResultHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }
}

