/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ClearableScheduledExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService scheduledExecutorService;
    private final List<Future<?>> futures = new ArrayList();

    ClearableScheduledExecutorService() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    private synchronized <T> Future<T> addFuture(Future<T> future) {
        this.futures.add(future);
        return future;
    }

    private synchronized <T> ScheduledFuture<T> addScheduledFuture(ScheduledFuture<T> scheduledFuture) {
        this.futures.add(scheduledFuture);
        return scheduledFuture;
    }

    private synchronized <T> List<Future<T>> addFutures(List<Future<T>> futures) {
        this.futures.addAll(futures);
        return futures;
    }

    public synchronized void cancelAllJobs() {
        this.cancelAllJobs(false);
    }

    public synchronized void cancelAllJobs(boolean mayInterruptIfRunning) {
        for (Future<?> future : this.futures) {
            future.cancel(mayInterruptIfRunning);
        }
        this.futures.clear();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.addScheduledFuture(this.scheduledExecutorService.schedule(command, delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.addScheduledFuture(this.scheduledExecutorService.schedule(callable, delay, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.addScheduledFuture(this.scheduledExecutorService.scheduleAtFixedRate(command, initialDelay, period, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.addScheduledFuture(this.scheduledExecutorService.scheduleWithFixedDelay(command, initialDelay, delay, unit));
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduledExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.scheduledExecutorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.scheduledExecutorService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.addFuture(this.scheduledExecutorService.submit(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.addFuture(this.scheduledExecutorService.submit(task, result));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.addFuture(this.scheduledExecutorService.submit(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.addFutures(this.scheduledExecutorService.invokeAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.addFutures(this.scheduledExecutorService.invokeAll(tasks, timeout, unit));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        return this.scheduledExecutorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.scheduledExecutorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.addFuture(this.scheduledExecutorService.schedule(command, 0L, TimeUnit.MILLISECONDS));
    }
}

