/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.sendbird.android.ClearableScheduledExecutorService;
import com.sendbird.android.Command;
import com.sendbird.android.Connection;
import com.sendbird.android.ConnectionConfig;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SocketManager;
import com.sendbird.android.log.Logger;
import java.util.concurrent.TimeUnit;

final class ApplicationStateHandler
implements Application.ActivityLifecycleCallbacks {
    private final ClearableScheduledExecutorService scheduler = new ClearableScheduledExecutorService();
    private boolean tryConnect;

    ApplicationStateHandler() {
    }

    void onActivityResumedInternal() {
        boolean stateChanged = SendBird.setAppState(SendBird.AppState.FOREGROUND);
        this.scheduler.cancelAllJobs();
        if (!SendBird.getAutoBackgroundDetection()) {
            Logger.d("getAutoBackgroundDetection() : " + SendBird.getAutoBackgroundDetection());
            return;
        }
        if (stateChanged) {
            SocketManager.getInstance().sendPing();
            if (SendBird.getConnectionState() == SendBird.ConnectionState.CLOSED && this.tryConnect && SendBird.getCurrentUser() != null) {
                SocketManager.getInstance().reconnect(false);
            } else if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN && SendBird.getCurrentUser() != null) {
                Logger.d("Application goes foreground with connected status.");
                Logger.d("sendCommand(UNRD)");
                SendBird.getInstance().sendCommand(Command.bUnrd(), false, new Command.SendCommandHandler(){

                    @Override
                    public void onResult(Command acked, SendBirdException e) {
                        Logger.d("sendCommand(UNRD) => " + (e != null ? e.getMessage() : "OK"));
                    }
                });
                SocketManager.getInstance().notifyReconnectCallbackForBackwardCompatibilityBlocking();
            }
        }
    }

    void onActivityPausedInternal() {
        ConnectionConfig connectionconfig = Connection.getConnectionConfig();
        int defaultBcDuration = ConnectionConfig.getDefaultBgConnectionDurationMs();
        Logger.d("++ bcDuration: " + connectionconfig.getBcDuration());
        this.scheduler.cancelAllJobs();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                boolean stateChanged = SendBird.setAppState(SendBird.AppState.BACKGROUND);
                if (stateChanged && SendBird.getAutoBackgroundDetection()) {
                    SocketManager.getInstance().sendPing();
                }
            }
        }, (long)defaultBcDuration, TimeUnit.MILLISECONDS);
        if (!SendBird.getAutoBackgroundDetection()) {
            Logger.d("getAutoBackgroundDetection() : " + SendBird.getAutoBackgroundDetection());
            return;
        }
        if (connectionconfig.getBcDuration() >= 0L) {
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    ApplicationStateHandler.this.disconnectInternal();
                }
            }, connectionconfig.getBcDuration(), TimeUnit.MILLISECONDS);
        }
    }

    private void disconnectInternal() {
        SendBird.setAppState(SendBird.AppState.BACKGROUND);
        Logger.d("++ getConnectionState(): " + (Object)((Object)SendBird.getConnectionState()));
        Logger.d("++ ConnectManager.getInstance().isReconnecting(): " + SocketManager.getInstance().isReconnecting());
        if (SendBird.getConnectionState() != SendBird.ConnectionState.CLOSED || SocketManager.getInstance().isReconnecting()) {
            SocketManager.getInstance().disconnect(false, null);
            this.tryConnect = true;
        } else {
            this.tryConnect = false;
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        Logger.d("onActivityResumed: " + activity.getPackageName() + ":" + activity.getLocalClassName());
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                ApplicationStateHandler.this.onActivityResumedInternal();
            }
        });
    }

    public void onActivityPaused(Activity activity) {
        Logger.d("onActivityPaused: " + activity.getPackageName() + ":" + activity.getLocalClassName());
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                ApplicationStateHandler.this.onActivityPausedInternal();
            }
        });
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

