/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AppInfo {
    private final long UNIT_MB = 0x100000L;
    private String emojiHash = "";
    private long uploadSizeLimit = Long.MAX_VALUE;
    private boolean useReaction = false;
    private final List<String> premiumFeatureList = new ArrayList<String>();
    private final List<String> attributesInUse = new ArrayList<String>();

    AppInfo(JsonObject json) {
        this.upsert(json);
    }

    void upsert(JsonObject json) {
        if (json.has("emoji_hash")) {
            this.emojiHash = json.get("emoji_hash").getAsString();
        }
        if (json.has("file_upload_size_limit")) {
            this.uploadSizeLimit = (long)json.get("file_upload_size_limit").getAsInt() * 0x100000L;
        }
        if (json.has("use_reaction")) {
            this.useReaction = json.get("use_reaction").getAsBoolean();
        }
        if (json.has("premium_feature_list")) {
            this.premiumFeatureList.clear();
            JsonArray featureList = json.getAsJsonArray("premium_feature_list");
            for (JsonElement feature : featureList) {
                this.premiumFeatureList.add(feature.getAsString());
            }
        }
        if (json.has("application_attributes")) {
            this.attributesInUse.clear();
            JsonArray attributes = json.getAsJsonArray("application_attributes");
            for (JsonElement attr : attributes) {
                this.attributesInUse.add(attr.getAsString());
            }
        }
    }

    public String getEmojiHash() {
        return this.emojiHash;
    }

    public long getUploadSizeLimit() {
        return this.uploadSizeLimit;
    }

    public boolean useReaction() {
        return this.useReaction;
    }

    public List<String> getPremiumFeatureList() {
        return Collections.unmodifiableList(this.premiumFeatureList);
    }

    public List<String> getAttributesInUse() {
        return Collections.unmodifiableList(this.attributesInUse);
    }

    public boolean needUpdateEmoji(String prevEmojiHash) {
        return this.emojiHash == null || !this.emojiHash.equals(prevEmojiHash);
    }

    public String toString() {
        return "AppInfo{emojiHash='" + this.emojiHash + '\'' + ", uploadSizeLimit=" + this.uploadSizeLimit + ", useReaction=" + this.useReaction + ", premiumFeatureList=" + this.premiumFeatureList + ", attributesInUse=" + this.attributesInUse + '}';
    }
}

