/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class PreviousMessageListQuery {
    private boolean mLoading = false;
    private BaseChannel mChannel;
    private long mMessageTimestamp = Long.MAX_VALUE;
    private boolean mHasMore = true;
    private int mLimit = 20;
    private boolean mReverse = false;
    private BaseChannel.MessageTypeFilter mMessageType = BaseChannel.MessageTypeFilter.ALL;
    private String mCustomType;
    private List<String> mSenderUserIds;
    private boolean mIncludeMetaArray = false;
    private boolean mIncludeReactions = false;
    private boolean includeThreadInfo = false;
    private boolean includeReplies = false;
    private boolean includeParentMessageText = false;
    private boolean showSubchannelMessagesOnly = false;

    PreviousMessageListQuery(BaseChannel channel) {
        this.mChannel = channel;
    }

    public boolean hasMore() {
        return this.mHasMore;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setReverse(boolean reverse) {
        this.mReverse = reverse;
    }

    public void setMessageTypeFilter(BaseChannel.MessageTypeFilter messageType) {
        this.mMessageType = messageType;
    }

    public void setCustomTypeFilter(String customType) {
        this.mCustomType = customType;
    }

    public void setSenderUserIdsFilter(List<String> senderUserIds) {
        this.mSenderUserIds = senderUserIds;
    }

    public void setIncludeMetaArray(boolean includeMetaArray) {
        this.mIncludeMetaArray = includeMetaArray;
    }

    public void setIncludeReactions(boolean includeReactions) {
        this.mIncludeReactions = includeReactions;
    }

    public void setIncludeThreadInfo(boolean includeThreadInfo) {
        this.includeThreadInfo = includeThreadInfo;
    }

    public void setIncludeReplies(boolean includeReplies) {
        this.includeReplies = includeReplies;
    }

    public void setIncludeParentMessageText(boolean includeParentMessageText) {
        this.includeParentMessageText = includeParentMessageText;
    }

    public void setShowSubchannelMessagesOnly(boolean showSubchannelMessagesOnly) {
        this.showSubchannelMessagesOnly = showSubchannelMessagesOnly;
    }

    public synchronized void load(MessageListQueryResult handler) {
        this.load(this.mLimit, this.mReverse, handler);
    }

    public synchronized void load(final int limit, final boolean reverse, final MessageListQueryResult handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        if (!this.hasMore()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(new ArrayList<BaseMessage>(), null);
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<BaseMessage>>(){

            @Override
            public List<BaseMessage> call() throws Exception {
                PreviousMessageListQuery.this.mLimit = limit;
                PreviousMessageListQuery.this.mReverse = reverse;
                String msgType = PreviousMessageListQuery.this.mMessageType == null || PreviousMessageListQuery.this.mMessageType == BaseChannel.MessageTypeFilter.ALL ? null : PreviousMessageListQuery.this.mMessageType.value();
                LinkedHashSet<String> senderUserIdsSet = null;
                if (PreviousMessageListQuery.this.mSenderUserIds != null) {
                    senderUserIdsSet = new LinkedHashSet<String>(PreviousMessageListQuery.this.mSenderUserIds);
                }
                JsonElement response = APIClient.getInstance().messageList(PreviousMessageListQuery.this.mChannel instanceof OpenChannel, PreviousMessageListQuery.this.mChannel.getUrl(), 0L, PreviousMessageListQuery.this.mMessageTimestamp, PreviousMessageListQuery.this.mLimit, 0, false, PreviousMessageListQuery.this.mReverse, msgType, PreviousMessageListQuery.this.mCustomType, senderUserIdsSet, PreviousMessageListQuery.this.mIncludeMetaArray, PreviousMessageListQuery.this.mIncludeReactions, PreviousMessageListQuery.this.includeThreadInfo, PreviousMessageListQuery.this.includeReplies, PreviousMessageListQuery.this.includeParentMessageText, PreviousMessageListQuery.this.showSubchannelMessagesOnly);
                JsonObject result = response.getAsJsonObject();
                JsonArray objs = result.get("messages").getAsJsonArray();
                ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < objs.size(); ++i) {
                    BaseMessage msg = BaseMessage.createMessage(objs.get(i), PreviousMessageListQuery.this.mChannel.getUrl(), PreviousMessageListQuery.this.mChannel.getChannelType());
                    if (msg == null) continue;
                    messages.add(msg);
                    if (msg.getCreatedAt() > PreviousMessageListQuery.this.mMessageTimestamp) continue;
                    PreviousMessageListQuery.this.mMessageTimestamp = msg.getCreatedAt();
                }
                if (messages.size() < limit) {
                    PreviousMessageListQuery.this.mHasMore = false;
                }
                return messages;
            }

            @Override
            public void onResultForUiThread(List<BaseMessage> messages, SendBirdException e) {
                PreviousMessageListQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(messages, e);
                }
            }
        });
    }

    public BaseChannel getChannel() {
        return this.mChannel;
    }

    public long getMessageTimestamp() {
        return this.mMessageTimestamp;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public boolean shouldReverse() {
        return this.mReverse;
    }

    public BaseChannel.MessageTypeFilter getMessageTypeFilter() {
        return this.mMessageType;
    }

    public String getCustomTypeFilter() {
        return this.mCustomType;
    }

    public List<String> getSenderUserIdsFilter() {
        return this.mSenderUserIds;
    }

    public boolean shouldIncludeMetaArray() {
        return this.mIncludeMetaArray;
    }

    public boolean shouldIncludeReactions() {
        return this.mIncludeReactions;
    }

    public boolean isIncludeThreadInfo() {
        return this.includeThreadInfo;
    }

    public boolean shouldIncludeReplies() {
        return this.includeReplies;
    }

    public boolean shouldIncludeParentMessageText() {
        return this.includeParentMessageText;
    }

    public boolean shouldShowSubchannelMessagesOnly() {
        return this.showSubchannelMessagesOnly;
    }

    public static interface MessageListQueryResult {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }
}

