/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android.utils;

import com.sendbird.android.log.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class TimeoutLock {
    private static final long DEFAULT_TIMEOUT = 10000L;
    private final long timeout;
    private final TimeUnit timeUnit;
    private final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final AtomicBoolean interrupted = new AtomicBoolean(false);
    private final AtomicBoolean isWaiting = new AtomicBoolean(false);
    private final AtomicReference<Future<?>> job = new AtomicReference();

    public TimeoutLock() {
        this(10000L, TimeUnit.MILLISECONDS);
    }

    public TimeoutLock(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public synchronized void await() throws InterruptedException, TimeoutException {
        Logger.d(">> TimeoutLock::await(%s)", this);
        if (this.countDownLatch.getCount() == 0L) {
            this.cancel();
            Logger.d("-- return TimeoutLock already released ");
            return;
        }
        if (this.interrupted.getAndSet(false)) {
            throw new InterruptedException("a job was interrupted");
        }
        Logger.d("++ isWaiting : " + this.isWaiting.get());
        if (this.isWaiting.getAndSet(true)) {
            return;
        }
        final AtomicBoolean isTimeout = new AtomicBoolean(false);
        try {
            this.job.set(this.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    Logger.d("++ TimeoutLock::Timeout( count=%s)", TimeoutLock.this.countDownLatch.getCount());
                    TimeoutLock.this.interrupted.set(false);
                    isTimeout.compareAndSet(false, TimeoutLock.this.countDownLatch.getCount() > 0L);
                    TimeoutLock.this.countDownLatch.countDown();
                }
            }, this.timeout, this.timeUnit));
            this.countDownLatch.await();
        }
        finally {
            this.isWaiting.set(false);
            this.cancel();
        }
        Logger.d("++ await end interrupted=%s, isTimeout=%s", this.interrupted, isTimeout.get());
        if (this.interrupted.getAndSet(false)) {
            throw new InterruptedException("a job was interrupted");
        }
        if (isTimeout.getAndSet(false)) {
            throw new TimeoutException("exceed the timed out");
        }
    }

    private void cancel() {
        Future currentJob = this.job.getAndSet(null);
        if (currentJob != null) {
            Logger.d(">> TimeoutLock::cancel() job : " + currentJob);
            currentJob.cancel(false);
        }
    }

    public void release() {
        Logger.d(">> TimeoutLock::release(%s)", this);
        this.cancel();
        this.countDownLatch.countDown();
    }

    public void interrupt() {
        Logger.i(">> TimeoutLock::isWaiting() : " + this.isWaiting.get(), new Object[0]);
        if (!this.isWaiting.get()) {
            return;
        }
        Logger.i(">> TimeoutLock::interrupt()", new Object[0]);
        this.interrupted.set(true);
        this.release();
    }

    public static class TimeoutException
    extends Exception {
        TimeoutException(String message) {
            super(message);
        }
    }
}

