/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.OGMetaData;
import com.sendbird.android.Sender;
import com.sendbird.android.ThreadInfo;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserMessage
extends BaseMessage {
    private HashMap<String, String> mTranslations;

    static UserMessage copiedInstance(String requestId, long rootMessageId, long parentMessageId, Sender sender, String channelUrl, BaseChannel.ChannelType channelType, String message, String data, String customType, String translations, long createdAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String sortedMetaArray, ThreadInfo threadInfo, OGMetaData ogMetaData, boolean isOpMsg) {
        JsonObject obj = BaseMessage.createJson(requestId, rootMessageId, parentMessageId, sender, channelUrl, channelType, data, customType, createdAt, mentionType, mentionedUserIds, mentionedUsers, sortedMetaArray, threadInfo, isOpMsg);
        obj.addProperty("message", message);
        if (translations != null) {
            obj.add("translations", new JsonParser().parse(translations));
        }
        if (ogMetaData != null) {
            obj.add("og_tag", ogMetaData.toJson());
        }
        return new UserMessage((JsonElement)obj);
    }

    UserMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mTranslations = new HashMap();
        if (obj.has("translations")) {
            JsonObject transObj = obj.get("translations").getAsJsonObject();
            for (Map.Entry entry : transObj.entrySet()) {
                this.mTranslations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", BaseChannel.MessageTypeFilter.USER.value());
        JsonObject transObj = new JsonObject();
        for (Map.Entry<String, String> entry : this.mTranslations.entrySet()) {
            transObj.addProperty(entry.getKey(), entry.getValue());
        }
        obj.add("translations", (JsonElement)transObj);
        return obj;
    }

    @Override
    public String getRequestId() {
        return this.mReqId;
    }

    public Map<String, String> getTranslations() {
        return this.mTranslations;
    }

    @Deprecated
    public RequestState getRequestState() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED) {
            return RequestState.SUCCEEDED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.FAILED) {
            return RequestState.FAILED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING) {
            return RequestState.PENDING;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return RequestState.FAILED;
        }
        return RequestState.NONE;
    }

    public List<String> getRequestedMentionUserIds() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING || this.getSendingStatus() == BaseMessage.SendingStatus.FAILED || this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return this.getMentionedUserIds();
        }
        return new ArrayList<String>();
    }

    @Override
    public String toString() {
        return super.toString() + "\nUserMessage{, mTranslations=" + this.mTranslations + '}';
    }

    @Deprecated
    public static enum RequestState {
        NONE,
        PENDING,
        FAILED,
        SUCCEEDED;

    }
}

