/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class PublicGroupChannelListQuery {
    private static final String ORDER_CHRONOLOGICAL = "chronological";
    private static final String ORDER_CHANNEL_NAME_ALPHABETICAL = "channel_name_alphabetical";
    static final String ORDER_METADATA_VALUE_ALPHABETICAL = "metadata_value_alphabetical";
    private static final String MEMBER_STATE_ALL = "all";
    private static final String MEMBER_STATE_INVITED_ONLY = "invited_only";
    private static final String MEMBER_STATE_INVITED_BY_FRIEND_ONLY = "invited_by_friend";
    private static final String MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY = "invited_by_non_friend";
    private static final String MEMBER_STATE_JOINED_ONLY = "joined_only";
    private String mToken = "";
    private boolean mHasNext = true;
    private int mLimit = 20;
    private boolean mLoading = false;
    private boolean mIncludeEmpty = true;
    private boolean includeFrozen = true;
    private String mOrder = "chronological";
    private String mMetaDataOrderKey;
    private String mCustomTypeStartsWith;
    private String mMemberState = "all";
    private ArrayList<String> mChannelUrls;
    private String mNameContains;
    private ArrayList<String> mCustomTypes;
    private SuperChannelFilter mSuperChannelFilter = SuperChannelFilter.ALL;
    private MembershipFilter mMembershipFilter = MembershipFilter.JOINED;

    PublicGroupChannelListQuery() {
    }

    public int getLimit() {
        return this.mLimit;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean isIncludeEmpty() {
        return this.mIncludeEmpty;
    }

    public void setIncludeEmpty(boolean includeEmpty) {
        this.mIncludeEmpty = includeEmpty;
    }

    public Order getOrder() {
        if (this.mOrder.equals(ORDER_CHANNEL_NAME_ALPHABETICAL)) {
            return Order.CHANNEL_NAME_ALPHABETICAL;
        }
        if (this.mOrder.equals(ORDER_METADATA_VALUE_ALPHABETICAL)) {
            return Order.METADATA_VALUE_ALPHABETICAL;
        }
        return Order.CHRONOLOGICAL;
    }

    public void setOrder(Order order) {
        if (order == Order.CHRONOLOGICAL) {
            this.mOrder = ORDER_CHRONOLOGICAL;
        } else if (order == Order.CHANNEL_NAME_ALPHABETICAL) {
            this.mOrder = ORDER_CHANNEL_NAME_ALPHABETICAL;
        } else if (order == Order.METADATA_VALUE_ALPHABETICAL) {
            this.mOrder = ORDER_METADATA_VALUE_ALPHABETICAL;
        }
    }

    public String getMetaDataOrderKeyFilter() {
        return this.mMetaDataOrderKey;
    }

    public void setMetaDataOrderKeyFilter(String metaDataOrderKey) {
        this.mMetaDataOrderKey = metaDataOrderKey;
    }

    public String getCustomTypeStartsWithFilter() {
        return this.mCustomTypeStartsWith;
    }

    public void setCustomTypeStartsWithFilter(String customType) {
        this.mCustomTypeStartsWith = customType;
    }

    public List<String> getCustomTypesFilter() {
        return this.mCustomTypes;
    }

    public void setCustomTypesFilter(List<String> customTypes) {
        if (customTypes == null || customTypes.size() <= 0) {
            return;
        }
        this.mCustomTypes = new ArrayList();
        this.mCustomTypes.addAll(customTypes);
    }

    public List<String> getChannelUrlsFilter() {
        return this.mChannelUrls;
    }

    public void setChannelUrlsFilter(List<String> channelUrls) {
        if (channelUrls == null || channelUrls.size() <= 0) {
            return;
        }
        this.mChannelUrls = new ArrayList();
        this.mChannelUrls.addAll(channelUrls);
    }

    public String getChannelNameContainsFilter() {
        return this.mNameContains;
    }

    public void setChannelNameContainsFilter(String channelName) {
        this.mNameContains = channelName;
    }

    public SuperChannelFilter getSuperChannelFilter() {
        return this.mSuperChannelFilter;
    }

    public void setSuperChannelFilter(SuperChannelFilter superChannelFilter) {
        this.mSuperChannelFilter = superChannelFilter;
    }

    public MembershipFilter getMembershipFilter() {
        return this.mMembershipFilter;
    }

    public void setMembershipFilter(MembershipFilter membershipFilter) {
        this.mMembershipFilter = membershipFilter;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public boolean isIncludeFrozen() {
        return this.includeFrozen;
    }

    public void setIncludeFrozen(boolean includeFrozen) {
        this.includeFrozen = includeFrozen;
    }

    public synchronized void next(final PublicGroupChannelListQueryResultHandler handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        if (!this.hasNext()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(new ArrayList<GroupChannel>(), null);
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<GroupChannel>>(){

            @Override
            public List<GroupChannel> call() throws Exception {
                JsonElement response = APIClient.getInstance().loadPublicGroupChannelList(PublicGroupChannelListQuery.this.mToken, PublicGroupChannelListQuery.this.mLimit, PublicGroupChannelListQuery.this.mIncludeEmpty, PublicGroupChannelListQuery.this.includeFrozen, PublicGroupChannelListQuery.this.mOrder, PublicGroupChannelListQuery.this.mMetaDataOrderKey, PublicGroupChannelListQuery.this.mCustomTypeStartsWith, PublicGroupChannelListQuery.this.mMemberState, PublicGroupChannelListQuery.this.mChannelUrls, PublicGroupChannelListQuery.this.mNameContains, PublicGroupChannelListQuery.this.mCustomTypes, PublicGroupChannelListQuery.this.mSuperChannelFilter, PublicGroupChannelListQuery.this.mMembershipFilter);
                JsonObject result = response.getAsJsonObject();
                PublicGroupChannelListQuery.this.mToken = result.get("next").getAsString();
                if (PublicGroupChannelListQuery.this.mToken == null || PublicGroupChannelListQuery.this.mToken.length() <= 0) {
                    PublicGroupChannelListQuery.this.mHasNext = false;
                }
                JsonArray channelObjs = result.get("channels").getAsJsonArray();
                ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
                for (int i = 0; i < channelObjs.size(); ++i) {
                    channels.add(GroupChannel.upsert(channelObjs.get(i), false));
                }
                return channels;
            }

            @Override
            public void onResultForUiThread(List<GroupChannel> result, SendBirdException e) {
                PublicGroupChannelListQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static interface PublicGroupChannelListQueryResultHandler {
        public void onResult(List<GroupChannel> var1, SendBirdException var2);
    }

    static enum FilterMode {
        ALL,
        MEMBERS_EXACTLY_IN,
        MEMBERS_NICKNAME_CONTAINS,
        MEMBERS_INCLUDE_IN;

    }

    public static enum MembershipFilter {
        ALL,
        JOINED;

    }

    public static enum SuperChannelFilter {
        ALL,
        SUPER_CHANNEL_ONLY,
        NONSUPER_CHANNEL_ONLY;

    }

    public static enum Order {
        CHRONOLOGICAL,
        CHANNEL_NAME_ALPHABETICAL,
        METADATA_VALUE_ALPHABETICAL;

    }
}

