/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.User;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class OpenChannelParams {
    String name;
    String channelUrl;
    Object coverUrlOrImage;
    String data;
    String customType;
    List<String> operatorUserIds = new ArrayList<String>();

    public OpenChannelParams() {
    }

    public OpenChannelParams(String userId) {
        this.operatorUserIds.add(userId);
    }

    public OpenChannelParams setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
        return this;
    }

    public OpenChannelParams setName(String name) {
        this.name = name;
        return this;
    }

    public OpenChannelParams setCoverUrl(String coverImageUrl) {
        this.coverUrlOrImage = coverImageUrl;
        return this;
    }

    public OpenChannelParams setCoverImage(File coverImageFile) {
        this.coverUrlOrImage = coverImageFile;
        return this;
    }

    public OpenChannelParams setData(String data) {
        this.data = data;
        return this;
    }

    public OpenChannelParams setCustomType(String customType) {
        this.customType = customType;
        return this;
    }

    public OpenChannelParams addOperator(User operator) {
        if (this.operatorUserIds == null) {
            this.operatorUserIds = new ArrayList<String>();
        }
        if (operator != null && operator.getUserId() != null && operator.getUserId().length() > 0) {
            this.operatorUserIds.add(operator.getUserId());
        }
        return this;
    }

    public OpenChannelParams addOperators(List<User> operators) {
        if (this.operatorUserIds == null) {
            this.operatorUserIds = new ArrayList<String>();
        }
        if (operators != null) {
            for (User operator : operators) {
                if (operator == null || operator.getUserId() == null || operator.getUserId().length() <= 0) continue;
                this.operatorUserIds.add(operator.getUserId());
            }
        }
        return this;
    }

    public OpenChannelParams addOperatorId(String operatorUserId) {
        if (this.operatorUserIds == null) {
            this.operatorUserIds = new ArrayList<String>();
        }
        if (operatorUserId != null && operatorUserId.length() > 0) {
            this.operatorUserIds.add(operatorUserId);
        }
        return this;
    }

    public OpenChannelParams addOperatorIds(List<String> operatorUserIds) {
        if (this.operatorUserIds == null) {
            this.operatorUserIds = new ArrayList<String>();
        }
        if (operatorUserIds != null) {
            for (String operatorUserId : operatorUserIds) {
                if (operatorUserId == null || operatorUserId.length() <= 0) continue;
                this.operatorUserIds.add(operatorUserId);
            }
        }
        return this;
    }

    public static OpenChannelParams clone(OpenChannelParams params) {
        if (params == null) {
            return null;
        }
        OpenChannelParams clonedParmas = new OpenChannelParams();
        clonedParmas.setChannelUrl(params.channelUrl).setCustomType(params.customType).setData(params.data).setName(params.name).addOperatorIds(params.operatorUserIds);
        if (params.coverUrlOrImage instanceof File) {
            clonedParmas.setCoverImage((File)params.coverUrlOrImage);
        } else if (params.coverUrlOrImage instanceof String) {
            clonedParmas.setCoverUrl((String)params.coverUrlOrImage);
        }
        return clonedParmas;
    }

    public String toString() {
        return "OpenChannelParams{name='" + this.name + '\'' + ", channelUrl='" + this.channelUrl + '\'' + ", coverUrlOrImage=" + this.coverUrlOrImage + ", data='" + this.data + '\'' + ", customType='" + this.customType + '\'' + ", operatorUserIds=" + this.operatorUserIds + '}';
    }
}

