/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.EmojiCategory;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmojiContainer {
    private final String emojiHash;
    private final List<EmojiCategory> emojiCategories = new ArrayList<EmojiCategory>();

    EmojiContainer(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        String string = this.emojiHash = obj.has("emoji_hash") ? obj.get("emoji_hash").getAsString() : "";
        if (obj.has("emoji_categories")) {
            JsonArray array = obj.getAsJsonArray("emoji_categories");
            for (int i = 0; i < array.size(); ++i) {
                if (array.get(i) == null) continue;
                JsonObject emojiCategory = array.get(i).getAsJsonObject();
                this.emojiCategories.add(new EmojiCategory((JsonElement)emojiCategory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("emoji_hash", this.emojiHash);
        List<EmojiCategory> list = this.emojiCategories;
        synchronized (list) {
            if (this.emojiCategories.size() > 0) {
                JsonArray array = new JsonArray();
                for (EmojiCategory emojiCategory : this.emojiCategories) {
                    if (emojiCategory == null) continue;
                    array.add(emojiCategory.toJson());
                }
                obj.add("emoji_categories", (JsonElement)array);
            }
        }
        return obj;
    }

    public static EmojiContainer buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new EmojiContainer(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getEmojiHash() {
        return this.emojiHash;
    }

    public List<EmojiCategory> getEmojiCategories() {
        return Collections.unmodifiableList(this.emojiCategories);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        EmojiContainer emojiContainer = (EmojiContainer)o;
        return this.getEmojiHash().equals(emojiContainer.getEmojiHash());
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getEmojiHash());
    }

    public String toString() {
        return "EmojiContainer{emojiHash='" + this.emojiHash + '\'' + ", emojiCategories=" + this.emojiCategories + '}';
    }
}

