/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.CancelableExecutorService;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.JobTask;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

final class TaskQueue {
    private final ExecutorService executorService;

    TaskQueue(ExecutorService executorService) {
        this.executorService = executorService;
    }

    <T> Future<T> addTask(JobTask<T> task) {
        if (!this.isEnable()) {
            throw new RuntimeException("Task has been terminated");
        }
        return this.executorService.submit(task.getCallable());
    }

    <T> Future<T> addTask(JobResultTask<T> task) {
        if (!this.isEnable()) {
            throw new RuntimeException("Task has been terminated");
        }
        return this.executorService.submit(task.getCallable());
    }

    void shutdown() {
        if (this.isEnable()) {
            this.executorService.shutdown();
        }
    }

    List<Runnable> shutdownNow() {
        if (this.isEnable()) {
            return this.executorService.shutdownNow();
        }
        return Collections.emptyList();
    }

    boolean isEnable() {
        return this.executorService != null && !this.executorService.isShutdown() && !this.executorService.isTerminated();
    }

    void cancelAll() {
        this.cancelAll(false);
    }

    void cancelAll(boolean mayInterruptIfRunning) {
        if (this.executorService instanceof CancelableExecutorService) {
            CancelableExecutorService service = (CancelableExecutorService)this.executorService;
            service.cancelAll(mayInterruptIfRunning);
        }
    }
}

