/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class OpenChannelListQuery {
    private String mToken = "";
    private boolean mHasNext = true;
    private int mLimit = 20;
    private String mNameKeyword;
    private String mUrlKeyword;
    private boolean mLoading = false;
    private String mCustomType;
    private String mCustomTypeStartsWith;
    private ArrayList<String> mCustomTypes;
    private boolean includeFrozen = true;

    OpenChannelListQuery() {
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setNameKeyword(String nameKeyword) {
        this.mNameKeyword = nameKeyword;
    }

    public void setUrlKeyword(String urlKeyword) {
        this.mUrlKeyword = urlKeyword;
    }

    public void setCustomTypeFilter(String customType) {
        this.mCustomType = customType;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public boolean isIncludeFrozen() {
        return this.includeFrozen;
    }

    public void setIncludeFrozen(boolean includeFrozen) {
        this.includeFrozen = includeFrozen;
    }

    public synchronized void next(final OpenChannelListQueryResultHandler handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        if (!this.hasNext()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(new ArrayList<OpenChannel>(), null);
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<OpenChannel>>(){

            @Override
            public List<OpenChannel> call() throws Exception {
                JsonElement response = APIClient.getInstance().loadOpenChannelList(OpenChannelListQuery.this.mToken, OpenChannelListQuery.this.mLimit, OpenChannelListQuery.this.mNameKeyword, OpenChannelListQuery.this.mUrlKeyword, OpenChannelListQuery.this.mCustomType, OpenChannelListQuery.this.mCustomTypeStartsWith, OpenChannelListQuery.this.mCustomTypes, OpenChannelListQuery.this.includeFrozen);
                JsonObject result = response.getAsJsonObject();
                OpenChannelListQuery.this.mToken = result.get("next").getAsString();
                if (OpenChannelListQuery.this.mToken == null || OpenChannelListQuery.this.mToken.length() <= 0) {
                    OpenChannelListQuery.this.mHasNext = false;
                }
                JsonArray channelObjs = result.get("channels").getAsJsonArray();
                ArrayList<OpenChannel> channels = new ArrayList<OpenChannel>();
                for (int i = 0; i < channelObjs.size(); ++i) {
                    channels.add(OpenChannel.upsert(channelObjs.get(i), false));
                }
                return channels;
            }

            @Override
            public void onResultForUiThread(List<OpenChannel> result, SendBirdException e) {
                OpenChannelListQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static interface OpenChannelListQueryResultHandler {
        public void onResult(List<OpenChannel> var1, SendBirdException var2);
    }
}

