/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonObject;

class ConnectionConfig {
    private static final float DEFAULT_INTERVAL = 3.0f;
    private static final float DEFAULT_MAX_INTERVAL = 24.0f;
    private static final int DEFAULT_MULTIPLIER = 2;
    private static final int DEFAULT_RETRY_CUONT = 5;
    private static final int DEFAULT_BACKGROUND_CONNECTION_DURATION_MS = 500;
    private static final int DEFAULT_PING_INTERVAL_MS = 15000;
    private static final int DEFAULT_PONG_TIMEOUT_MS = 5000;
    private static final int DEFAULT_UNREAD_COUNT_ON_SUPER_GROUP = 1;
    private float baseInterval = 3.0f;
    private float maxInterval = 24.0f;
    private int multiplier = 2;
    private int maxRetryCount = 5;
    private int pingInterval = 15000;
    private int pongTimeout = 5000;
    private long lastConnectedAt = 0L;
    private long bcDuration = 500L;
    private int maxUnreadCountOnSuperGroup = 1;

    ConnectionConfig() {
    }

    ConnectionConfig(JsonObject json) {
        this.upsert(json);
    }

    void upsert(JsonObject json) {
        if (json.has("ping_interval")) {
            this.pingInterval = json.get("ping_interval").getAsInt() * 1000;
        }
        if (json.has("pong_timeout") && json.get("pong_timeout").isJsonPrimitive()) {
            this.pongTimeout = json.get("pong_timeout").getAsInt() * 1000;
        }
        if (json.has("login_ts") && json.get("login_ts").isJsonPrimitive()) {
            this.lastConnectedAt = json.get("login_ts").getAsLong();
        }
        if (json.has("max_unread_cnt_on_super_group")) {
            this.maxUnreadCountOnSuperGroup = json.get("max_unread_cnt_on_super_group").getAsInt();
        }
        if (json.has("bc_duration") && json.get("bc_duration").isJsonPrimitive()) {
            this.bcDuration = json.get("bc_duration").getAsInt();
            if (this.bcDuration == 0L) {
                this.bcDuration = 500L;
            } else if (this.bcDuration > 0L) {
                this.bcDuration *= 1000L;
            }
        }
        if (json.has("reconnect") && json.get("reconnect").isJsonObject()) {
            JsonObject reconnectObj = json.get("reconnect").getAsJsonObject();
            if (reconnectObj.has("interval")) {
                this.baseInterval = (float)Math.round(reconnectObj.get("interval").getAsFloat() * 10.0f) / 10.0f;
            }
            if (reconnectObj.has("max_interval")) {
                this.maxInterval = reconnectObj.get("max_interval").getAsFloat();
            }
            if (reconnectObj.has("mul")) {
                this.multiplier = reconnectObj.get("mul").getAsInt();
            }
            if (reconnectObj.has("retry_cnt")) {
                this.maxRetryCount = reconnectObj.get("retry_cnt").getAsInt();
            }
        }
    }

    float getBackoffPeriod() {
        return this.multiplier;
    }

    float getBaseInterval() {
        return this.baseInterval;
    }

    float getMaxInterval() {
        return this.maxInterval;
    }

    int getMultiplier() {
        return this.multiplier;
    }

    int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    int getPingInterval() {
        return this.pingInterval;
    }

    int getPongTimeout() {
        return this.pongTimeout;
    }

    long getLastConnectedAt() {
        return this.lastConnectedAt;
    }

    long getBcDuration() {
        return this.bcDuration;
    }

    float getRetryDelayMillis(int retryCount) {
        return Math.min(retryCount == 0 ? 0.0f : this.maxInterval, this.baseInterval + (float)(retryCount * this.multiplier)) * 1000.0f;
    }

    public int getMaxUnreadCountOnSuperGroup() {
        return this.maxUnreadCountOnSuperGroup;
    }

    static int getDefaultBgConnectionDurationMs() {
        return 500;
    }

    public String toString() {
        return "ConnectionConfig{DEFAULT_INTERVAL=3.0, DEFAULT_MAX_INTERVAL=24.0, DEFAULT_MULTIPLIER=2, DEFAULT_RETRY_CUONT=5, baseInterval=" + this.baseInterval + ", maxInterval=" + this.maxInterval + ", multiplier=" + this.multiplier + ", maxRetryCount=" + this.maxRetryCount + ", pingInterval=" + this.pingInterval + ", pongTimeout=" + this.pongTimeout + ", lastConnectedAt=" + this.lastConnectedAt + ", maxUnreadCountOnSuperGroup=" + this.maxUnreadCountOnSuperGroup + ", bcDuration=" + this.bcDuration + '}';
    }
}

