/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Log;
import com.sendbird.android.APIClient;
import com.sendbird.android.CancelableExecutorService;
import com.sendbird.android.Command;
import com.sendbird.android.Connection;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SocketManager;
import com.sendbird.android.TaskQueue;
import com.sendbird.android.handlers.SessionHandler;
import com.sendbird.android.handlers.SessionTokenRequester;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.utils.TimeoutLock;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class Authentication {
    private final int MAX_RETRY_COUNT = 3;
    private final TaskQueue sessionTaskQueue = new TaskQueue(CancelableExecutorService.newSingleThreadExecutor());
    private final AtomicInteger expirationCode = new AtomicInteger(0);
    private final AtomicLong refreshTs = new AtomicLong(0L);
    private final AtomicInteger retryCount = new AtomicInteger();
    private final UpdateSessionJobResultTask updateSessionJobResultTask = new UpdateSessionJobResultTask();
    private String accessToken;

    Authentication(String token) {
        this.accessToken = token;
    }

    private void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private boolean keyExpired() {
        return this.expirationCode.get() == 400309;
    }

    private boolean tokenExpired() {
        return this.expirationCode.get() == 400302;
    }

    private boolean isExpired() {
        return SendBirdException.isSessionExpirationError(this.expirationCode.get());
    }

    static void handleSessionRefresh(SendBirdException exception, long requestTs) throws SendBirdException {
        RefreshResult refreshResult;
        Authentication authentication = SocketManager.getInstance().getAuthentication();
        if (authentication == null) {
            throw SocketManager.createConnectionRequiredException();
        }
        Future<RefreshResult> updateSessionFuture = authentication.updateSession(exception.getCode(), requestTs);
        Logger.d("future : " + updateSessionFuture);
        if (updateSessionFuture == null) {
            throw exception;
        }
        try {
            refreshResult = updateSessionFuture.get();
        }
        catch (Exception e) {
            throw new SendBirdException(e.getMessage(), 800502);
        }
        Logger.d("refresh result : " + (Object)((Object)refreshResult));
        if (refreshResult == null) {
            throw new SendBirdException("Error occurred while refreshing the session.", 800502);
        }
        if (refreshResult == RefreshResult.DECLINED) {
            throw new SendBirdException("Session refresh had been declined.", 800502);
        }
    }

    private synchronized void updateExpirationCode(int errorCode, long ts) {
        if (!SendBirdException.isSessionExpirationError(errorCode)) {
            Logger.d("Not an expiration error code: " + errorCode);
            return;
        }
        if (errorCode == 400309 && this.tokenExpired()) {
            Logger.d("token expired already. ignoring key expiration code.");
            return;
        }
        long refreshedTs = this.refreshTs.get();
        Logger.d("refreshedAt : " + refreshedTs + ", expiration ts : " + ts);
        if (ts < refreshedTs) {
            Logger.d("refreshed already.");
            return;
        }
        this.setExpirationCode(errorCode);
    }

    private void setExpirationCode(int code) {
        this.expirationCode.set(code);
    }

    private void setRefreshed() {
        this.retryCount.set(0);
        this.refreshTs.set(System.currentTimeMillis());
        this.setExpirationCode(0);
        Logger.i("refreshed on : " + this.refreshTs.get(), new Object[0]);
    }

    void destroy() {
        Logger.d("destroy authentication");
        this.sessionTaskQueue.cancelAll(true);
    }

    synchronized Future<RefreshResult> updateSession(int code, long requestTs) {
        Logger.d("updating session key. sessionHandler : " + SendBird.getSessionHandler());
        SessionHandler sessionHandler = SendBird.getSessionHandler();
        if (sessionHandler == null) {
            return null;
        }
        this.updateExpirationCode(code, requestTs);
        return this.sessionTaskQueue.addTask(this.updateSessionJobResultTask);
    }

    private String fetchTokenFromApp(final SessionHandler sessionHandler) throws SendBirdException {
        Logger.d("sessionHandler : " + sessionHandler);
        if (sessionHandler == null) {
            throw new SendBirdException("Session handler is not registered", 800502);
        }
        final TimeoutLock tokenLock = new TimeoutLock(SendBird.Options.authenticationTimeout, TimeUnit.SECONDS);
        final AtomicBoolean result = new AtomicBoolean();
        final AtomicReference newTokenRef = new AtomicReference();
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                Logger.d("request for new token");
                sessionHandler.onSessionTokenRequired(new SessionTokenRequester(){

                    @Override
                    public void onSuccess(String newToken) {
                        Logger.d("new token : " + newToken);
                        result.set(true);
                        newTokenRef.set(newToken);
                        tokenLock.release();
                    }

                    @Override
                    public void onFail() {
                        Logger.d("failed");
                        result.set(false);
                        tokenLock.release();
                    }
                });
            }
        });
        try {
            Logger.d("waiting for new token");
            tokenLock.await();
        }
        catch (TimeoutLock.TimeoutException te) {
            throw new SendBirdException("Timeout on getting new token.", 800500);
        }
        catch (Exception e) {
            throw new SendBirdException("Interrupted on getting new token.", 800502);
        }
        Logger.d("fetch token success : " + result.get() + ", token : " + (String)newTokenRef.get());
        if (result.get()) {
            return (String)newTokenRef.get();
        }
        throw new SendBirdException("Failed to get access token.", 800500);
    }

    private void tryRefreshSessionKey() throws SendBirdException {
        Logger.d("connected : " + SocketManager.getInstance().isConnected());
        if (SocketManager.getInstance().isConnected()) {
            try {
                this.refreshSessionKeyByLOGI();
            }
            catch (SendBirdException e) {
                if (e.isSessionExpirationError()) {
                    throw e;
                }
                Logger.d("refreshed by LOGI exception : " + Log.getStackTraceString((Throwable)e));
                this.refreshSessionKeyByApi();
            }
        } else {
            this.refreshSessionKeyByApi();
        }
    }

    private void refreshSessionKeyByLOGI() throws SendBirdException {
        boolean refreshed;
        Command logiCommand = Command.bLogi(this.accessToken);
        Logger.d("logiCommand : " + logiCommand);
        final AtomicReference logiAckRef = new AtomicReference();
        final TimeoutLock timeoutLock = new TimeoutLock(SendBird.Options.wsResponseTimeoutSec, TimeUnit.SECONDS);
        SocketManager.getInstance().sendCommand(logiCommand, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, SendBirdException e) {
                Logger.i("LOGI ack : " + acked + ", error : " + e, new Object[0]);
                if (e == null) {
                    logiAckRef.set(acked);
                }
                timeoutLock.release();
            }
        });
        try {
            timeoutLock.await();
        }
        catch (TimeoutLock.TimeoutException e) {
            throw new SendBirdException("Timed out on receiving new session key.", 800502);
        }
        catch (InterruptedException e) {
            throw new SendBirdException("Interrupted on receiving new session key.", 800502);
        }
        Command logiResponse = (Command)logiAckRef.get();
        Logger.d("logiResponse : " + logiResponse);
        if (logiResponse == null) {
            throw new SendBirdException("Didn't receive any response on session key.", 800502);
        }
        SendBirdException logiException = Connection.parseLOGIException(logiResponse);
        if (logiException != null) {
            Logger.d("received error in LOGI response. " + logiException);
            throw logiException;
        }
        JsonObject obj = logiResponse.getJsonElement().getAsJsonObject();
        if (obj.has("new_key") && (refreshed = APIClient.getInstance().setSessionKey(obj.get("new_key").getAsString()))) {
            this.setRefreshed();
        }
    }

    private void refreshSessionKeyByApi() throws SendBirdException {
        try {
            boolean refreshed;
            Logger.d("refreshing by api");
            JsonElement response = APIClient.getInstance().refreshSessionKey(this.accessToken);
            Logger.d("response : " + response);
            JsonObject result = response.getAsJsonObject();
            if (result.has("key") && (refreshed = APIClient.getInstance().setSessionKey(result.get("key").getAsString()))) {
                this.setRefreshed();
            }
        }
        catch (Exception e) {
            throw e instanceof SendBirdException ? (SendBirdException)e : new SendBirdException(e.getMessage(), 800502);
        }
    }

    public String toString() {
        return "Session{, accessToken='" + this.accessToken + '\'' + '}';
    }

    private class UpdateSessionJobResultTask
    extends JobResultTask<RefreshResult> {
        private UpdateSessionJobResultTask() {
        }

        @Override
        public RefreshResult call() throws Exception {
            final SessionHandler sessionHandler = SendBird.getSessionHandler();
            Logger.i("update job start. sessionHandler : " + sessionHandler, new Object[0]);
            if (sessionHandler == null) {
                return RefreshResult.DECLINED;
            }
            Logger.d("expired : " + Authentication.this.isExpired());
            if (!Authentication.this.isExpired()) {
                return RefreshResult.ALREADY_REFRESHED;
            }
            if (TextUtils.isEmpty((CharSequence)Authentication.this.accessToken)) {
                Logger.d("guest login.");
                Authentication.this.updateExpirationCode(400309, Authentication.this.refreshTs.get());
            }
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    sessionHandler.onSessionExpired();
                }
            });
            Authentication.this.retryCount.set(0);
            while (Authentication.this.retryCount.getAndIncrement() < 3) {
                boolean tokenExpired = Authentication.this.tokenExpired();
                boolean keyExpired = Authentication.this.keyExpired();
                Logger.d("retryCount : " + Authentication.this.retryCount.get() + ", tokenExpired : " + tokenExpired + ", keyExpired : " + keyExpired);
                if (tokenExpired) {
                    String newToken = Authentication.this.fetchTokenFromApp(sessionHandler);
                    if (newToken == null) {
                        Logger.i("App declined to refresh the session", new Object[0]);
                        return RefreshResult.DECLINED;
                    }
                    Authentication.this.setAccessToken(newToken);
                    Logger.i("setToken done", new Object[0]);
                }
                if (!tokenExpired && !keyExpired) continue;
                try {
                    Authentication.this.tryRefreshSessionKey();
                    Logger.d("refresh done");
                    break;
                }
                catch (SendBirdException e) {
                    Logger.d(e);
                    if (!e.isSessionExpirationError()) continue;
                    Authentication.this.updateExpirationCode(e.getCode(), Authentication.this.refreshTs.get());
                }
            }
            if (Authentication.this.retryCount.get() >= 3 && Authentication.this.isExpired()) {
                throw new SendBirdException("Max retry for updating session key has exceeded.", 800502);
            }
            return RefreshResult.REFRESHED;
        }

        @Override
        void onResultForUiThread(RefreshResult result, SendBirdException e) {
            SessionHandler sessionHandler = SendBird.getSessionHandler();
            Logger.i("updateSessionKey result : " + (Object)((Object)result) + ", sessionHandler : " + sessionHandler + ", error : " + e, new Object[0]);
            if (sessionHandler == null) {
                return;
            }
            if (e != null) {
                sessionHandler.onSessionError(e);
                return;
            }
            if (result != null) {
                switch (result) {
                    case REFRESHED: {
                        sessionHandler.onSessionRefreshed();
                        break;
                    }
                    case DECLINED: {
                        if (SendBird.getCurrentUser() != null) {
                            SendBird.disconnect(null);
                        }
                        sessionHandler.onSessionClosed();
                        break;
                    }
                }
            }
        }
    }

    private static enum RefreshResult {
        ALREADY_REFRESHED,
        REFRESHED,
        DECLINED;

    }
}

