/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import com.sendbird.android.APIClient;
import com.sendbird.android.AckSession;
import com.sendbird.android.CancelableExecutorService;
import com.sendbird.android.ChannelManager;
import com.sendbird.android.Command;
import com.sendbird.android.CommandType;
import com.sendbird.android.Connection;
import com.sendbird.android.ConnectionConfig;
import com.sendbird.android.ConnectionManager;
import com.sendbird.android.EventController;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.JobTask;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SendBirdPushHelper;
import com.sendbird.android.TaskQueue;
import com.sendbird.android.TimeoutScheduler;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.utils.CancelableThreadHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class SocketManager
implements Connection.WSClientHandler {
    static String CUSTOM_WS_HOST;
    static String CUSTOM_API_HOST;
    private Connection connection;
    private CancelableThreadHolder reconnectThreadHolder;
    private TaskQueue commandTask = new TaskQueue(CancelableExecutorService.newSingleThreadExecutor());
    private final Object connectionLock = new Object();
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private final AtomicBoolean reconnectFromError = new AtomicBoolean(false);
    private final AtomicInteger retryCount = new AtomicInteger(1);
    private final TaskQueue connectTaskQueue = new TaskQueue(CancelableExecutorService.newSingleThreadExecutor());
    private final TaskQueue reconnectTaskQueue = new TaskQueue(CancelableExecutorService.newSingleThreadExecutor());
    private final CopyOnWriteArraySet<SendBird.ConnectHandler> connectionHandlerSet = new CopyOnWriteArraySet();
    private final ConcurrentHashMap<String, SendBird.ConnectionHandler> reconnectionHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConnectionManager.NetworkHandler> localNetworkHandlers = new ConcurrentHashMap();
    private final CopyOnWriteArraySet<CountDownLatch> lazyCommandSet = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<TimeoutScheduler> authenticationTimers = new CopyOnWriteArraySet();
    private final ConcurrentHashMap<String, AckSession> ackSessionMap = new ConcurrentHashMap();

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        return SocketHolder.INSTANCE;
    }

    static SendBirdException createConnectionRequiredException() {
        return new SendBirdException("Connection must be made.", 800101);
    }

    private void addAuthenticationTimer(TimeoutScheduler timer) {
        this.authenticationTimers.add(timer);
    }

    private boolean removeAuthenticationTimer(TimeoutScheduler timer) {
        boolean removed = false;
        if (timer != null) {
            timer.stop();
            removed = this.authenticationTimers.remove(timer);
        }
        if (this.connecting.get() && this.connectionHandlerSet.isEmpty() && this.authenticationTimers.isEmpty()) {
            this.connecting.set(false);
        }
        return removed;
    }

    void addConnectionHandler(String identifier, SendBird.ConnectionHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        this.reconnectionHandlers.put(identifier, handler);
    }

    SendBird.ConnectionHandler removeConnectionHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return this.reconnectionHandlers.remove(identifier);
    }

    void removeAllConnectionHandlers() {
        this.reconnectionHandlers.clear();
    }

    void addNetworkHandler(String identifier, ConnectionManager.NetworkHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        this.localNetworkHandlers.put(identifier, handler);
    }

    ConnectionManager.NetworkHandler removeNetworkHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return this.localNetworkHandlers.remove(identifier);
    }

    void removeAllNetworkHandlers() {
        this.localNetworkHandlers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectionHandler(SendBird.ConnectHandler handler) {
        CopyOnWriteArraySet<SendBird.ConnectHandler> copyOnWriteArraySet = this.connectionHandlerSet;
        synchronized (copyOnWriteArraySet) {
            if (handler != null) {
                Logger.d("CONNECT", "++ addHandeler");
                this.connectionHandlerSet.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllConnectHandlers(User user, SendBirdException e) {
        HashSet<SendBird.ConnectHandler> tempHandlerSet;
        CopyOnWriteArraySet<SendBird.ConnectHandler> copyOnWriteArraySet = this.connectionHandlerSet;
        synchronized (copyOnWriteArraySet) {
            tempHandlerSet = new HashSet<SendBird.ConnectHandler>(this.connectionHandlerSet);
            this.connectionHandlerSet.clear();
        }
        for (SendBird.ConnectHandler handler : tempHandlerSet) {
            handler.onConnected(user, e);
        }
    }

    private void connectionComplete(User user, SendBirdException e) {
        Logger.d(">> connectionComplete() e : " + e);
        if (e == null) {
            ChannelManager.getInstance().startWatchdog();
            SendBirdPushHelper.retryPendingAction();
        }
        this.processAllConnectHandlers(user, e);
        this.notifyAllLazyCommands();
    }

    SendBird.ConnectionState getConnectionState() {
        Logger.i("__  connecting=%s, reconnecting=%s, connection=%s, getCurrentState=%s", new Object[]{this.connecting.get(), this.reconnecting.get(), this.connection, this.connection != null ? this.connection.getCurrentState() : "connection is null"});
        if (this.connecting.get()) {
            return SendBird.ConnectionState.CONNECTING;
        }
        if (this.connection == null) {
            return SendBird.ConnectionState.CLOSED;
        }
        return this.connection.getCurrentState();
    }

    boolean isConnecting() {
        return this.getConnectionState() == SendBird.ConnectionState.CONNECTING;
    }

    boolean isConnected() {
        return this.getConnectionState() == SendBird.ConnectionState.OPEN;
    }

    boolean isDisconnected() {
        return this.getConnectionState() == SendBird.ConnectionState.CLOSED;
    }

    boolean isReconnectFromError() {
        return this.reconnectFromError.get();
    }

    boolean isReconnecting() {
        return this.reconnecting.get();
    }

    synchronized void connectFromAuthenticate(ConnectionManager.AuthInfoRequestHandler authInfoRequestHandler, final ConnectionManager.AuthenticateHandler handler) {
        Logger.d(">> SocketManager::connectFromAuthenticate() ");
        if (SendBird.getCurrentUser() != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Logger.d("[ConnectionManager] onAuthenticated()");
                    if (handler != null) {
                        handler.onAuthenticated(SendBird.getCurrentUser(), null);
                    }
                }
            });
            return;
        }
        long timeout = SendBird.Options.authenticationTimeout * 1000;
        Logger.d("++ connectFromAuthenticate timeout : " + timeout);
        final TimeoutScheduler timer = new TimeoutScheduler(timeout);
        this.addAuthenticationTimer(timer);
        timer.setEventHandler(new TimeoutScheduler.TimeoutEventhandler(){

            @Override
            public void onTimeout(Object extra) {
                Logger.i("++ onTimeout()", new Object[0]);
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SocketManager.this.removeAuthenticationTimer(timer) && handler != null) {
                            handler.onAuthenticated(null, new SendBirdException("setAuthInfo() or setAuthInfoWithHostInfo() in AuthInfoRequester must be called before authentication timeout."));
                        }
                    }
                });
            }
        });
        timer.once();
        if (authInfoRequestHandler != null) {
            authInfoRequestHandler.onAuthInfoRequest(new ConnectionManager.AuthInfoRequester(){

                @Override
                public void setAuthInfo(String userId, String accessToken) {
                    SocketManager.this.localAuthenticate(userId, accessToken, null, null, handler, timer);
                }

                @Override
                public void setAuthInfoWithHostInfo(String userId, String accessToken, String apiHost, String wsHost) {
                    SocketManager.this.localAuthenticate(userId, accessToken, apiHost, wsHost, handler, timer);
                }
            });
        }
    }

    private void localAuthenticate(String userId, String accessToken, String apiHost, String wsHost, final ConnectionManager.AuthenticateHandler handler, TimeoutScheduler timer) {
        if (this.removeAuthenticationTimer(timer)) {
            Logger.d("[SocketManager] localAuthenticate()");
            this.connect(userId, accessToken, apiHost, wsHost, new SendBird.ConnectHandler(){

                @Override
                public void onConnected(User user, SendBirdException e) {
                    Logger.d("[SocketManager] onAuthenticated()" + (e != null ? " => " + e.getMessage() : ""));
                    if (handler != null) {
                        handler.onAuthenticated(user, e);
                    }
                }
            });
        }
    }

    synchronized Future<User> connect(String userId, String accessToken, String apiHost, String wsHost, final SendBird.ConnectHandler handler) {
        Logger.d("-- connect start()");
        Logger.d("-- connect userId=%s", userId);
        CUSTOM_API_HOST = apiHost;
        CUSTOM_WS_HOST = wsHost;
        if (TextUtils.isEmpty((CharSequence)userId)) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onConnected(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                }
            });
            return null;
        }
        TimeoutScheduler.await(30L);
        Logger.d("-- connection=%s", new Object[]{this.connection});
        boolean isSameRequest = this.connection != null && this.connection.isSameConnectInfo(userId);
        Logger.d("-- isSameRequest : " + isSameRequest);
        Logger.d("++ connect status : %s, connecting=%s", new Object[]{this.getConnectionState(), this.connecting.get()});
        if (isSameRequest && this.isConnected()) {
            Logger.d("++ isSameRequest && isConnected()");
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    handler.onConnected(SendBird.getCurrentUser(), null);
                }
            });
            return SocketManager.dummyFuture(SendBird.getCurrentUser());
        }
        this.addConnectionHandler(handler);
        if (this.isConnecting() && !this.isReconnecting()) {
            Logger.d("-- return (already connecting)");
            return SocketManager.dummyFuture(SendBird.getCurrentUser());
        }
        if (this.isReconnecting()) {
            Logger.d("++ isReconnecting()");
            this.disconnect(false, null);
        }
        if (!isSameRequest && !this.isDisconnected()) {
            Logger.d("++ !isSameRequest && !isDisconnected()");
            this.disconnect(true, null);
        }
        APIClient.getInstance().evictAllConnections();
        this.connecting.set(true);
        return this.connectInternal(userId, accessToken, false);
    }

    private Future<User> connectInternal(final String userId, final String accessToken, final boolean fromReconnect) {
        Logger.d(">> connectInternal(fromReconnect: %s)", fromReconnect);
        return this.connectTaskQueue.addTask(new JobResultTask<User>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public User call() throws Exception {
                Logger.d("++ connectInternal request connect() state : " + (Object)((Object)SocketManager.this.getConnectionState()));
                try {
                    boolean isSameRequest;
                    boolean bl = isSameRequest = SocketManager.this.connection != null && SocketManager.this.connection.isSameConnectInfo(userId);
                    if (isSameRequest && SocketManager.this.isConnected()) {
                        Logger.d("-- return (connection is already connected)");
                        User user = SendBird.getCurrentUser();
                        return user;
                    }
                    if (SocketManager.this.connection != null && SocketManager.this.isConnected()) {
                        SocketManager.this.disconnect(!isSameRequest, null);
                    }
                    Object object = SocketManager.this.connectionLock;
                    synchronized (object) {
                        SocketManager.this.connection = new Connection(userId, accessToken, SocketManager.this);
                        Logger.i("++ new Connection is made %s", new Object[]{SocketManager.this.connection});
                        SocketManager.this.connection.connect();
                    }
                }
                finally {
                    SocketManager.this.connecting.set(false);
                }
                return SendBird.getCurrentUser();
            }

            @Override
            public void onResultForUiThread(User user, SendBirdException e) {
                if (!fromReconnect) {
                    SocketManager.this.connectionComplete(user, e);
                }
                Logger.d("-- connect end(), e = %s, fromReconnect = %s", e, fromReconnect);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void disconnect(boolean logout, final SendBird.DisconnectHandler handler) {
        ArrayList<AckSession> sessions;
        Logger.d("++ disconnect start (logout : %s, state : %s, isReconnecting : %s)", new Object[]{logout, this.getConnectionState(), this.isReconnecting()});
        TimeoutScheduler.await(30L);
        this.connectTaskQueue.cancelAll(true);
        this.reconnectTaskQueue.cancelAll(true);
        this.commandTask.cancelAll(true);
        Logger.i("++ ackSessionMap : " + this.ackSessionMap, new Object[0]);
        Object object = this.ackSessionMap;
        synchronized (object) {
            sessions = new ArrayList<AckSession>(this.ackSessionMap.values());
            this.ackSessionMap.clear();
        }
        for (AckSession session : sessions) {
            if (session == null) continue;
            Logger.i("-- session canceled()", new Object[0]);
            session.cancel();
        }
        this.connecting.set(false);
        this.reconnecting.set(false);
        ChannelManager.getInstance().stopWatchdog();
        object = this.connectionLock;
        synchronized (object) {
            Logger.d("-- connection : " + (Object)((Object)this.connection));
            if (this.connection != null) {
                this.connection.disconnect();
                this.connection = null;
            }
        }
        if (logout) {
            Logger.d("Clear local data.");
            APIClient.getInstance().cancelAllRequests();
            APIClient.getInstance().clearKeys();
            SendBird.setEkey("");
            ChannelManager.getInstance().clearUnreadCount();
            SendBird.setCurrentUser(null);
            OpenChannel.clearEnteredChannels();
            OpenChannel.clearCache();
            GroupChannel.clearCache();
        }
        Logger.d("++ isReconnecting : " + this.isReconnecting());
        Logger.d("++ request disconnect finished state : " + (Object)((Object)this.getConnectionState()));
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (handler != null) {
                    handler.onDisconnected();
                }
            }
        });
    }

    synchronized boolean reconnect(final boolean fromOnError) {
        Logger.d(">> reconnect() from error : %s, reconnecting : %s", fromOnError, this.reconnecting.get());
        User user = SendBird.getCurrentUser();
        if (user == null || TextUtils.isEmpty((CharSequence)user.getUserId()) || TextUtils.isEmpty((CharSequence)APIClient.getInstance().getSessionKey())) {
            Logger.d("-- return currentUser =%s, sessionKey =%s", SendBird.getCurrentUser(), APIClient.getInstance().getSessionKey());
            return false;
        }
        this.reconnectFromError.set(fromOnError);
        if (this.reconnecting.get()) {
            if (this.reconnectThreadHolder != null) {
                this.reconnectThreadHolder.awake();
            }
            this.retryCount.set(0);
            Logger.d("-- return reconnecting =%s, retryCount =%s", this.reconnecting.get(), this.retryCount.get());
            return false;
        }
        this.disconnect(false, null);
        APIClient.getInstance().evictAllConnections();
        this.notifyReconnectState(ReconnectState.START);
        final String userId = SendBird.getCurrentUser().getUserId();
        Logger.d("++ reconnect user id : " + userId);
        this.reconnectTaskQueue.addTask(new JobResultTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    SocketManager.this.reconnecting.set(true);
                    SocketManager.this.reconnectInternal(userId);
                    SocketManager.this.reconnecting.set(false);
                    ChannelManager.tryToEnterEnteredOpenChannels();
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedException)) {
                        SocketManager.this.disconnect(false, null);
                    }
                    throw e;
                }
                finally {
                    SocketManager.this.reconnecting.set(false);
                    SocketManager.this.reconnectFromError.compareAndSet(true, false);
                }
            }

            @Override
            public void onResultForUiThread(Boolean isComplete, SendBirdException e) {
                Logger.i("++ reconnect isComplete : %s, e : %s", isComplete, e);
                if (isComplete != null && isComplete.booleanValue()) {
                    if (e != null || !SocketManager.this.isConnected()) {
                        if (SocketManager.this.isDisconnected()) {
                            SocketManager.this.connectionComplete(null, SocketManager.createConnectionRequiredException());
                        } else {
                            Logger.i("The connection is in the middle of connecting..", new Object[0]);
                        }
                    } else {
                        SocketManager.this.onReconnected(fromOnError);
                    }
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnectInternal(String userId) throws InterruptedException {
        Logger.d(">> reconnectInternal()");
        this.retryCount.set(0);
        ConnectionConfig config = Connection.getConnectionConfig();
        int maxRetryCount = config.getMaxRetryCount();
        Logger.d("++ maxRetryCount : " + maxRetryCount);
        while (maxRetryCount < 0 || this.retryCount.get() < maxRetryCount) {
            try {
                this.reconnectThreadHolder = new CancelableThreadHolder();
                float delay = config.getRetryDelayMillis(this.retryCount.getAndIncrement());
                Logger.d("++ reconnect delay : " + delay);
                if (delay > 0.0f) {
                    this.reconnectThreadHolder.sleep((long)delay);
                    Logger.d("++ reconnect sleep released");
                }
                Logger.d("++ reconnect connect state : %s, user id : %s", new Object[]{this.getConnectionState(), userId});
                if (this.isDisconnected()) {
                    this.connectInternal(userId, null, true).get();
                }
                if (!this.isConnected()) continue;
                this.notifyReconnectState(ReconnectState.SUCCESS);
                boolean bl = true;
                return bl;
            }
            catch (InterruptedException interrupt) {
                Logger.e("-- reconnect interrupted retry count = " + this.retryCount.get());
                throw interrupt;
            }
            catch (Exception e) {
                Logger.e("-- reconnect fail retry count = " + this.retryCount.get() + " message : " + e.getMessage());
            }
            finally {
                Logger.d("++ reconnect retrycount : " + this.retryCount.get());
                this.reconnectThreadHolder = null;
            }
        }
        this.notifyReconnectState(ReconnectState.FAIL);
        return false;
    }

    private void onReconnected(boolean reconnectFromError) {
        Logger.d("[SendBird] reconnected()");
        this.connectionComplete(SendBird.getCurrentUser(), null);
        if (reconnectFromError) {
            this.reconnectSucceededFromOnErrorForNetworkHandler();
        }
    }

    void notifyReconnectCallbackForBackwardCompatibilityBlocking() {
        this.notifyReconnectState(ReconnectState.START);
        try {
            ChannelManager.tryToEnterEnteredOpenChannels();
            this.onReconnected(false);
            this.notifyReconnectState(ReconnectState.SUCCESS);
        }
        catch (Exception e) {
            this.disconnect(false, null);
            this.notifyReconnectState(ReconnectState.FAIL);
        }
    }

    private void notifyReconnectState(final ReconnectState state) {
        Logger.d(">> ConnectManager::notifyReconnectState() state : " + state.name());
        if (SendBird.isAppBackground() || this.reconnectionHandlers.isEmpty()) {
            return;
        }
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                block4: for (SendBird.ConnectionHandler handler : SocketManager.this.reconnectionHandlers.values()) {
                    switch (state) {
                        case START: {
                            handler.onReconnectStarted();
                            continue block4;
                        }
                        case SUCCESS: {
                            handler.onReconnectSucceeded();
                            continue block4;
                        }
                    }
                    handler.onReconnectFailed();
                }
            }
        });
    }

    private void reconnectSucceededFromOnErrorForNetworkHandler() {
        Logger.d("[SendBird] reconnectSucceededFromOnErrorForNetworkHandler()");
        if (SendBird.isAppBackground() || this.localNetworkHandlers.isEmpty()) {
            return;
        }
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                for (ConnectionManager.NetworkHandler handler : SocketManager.this.localNetworkHandlers.values()) {
                    if (handler == null) continue;
                    handler.onReconnected();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllLazyCommands() {
        CopyOnWriteArraySet<CountDownLatch> copyOnWriteArraySet = this.lazyCommandSet;
        synchronized (copyOnWriteArraySet) {
            for (CountDownLatch lock : this.lazyCommandSet) {
                lock.countDown();
            }
            this.lazyCommandSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitUntilConnected() throws SendBirdException {
        CountDownLatch lazyLock = new CountDownLatch(1);
        CopyOnWriteArraySet<CountDownLatch> copyOnWriteArraySet = this.lazyCommandSet;
        synchronized (copyOnWriteArraySet) {
            this.lazyCommandSet.add(lazyLock);
        }
        try {
            lazyLock.await(SendBird.Options.connectionTimeout + SendBird.Options.wsResponseTimeoutSec, TimeUnit.SECONDS);
            if (!this.isConnected()) {
                throw SocketManager.createConnectionRequiredException();
            }
        }
        catch (Exception e) {
            throw SocketManager.createConnectionRequiredException();
        }
    }

    Future<Boolean> sendCommand(final Command reqCommand, final boolean lazy, final Command.SendCommandHandler handler) {
        Logger.d("__ request sendCommand[%s] Start", new Object[]{reqCommand.getCommandType()});
        if (this.isDisconnected()) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection closed.", 800200));
            }
            return SocketManager.dummyFuture(false);
        }
        return this.commandTask.addTask(new JobTask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                block7: {
                    try {
                        Logger.d("++ request sendCommand[%s] connected : %s, isReconnectFromError : %s", new Object[]{reqCommand.getCommandType(), SocketManager.this.isConnected(), SocketManager.this.isReconnectFromError()});
                        if (!SocketManager.this.isConnected() && !lazy || SocketManager.this.isReconnectFromError()) {
                            throw new SendBirdException("WS connection closed.", 800200);
                        }
                        if (reqCommand.isAckRequired() && reqCommand.hasRequestId()) {
                            AckSession session = new AckSession(SendBird.Options.wsResponseTimeoutSec * 1000, handler);
                            ConcurrentHashMap concurrentHashMap = SocketManager.this.ackSessionMap;
                            synchronized (concurrentHashMap) {
                                SocketManager.this.ackSessionMap.putIfAbsent(reqCommand.getRequestId(), session);
                                SocketManager.this.send(reqCommand, lazy);
                                session.start();
                                break block7;
                            }
                        }
                        SocketManager.this.send(reqCommand, lazy);
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (handler != null) {
                                    handler.onResult(reqCommand, null);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (handler != null) {
                                    handler.onResult(reqCommand, e instanceof SendBirdException ? (SendBirdException)e : new SendBirdException(e.getMessage(), 800220));
                                }
                            }
                        });
                    }
                }
                return true;
            }
        });
    }

    void sendPing(boolean force) {
        if (this.isConnected() && this.connection != null) {
            this.connection.sendPing(force);
        }
    }

    private void send(Command command, boolean lazy) throws SendBirdException {
        Logger.d("_____ [%s][lazy : %s] SEND START, reconnectingFromError : %s, isConnecting : %s", new Object[]{command.getCommandType(), lazy, this.isReconnectFromError(), this.isConnecting()});
        try {
            if (lazy && !this.isConnected()) {
                if (this.isDisconnected() || this.isReconnectFromError()) {
                    throw SocketManager.createConnectionRequiredException();
                }
                if (this.isConnecting()) {
                    this.awaitUntilConnected();
                }
            }
            this.connection.send(command);
        }
        catch (Throwable throwable) {
            Logger.d("_____ [%s] SEND END", new Object[]{command.getCommandType()});
            throw throwable;
        }
        Logger.d("_____ [%s] SEND END", new Object[]{command.getCommandType()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Command command) {
        SendBirdException error = null;
        ChannelManager.getInstance().processSubscribedUnreadMessageCount(command);
        CommandType commandType = command.getCommandType();
        if (commandType == CommandType.EROR) {
            JsonObject errorJson = command.getJsonElement().getAsJsonObject();
            int errCode = errorJson.get("code").getAsInt();
            String errMessage = errorJson.get("message").getAsString();
            error = new SendBirdException(errMessage, errCode);
        } else {
            EventController.getInstance().processResponse(command);
        }
        if (error != null || command.isAckRequired() && command.hasRequestId()) {
            AckSession session;
            ConcurrentHashMap<String, AckSession> concurrentHashMap = this.ackSessionMap;
            synchronized (concurrentHashMap) {
                session = this.ackSessionMap.remove(command.getRequestId());
            }
            if (session != null) {
                session.ackReceived(command, error);
            }
        }
    }

    @Override
    public void onError(boolean explicitDisconnect, SendBirdException e) {
        Logger.w(">> onError : " + e.getMessage() + ", reconnecting : " + this.reconnecting.get() + ", explicitDisconnect : " + explicitDisconnect);
        if (!explicitDisconnect && !this.reconnecting.get()) {
            ChannelManager.getInstance().stopWatchdog();
            APIClient.getInstance().cancelAllRequests();
            APIClient.getInstance().evictAllConnections();
            this.reconnect(true);
        }
    }

    private static <T> Future<T> dummyFuture() {
        return SocketManager.dummyFuture(null);
    }

    private static <T> Future<T> dummyFuture(final T def) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public T get() {
                return def;
            }

            @Override
            public T get(long timeout, TimeUnit unit) {
                return def;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }
        };
    }

    private static enum ReconnectState {
        START,
        SUCCESS,
        FAIL;

    }

    private static class SocketHolder {
        private static final SocketManager INSTANCE = new SocketManager();

        private SocketHolder() {
        }
    }
}

