/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Base64;
import com.sendbird.android.HashUtils;
import com.sendbird.android.OGImage;
import com.sendbird.android.SendBird;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;

public class OGMetaData {
    private final String title;
    private final String url;
    private final String description;
    private final OGImage ogImage;

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public OGImage getOGImage() {
        return this.ogImage;
    }

    OGMetaData(JsonObject jsonObject) {
        this.title = jsonObject.has("og:title") ? jsonObject.get("og:title").getAsString() : null;
        this.url = jsonObject.has("og:url") ? jsonObject.get("og:url").getAsString() : null;
        this.description = jsonObject.has("og:description") ? jsonObject.get("og:description").getAsString() : null;
        this.ogImage = jsonObject.get("og:image") instanceof JsonObject ? new OGImage(jsonObject.get("og:image").getAsJsonObject()) : null;
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        if (this.title != null) {
            obj.addProperty("og:title", this.title);
        }
        if (this.url != null) {
            obj.addProperty("og:url", this.url);
        }
        if (this.description != null) {
            obj.addProperty("og:description", this.description);
        }
        if (this.ogImage != null) {
            obj.add("og:image", this.ogImage.toJson());
        }
        return obj;
    }

    public static OGMetaData buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            JsonElement parsed = new JsonParser().parse(str);
            if (parsed.isJsonObject()) {
                return new OGMetaData(parsed.getAsJsonObject());
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(e);
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(e);
            return null;
        }
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.title, this.url, this.description, this.ogImage);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OGMetaData)) {
            return false;
        }
        OGMetaData other = (OGMetaData)obj;
        return TextUtils.equals((CharSequence)this.title, (CharSequence)other.title) && TextUtils.equals((CharSequence)this.url, (CharSequence)other.url) && TextUtils.equals((CharSequence)this.description, (CharSequence)other.description) && (this.ogImage == null ? other.ogImage == null : this.ogImage.equals(other.ogImage));
    }

    public String toString() {
        return "OGMetaData{title='" + this.title + '\'' + ", url='" + this.url + '\'' + ", description='" + this.description + '\'' + ", ogImage=" + this.ogImage + '}';
    }
}

