/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Base64;
import com.sendbird.android.APIClient;
import com.sendbird.android.APITaskQueue;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.JobResultTask;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class MessageSearchQuery {
    private boolean loading = false;
    private boolean hasNext = true;
    private int totalCount = 0;
    private String endToken = null;
    private final boolean reverse;
    private final boolean exactMatch;
    private final int limit;
    private final Long messageTimestampFrom;
    private final Long messageTimestampTo;
    private final String keyword;
    private final String channelUrl;
    private final String channelCustomType;
    private final Order order;

    private MessageSearchQuery(int limit, boolean reverse, String keyword, boolean exactMatch, String channelUrl, String channelCustomType, Long messageTimestampFrom, Long messageTimestampTo, Order order) {
        this.limit = limit;
        this.reverse = reverse;
        this.keyword = keyword;
        this.exactMatch = exactMatch;
        this.channelUrl = channelUrl;
        this.channelCustomType = channelCustomType;
        this.messageTimestampFrom = messageTimestampFrom;
        this.messageTimestampTo = messageTimestampTo;
        this.order = order;
    }

    MessageSearchQuery(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.hasNext = obj.has("has_next") ? obj.get("has_next").getAsBoolean() : true;
        this.endToken = obj.has("token") ? obj.get("token").getAsString() : null;
        this.totalCount = obj.has("total_count") ? obj.get("total_count").getAsInt() : 0;
        this.limit = obj.has("limit") ? obj.get("limit").getAsInt() : 20;
        this.reverse = obj.has("reverse") ? obj.get("reverse").getAsBoolean() : false;
        this.keyword = obj.has("query") ? obj.get("query").getAsString() : "";
        this.exactMatch = obj.has("exact_match") ? obj.get("exact_match").getAsBoolean() : false;
        this.channelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.channelCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
        this.messageTimestampFrom = obj.has("message_ts_from") ? Long.valueOf(obj.get("message_ts_from").getAsLong()) : null;
        this.messageTimestampTo = obj.has("message_ts_to") ? Long.valueOf(obj.get("message_ts_to").getAsLong()) : null;
        this.order = obj.has("sort_field") ? Order.fromValue(obj.get("sort_field").getAsString()) : Order.SCORE;
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("has_next", Boolean.valueOf(this.hasNext));
        obj.addProperty("end_cursor", this.endToken);
        obj.addProperty("total_count", (Number)this.totalCount);
        obj.addProperty("limit", (Number)this.limit);
        obj.addProperty("reverse", Boolean.valueOf(this.reverse));
        obj.addProperty("query", this.keyword);
        obj.addProperty("exact_match", Boolean.valueOf(this.exactMatch));
        if (this.channelUrl != null) {
            obj.addProperty("channel_url", this.channelUrl);
        }
        if (this.channelCustomType != null) {
            obj.addProperty("custom_type", this.channelCustomType);
        }
        obj.addProperty("message_ts_from", (Number)this.messageTimestampFrom);
        obj.addProperty("message_ts_to", (Number)this.messageTimestampTo);
        obj.addProperty("sort_field", this.order.getValue());
        return obj;
    }

    synchronized void setLoading(boolean tf) {
        this.loading = tf;
    }

    public synchronized void next(final MessageSearchQueryResultHandler handler) {
        if (this.isLoading()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                }
            });
            return;
        }
        if (!this.hasNext()) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onResult(new ArrayList<BaseMessage>(), null);
                    }
                }
            });
            return;
        }
        this.setLoading(true);
        APITaskQueue.addTask(new JobResultTask<List<BaseMessage>>(){

            @Override
            public List<BaseMessage> call() throws Exception {
                JsonElement response = APIClient.getInstance().queryFullTextMessageSearch(MessageSearchQuery.this.keyword, MessageSearchQuery.this.channelUrl, MessageSearchQuery.this.channelCustomType, MessageSearchQuery.this.limit, null, MessageSearchQuery.this.endToken, null, MessageSearchQuery.this.messageTimestampFrom, MessageSearchQuery.this.messageTimestampTo, MessageSearchQuery.this.order.getValue(), MessageSearchQuery.this.reverse, MessageSearchQuery.this.exactMatch);
                JsonObject result = response.getAsJsonObject();
                MessageSearchQuery.this.endToken = result.has("end_cursor") ? result.get("end_cursor").getAsString() : null;
                MessageSearchQuery.this.hasNext = result.has("has_next") ? result.get("has_next").getAsBoolean() : !TextUtils.isEmpty((CharSequence)MessageSearchQuery.this.endToken);
                MessageSearchQuery.this.totalCount = result.has("total_count") ? result.get("total_count").getAsInt() : 0;
                JsonArray jsonArray = result.get("results").getAsJsonArray();
                ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonElement jsonElement = jsonArray.get(i);
                    if (!jsonElement.isJsonObject()) continue;
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    JsonObject channelObject = jsonObject.get("channel").getAsJsonObject();
                    try {
                        messages.add(BaseMessage.build(jsonElement, channelObject.get("channel_url").getAsString(), channelObject.get("channel_type").getAsString()));
                        continue;
                    }
                    catch (Exception e1) {
                        Logger.e(e1);
                    }
                }
                return messages;
            }

            @Override
            public void onResultForUiThread(List<BaseMessage> result, SendBirdException e) {
                MessageSearchQuery.this.setLoading(false);
                if (handler != null) {
                    handler.onResult(result, e);
                }
            }
        });
    }

    public static MessageSearchQuery buildFromSerializedData(byte[] data) {
        MessageSearchQuery query = null;
        if (data != null) {
            byte[] copiedData = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                copiedData[i] = (byte)(data[i] ^ i & 0xFF);
            }
            try {
                String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
                query = new MessageSearchQuery(new JsonParser().parse(str));
            }
            catch (UnsupportedEncodingException e) {
                Logger.e(e);
            }
        }
        return query;
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public synchronized boolean isLoading() {
        return this.loading;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public String getChannelCustomType() {
        return this.channelCustomType;
    }

    public long getMessageTimestampFrom() {
        return this.messageTimestampFrom;
    }

    public long getMessageTimestampTo() {
        return this.messageTimestampTo;
    }

    public Order getOrder() {
        return this.order;
    }

    public static class Builder {
        private static final int MESSAGE_SEARCH_QUERY_DEFAULT_LIMIT = 20;
        private boolean reverse = false;
        private boolean exactMatch = false;
        private int limit = 20;
        private Long messageTimestampFrom = null;
        private Long messageTimestampTo = null;
        private String keyword = "";
        private String channelUrl = "";
        private String channelCustomType = null;
        private Order order = Order.SCORE;

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder setReverse(boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public Builder setKeyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public Builder setExactMatch(boolean exactMatch) {
            this.exactMatch = exactMatch;
            return this;
        }

        public Builder setChannelUrl(String channelUrl) {
            this.channelUrl = channelUrl;
            return this;
        }

        public Builder setChannelCustomType(String channelCustomType) {
            this.channelCustomType = channelCustomType;
            return this;
        }

        public Builder setMessageTimestampFrom(long messageTimestampFrom) {
            this.messageTimestampFrom = messageTimestampFrom;
            return this;
        }

        public Builder setMessageTimestampTo(long messageTimestampTo) {
            this.messageTimestampTo = messageTimestampTo;
            return this;
        }

        public Builder setOrder(Order order) {
            this.order = order;
            return this;
        }

        public MessageSearchQuery build() {
            return new MessageSearchQuery(this.limit, this.reverse, this.keyword, this.exactMatch, this.channelUrl, this.channelCustomType, this.messageTimestampFrom, this.messageTimestampTo, this.order);
        }
    }

    public static enum Order {
        SCORE("score"),
        TIMESTAMP("ts");

        private String value;

        private Order(String value) {
            this.value = value;
        }

        public static Order fromValue(String value) {
            for (Order order : Order.values()) {
                if (!order.getValue().equalsIgnoreCase(value)) continue;
                return order;
            }
            return SCORE;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface MessageSearchQueryResultHandler {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }
}

