/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import com.sendbird.android.APIClient;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SocketManager;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonNull;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import com.sendbird.android.shadow.okhttp3.Call;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.Request;
import com.sendbird.android.shadow.okhttp3.RequestBody;
import com.sendbird.android.shadow.okhttp3.Response;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class APIRequest {
    private final OkHttpClient client;
    private AtomicBoolean isCanceled = new AtomicBoolean(false);
    private final AtomicReference<Call> requestedCall = new AtomicReference();

    APIRequest(OkHttpClient client) {
        this.client = client;
    }

    boolean cancel() {
        Call call = this.requestedCall.getAndSet(null);
        Logger.i("++ call : %s, isCanceled : %s", call, call != null ? Boolean.valueOf(call.isCanceled()) : "call is null");
        this.isCanceled.set(true);
        if (call != null && !call.isCanceled()) {
            Logger.i("++ The requested Call is requested to cancel.", new Object[0]);
            call.cancel();
            return true;
        }
        return false;
    }

    private static String getApiHost() throws SendBirdException {
        if (SendBird.getApplicationId() == null || SendBird.getApplicationId().length() == 0) {
            throw new SendBirdException("Application ID is not set. Initialize SendBird class.", 800100);
        }
        return SocketManager.CUSTOM_API_HOST != null ? SocketManager.CUSTOM_API_HOST : "https://api-" + SendBird.getApplicationId() + ".sendbird.com";
    }

    private static Request.Builder makeRequestBuilder(String path) throws SendBirdException {
        String sessionKey = APIClient.getInstance().getSessionKey();
        boolean hasSessionKey = !TextUtils.isEmpty((CharSequence)sessionKey);
        Logger.d("++ hasSessionKey : " + hasSessionKey);
        if (hasSessionKey && SendBird.getConnectionState() == SendBird.ConnectionState.CLOSED && !SendBird.isAppBackground()) {
            SendBird.reconnect();
        }
        if (!hasSessionKey) {
            if (SocketManager.getInstance().isReconnectFromError()) {
                throw SocketManager.createConnectionRequiredException();
            }
            SendBird.ConnectionState status = SocketManager.getInstance().getConnectionState();
            Logger.i("++ SessionKey is empty, connection state : %s", new Object[]{status});
            switch (status) {
                case CLOSED: {
                    throw SocketManager.createConnectionRequiredException();
                }
                case CONNECTING: {
                    SocketManager.getInstance().awaitUntilConnected();
                    break;
                }
            }
        }
        return new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SB-User-Agent", SendBird.makeExUserAgentString()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).header("Session-Key", APIClient.getInstance().getSessionKey()).url(APIRequest.getApiHost() + path);
    }

    JsonElement GET(String path) throws SendBirdException {
        Logger.d("++ request GET path : " + path);
        Request.Builder builder = APIRequest.makeRequestBuilder(path).get();
        return this.request(builder.build());
    }

    JsonElement POST(String path, RequestBody body) throws SendBirdException {
        Logger.d("++ request POST path : " + path);
        Request.Builder builder = APIRequest.makeRequestBuilder(path).post(body);
        return this.request(builder.build());
    }

    JsonElement PUT(String path, RequestBody body) throws SendBirdException {
        Logger.d("++ request PUT path : " + path);
        Request.Builder builder = APIRequest.makeRequestBuilder(path).put(body);
        return this.request(builder.build());
    }

    JsonElement DELETE(String path, RequestBody body) throws SendBirdException {
        Logger.d("++ request DELETE path : " + path);
        Request.Builder builder = APIRequest.makeRequestBuilder(path).delete(body);
        return this.request(builder.build());
    }

    private JsonElement request(Request request) throws SendBirdException {
        try {
            if (this.isCanceled.getAndSet(false)) {
                Logger.d("Thre request already canceled");
                throw new SendBirdException("Canceled", 800240);
            }
            Call call = this.client.newCall(request);
            this.requestedCall.set(call);
            Response response = call.execute();
            JsonElement jsonElement = this.processResponse(response);
            return jsonElement;
        }
        catch (IOException io) {
            Logger.d(io);
            throw new SendBirdException(io.getMessage(), this.isCanceled.get() ? 800240 : 800120);
        }
        catch (Exception e) {
            Logger.d(e);
            throw e instanceof SendBirdException ? (SendBirdException)e : new SendBirdException(e.getMessage(), 800220);
        }
        finally {
            this.requestedCall.set(null);
        }
    }

    private JsonElement processResponse(Response response) throws SendBirdException {
        JsonElement json;
        if (response.code() == 500) {
            throw new SendBirdException(response.message(), 500901);
        }
        String body = null;
        try {
            if (response.body() != null) {
                body = response.body().string();
                String tlsVersion = "";
                if (response.handshake() != null) {
                    tlsVersion = "(" + response.handshake().tlsVersion().javaName() + ")";
                }
                Logger.d("API response tlsVersion = %s, [%s], body : %s", tlsVersion, response.request().url(), body);
            }
        }
        catch (IOException e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (body == null || body.length() <= 0) {
            return JsonNull.INSTANCE;
        }
        try {
            json = new JsonParser().parse(body);
        }
        catch (Exception e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (!response.isSuccessful() && json.isJsonObject() && json.getAsJsonObject().has("error") && json.getAsJsonObject().get("error").isJsonPrimitive() && json.getAsJsonObject().get("error").getAsBoolean()) {
            String message = "";
            int code = 0;
            if (json.getAsJsonObject().has("message") && json.getAsJsonObject().get("message").isJsonPrimitive()) {
                message = json.getAsJsonObject().get("message").getAsString();
            }
            if (json.getAsJsonObject().has("code") && json.getAsJsonObject().get("code").isJsonPrimitive()) {
                code = json.getAsJsonObject().get("code").getAsInt();
            }
            throw new SendBirdException(message, code);
        }
        return json;
    }
}

