/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.HashUtils;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class MessageMetaArray {
    private String mKey;
    private List<String> mValue;

    public MessageMetaArray(String key) {
        this.mKey = key;
        this.mValue = new ArrayList<String>();
    }

    public MessageMetaArray(String key, List<String> value) {
        this.mKey = key;
        this.mValue = new ArrayList<String>(value);
    }

    public String getKey() {
        return this.mKey;
    }

    public List<String> getValue() {
        return new ArrayList<String>(this.mValue);
    }

    public synchronized void addValue(String value) {
        this.mValue.add(value);
    }

    public void addValue(List<String> value) {
        for (String v : value) {
            this.addValue(v);
        }
    }

    public synchronized void removeValue(String value) {
        this.mValue.remove(value);
    }

    synchronized void setValue(List<String> value) {
        this.mValue = value;
    }

    JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("key", this.mKey);
        JsonArray valueArray = new JsonArray();
        for (String value : this.mValue) {
            valueArray.add(value);
        }
        obj.add("value", (JsonElement)valueArray);
        return obj;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MessageMetaArray that = (MessageMetaArray)o;
        if (this.mKey == null) {
            return false;
        }
        return this.mKey.equals(that.mKey);
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.mKey);
    }

    public String toString() {
        return "MessageMetaArray{mKey='" + this.mKey + '\'' + ", mValue=" + this.mValue + '}';
    }
}

