/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import com.sendbird.android.APIClient;
import com.sendbird.android.AppInfo;
import com.sendbird.android.Command;
import com.sendbird.android.CommandType;
import com.sendbird.android.ConnectionConfig;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SocketManager;
import com.sendbird.android.TimeoutScheduler;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.log.Tag;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.Request;
import com.sendbird.android.shadow.okhttp3.Response;
import com.sendbird.android.shadow.okhttp3.WebSocket;
import com.sendbird.android.shadow.okhttp3.WebSocketListener;
import com.sendbird.android.utils.TimeoutLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class Connection
extends WebSocketListener {
    private SendBirdException loginException;
    private AtomicReference<SendBird.ConnectionState> currentState = new AtomicReference<SendBird.ConnectionState>(SendBird.ConnectionState.CLOSED);
    private TimeoutLock connectLock;
    private WebSocket websocket;
    private WSClientHandler handler;
    private final String userId;
    private final String accessToken;
    private final StringBuffer recvBuffer;
    private static AppInfo appInfo;
    private static ConnectionConfig connectionConfig;
    private final AtomicBoolean explicitDisconnect = new AtomicBoolean(false);
    private final Pinger pinger;

    Connection(String userId, String accessToken, WSClientHandler handler) {
        this.changeState(SendBird.ConnectionState.CLOSED);
        this.recvBuffer = new StringBuffer();
        this.userId = userId;
        this.accessToken = accessToken;
        this.handler = handler;
        this.pinger = new Pinger();
    }

    static ConnectionConfig getConnectionConfig() {
        return connectionConfig;
    }

    static AppInfo getAppInfo() {
        return appInfo;
    }

    private void changeState(SendBird.ConnectionState state) {
        this.currentState.compareAndSet(this.currentState.get(), state);
    }

    boolean isConnected() {
        return this.currentState.get() == SendBird.ConnectionState.OPEN;
    }

    boolean isConnecting() {
        return this.currentState.get() == SendBird.ConnectionState.CONNECTING;
    }

    boolean isDisconnected() {
        return this.currentState.get() == SendBird.ConnectionState.CLOSED;
    }

    long getLastConnectedAt() {
        return connectionConfig != null ? connectionConfig.getLastConnectedAt() : 0L;
    }

    Request makeRequest(String userId, String accessToken) throws SendBirdException {
        if (SendBird.getApplicationId() == null || SendBird.getApplicationId().length() == 0) {
            throw new SendBirdException("Application ID is not set. Initialize SendBird class.", 800100);
        }
        String apiHost = SocketManager.CUSTOM_API_HOST != null ? SocketManager.CUSTOM_API_HOST : "https://api-" + SendBird.getApplicationId() + ".sendbird.com";
        String wsHost = SocketManager.CUSTOM_WS_HOST != null ? SocketManager.CUSTOM_WS_HOST : "wss://ws-" + SendBird.getApplicationId() + ".sendbird.com";
        Logger.dt(Tag.CONNECTION, "++ wsHost : " + wsHost);
        StringBuilder sb = new StringBuilder(wsHost);
        sb.append("/?p=Android").append("&pv=").append(SendBird.getOSVersion()).append("&sv=").append(SendBird.getSDKVersion()).append("&ai=").append(SendBird.getApplicationId());
        sb.append("&SB-User-Agent=").append(APIClient.UrlUtil.urlEncodeUTF8(SendBird.makeExUserAgentString()));
        sb.append("&include_extra_data=").append(APIClient.UrlUtil.urlEncodeUTF8(SendBird.getAdditionalData()));
        if (SendBird.getCurrentUser() == null || TextUtils.isEmpty((CharSequence)APIClient.getInstance().getSessionKey())) {
            sb.append("&user_id=").append(APIClient.UrlUtil.urlEncodeUTF8(userId));
            if (accessToken != null) {
                sb.append("&access_token=").append(accessToken);
            }
        } else {
            sb.append("&key=").append(APIClient.getInstance().getSessionKey());
        }
        if (SendBird.getInstance() != null) {
            sb.append("&active=").append(SendBird.getInstance().isActive());
        }
        Logger.dt(Tag.CONNECTION, "WS request: " + sb.toString());
        APIClient.getInstance().makeDummyCallToKeepConnectionAlive(apiHost);
        return new Request.Builder().header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(sb.toString()).build();
    }

    private void connectInternal() throws SendBirdException {
        Logger.dt(Tag.CONNECTION, ">> Connection::connect connectInternal()");
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)SendBird.Options.connectionTimeout, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.websocket = okHttpClient.newWebSocket(this.makeRequest(this.userId, this.accessToken), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                Connection.this.websocket = webSocket;
                if (response.handshake() != null) {
                    Logger.dt(Tag.CONNECTION, "WSClient onOpen. TLS version = " + response.handshake().tlsVersion().javaName());
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                int nl;
                Connection.this.pinger.onActive();
                Connection.this.recvBuffer.append(text);
                while ((nl = Connection.this.recvBuffer.indexOf("\n")) >= 0) {
                    String message = Connection.this.recvBuffer.substring(0, nl);
                    Connection.this.recvBuffer.delete(0, nl + 1);
                    Command command = new Command(message);
                    if (command.getCommandType() == CommandType.LOGI) {
                        Connection.this.parseLOGI(command);
                    }
                    if (Connection.this.handler != null) {
                        Logger.w("onMessage instance : [%s] %s", new Object[]{command.getCommandType(), Connection.this});
                        Logger.dt(Tag.CONNECTION, "Recv: " + message);
                        Connection.this.handler.onMessage(command);
                    }
                    if (command.getCommandType() != CommandType.LOGI) continue;
                    Connection.this.done();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                try {
                    Logger.w("onFailed instance : %s", new Object[]{Connection.this});
                    Connection.this.quit();
                    Logger.w("onFailed handler : %s", Connection.this.handler);
                    if (Connection.this.handler != null) {
                        Connection.this.handler.onError(Connection.this.explicitDisconnect.get(), new SendBirdException(t.getMessage(), 800120));
                        Connection.this.handler = null;
                    }
                }
                finally {
                    Connection.this.done();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClosed(WebSocket webSocket, int code, String reason) {
                try {
                    Logger.w("++ onClosed %s" + Connection.this.isDisconnected());
                    Logger.w("onClosed instance : " + (Object)((Object)Connection.this));
                    Connection.this.quit();
                    if (Connection.this.handler != null) {
                        Connection.this.handler.onError(Connection.this.explicitDisconnect.get(), new SendBirdException("WS connection closed by server. " + code, 800200));
                        Connection.this.handler = null;
                    }
                }
                finally {
                    Connection.this.done();
                }
            }
        });
        okHttpClient.dispatcher().executorService().shutdown();
    }

    boolean isSameConnectInfo(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        return userId.equals(this.userId);
    }

    synchronized void connect() throws SendBirdException {
        Logger.dt(Tag.CONNECTION, ">> Connection::connect user id : " + this.userId);
        try {
            Logger.dt(Tag.CONNECTION, "connect await start");
            this.changeState(SendBird.ConnectionState.CONNECTING);
            this.connectLock = new TimeoutLock(SendBird.Options.connectionTimeout + SendBird.Options.wsResponseTimeoutSec, TimeUnit.SECONDS);
            this.connectInternal();
            this.connectLock.await();
            if (this.isDisconnected()) {
                throw new SendBirdException("Connection has not made.", 800200);
            }
            if (this.loginException != null) {
                throw new SendBirdException(this.loginException.getMessage(), this.loginException.getCode());
            }
            Logger.dt(Tag.CONNECTION, "connect await end success");
            this.changeState(SendBird.ConnectionState.OPEN);
            this.pinger.start();
        }
        catch (SendBirdException | TimeoutLock.TimeoutException | InterruptedException e) {
            Logger.it(Tag.CONNECTION, "connect await end exception : " + e);
            this.disconnect();
            if (e instanceof TimeoutLock.TimeoutException) {
                throw new SendBirdException("WebSocket Connection failure [TIMEOUT]", 800190);
            }
            if (e instanceof InterruptedException) {
                Logger.dt(Tag.CONNECTION, "-- interrupted instance : " + (Object)((Object)this));
                throw new SendBirdException("Connection has been canceled.", 800102);
            }
            throw new SendBirdException(e.getMessage(), ((SendBirdException)e).getCode());
        }
        finally {
            this.loginException = null;
        }
    }

    boolean disconnect() {
        Logger.it(Tag.CONNECTION, "__ actural disconnect isConnecting :" + this.isConnecting());
        if (this.connectLock != null) {
            this.connectLock.release();
        }
        this.explicitDisconnect.set(true);
        if (this.isDisconnected()) {
            Logger.dt(Tag.CONNECTION, "++ socket is already disconnected()");
            return false;
        }
        this.quit();
        return true;
    }

    private void quit() {
        if (this.websocket == null) {
            return;
        }
        Logger.it(Tag.CONNECTION, ">> Connection::quit()");
        this.pinger.stop();
        if (this.websocket != null) {
            this.websocket.cancel();
        }
        try {
            if (this.websocket != null) {
                this.websocket.close(1000, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.websocket = null;
        this.changeState(SendBird.ConnectionState.CLOSED);
    }

    SendBird.ConnectionState getCurrentState() {
        return this.currentState.get();
    }

    private void done() {
        Logger.dt(Tag.CONNECTION, "-- done connectLock released ");
        this.connectLock.release();
    }

    boolean parseLOGI(Command command) {
        if (command.getCommandType() == CommandType.LOGI) {
            Logger.dt(Tag.CONNECTION, "LOGI RECEIVED: ");
            this.loginException = null;
            JsonObject obj = command.getJsonElement().getAsJsonObject();
            if (obj.getAsJsonObject().has("error") && obj.getAsJsonObject().get("error").isJsonPrimitive() && obj.getAsJsonObject().get("error").getAsBoolean()) {
                String errMsg = "";
                int errCode = 0;
                if (obj.getAsJsonObject().has("message") && obj.getAsJsonObject().get("message").isJsonPrimitive()) {
                    errMsg = obj.getAsJsonObject().get("message").getAsString();
                }
                if (obj.getAsJsonObject().has("code") && obj.getAsJsonObject().get("code").isJsonPrimitive()) {
                    errCode = obj.getAsJsonObject().get("code").getAsInt();
                }
                this.loginException = new SendBirdException(errMsg, errCode);
            } else {
                if (obj.has("user_id")) {
                    Logger.dt(Tag.CONNECTION, "++ LOGI user id : " + obj.get("user_id").getAsString());
                    SendBird.setCurrentUser(new User(command.getJsonElement()));
                    Logger.dt(Tag.CONNECTION, "++ after LOGI user id : " + SendBird.getCurrentUser().getUserId());
                }
                if (obj.has("key")) {
                    APIClient.getInstance().setSessionKey(obj.get("key").getAsString());
                }
                if (obj.has("ekey")) {
                    SendBird.setEkey(obj.get("ekey").getAsString());
                }
                connectionConfig = new ConnectionConfig(obj);
                appInfo = new AppInfo(obj);
            }
            return true;
        }
        return false;
    }

    void send(Command command) throws SendBirdException {
        Logger.dt(Tag.CONNECTION, "++ Send: " + command.encode());
        if (this.websocket == null) {
            throw new SendBirdException("Connection closed.", 800200);
        }
        try {
            this.websocket.send(command.encode());
        }
        catch (Exception e) {
            throw new SendBirdException(e.getMessage(), 800210);
        }
    }

    void sendPing(boolean force) {
        if (this.pinger != null) {
            this.pinger.start();
        }
    }

    static {
        connectionConfig = new ConnectionConfig();
    }

    private class Pinger {
        private TimeoutScheduler timer;
        private long lastActiveTime;
        private TimeoutLock lock;
        private AtomicBoolean forcePing = new AtomicBoolean(true);

        private Pinger() {
        }

        private synchronized void start() {
            Logger.dt(Tag.PINGER, "[Pinger] start()");
            this.forcePing.set(true);
            if (this.timer != null) {
                this.timer.restart();
                this.done();
                return;
            }
            int pingInterval = Connection.getConnectionConfig().getPingInterval();
            this.timer = new TimeoutScheduler(0L, pingInterval, true, new TimeoutScheduler.TimeoutEventhandler(){

                @Override
                public void onTimeout(Object extra) {
                    Logger.dt(Tag.PINGER, ">> Pinger::onTimeout(timer : %s)", Pinger.this.timer);
                    Pinger.this.sendPing(Pinger.this.forcePing.getAndSet(false));
                }
            }, null);
            this.timer.start();
        }

        private synchronized void stop() {
            Logger.dt(Tag.PINGER, "[Pinger] stop()");
            Logger.et(Tag.PINGER, "Pinger stop %s", this.timer != null ? Boolean.valueOf(this.timer.isRunning()) : "timer is null");
            if (this.timer != null) {
                Logger.dt(Tag.PINGER, ">> Pinger::stop() isRunning : " + this.timer.isRunning());
                this.timer.stop();
            }
            this.done();
            Logger.dt(Tag.PINGER, "[Pinger] stop end()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendPing(final boolean forcedPing) {
            int pingInterval = Connection.getConnectionConfig().getPingInterval();
            long diff = System.currentTimeMillis() - this.lastActiveTime + 500L;
            if (forcedPing || diff >= (long)pingInterval) {
                Logger.dt(Tag.PINGER, "[Pinger] sendPing(forcedPing: " + forcedPing + ")");
                try {
                    Command pingCommand = Command.bPing();
                    if (pingCommand == null) return;
                    SocketManager.getInstance().sendCommand(pingCommand, false, new Command.SendCommandHandler(){

                        @Override
                        public void onResult(Command acked, SendBirdException e) {
                            Logger.dt(Tag.PINGER, "[Pinger] sendPing(forcedPing: " + forcedPing + ") => " + (e != null ? e.getMessage() : "OK"));
                        }
                    });
                    ConnectionConfig config = Connection.getConnectionConfig();
                    Logger.dt(Tag.PINGER, "++ pong time out : " + config.getPongTimeout());
                    this.lock = new TimeoutLock(config.getPongTimeout(), TimeUnit.MILLISECONDS);
                    Logger.dt(Tag.PINGER, "-- ping await start (%s)", this.lock);
                    this.lock.await();
                    this.lastActiveTime = System.currentTimeMillis();
                    return;
                }
                catch (TimeoutLock.TimeoutException timeout) {
                    if (Connection.this.handler == null) return;
                    Logger.dt(Tag.PINGER, "[Pinger] sendPing timeout error=%s, lock=%s", timeout, this.lock);
                    Connection.this.handler.onError(Connection.this.explicitDisconnect.get(), new SendBirdException("Server is unreachable.", 800120));
                    return;
                }
                catch (Exception e) {
                    Logger.dt(Tag.PINGER, "[Pinger] sendPing error", e.getMessage());
                    return;
                }
                finally {
                    Logger.dt(Tag.PINGER, "-- ping end");
                    this.done();
                }
            } else {
                Logger.dt(Tag.PINGER, "-- skip sendPing interval=%s, diff=%s", pingInterval, diff);
            }
        }

        private void onActive() {
            Logger.dt(Tag.PINGER, ">> Pinger::onActive()");
            this.lastActiveTime = System.currentTimeMillis();
            this.done();
        }

        private void done() {
            Logger.dt(Tag.PINGER, "++ Pinger::done() lock : " + this.lock);
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
            }
        }
    }

    public static interface WSClientHandler {
        public void onMessage(Command var1);

        public void onError(boolean var1, SendBirdException var2);
    }
}

