/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CancelableExecutorService
implements ExecutorService {
    private final ExecutorService executorService;
    private final List<Future<?>> futures = new ArrayList();

    CancelableExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Future<T> addFuture(Future<T> future) {
        List<Future<?>> list = this.futures;
        synchronized (list) {
            this.futures.add(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<Future<T>> addFutures(List<Future<T>> futures) {
        List<Future<?>> list = this.futures;
        synchronized (list) {
            this.futures.addAll(futures);
        }
        return futures;
    }

    public void cancelAll() {
        this.cancelAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(boolean mayInterruptIfRunning) {
        Logger.d("CancelableExecutorService::cancelAll(%s), jobSize=%s", mayInterruptIfRunning, this.futures.size());
        List<Future<?>> list = this.futures;
        synchronized (list) {
            for (Future<?> future : this.futures) {
                future.cancel(mayInterruptIfRunning);
            }
            this.futures.clear();
        }
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.addFuture(this.executorService.submit(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.addFuture(this.executorService.submit(task, result));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.addFuture(this.executorService.submit(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.addFutures(this.executorService.invokeAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.addFutures(this.executorService.invokeAll(tasks, timeout, unit));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        return this.executorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.executorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        throw new UnsupportedOperationException("execute operation not supported");
    }

    public static CancelableExecutorService newSingleThreadExecutor() {
        return new CancelableExecutorService(Executors.newSingleThreadExecutor());
    }
}

