/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.sendbird.android.APIClient;
import com.sendbird.android.AppInfo;
import com.sendbird.android.ApplicationStateHandler;
import com.sendbird.android.ApplicationUserListQuery;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BlockedUserListQuery;
import com.sendbird.android.ChannelManager;
import com.sendbird.android.Command;
import com.sendbird.android.Connection;
import com.sendbird.android.ConnectionManager;
import com.sendbird.android.Emoji;
import com.sendbird.android.EmojiCategory;
import com.sendbird.android.EmojiContainer;
import com.sendbird.android.FriendListQuery;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelChangeLogsParams;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelTotalUnreadMessageCountParams;
import com.sendbird.android.IntRangeComparableUtils;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SocketManager;
import com.sendbird.android.ThreadInfoUpdateEvent;
import com.sendbird.android.User;
import com.sendbird.android.UserListQuery;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.conscrypt.Conscrypt;

public final class SendBird {
    private static SendBird sInstance;
    private static final Handler sUIThreadHandler;
    private String mAppId;
    private final Context mAppContext;
    private String mPushToken;
    private User mCurrentUser;
    boolean mIsAppBackgroundAndDisconnected = false;
    boolean mIsAppBackground = true;
    final Map<String, UserEventHandler> mUserEventHandlers = new ConcurrentHashMap<String, UserEventHandler>();
    private boolean mIsTrackingApplicationState = true;
    private boolean mIsNetworkAwarenessReconnection = true;
    private ConnectivityManager mConnectivityManager;
    private String mPrefApiHost;
    private String mPrefWsHost;
    private static Map<ExtentionFrom, String> exUserAgent;
    private static String ekey;
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;
    public static final String PUSH_TEMPLATE_DEFAULT = "default";
    public static final String PUSH_TEMPLATE_ALTERNATIVE = "alternative";

    public static void addExtension(String key, String version) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)version)) {
            return;
        }
        ExtentionFrom type = ExtentionFrom.from(key);
        if (type != ExtentionFrom.None) {
            exUserAgent.put(type, version);
        }
    }

    static String getAdditionalData() {
        StringBuilder builder = new StringBuilder();
        builder.append("premium_feature_list").append(",");
        builder.append("file_upload_size_limit").append(",");
        builder.append("application_attributes").append(",");
        builder.append("emoji_hash");
        Logger.i("additionalData : " + builder.toString(), new Object[0]);
        return builder.toString();
    }

    static String makeExUserAgentString() {
        StringBuilder userAgentBuilder = new StringBuilder("Android");
        userAgentBuilder.append("/").append(ExtentionFrom.Core.getValue("3.0.147"));
        for (ExtentionFrom extention : exUserAgent.keySet()) {
            String value = exUserAgent.get((Object)extention);
            userAgentBuilder.append("/").append(extention.getValue(value));
        }
        return userAgentBuilder.toString();
    }

    static int getMaxUnreadMessageCountOnSuperGroup() {
        return Connection.getConnectionConfig().getMaxUnreadCountOnSuperGroup();
    }

    public static void runOnUIThread(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        switch (Options.mThreadOption) {
            case NEW_THREAD: {
                new Thread(){

                    @Override
                    public void run() {
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                }.start();
                break;
            }
            case HANDLER: {
                if (Options.mHandlerForThreadOption == null) break;
                Options.mHandlerForThreadOption.post(runnable);
                break;
            }
            default: {
                if (sUIThreadHandler == null) break;
                sUIThreadHandler.post(runnable);
            }
        }
    }

    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getSDKVersion() {
        return "3.0.147";
    }

    public static String getApplicationId() {
        return SendBird.getInstance().mAppId;
    }

    private boolean setNewApplicationId(String newAppId) {
        boolean result = false;
        if (SendBird.getConnectionState() == ConnectionState.CLOSED) {
            this.setAppId(newAppId, true);
            result = true;
        }
        return result;
    }

    public static void setLoggerLevel(int level) {
        Logger.setLoggerLevel(level);
    }

    private void setAppId(String appId, boolean resetHosts) {
        this.mAppId = appId;
        this.mPrefApiHost = "com.sendbird." + this.mAppId + ".PREF_API_HOST";
        this.mPrefWsHost = "com.sendbird." + this.mAppId + ".PREF_WS_HOST";
        if (resetHosts) {
            APIClient.getInstance().initCheckRouting();
        }
    }

    private SendBird(String appId, Context context) {
        this.setAppId(appId, false);
        this.mAppContext = context;
        if (context != null) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkReceiver mNetworkReceiver = new NetworkReceiver();
            context.registerReceiver((BroadcastReceiver)mNetworkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        SendBird.initConscrypt();
    }

    private static void initConscrypt() {
        try {
            Security.insertProviderAt(Conscrypt.newProvider(), 1);
        }
        catch (NoClassDefFoundError error) {
            System.out.println("[SendBird] To enable TLS 1.3, do not exclude conscrypt from your build.gradle");
            error.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("[SendBird] TLS 1.3 might be disabled for some unknown reason.");
            throwable.printStackTrace();
        }
    }

    protected static SendBird getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    protected static synchronized boolean isInitialized() {
        return sInstance != null;
    }

    public static synchronized boolean init(String appId, Context context) {
        boolean result = true;
        if (sInstance == null) {
            sInstance = new SendBird(appId, context.getApplicationContext());
            ConnectionManager.init();
            APIClient.init(context.getApplicationContext());
            if (SendBird.sInstance.mAppContext instanceof Application) {
                ((Application)SendBird.sInstance.mAppContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ApplicationStateHandler());
            }
        } else {
            if (appId != null && appId.length() > 0 && SendBird.getApplicationId() != null && appId.equals(SendBird.getApplicationId())) {
                return true;
            }
            result = sInstance.setNewApplicationId(appId);
            SocketManager.getInstance().disconnect(true, null);
        }
        SendBird.sInstance.mIsTrackingApplicationState = true;
        SendBird.sInstance.mIsNetworkAwarenessReconnection = true;
        return result;
    }

    static boolean isAppBackground() {
        return sInstance != null && SendBird.sInstance.mIsAppBackground;
    }

    int isActive() {
        return this.mIsAppBackground ? 0 : 1;
    }

    @Deprecated
    public static void notifyActivityResumedForOldAndroids() {
    }

    @Deprecated
    public static void notifyActivityPausedForOldAndroids() {
    }

    public static void setAutoBackgroundDetection(boolean enable) {
        SendBird.getInstance().mIsTrackingApplicationState = enable;
    }

    public static boolean getAutoBackgroundDetection() {
        return SendBird.getInstance().mIsTrackingApplicationState;
    }

    public static void setNetworkAwarenessReconnection(boolean enable) {
        SendBird.getInstance().mIsNetworkAwarenessReconnection = enable;
    }

    public static boolean getNetworkAwarenessReconnection() {
        return SendBird.getInstance().mIsNetworkAwarenessReconnection;
    }

    public static ConnectionState getConnectionState() {
        if (!SendBird.isInitialized()) {
            return ConnectionState.CLOSED;
        }
        return SocketManager.getInstance().getConnectionState();
    }

    public static void connect(String userId, ConnectHandler handler) {
        SendBird._connect(userId, null, null, null, handler);
    }

    public static void connect(String userId, String accessToken, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, null, null, handler);
    }

    public static void connect(String userId, String accessToken, String apiHost, String wsHost, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, apiHost, wsHost, handler);
    }

    private static void _connect(String userId, String accessToken, String apiHost, String wsHost, ConnectHandler handler) {
        SocketManager.getInstance().connect(userId, accessToken, apiHost, wsHost, handler);
    }

    public static synchronized boolean reconnect() {
        return SocketManager.getInstance().reconnect(false);
    }

    public static void addChannelHandler(String identifier, ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        ChannelManager.getInstance().addChannelHandler(identifier, handler);
    }

    public static ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return ChannelManager.getInstance().removeChannelHandler(identifier);
    }

    public static void removeAllChannelHandlers() {
        ChannelManager.getInstance().removeAllChannelHandlers();
    }

    public static void addUserEventHandler(String identifier, UserEventHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mUserEventHandlers.put(identifier, handler);
    }

    public static UserEventHandler removeUserEventHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mUserEventHandlers.remove(identifier);
    }

    public static void removeAllUserEventHandlers() {
        SendBird.getInstance().mUserEventHandlers.clear();
    }

    public static void addConnectionHandler(String identifier, ConnectionHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SocketManager.getInstance().addConnectionHandler(identifier, handler);
    }

    public static ConnectionHandler removeConnectionHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SocketManager.getInstance().removeConnectionHandler(identifier);
    }

    public static void removeAllConnectionHandlers() {
        SocketManager.getInstance().removeAllConnectionHandlers();
    }

    public static void disconnect(DisconnectHandler handler) {
        SocketManager.getInstance().disconnect(true, handler);
    }

    public static AppInfo getAppInfo() {
        return Connection.getAppInfo();
    }

    public static User getCurrentUser() {
        return SendBird.getInstance().mCurrentUser;
    }

    static void setCurrentUser(User user) {
        SendBird.getInstance().mCurrentUser = user;
    }

    public static long getLastConnectedAt() {
        if (SendBird.getConnectionState() == ConnectionState.OPEN) {
            return Connection.getConnectionConfig().getLastConnectedAt();
        }
        return 0L;
    }

    @Deprecated
    public static UserListQuery createUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.ALL_USER);
    }

    @Deprecated
    public static UserListQuery createUserListQuery(List<String> userIds) {
        return new UserListQuery(UserListQuery.QueryType.FILTERED_USER, userIds);
    }

    public static ApplicationUserListQuery createApplicationUserListQuery() {
        return new ApplicationUserListQuery();
    }

    public static BlockedUserListQuery createBlockedUserListQuery() {
        return new BlockedUserListQuery();
    }

    public static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfoWithProfileImage(nickname, profileImage, null, handler);
    }

    private static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, List<String> discoveryKeys, final UserInfoUpdateHandler handler) {
        APIClient.getInstance().updateUserInfo(nickname, profileImage, discoveryKeys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                if (obj.has("require_auth_for_profile_image")) {
                    user.setRequireAuth(obj.get("require_auth_for_profile_image").getAsBoolean());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static void updateCurrentUserInfo(String nickname, String profileUrl, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfo(nickname, profileUrl, null, null, handler);
    }

    public static void updateCurrentUserInfo(List<String> preferredLanguages, final UserInfoUpdateHandler handler) {
        if (preferredLanguages == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.updateCurrentUserInfo(null, null, null, preferredLanguages, handler);
    }

    private static void updateCurrentUserInfo(String nickname, String profileUrl, List<String> discoveryKeys, List<String> preferredLanguages, final UserInfoUpdateHandler handler) {
        APIClient.getInstance().updateUserInfo(nickname, profileUrl, discoveryKeys, preferredLanguages, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                user.parsePreferredLanguages(obj);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static String getPendingPushToken() {
        return SendBird.getInstance().mPushToken;
    }

    @Deprecated
    public static void registerPushTokenForCurrentUser(String gcmRegToken, final RegisterPushTokenHandler handler) {
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(PushTokenType.GCM, gcmRegToken, false, false, false, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(gcmRegToken, false, handler);
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, boolean unique, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(PushTokenType.GCM, gcmRegToken, unique, false, false, handler);
    }

    static void registerPushTokenForCurrentUserInternal(PushTokenType type, String token, boolean unique, boolean alwaysPushOn, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(type, token, unique, alwaysPushOn, true, handler);
    }

    static void registerPushTokenForCurrentUser(PushTokenType type, String token, boolean unique, boolean alwaysPushOn, boolean isInternal, final RegisterPushTokenWithStatusHandler handler) {
        if (token == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.ERROR, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            SendBird.getInstance().mPushToken = token;
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.PENDING, null);
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(type, token, unique, alwaysPushOn, isInternal, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(PushTokenRegistrationStatus.ERROR, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.getInstance().mPushToken = null;
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(PushTokenRegistrationStatus.SUCCESS, null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenForCurrentUser(String gcmRegToken, UnregisterPushTokenHandler handler) {
        SendBird.unregisterPushTokenForCurrentUser(PushTokenType.GCM, gcmRegToken, handler);
    }

    static void unregisterPushTokenForCurrentUser(PushTokenType type, String token, final UnregisterPushTokenHandler handler) {
        if (token == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unregisterPushToken(type, token, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenAllForCurrentUser(final UnregisterPushTokenHandler handler) {
        APIClient.getInstance().unregisterPushTokenAll(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void getMyPushTokensByToken(String token, PushTokenType type, final GetPushTokensHandler handler) {
        if (type == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMyPushTokens(token, type, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                final PushTokenType pushTokenType = result.has("type") ? PushTokenType.from(result.get("type").getAsString()) : PushTokenType.GCM;
                final String token = result.has("token") ? result.get("token").getAsString() : "";
                final boolean hasMore = result.has("has_more") && result.get("has_more").getAsBoolean();
                final ArrayList<String> pushTokens = new ArrayList<String>();
                JsonArray deviceTokenArray = result.get("device_tokens").getAsJsonArray();
                for (int i = 0; i < deviceTokenArray.size(); ++i) {
                    pushTokens.add(deviceTokenArray.get(i).getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(pushTokens, pushTokenType, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public static void setDoNotDisturb(boolean doNotDisturbOn, int startHour, int startMin, int endHour, int endMin, String timezone, final SetDoNotDisturbHandler handler) {
        if (startHour < 0 || startHour > 23 || startMin < 0 || startMin > 59 || endHour < 0 || endHour > 23 || endMin < 0 || endMin > 59) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setDoNotDisturb(doNotDisturbOn, startHour, startMin, endHour, endMin, timezone, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getDoNotDisturb(final GetDoNotDisturbHandler handler) {
        APIClient.getInstance().getDoNotDisturb(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, 0, 0, 0, 0, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final boolean isDisturbOn = obj.get("do_not_disturb").getAsBoolean();
                final int startHour = obj.get("start_hour").getAsInt();
                final int startMin = obj.get("start_min").getAsInt();
                final int endHour = obj.get("end_hour").getAsInt();
                final int endMin = obj.get("end_min").getAsInt();
                final String timezone = obj.get("timezone").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isDisturbOn, startHour, startMin, endHour, endMin, timezone, null);
                        }
                    });
                }
            }
        });
    }

    public static void setSnoozePeriod(boolean snoozeOn, long startTs, long endTs, final SetSnoozePeriodHandler handler) {
        if (startTs >= endTs) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setSnoozePeriod(snoozeOn, startTs, endTs, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getSnoozePeriod(final GetSnoozePeriodHandler handler) {
        APIClient.getInstance().getSnoozePeriod(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                boolean isSnoozeOn;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, 0L, 0L, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                String strStartTs = obj.has("snooze_start_ts") && !obj.get("snooze_start_ts").isJsonNull() ? obj.get("snooze_start_ts").getAsString() : "";
                String strEndTs = obj.has("snooze_end_ts") && !obj.get("snooze_end_ts").isJsonNull() ? obj.get("snooze_end_ts").getAsString() : "";
                final long startTs = strStartTs.isEmpty() ? 0L : Long.valueOf(strStartTs);
                final long endTs = strEndTs.isEmpty() ? 0L : Long.valueOf(strEndTs);
                boolean bl = isSnoozeOn = obj.has("snooze_enabled") && !obj.get("snooze_enabled").isJsonNull() && obj.get("snooze_enabled").getAsBoolean();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isSnoozeOn, startTs, endTs, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushSound(String sound, final SetPushSoundHandler handler) {
        if (sound == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setPushSound(sound, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getPushSound(final GetPushSoundHandler handler) {
        APIClient.getInstance().getPushSound(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                String sound;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                String string = sound = obj.has("push_sound") && !obj.get("push_sound").isJsonNull() ? obj.get("push_sound").getAsString() : "";
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(sound, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushTemplate(String templateName, final SetPushTemplateHandler handler) {
        if (templateName == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setPushTemplate(templateName, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                handler.onResult(e);
                            } else {
                                handler.onResult(null);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void getPushTemplate(final GetPushTemplateHandler handler) {
        APIClient.getInstance().getPushTemplate(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final String name = response.getAsJsonObject().get("name").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(name, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushTriggerOption(PushTriggerOption pushTriggerOption, final SetPushTriggerOptionHandler handler) {
        APIClient.getInstance().setPushTriggerOption(pushTriggerOption, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getPushTriggerOption(final GetPushTriggerOptionHandler handler) {
        APIClient.getInstance().getPushTriggerOption(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                PushTriggerOption pushTriggerOption;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                PushTriggerOption pushTriggerOption2 = pushTriggerOption = obj.has("push_trigger_option") ? PushTriggerOption.from(obj.get("push_trigger_option").getAsString()) : PushTriggerOption.ALL;
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(pushTriggerOption, null);
                        }
                    });
                }
            }
        });
    }

    public static void setChannelInvitationPreference(boolean autoAccept, final SetChannelInvitationPreferenceHandler handler) {
        APIClient.getInstance().setAutoAcceptInvitation(autoAccept, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getChannelInvitationPreference(final GetChannelInvitationPreferenceHandler handler) {
        APIClient.getInstance().getAutoAcceptInvitation(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, e);
                            }
                        });
                    }
                    return;
                }
                final boolean autoAccept = response.getAsJsonObject().get("auto_accept").getAsBoolean();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(autoAccept, null);
                        }
                    });
                }
            }
        });
    }

    public static void blockUser(User userToBlock, final UserBlockHandler handler) {
        if (userToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.blockUserWithUserId(userToBlock.getUserId(), handler);
    }

    public static void blockUserWithUserId(String userIdToBlock, final UserBlockHandler handler) {
        if (userIdToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().blockUser(userIdToBlock, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onBlocked(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onBlocked(new User(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void unblockUser(User blockedUser, final UserUnblockHandler handler) {
        if (blockedUser == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.unblockUserWithUserId(blockedUser.getUserId(), handler);
    }

    public static void unblockUserWithUserId(String blockedUserId, final UserUnblockHandler handler) {
        if (blockedUserId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unblockUser(blockedUserId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnblocked(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnblocked(null);
                        }
                    });
                }
            }
        });
    }

    public static void addFriends(List<String> userIds, final AddFriendsHandler handler) {
        if (userIds == null || userIds.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().addFriends(userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    JsonArray array;
                    JsonObject obj;
                    final ArrayList<User> users = new ArrayList<User>();
                    if (response != null && (obj = response.getAsJsonObject()) != null && obj.has("users") && (array = obj.getAsJsonArray("users")) != null) {
                        for (int i = 0; i < array.size(); ++i) {
                            users.add(new User(array.get(i)));
                        }
                    }
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(users, null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriends(List<String> userIds, final DeleteFriendsHandler handler) {
        if (userIds == null || userIds.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriends(userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriend(String userId, final DeleteFriendHandler handler) {
        if (userId == null || userId.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriend(userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void uploadFriendDiscoveries(Map<String, String> discoveryMap, final UploadFriendDiscoveriesHandler handler) {
        if (discoveryMap == null || discoveryMap.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().uploadFriendDiscoveries(discoveryMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriendDiscoveries(List<String> discoveryKeys, final DeleteFriendDiscoveriesHandler handler) {
        if (discoveryKeys == null || discoveryKeys.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriendDiscoveries(discoveryKeys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriendDiscovery(String discoveryKey, final DeleteFriendDiscoveryHandler handler) {
        if (discoveryKey == null || discoveryKey.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriendDiscovery(discoveryKey, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getFriendChangeLogsByToken(String token, final GetFriendChangeLogsByTokenHandler handler) {
        APIClient.getInstance().getFriendChangeLogsByToken(token, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                final ArrayList<User> updatedUsers = new ArrayList<User>();
                for (int i = 0; i < updatedJsonArray.size(); ++i) {
                    updatedUsers.add(new User(updatedJsonArray.get(i)));
                }
                JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                final ArrayList<String> deletedUserIds = new ArrayList<String>();
                for (int i = 0; i < deletedJsonArray.size(); ++i) {
                    deletedUserIds.add(deletedJsonArray.get(i).getAsString());
                }
                final boolean hasMore = result.get("has_more").getAsBoolean();
                final String token = result.get("next").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(updatedUsers, deletedUserIds, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public static FriendListQuery createFriendListQuery() {
        return new FriendListQuery();
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByToken(String token, List<String> customTypes, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(token, null, customTypes, true, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByTimestamp(long ts, List<String> customTypes, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(null, ts, customTypes, true, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByToken(String token, List<String> customTypes, boolean includeEmpty, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(token, null, customTypes, includeEmpty, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByTimestamp(long ts, List<String> customTypes, boolean includeEmpty, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(null, ts, customTypes, includeEmpty, true, handler);
    }

    public static void getMyGroupChannelChangeLogsByTokenWithParams(String token, GroupChannelChangeLogsParams params, final GetMyGroupChannelChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.getMyGroupChannelChangeLogs(token, null, params.customTypes, params.includeEmpty, params.includeFrozen, handler);
    }

    public static void getMyGroupChannelChangeLogsByTimestampWithParams(long ts, GroupChannelChangeLogsParams params, final GetMyGroupChannelChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.getMyGroupChannelChangeLogs(null, ts, params.customTypes, params.includeEmpty, params.includeFrozen, handler);
    }

    private static void getMyGroupChannelChangeLogs(String token, Long ts, List<String> customTypes, boolean includeEmpty, boolean includeFrozen, final GetMyGroupChannelChangeLogsHandler handler) {
        if (ts != null && ts < 0L) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid Arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (customTypes != null) {
            customTypes = new ArrayList<String>(new LinkedHashSet<String>(customTypes));
        }
        GroupChannelChangeLogsParams params = new GroupChannelChangeLogsParams(customTypes, includeEmpty, includeFrozen);
        APIClient.getInstance().getMyGroupChannelChangeLogs(token, ts, params, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                final ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
                for (int i = 0; i < updatedJsonArray.size(); ++i) {
                    updatedChannels.add(GroupChannel.upsert(updatedJsonArray.get(i), false));
                }
                JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                final ArrayList<String> deletedChannelUrls = new ArrayList<String>();
                for (int i = 0; i < deletedJsonArray.size(); ++i) {
                    deletedChannelUrls.add(deletedJsonArray.get(i).getAsString());
                }
                final boolean hasMore = result.get("has_more").getAsBoolean();
                final String token = result.get("next").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(updatedChannels, deletedChannelUrls, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public static void markAsDelivered(String channelUrl) {
        Logger.d(">> markAsDelivered()");
        GroupChannel.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

            @Override
            public void onResult(GroupChannel channel, SendBirdException e) {
                if (channel != null) {
                    channel.markAsDelivered();
                }
            }
        });
    }

    public static void markAsReadAll(MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadAll(null, handler);
    }

    public static void markAsReadWithChannelUrls(List<String> channelUrls, MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadWithChannelUrls(channelUrls, handler);
    }

    public static void getAllEmoji(final GetAllEmojiHandler handler) {
        APIClient.getInstance().getAllEmoji(new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(new EmojiContainer(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void getEmojiCategory(long emojiCategoryId, final GetEmojiCategoryHandler handler) {
        if (emojiCategoryId < 0L) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getEmojiCategory(emojiCategoryId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(new EmojiCategory(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void getEmoji(String key, final GetEmojiHandler handler) {
        if (key == null || key.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getEmoji(key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(new Emoji(response), null);
                        }
                    });
                }
            }
        });
    }

    void sendCommand(Command cmd, boolean lazy, Command.SendCommandHandler handler) {
        SocketManager.getInstance().sendCommand(cmd, lazy, handler);
    }

    private String getStringPref(String key) {
        String result = null;
        if (this.mAppContext != null) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.mAppContext);
            result = sp.getString(key, null);
        }
        return result;
    }

    private void setStringPref(String key, String value) {
        if (this.mAppContext != null) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.mAppContext);
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(key, value);
            editor.apply();
        }
    }

    String getAPIHostFromPref() {
        return this.getStringPref(this.mPrefApiHost);
    }

    void setAPIHostToPref(String apiHost) {
        this.setStringPref(this.mPrefApiHost, apiHost);
    }

    String getWSHostFromPref() {
        return this.getStringPref(this.mPrefWsHost);
    }

    void setWSHostToPref(String wsHost) {
        this.setStringPref(this.mPrefWsHost, wsHost);
    }

    public static void getTotalUnreadMessageCount(GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, null, handler);
    }

    public static void getTotalUnreadMessageCount(List<String> channelCustomTypes, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, channelCustomTypes, handler);
    }

    public static void getTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams params, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(params.mSuperChannelFilter, params.mChannelCustomTypes, handler);
    }

    static void localGetTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter superChannelFilter, List<String> channelCustomTypes, final GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        APIClient.getInstance().getTotalUnreadMessageCount(superChannelFilter, channelCustomTypes, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int unreadCount = response.getAsJsonObject().get("unread_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(unreadCount, null);
                        }
                    });
                }
            }
        });
    }

    public static int getSubscribedTotalUnreadMessageCount() {
        return ChannelManager.getInstance().getUnReadMessageCount().getTotalCount();
    }

    public static int getSubscribedCustomTypeTotalUnreadMessageCount() {
        return ChannelManager.getInstance().getUnReadMessageCount().getTotalCountByCustomTypes();
    }

    public static int getSubscribedCustomTypeUnreadMessageCount(String customType) {
        return ChannelManager.getInstance().getUnReadMessageCount().getCustomTypeUnreadMessageCount(customType);
    }

    public static void getUnreadItemCount(Collection<GroupChannel.UnreadItemKey> keys, final GroupChannel.GroupChannelGetUnreadItemCountHandler handler) {
        if (keys == null || keys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getUnreadItemCount(keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final HashMap<GroupChannel.UnreadItemKey, Integer> result = new HashMap<GroupChannel.UnreadItemKey, Integer>();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    GroupChannel.UnreadItemKey unreadItemKey = null;
                    String key = (String)entry.getKey();
                    if (key.equals("group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MENTION_COUNT;
                    } else if (key.equals("group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_INVITATION_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("non_super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_INVITATION_COUNT;
                    } else if (key.equals("super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_INVITATION_COUNT;
                    }
                    if (unreadItemKey == null) continue;
                    result.put(unreadItemKey, ((JsonElement)entry.getValue()).getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public static void getTotalUnreadChannelCount(final GroupChannel.GroupChannelTotalUnreadChannelCountHandler handler) {
        APIClient.getInstance().getTotalUnreadChannelCount(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int unreadCount = response.getAsJsonObject().get("unread_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(unreadCount, null);
                        }
                    });
                }
            }
        });
    }

    public static void getGroupChannelCount(GroupChannelListQuery.MemberStateFilter memberStateFilter, GroupChannel.GroupChannelChannelCountHandler handler) {
        String state;
        switch (memberStateFilter) {
            case ALL: {
                state = "all";
                break;
            }
            case INVITED: {
                state = "invited";
                break;
            }
            case INVITED_BY_FRIEND: {
                state = "invited_by_friend";
                break;
            }
            case INVITED_BY_NON_FRIEND: {
                state = "invited_by_non_friend";
                break;
            }
            case JOINED: {
                state = "joined";
                break;
            }
            default: {
                state = null;
            }
        }
        SendBird.localGetGroupChannelCount(state, handler);
    }

    static void localGetGroupChannelCount(String state, final GroupChannel.GroupChannelChannelCountHandler handler) {
        APIClient.getInstance().getChannelCount(state, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int myChannelCount = response.getAsJsonObject().get("group_channel_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(myChannelCount, null);
                        }
                    });
                }
            }
        });
    }

    static void setEkey(String ekey) {
        SendBird.ekey = ekey;
    }

    public static String getEkey() {
        return ekey;
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
        exUserAgent = new HashMap<ExtentionFrom, String>();
        ekey = "";
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private boolean mNeedReconnect = false;

        private NetworkReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            NetworkInfo networkInfo = null;
            try {
                networkInfo = SendBird.this.mConnectivityManager.getActiveNetworkInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (networkInfo != null && networkInfo.isConnected()) {
                if (this.mNeedReconnect && !SendBird.this.mIsAppBackgroundAndDisconnected) {
                    this.mNeedReconnect = false;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (SendBird.getNetworkAwarenessReconnection()) {
                                    SocketManager.getInstance().reconnect(true);
                                }
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            } else if (networkInfo == null) {
                this.mNeedReconnect = true;
                if (SendBird.getConnectionState() == ConnectionState.OPEN) {
                    SocketManager.getInstance().disconnect(false, null);
                }
            }
        }
    }

    public static interface GetEmojiHandler {
        public void onResult(Emoji var1, SendBirdException var2);
    }

    public static interface GetEmojiCategoryHandler {
        public void onResult(EmojiCategory var1, SendBirdException var2);
    }

    public static interface GetAllEmojiHandler {
        public void onResult(EmojiContainer var1, SendBirdException var2);
    }

    static interface MarkAsDeliveredHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MarkAsReadHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetMyGroupChannelChangeLogsHandler {
        public void onResult(List<GroupChannel> var1, List<String> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface GetFriendChangeLogsByTokenHandler {
        public void onResult(List<User> var1, List<String> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface DeleteFriendDiscoveryHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UploadFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendsHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface AddFriendsHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }

    public static interface UserUnblockHandler {
        public void onUnblocked(SendBirdException var1);
    }

    public static interface UserBlockHandler {
        public void onBlocked(User var1, SendBirdException var2);
    }

    public static interface GetChannelInvitationPreferenceHandler {
        public void onResult(boolean var1, SendBirdException var2);
    }

    public static interface SetChannelInvitationPreferenceHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UserInfoUpdateHandler {
        public void onUpdated(SendBirdException var1);
    }

    public static interface GetPushTriggerOptionHandler {
        public void onResult(PushTriggerOption var1, SendBirdException var2);
    }

    public static interface SetPushTriggerOptionHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushTemplateHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushTemplateHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushSoundHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushSoundHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetSnoozePeriodHandler {
        public void onResult(boolean var1, long var2, long var4, SendBirdException var6);
    }

    public static interface SetSnoozePeriodHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetDoNotDisturbHandler {
        public void onResult(boolean var1, int var2, int var3, int var4, int var5, String var6, SendBirdException var7);
    }

    public static interface SetDoNotDisturbHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushTokensHandler {
        public void onResult(List<String> var1, PushTokenType var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface UnregisterPushTokenHandler {
        public void onUnregistered(SendBirdException var1);
    }

    public static interface RegisterPushTokenWithStatusHandler {
        public void onRegistered(PushTokenRegistrationStatus var1, SendBirdException var2);
    }

    @Deprecated
    public static interface RegisterPushTokenHandler {
        @Deprecated
        public void onRegistered(SendBirdException var1);
    }

    public static enum PushTokenRegistrationStatus {
        SUCCESS,
        PENDING,
        ERROR;

    }

    public static class HMS {
        public static String getPendingPushToken() {
            return SendBird.getInstance().mPushToken;
        }

        public static void registerPushTokenForCurrentUser(String token, RegisterPushTokenWithStatusHandler handler) {
            HMS.registerPushTokenForCurrentUser(token, false, handler);
        }

        public static void registerPushTokenForCurrentUser(String token, boolean unique, RegisterPushTokenWithStatusHandler handler) {
            SendBird.registerPushTokenForCurrentUser(PushTokenType.HMS, token, unique, false, false, handler);
        }

        public static void unregisterPushTokenForCurrentUser(String token, UnregisterPushTokenHandler handler) {
            SendBird.unregisterPushTokenForCurrentUser(PushTokenType.HMS, token, handler);
        }

        public static void unregisterPushTokenAllForCurrentUser(UnregisterPushTokenHandler handler) {
            SendBird.unregisterPushTokenAllForCurrentUser(handler);
        }

        public static void getMyPushTokensByToken(String token, PushTokenType type, GetPushTokensHandler handler) {
            SendBird.getMyPushTokensByToken(token, type, handler);
        }

        public static void setDoNotDisturb(boolean doNotDisturbOn, int startHour, int startMin, int endHour, int endMin, String timezone, SetDoNotDisturbHandler handler) {
            SendBird.setDoNotDisturb(doNotDisturbOn, startHour, startMin, endHour, endMin, timezone, handler);
        }

        public static void getDoNotDisturb(GetDoNotDisturbHandler handler) {
            SendBird.getDoNotDisturb(handler);
        }

        public static void setSnoozePeriod(boolean snoozeOn, long startTs, long endTs, SetSnoozePeriodHandler handler) {
            SendBird.setSnoozePeriod(snoozeOn, startTs, endTs, handler);
        }

        public static void getSnoozePeriod(GetSnoozePeriodHandler handler) {
            SendBird.getSnoozePeriod(handler);
        }

        public static void setPushSound(String sound, SetPushSoundHandler handler) {
            SendBird.setPushSound(sound, handler);
        }

        public static void getPushSound(GetPushSoundHandler handler) {
            SendBird.getPushSound(handler);
        }

        public static void setPushTemplate(String templateName, SetPushTemplateHandler handler) {
            SendBird.setPushTemplate(templateName, handler);
        }

        public static void getPushTemplate(GetPushTemplateHandler handler) {
            SendBird.getPushTemplate(handler);
        }

        public static void setPushTriggerOption(PushTriggerOption pushTriggerOption, SetPushTriggerOptionHandler handler) {
            SendBird.setPushTriggerOption(pushTriggerOption, handler);
        }

        public static void getPushTriggerOption(GetPushTriggerOptionHandler handler) {
            SendBird.getPushTriggerOption(handler);
        }
    }

    public static enum PushTriggerOption {
        ALL("all"),
        OFF("off"),
        MENTION_ONLY("mention_only");

        private String value;

        private PushTriggerOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PushTriggerOption from(String value) {
            for (PushTriggerOption option : PushTriggerOption.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return ALL;
        }
    }

    public static enum PushTokenType {
        GCM("gcm"),
        APNS("apns"),
        APNS_VOIP("apns_voip"),
        HMS("huawei");

        private String value;

        private PushTokenType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PushTokenType from(String value) {
            for (PushTokenType type : PushTokenType.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            return GCM;
        }
    }

    public static interface DisconnectHandler {
        public void onDisconnected();
    }

    public static interface ConnectionHandler {
        public void onReconnectStarted();

        public void onReconnectSucceeded();

        public void onReconnectFailed();
    }

    public static abstract class UserEventHandler {
        public abstract void onFriendsDiscovered(List<User> var1);

        public void onTotalUnreadMessageCountChanged(int totalCount, Map<String, Integer> totalCountByCustomType) {
        }
    }

    public static abstract class ChannelHandler {
        public abstract void onMessageReceived(BaseChannel var1, BaseMessage var2);

        public void onMentionReceived(BaseChannel channel, BaseMessage message) {
        }

        public void onMessageDeleted(BaseChannel channel, long msgId) {
        }

        public void onMessageUpdated(BaseChannel channel, BaseMessage message) {
        }

        public void onChannelChanged(BaseChannel channel) {
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
        }

        public void onReactionUpdated(BaseChannel channel, ReactionEvent reactionEvent) {
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
        }

        public void onDeliveryReceiptUpdated(GroupChannel channel) {
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
        }

        public void onUserReceivedInvitation(GroupChannel channel, User inviter, List<User> invitees) {
        }

        public void onUserJoined(GroupChannel channel, User user) {
        }

        public void onUserDeclinedInvitation(GroupChannel channel, User inviter, User invitee) {
        }

        public void onUserLeft(GroupChannel channel, User user) {
        }

        public void onUserEntered(OpenChannel channel, User user) {
        }

        public void onUserExited(OpenChannel channel, User user) {
        }

        public void onUserMuted(BaseChannel channel, User user) {
        }

        public void onUserUnmuted(BaseChannel channel, User user) {
        }

        public void onUserBanned(BaseChannel channel, User user) {
        }

        public void onUserUnbanned(BaseChannel channel, User user) {
        }

        public void onChannelFrozen(BaseChannel channel) {
        }

        public void onChannelUnfrozen(BaseChannel channel) {
        }

        public void onMetaDataCreated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataUpdated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onMetaCountersCreated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersUpdated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onChannelHidden(GroupChannel channel) {
        }

        public void onOperatorUpdated(BaseChannel channel) {
        }

        public void onThreadInfoUpdated(BaseChannel channel, ThreadInfoUpdateEvent threadInfoUpdateEvent) {
        }
    }

    public static interface ConnectHandler {
        public void onConnected(User var1, SendBirdException var2);
    }

    public static class Options {
        static boolean useMemberAsMessageSender = true;
        static ThreadOption mThreadOption = ThreadOption.UI_THREAD;
        static Handler mHandlerForThreadOption;
        static int connectionTimeout;
        static int authenticationTimeout;
        static int typingIndicatorThrottle;
        static int wsResponseTimeoutSec;

        static void init() {
            useMemberAsMessageSender = true;
            mThreadOption = ThreadOption.UI_THREAD;
            connectionTimeout = 10;
            authenticationTimeout = 10;
            typingIndicatorThrottle = 1000;
        }

        public static void useMemberAsMessageSender(boolean tf) {
            useMemberAsMessageSender = tf;
        }

        @Deprecated
        public static void useUiThreadForCallbacks(boolean tf) {
            mThreadOption = tf ? ThreadOption.UI_THREAD : ThreadOption.NEW_THREAD;
        }

        @Deprecated
        public static void setHandlerForCallbacks(Handler handler) {
            if (handler != null) {
                mThreadOption = ThreadOption.HANDLER;
                mHandlerForThreadOption = handler;
            } else {
                mThreadOption = ThreadOption.UI_THREAD;
            }
        }

        public static void setThreadOption(ThreadOption threadOption, Handler handler) {
            if (threadOption != null) {
                mThreadOption = threadOption;
                if (threadOption == ThreadOption.HANDLER) {
                    mHandlerForThreadOption = handler;
                }
            }
        }

        public static void setConnectionTimeout(int connectionTimeout) {
            Options.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 10;
        }

        public static void setAuthenticationTimeout(int authenticationTimeout) {
            Options.authenticationTimeout = authenticationTimeout > 0 ? authenticationTimeout : 10;
        }

        public static void setTypingIndicatorThrottle(int msec) {
            if (msec >= 1000 && msec <= 9000) {
                typingIndicatorThrottle = msec;
            }
        }

        public static void setWebSocketResponseTimeout(int webSocketResponseTimeoutSec) {
            int MIN_TIMEOUT_SEC = 5;
            int MAX_TIMEOUT_SEC = 300;
            wsResponseTimeoutSec = IntRangeComparableUtils.coerceIn(webSocketResponseTimeoutSec, 5, 300);
        }

        static {
            connectionTimeout = 10;
            authenticationTimeout = 10;
            typingIndicatorThrottle = 1000;
            wsResponseTimeoutSec = 10;
        }

        public static enum ThreadOption {
            UI_THREAD,
            NEW_THREAD,
            HANDLER;

        }
    }

    static enum ExtentionFrom {
        None("none", ""),
        Core("core", "c"),
        SyncManager("sb_syncmanager", "s"),
        UIKit("sb_uikit", "u");

        private String key;
        private String shortCut;

        private ExtentionFrom(String key, String shortCut) {
            this.key = key;
            this.shortCut = shortCut;
        }

        public String getValue(String value) {
            return this.shortCut + value;
        }

        public static ExtentionFrom from(String key) {
            for (ExtentionFrom value : ExtentionFrom.values()) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return None;
        }
    }

    public static enum ConnectionState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

