/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Pair;
import com.sendbird.android.APIClient;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BannedUserListQuery;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.ChannelManager;
import com.sendbird.android.Command;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelMemberListQuery;
import com.sendbird.android.GroupChannelParams;
import com.sendbird.android.GroupChannelTotalUnreadMessageCountParams;
import com.sendbird.android.HashUtils;
import com.sendbird.android.Member;
import com.sendbird.android.PublicGroupChannelListQuery;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.ScheduledUserMessage;
import com.sendbird.android.ScheduledUserMessageParams;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.SocketManager;
import com.sendbird.android.TimeoutScheduler;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public final class GroupChannel
extends BaseChannel {
    protected static final ConcurrentHashMap<String, GroupChannel> sCachedChannels = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Pair<Long, User>> mCachedTypingStatus = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> mCachedReadReceiptStatus;
    private ConcurrentHashMap<String, Long> mCachedDeliveryReceipt;
    private boolean mIsSuper;
    private boolean mIsPublic;
    private boolean mIsDistinct;
    private boolean mIsDiscoverable;
    private int mUnreadMessageCount;
    private int mUnreadMentionCount;
    private List<Member> mMembers;
    protected Map<String, Member> mMemberMap;
    private BaseMessage mLastMessage;
    private User mInviter;
    private int mMemberCount;
    private int mJoinedMemberCount;
    private long mInvitedAt;
    private static long sMarkAsReadAllLastSentAt;
    private long mStartTypingLastSentAt;
    private long mEndTypingLastSentAt;
    protected long mMarkAsReadLastSentAt;
    private long mMyLastRead;
    private boolean mMarkAsReadScheduled;
    private long mMessageOffsetTimestamp;
    private String mCustomType;
    private boolean mIsPushEnabled;
    private PushTriggerOption mMyPushTriggerOption;
    private CountPreference mMyCountPreference;
    private boolean mIsHidden;
    private HiddenState mHiddenState;
    private boolean mIsAccessCodeRequired;
    private Member.MemberState mMyMemberState;
    private Member.Role mMyRole;
    private Member.MutedState mMyMutedState;
    private TimeoutScheduler rateLimitScheduler;
    private boolean isBroadcast;
    private int messageSurvivalSeconds;
    boolean mHasBeenUpdated;
    private long mMemberCountUpdatedAt;
    private AtomicLong memberRoleUpdatedAt;
    protected User createdBy;

    static synchronized void clearCache() {
        sCachedChannels.clear();
    }

    static synchronized void removeChannelFromCache(String channelUrl) {
        sCachedChannels.remove(channelUrl);
    }

    public void refresh(final GroupChannelRefreshHandler handler) {
        GroupChannel.getChannelWithoutCache(this.getUrl(), new GroupChannelGetHandler(){

            @Override
            public void onResult(GroupChannel channel, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static GroupChannelListQuery createMyGroupChannelListQuery() {
        return new GroupChannelListQuery(SendBird.getCurrentUser());
    }

    public static PublicGroupChannelListQuery createPublicGroupChannelListQuery() {
        return new PublicGroupChannelListQuery();
    }

    public static void createChannel(List<User> users, boolean isDistinct, final GroupChannelCreateHandler handler) {
        if (users == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userIds.add(user.getUserId());
        }
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, null, null, null, handler);
    }

    @Deprecated
    public static void createChannel(List<User> users, boolean isDistinct, String name, Object coverUrlOrImage, String data, final GroupChannelCreateHandler handler) throws ClassCastException {
        if (users == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userIds.add(user.getUserId());
        }
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, name, coverUrlOrImage, data, handler);
    }

    public static void createChannel(List<User> users, boolean isDistinct, String name, Object coverUrlOrImage, String data, String customType, final GroupChannelCreateHandler handler) throws ClassCastException {
        if (users == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userIds.add(user.getUserId());
        }
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, name, coverUrlOrImage, data, customType, handler);
    }

    public static void createChannelWithUserIds(List<String> userIds, boolean isDistinct, GroupChannelCreateHandler handler) {
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, null, null, null, handler);
    }

    @Deprecated
    public static void createChannelWithUserIds(List<String> userIds, boolean isDistinct, String name, Object coverUrlOrImage, String data, GroupChannelCreateHandler handler) throws ClassCastException {
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, name, coverUrlOrImage, data, null, handler);
    }

    public static void createChannelWithUserIds(List<String> userIds, boolean isDistinct, String name, Object coverUrlOrImage, String data, String customType, GroupChannelCreateHandler handler) throws ClassCastException {
        GroupChannel.localCreateChannel(userIds, null, null, null, null, isDistinct, null, null, name, coverUrlOrImage, data, customType, null, null, null, null, handler);
    }

    public static void createChannel(GroupChannelParams params, final GroupChannelCreateHandler handler) throws ClassCastException {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        GroupChannel.localCreateChannel(params.mUserIds, params.mOperatorUserIds, params.mIsSuper, params.mIsPublic, params.mIsEphemeral, params.mIsDistinct, params.mIsDiscoverable, params.mChannelUrl, params.mName, params.mCoverUrlOrImage, params.mData, params.mCustomType, params.mAccessCode, params.mStrict, params.isBroadcast, params.messageSurvivalSeconds, handler);
    }

    public static void createDistinctChannelIfNotExist(GroupChannelParams params, final GroupChannelCreateDistinctChannelIfNotExistHandler handler) throws ClassCastException {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, false, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        GroupChannel.localCreateChannel(params.mUserIds, params.mOperatorUserIds, params.mIsSuper, params.mIsPublic, params.mIsEphemeral, true, params.mIsDiscoverable, params.mChannelUrl, params.mName, params.mCoverUrlOrImage, params.mData, params.mCustomType, params.mAccessCode, params.mStrict, params.isBroadcast, params.messageSurvivalSeconds, handler);
    }

    private static void localCreateChannel(List<String> userIds, List<String> operatorUserIds, Boolean isSuper, Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, Boolean isDiscoverable, String channelUrl, String name, Object coverUrlOrImage, String data, String customType, String accessCode, Boolean strict, Boolean isBroadcast, Integer messageSurvivalSeconds, final Object handler) throws ClassCastException {
        if (userIds == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler instanceof GroupChannelCreateHandler) {
                            ((GroupChannelCreateHandler)handler).onResult(null, new SendBirdException("Invalid arguments.", 800110));
                        } else if (handler instanceof GroupChannelCreateDistinctChannelIfNotExistHandler) {
                            ((GroupChannelCreateDistinctChannelIfNotExistHandler)handler).onResult(null, false, new SendBirdException("Invalid arguments.", 800110));
                        }
                    }
                });
            }
            return;
        }
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException();
        }
        if (operatorUserIds != null && operatorUserIds.size() > 0) {
            LinkedHashSet<String> operatorUserIdSet = new LinkedHashSet<String>(operatorUserIds);
            operatorUserIds = new ArrayList<String>(operatorUserIdSet);
        }
        APIClient.APIClientHandler apiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                boolean isCreated;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (handler instanceof GroupChannelCreateHandler) {
                                    ((GroupChannelCreateHandler)handler).onResult(null, e);
                                } else if (handler instanceof GroupChannelCreateDistinctChannelIfNotExistHandler) {
                                    ((GroupChannelCreateDistinctChannelIfNotExistHandler)handler).onResult(null, false, e);
                                }
                            }
                        });
                    }
                    return;
                }
                final GroupChannel channel = GroupChannel.upsert(response, false);
                boolean bl = isCreated = response.getAsJsonObject().has("is_created") && response.getAsJsonObject().get("is_created").getAsBoolean();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (handler instanceof GroupChannelCreateHandler) {
                                ((GroupChannelCreateHandler)handler).onResult(channel, null);
                            } else if (handler instanceof GroupChannelCreateDistinctChannelIfNotExistHandler) {
                                ((GroupChannelCreateDistinctChannelIfNotExistHandler)handler).onResult(channel, isCreated, null);
                            }
                        }
                    });
                }
            }
        };
        if (coverUrlOrImage instanceof String || coverUrlOrImage == null) {
            APIClient.getInstance().createGroupChannel(userIds, operatorUserIds, isSuper, isPublic, isEphemeral, isDistinct, isDiscoverable, channelUrl, name, (String)coverUrlOrImage, data, customType, accessCode, strict, isBroadcast, messageSurvivalSeconds, apiClientHandler);
        } else {
            APIClient.getInstance().createGroupChannel(userIds, operatorUserIds, isSuper, isPublic, isEphemeral, isDistinct, isDiscoverable, channelUrl, name, (File)coverUrlOrImage, data, customType, accessCode, strict, isBroadcast, messageSurvivalSeconds, apiClientHandler);
        }
    }

    static boolean hasCachedChannel(String channelUrl) {
        if (TextUtils.isEmpty((CharSequence)channelUrl)) {
            return false;
        }
        return sCachedChannels.containsKey(channelUrl);
    }

    protected static void getChannelWithoutCache(String channelUrl, GroupChannelGetHandler handler) {
        GroupChannel.getChannelWithoutCache(false, channelUrl, handler);
    }

    static void getChannelWithoutCacheInternal(String channelUrl, GroupChannelGetHandler handler) {
        GroupChannel.getChannelWithoutCache(true, channelUrl, handler);
    }

    public static void getChannel(String channelUrl, GroupChannelGetHandler handler) {
        GroupChannel.getChannel(false, channelUrl, handler);
    }

    static void getChannelInternal(String channelUrl, GroupChannelGetHandler handler) {
        GroupChannel.getChannel(true, channelUrl, handler);
    }

    private static void getChannel(boolean isInternal, final String channelUrl, final GroupChannelGetHandler handler) {
        if (channelUrl == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (sCachedChannels.containsKey(channelUrl) && !sCachedChannels.get(channelUrl).isDirty()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GroupChannel channel = sCachedChannels.get(channelUrl);
                        if (channel == null) {
                            return;
                        }
                        handler.onResult(sCachedChannels.get(channelUrl), null);
                    }
                });
            }
        } else {
            GroupChannel.getChannelWithoutCache(isInternal, channelUrl, new GroupChannelGetHandler(){

                @Override
                public void onResult(final GroupChannel channel, final SendBirdException e) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (channel == null && e == null) {
                                    return;
                                }
                                handler.onResult(channel, e);
                            }
                        });
                    }
                }
            });
        }
    }

    private static void getChannelWithoutCache(boolean isInternal, final String channelUrl, final GroupChannelGetHandler handler) {
        APIClient.getInstance().getGroupChannel(channelUrl, true, true, isInternal, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                GroupChannel.upsert(response, false);
                if (handler != null) {
                    handler.onResult(sCachedChannels.get(channelUrl), null);
                }
            }
        });
    }

    @Deprecated
    public static void getTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, null, handler);
    }

    @Deprecated
    public static void getTotalUnreadMessageCount(List<String> channelCustomTypes, GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, channelCustomTypes, handler);
    }

    @Deprecated
    public static void getTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams params, GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(params.mSuperChannelFilter, params.mChannelCustomTypes, handler);
    }

    @Deprecated
    public static void getUnreadItemCount(Collection<UnreadItemKey> keys, final GroupChannelGetUnreadItemCountHandler handler) {
        if (keys == null || keys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getUnreadItemCount(keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final HashMap<UnreadItemKey, Integer> result = new HashMap<UnreadItemKey, Integer>();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    UnreadItemKey unreadItemKey = null;
                    String key = (String)entry.getKey();
                    if (key.equals("group_channel_unread_message_count")) {
                        unreadItemKey = UnreadItemKey.GROUP_CHANNEL_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("group_channel_unread_mention_count")) {
                        unreadItemKey = UnreadItemKey.GROUP_CHANNEL_UNREAD_MENTION_COUNT;
                    } else if (key.equals("group_channel_invitation_count")) {
                        unreadItemKey = UnreadItemKey.GROUP_CHANNEL_INVITATION_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_message_count")) {
                        unreadItemKey = UnreadItemKey.NONSUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("super_group_channel_unread_message_count")) {
                        unreadItemKey = UnreadItemKey.SUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_mention_count")) {
                        unreadItemKey = UnreadItemKey.NONSUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("super_group_channel_unread_mention_count")) {
                        unreadItemKey = UnreadItemKey.SUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("non_super_group_channel_invitation_count")) {
                        unreadItemKey = UnreadItemKey.NONSUPER_INVITATION_COUNT;
                    } else if (key.equals("super_group_channel_invitation_count")) {
                        unreadItemKey = UnreadItemKey.SUPER_INVITATION_COUNT;
                    }
                    if (unreadItemKey == null) continue;
                    result.put(unreadItemKey, ((JsonElement)entry.getValue()).getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public static void getTotalUnreadChannelCount(final GroupChannelTotalUnreadChannelCountHandler handler) {
        APIClient.getInstance().getTotalUnreadChannelCount(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int unreadCount = response.getAsJsonObject().get("unread_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(unreadCount, null);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public static void getChannelCount(MemberState memberState, GroupChannelChannelCountHandler handler) {
        String state;
        switch (memberState) {
            case ALL: {
                state = "all";
                break;
            }
            case INVITED: {
                state = "invited";
                break;
            }
            case INVITED_BY_FRIEND: {
                state = "invited_by_friend";
                break;
            }
            case INVITED_BY_NON_FRIEND: {
                state = "invited_by_non_friend";
                break;
            }
            case JOINED: {
                state = "joined";
                break;
            }
            default: {
                state = null;
            }
        }
        SendBird.localGetGroupChannelCount(state, handler);
    }

    @Deprecated
    public static void getChannelCount(GroupChannelListQuery.MemberStateFilter memberStateFilter, GroupChannelChannelCountHandler handler) {
        String state;
        switch (memberStateFilter) {
            case ALL: {
                state = "all";
                break;
            }
            case INVITED: {
                state = "invited";
                break;
            }
            case INVITED_BY_FRIEND: {
                state = "invited_by_friend";
                break;
            }
            case INVITED_BY_NON_FRIEND: {
                state = "invited_by_non_friend";
                break;
            }
            case JOINED: {
                state = "joined";
                break;
            }
            default: {
                state = null;
            }
        }
        SendBird.localGetGroupChannelCount(state, handler);
    }

    public GroupChannelMemberListQuery createMemberListQuery() {
        return new GroupChannelMemberListQuery(this);
    }

    protected static synchronized GroupChannel upsert(JsonElement el, boolean dirty) {
        String channelUrl = el.getAsJsonObject().get("channel_url").getAsString();
        if (sCachedChannels.containsKey(channelUrl)) {
            GroupChannel channel = sCachedChannels.get(channelUrl);
            if (!dirty || channel.isDirty()) {
                boolean isEphemeral;
                JsonObject newObj = el.getAsJsonObject();
                boolean bl = isEphemeral = newObj.has("is_ephemeral") && newObj.get("is_ephemeral").getAsBoolean();
                if (isEphemeral && !dirty) {
                    if (channel.getLastMessage() != null) {
                        newObj.add("last_message", channel.getLastMessage().toJson());
                    }
                    newObj.addProperty("unread_message_count", (Number)channel.getUnreadMessageCount());
                    newObj.addProperty("unread_mention_count", (Number)channel.getUnreadMentionCount());
                }
                channel.update((JsonElement)newObj);
                channel.setDirty(dirty);
            }
        } else {
            sCachedChannels.put(channelUrl, new GroupChannel(el));
        }
        return sCachedChannels.get(channelUrl);
    }

    protected static synchronized void setDirtyToAllCachedChannels(boolean dirty) {
        if (sCachedChannels != null) {
            for (GroupChannel channel : sCachedChannels.values()) {
                channel.setDirty(dirty);
            }
        }
    }

    protected GroupChannel(JsonElement el) {
        super(el);
    }

    @Override
    protected void update(JsonElement el) {
        super.update(el);
        this.parse(el);
    }

    private synchronized void parse(JsonElement el) {
        String myMemberState;
        JsonObject obj = el.getAsJsonObject();
        if (this.mCachedReadReceiptStatus == null) {
            this.mCachedReadReceiptStatus = new ConcurrentHashMap();
        }
        if (this.mCachedDeliveryReceipt == null) {
            this.mCachedDeliveryReceipt = new ConcurrentHashMap();
        }
        this.mIsSuper = obj.has("is_super") && obj.get("is_super").getAsBoolean();
        this.mIsPublic = obj.has("is_public") && obj.get("is_public").getAsBoolean();
        this.mIsDistinct = obj.get("is_distinct").getAsBoolean();
        this.mIsDiscoverable = obj.has("is_discoverable") ? obj.get("is_discoverable").getAsBoolean() : this.mIsPublic;
        this.mIsAccessCodeRequired = obj.has("is_access_code_required") && obj.get("is_access_code_required").getAsBoolean();
        this.isBroadcast = obj.has("is_broadcast") && obj.get("is_broadcast").getAsBoolean();
        this.mUnreadMessageCount = obj.get("unread_message_count").getAsInt();
        if (obj.has("unread_mention_count")) {
            this.mUnreadMentionCount = obj.get("unread_mention_count").getAsInt();
        }
        if (obj.has("read_receipt")) {
            JsonObject readReceiptObj = obj.get("read_receipt").getAsJsonObject();
            for (Object entry : readReceiptObj.entrySet()) {
                this.updateReadReceipt((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
            }
            this.mCachedReadReceiptStatus.keySet().retainAll(readReceiptObj.keySet());
        }
        if (obj.has("delivery_receipt")) {
            JsonObject deliveryReceiptObj = obj.get("delivery_receipt").getAsJsonObject();
            Set deliveryReceiptSet = deliveryReceiptObj.entrySet();
            for (Map.Entry entry : deliveryReceiptSet) {
                this.updateDeliveryReceipt((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
            }
            this.mCachedDeliveryReceipt.keySet().retainAll(deliveryReceiptObj.keySet());
        }
        if (obj.has("members")) {
            if (this.mMembers != null) {
                this.mMembers.clear();
            } else {
                this.mMembers = new CopyOnWriteArrayList<Member>();
            }
            if (this.mMemberMap != null) {
                this.mMemberMap.clear();
            } else {
                this.mMemberMap = new ConcurrentHashMap<String, Member>();
            }
            JsonArray objMembers = obj.get("members").getAsJsonArray();
            for (int i = 0; i < objMembers.size(); ++i) {
                Member member = new Member(objMembers.get(i));
                this.mMembers.add(member);
                this.mMemberMap.put(member.getUserId(), member);
            }
            this.mMemberCount = this.mMembers.size();
        }
        if (obj.has("member_count")) {
            this.mMemberCount = obj.get("member_count").getAsInt();
        }
        if (obj.has("joined_member_count")) {
            this.mJoinedMemberCount = obj.get("joined_member_count").getAsInt();
        }
        if (obj.has("invited_at") && !obj.get("invited_at").isJsonNull()) {
            this.setInvitedAt(obj.get("invited_at").getAsLong());
        }
        this.mLastMessage = obj.has("last_message") && obj.get("last_message").isJsonObject() ? BaseMessage.build(obj.get("last_message"), this.getUrl(), this.getType()) : null;
        this.mInviter = obj.has("inviter") && obj.get("inviter").isJsonObject() ? new User((JsonElement)obj.get("inviter").getAsJsonObject()) : null;
        if (obj.has("custom_type")) {
            this.mCustomType = obj.get("custom_type").getAsString();
        }
        if (obj.has("is_push_enabled")) {
            this.mIsPushEnabled = obj.get("is_push_enabled").getAsBoolean();
        }
        if (obj.has("push_trigger_option")) {
            String pushTriggerOption;
            String string = pushTriggerOption = obj.get("push_trigger_option").isJsonNull() ? "default" : obj.get("push_trigger_option").getAsString();
            this.mMyPushTriggerOption = pushTriggerOption.equals("all") ? PushTriggerOption.ALL : (pushTriggerOption.equals("off") ? PushTriggerOption.OFF : (pushTriggerOption.equals("mention_only") ? PushTriggerOption.MENTION_ONLY : (pushTriggerOption.equals("default") ? PushTriggerOption.DEFAULT : PushTriggerOption.DEFAULT)));
        } else {
            this.mMyPushTriggerOption = PushTriggerOption.DEFAULT;
        }
        if (obj.has("count_preference")) {
            String countPreference = obj.get("count_preference").getAsString();
            if (countPreference != null) {
                this.mMyCountPreference = countPreference.equals("all") ? CountPreference.ALL : (countPreference.equals("unread_message_count_only") ? CountPreference.UNREAD_MESSAGE_COUNT_ONLY : (countPreference.equals("unread_mention_count_only") ? CountPreference.UNREAD_MENTION_COUNT_ONLY : (countPreference.equals("off") ? CountPreference.OFF : CountPreference.ALL)));
            }
        } else {
            this.mMyCountPreference = CountPreference.ALL;
        }
        if (obj.has("is_hidden")) {
            this.mIsHidden = obj.get("is_hidden").getAsBoolean();
        }
        if (obj.has("hidden_state")) {
            String hiddenState = obj.get("hidden_state").getAsString();
            if (hiddenState.equals("unhidden")) {
                this.setHiddenState(HiddenState.UNHIDDEN);
            } else if (hiddenState.equals("hidden_allow_auto_unhide")) {
                this.setHiddenState(HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
            } else if (hiddenState.equals("hidden_prevent_auto_unhide")) {
                this.setHiddenState(HiddenState.HIDDEN_PREVENT_AUTO_UNHIDE);
            } else {
                this.setHiddenState(HiddenState.UNHIDDEN);
            }
        } else {
            this.setHiddenState(HiddenState.UNHIDDEN);
        }
        this.mMyMemberState = Member.MemberState.NONE;
        if (obj.has("member_state") && (myMemberState = obj.get("member_state").getAsString()) != null && myMemberState.length() > 0) {
            if (myMemberState.equals("none")) {
                this.mMyMemberState = Member.MemberState.NONE;
            } else if (myMemberState.equals("invited")) {
                this.mMyMemberState = Member.MemberState.INVITED;
            } else if (myMemberState.equals("joined")) {
                this.mMyMemberState = Member.MemberState.JOINED;
            }
        }
        this.mMyRole = Member.Role.NONE;
        if (obj.has("my_role")) {
            String myRole = obj.get("my_role").getAsString();
            this.mMyRole = Member.Role.fromValue(myRole);
        }
        this.mMyMutedState = Member.MutedState.UNMUTED;
        if (obj.has("is_muted")) {
            Member.MutedState mutedState = this.mMyMutedState = obj.get("is_muted").getAsBoolean() ? Member.MutedState.MUTED : Member.MutedState.UNMUTED;
        }
        if (obj.has("user_last_read")) {
            long myLastRead = obj.get("user_last_read").getAsLong();
            this.mMyLastRead = Math.max(this.mMyLastRead, myLastRead);
        } else {
            this.mMyLastRead = 0L;
        }
        this.mMemberCountUpdatedAt = 0L;
        this.parseMessageOffset((JsonElement)obj);
        this.messageSurvivalSeconds = obj.has("message_survival_seconds") ? obj.get("message_survival_seconds").getAsInt() : -1;
        this.memberRoleUpdatedAt = new AtomicLong(0L);
        this.createdBy = obj.has("created_by") && !obj.get("created_by").isJsonNull() ? new User(obj.get("created_by")) : null;
    }

    @Override
    synchronized JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("channel_type", BaseChannel.ChannelType.GROUP.value());
        obj.addProperty("is_super", Boolean.valueOf(this.mIsSuper));
        obj.addProperty("is_public", Boolean.valueOf(this.mIsPublic));
        obj.addProperty("is_distinct", Boolean.valueOf(this.mIsDistinct));
        obj.addProperty("is_access_code_required", Boolean.valueOf(this.mIsAccessCodeRequired));
        obj.addProperty("unread_message_count", (Number)this.mUnreadMessageCount);
        obj.addProperty("unread_mention_count", (Number)this.mUnreadMentionCount);
        obj.addProperty("member_count", (Number)this.mMemberCount);
        obj.addProperty("joined_member_count", (Number)this.mJoinedMemberCount);
        obj.addProperty("invited_at", (Number)this.mInvitedAt);
        obj.addProperty("is_push_enabled", Boolean.valueOf(this.mIsPushEnabled));
        obj.addProperty("user_last_read", (Number)this.mMyLastRead);
        obj.addProperty("is_broadcast", Boolean.valueOf(this.isBroadcast));
        if (this.mMyCountPreference == CountPreference.ALL) {
            obj.addProperty("count_preference", "all");
        } else if (this.mMyCountPreference == CountPreference.UNREAD_MESSAGE_COUNT_ONLY) {
            obj.addProperty("count_preference", "unread_message_count_only");
        } else if (this.mMyCountPreference == CountPreference.UNREAD_MENTION_COUNT_ONLY) {
            obj.addProperty("count_preference", "unread_mention_count_only");
        } else if (this.mMyCountPreference == CountPreference.OFF) {
            obj.addProperty("count_preference", "off");
        }
        obj.addProperty("is_hidden", Boolean.valueOf(this.mIsHidden));
        if (this.mHiddenState == HiddenState.UNHIDDEN) {
            obj.addProperty("hidden_state", "unhidden");
        } else if (this.mHiddenState == HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE) {
            obj.addProperty("hidden_state", "hidden_allow_auto_unhide");
        } else if (this.mHiddenState == HiddenState.HIDDEN_PREVENT_AUTO_UNHIDE) {
            obj.addProperty("hidden_state", "hidden_prevent_auto_unhide");
        }
        if (this.mMyPushTriggerOption == PushTriggerOption.ALL) {
            obj.addProperty("push_trigger_option", "all");
        } else if (this.mMyPushTriggerOption == PushTriggerOption.OFF) {
            obj.addProperty("push_trigger_option", "off");
        } else if (this.mMyPushTriggerOption == PushTriggerOption.MENTION_ONLY) {
            obj.addProperty("push_trigger_option", "mention_only");
        } else if (this.mMyPushTriggerOption == PushTriggerOption.DEFAULT) {
            obj.addProperty("push_trigger_option", "default");
        }
        if (this.mCustomType != null) {
            obj.addProperty("custom_type", this.mCustomType);
        }
        JsonObject rrObj = new JsonObject();
        for (Map.Entry<String, Long> entry : this.mCachedReadReceiptStatus.entrySet()) {
            rrObj.addProperty(entry.getKey(), (Number)entry.getValue());
        }
        obj.add("read_receipt", (JsonElement)rrObj);
        if (this.mCachedDeliveryReceipt != null && this.mCachedDeliveryReceipt.size() > 0) {
            JsonObject drObj = new JsonObject();
            for (Map.Entry entry : this.mCachedDeliveryReceipt.entrySet()) {
                drObj.addProperty((String)entry.getKey(), (Number)entry.getValue());
            }
            obj.add("delivery_receipt", (JsonElement)drObj);
        }
        if (this.mMembers != null) {
            JsonArray membersObj = new JsonArray();
            for (Member member : this.mMembers) {
                membersObj.add(member.toJson());
            }
            obj.add("members", (JsonElement)membersObj);
        }
        if (this.mLastMessage != null) {
            obj.add("last_message", this.mLastMessage.toJson());
        }
        if (this.mInviter != null) {
            obj.add("inviter", this.mInviter.toJson());
        }
        if (this.mMyMemberState == Member.MemberState.NONE) {
            obj.addProperty("member_state", "none");
        } else if (this.mMyMemberState == Member.MemberState.INVITED) {
            obj.addProperty("member_state", "invited");
        } else if (this.mMyMemberState == Member.MemberState.JOINED) {
            obj.addProperty("member_state", "joined");
        }
        obj.addProperty("my_role", this.mMyRole.getValue());
        if (this.mMyMutedState == Member.MutedState.UNMUTED) {
            obj.addProperty("is_muted", "false");
        } else if (this.mMyMutedState == Member.MutedState.MUTED) {
            obj.addProperty("is_muted", "true");
        }
        obj.addProperty("ts_message_offset", (Number)this.mMessageOffsetTimestamp);
        obj.addProperty("message_survival_seconds", (Number)this.messageSurvivalSeconds);
        if (this.createdBy != null) {
            obj.add("created_by", this.createdBy.toJson());
        }
        return obj;
    }

    public BaseMessage getLastMessage() {
        return this.mLastMessage;
    }

    protected synchronized void setLastMessage(BaseMessage lastMessage) {
        this.mLastMessage = lastMessage;
    }

    synchronized boolean setLastMessageByCreatedAt(BaseMessage lastMessage) {
        if (this.getLastMessage() == null || this.getLastMessage().getCreatedAt() < lastMessage.getCreatedAt()) {
            this.setLastMessage(lastMessage);
            return true;
        }
        return false;
    }

    public User getInviter() {
        return this.mInviter;
    }

    public int getUnreadMessageCount() {
        return this.mUnreadMessageCount;
    }

    protected synchronized void setUnreadMessageCount(int count) {
        this.mUnreadMessageCount = this.isMyUnreadMessageCountEnabled() ? (this.isSuper() ? Math.min(SendBird.getMaxUnreadMessageCountOnSuperGroup(), count) : count) : 0;
    }

    public int getUnreadMentionCount() {
        return this.mUnreadMentionCount;
    }

    protected synchronized void setUnreadMentionCount(int count) {
        if (this.isMyUnreadMentionCountEnabled()) {
            if (count < 0) {
                count = 0;
            }
            this.mUnreadMentionCount = count;
        } else {
            this.mUnreadMentionCount = 0;
        }
    }

    public List<Member> getMembers() {
        return Arrays.asList(this.mMembers.toArray(new Member[0]));
    }

    public int getMemberCount() {
        return this.mMemberCount;
    }

    public int getJoinedMemberCount() {
        return this.mJoinedMemberCount;
    }

    public long getInvitedAt() {
        return this.mInvitedAt;
    }

    void setInvitedAt(long invitedAt) {
        this.mInvitedAt = invitedAt;
    }

    public boolean isSuper() {
        return this.mIsSuper;
    }

    public boolean isPublic() {
        return this.mIsPublic;
    }

    public boolean isDistinct() {
        return this.mIsDistinct;
    }

    public boolean isDiscoverable() {
        return this.mIsDiscoverable;
    }

    public boolean isPushEnabled() {
        return this.mIsPushEnabled;
    }

    public PushTriggerOption getMyPushTriggerOption() {
        return this.mMyPushTriggerOption;
    }

    public boolean isAccessCodeRequired() {
        return this.mIsAccessCodeRequired;
    }

    public CountPreference getMyCountPreference() {
        return this.mMyCountPreference;
    }

    boolean isMyUnreadMessageCountEnabled() {
        return this.mMyCountPreference == CountPreference.ALL || this.mMyCountPreference == CountPreference.UNREAD_MESSAGE_COUNT_ONLY;
    }

    boolean isMyUnreadMentionCountEnabled() {
        return this.mMyCountPreference == CountPreference.ALL || this.mMyCountPreference == CountPreference.UNREAD_MENTION_COUNT_ONLY;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    private void setIsHidden(boolean isHidden) {
        this.mIsHidden = isHidden;
    }

    public HiddenState getHiddenState() {
        return this.mHiddenState;
    }

    void setHiddenState(HiddenState hiddenState) {
        this.mHiddenState = hiddenState;
        if (hiddenState == HiddenState.UNHIDDEN) {
            this.setIsHidden(false);
        } else if (hiddenState == HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE) {
            this.setIsHidden(true);
        } else if (hiddenState == HiddenState.HIDDEN_PREVENT_AUTO_UNHIDE) {
            this.setIsHidden(true);
        }
    }

    public long getMessageOffsetTimestamp() {
        return this.mMessageOffsetTimestamp;
    }

    void parseMessageOffset(JsonElement element) {
        if (element.getAsJsonObject().has("ts_message_offset")) {
            long messageOffset = element.getAsJsonObject().get("ts_message_offset").getAsLong();
            this.setMessageOffsetTimestamp(messageOffset);
        }
    }

    private void setMessageOffsetTimestamp(long ts) {
        this.mMessageOffsetTimestamp = ts;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public void updateChannel(String name, Object coverUrlOrImage, String data, GroupChannelUpdateHandler handler) throws ClassCastException {
        this.updateChannel(this.isDistinct(), name, coverUrlOrImage, data, handler);
    }

    @Deprecated
    public void updateChannel(boolean isDistinct, String name, Object coverUrlOrImage, String data, GroupChannelUpdateHandler handler) throws ClassCastException {
        this.updateChannel(isDistinct, name, coverUrlOrImage, data, null, handler);
    }

    public void updateChannel(boolean isDistinct, String name, Object coverUrlOrImage, String data, String customType, GroupChannelUpdateHandler handler) throws ClassCastException {
        this.localUpdateChannel(null, null, isDistinct, null, name, coverUrlOrImage, data, customType, null, null, null, null, handler);
    }

    public void updateChannel(GroupChannelParams params, final GroupChannelUpdateHandler handler) throws ClassCastException {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localUpdateChannel(params.mIsPublic, null, params.mIsDistinct, params.mIsDiscoverable, params.mName, params.mCoverUrlOrImage, params.mData, params.mCustomType, params.mAccessCode, params.mStrict, params.messageSurvivalSeconds, params.mOperatorUserIds, handler);
    }

    private void localUpdateChannel(Boolean isPublic, Boolean isEphemeral, Boolean isDistinct, Boolean isDiscoverable, String name, Object coverUrlOrImage, String data, String customType, String accessCode, Boolean strict, Integer messageSurvivalSeconds, List<String> operatorUserIds, final GroupChannelUpdateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException();
        }
        APIClient.APIClientHandler apiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final GroupChannel channel = GroupChannel.upsert(response, false);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channel, null);
                        }
                    });
                }
            }
        };
        if (coverUrlOrImage instanceof String || coverUrlOrImage == null) {
            APIClient.getInstance().updateGroupChannel(this.getUrl(), isPublic, isEphemeral, isDistinct, isDiscoverable, name, (String)coverUrlOrImage, data, customType, accessCode, strict, messageSurvivalSeconds, operatorUserIds, apiClientHandler);
        } else {
            APIClient.getInstance().updateGroupChannel(this.getUrl(), isPublic, isEphemeral, isDistinct, isDiscoverable, name, (File)coverUrlOrImage, data, customType, accessCode, strict, messageSurvivalSeconds, operatorUserIds, apiClientHandler);
        }
    }

    public void invite(User user, final GroupChannelInviteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(user.getUserId());
        this.inviteWithUserIds(userIds, handler);
    }

    public void invite(List<User> users, final GroupChannelInviteHandler handler) {
        if (users == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userIds.add(user.getUserId());
        }
        this.inviteWithUserIds(userIds, handler);
    }

    public void inviteWithUserId(String userId, final GroupChannelInviteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId);
        this.inviteWithUserIds(userIds, handler);
    }

    public void inviteWithUserIds(List<String> userIds, final GroupChannelInviteHandler handler) {
        if (userIds == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        LinkedHashSet<String> userIdSet = new LinkedHashSet<String>(userIds);
        userIds = new ArrayList<String>(userIdSet);
        APIClient.getInstance().groupChannelInvite(this.getUrl(), userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.upsert(response, false);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void join(GroupChannelJoinHandler handler) {
        this.join(null, handler);
    }

    public void join(String accessCode, final GroupChannelJoinHandler handler) {
        APIClient.getInstance().groupChannelJoin(this.getUrl(), accessCode, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.upsert(response, false);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void hide(GroupChannelHideHandler handler) {
        this.hide(false, handler);
    }

    public void hide(boolean hidePreviousMessages, GroupChannelHideHandler handler) {
        this.hide(hidePreviousMessages, true, handler);
    }

    public void hide(final boolean hidePreviousMessages, final boolean allowAutoUnhide, final GroupChannelHideHandler handler) {
        APIClient.getInstance().groupChannelHide(this.getUrl(), hidePreviousMessages, allowAutoUnhide, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (allowAutoUnhide) {
                    GroupChannel.this.setHiddenState(HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
                } else {
                    GroupChannel.this.setHiddenState(HiddenState.HIDDEN_PREVENT_AUTO_UNHIDE);
                }
                if (hidePreviousMessages) {
                    GroupChannel.this.setUnreadMessageCount(0);
                    GroupChannel.this.setUnreadMentionCount(0);
                    GroupChannel.this.parseMessageOffset(response);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unhide(final GroupChannelUnhideHandler handler) {
        APIClient.getInstance().groupChannelUnhide(this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void leave(final GroupChannelLeaveHandler handler) {
        APIClient.getInstance().groupChannelLeave(this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void acceptInvitation(GroupChannelAcceptInvitationHandler handler) {
        this.acceptInvitation(null, handler);
    }

    public void acceptInvitation(String accessCode, final GroupChannelAcceptInvitationHandler handler) {
        APIClient.getInstance().groupChannelAcceptInvitation(this.getUrl(), accessCode, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void declineInvitation(final GroupChannelDeclineInvitationHandler handler) {
        APIClient.getInstance().groupChannelDeclineInvitation(this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void setPushPreference(final boolean pushOn, final GroupChannelSetPushPreferenceHandler handler) {
        APIClient.getInstance().setPushPreference(this.getUrl(), pushOn, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.this.mIsPushEnabled = pushOn;
                if (!pushOn) {
                    GroupChannel.this.mMyPushTriggerOption = PushTriggerOption.OFF;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public void getPushPreference(final GroupChannelGetPushPreferenceHandler handler) {
        APIClient.getInstance().getPushPreference(this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, e);
                            }
                        });
                    }
                    return;
                }
                final boolean isPushOn = response.getAsJsonObject().get("enable").getAsBoolean();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isPushOn, null);
                        }
                    });
                }
            }
        });
    }

    public void setMyPushTriggerOption(final PushTriggerOption pushTriggerOption, final GroupChannelSetMyPushTriggerOptionHandler handler) {
        APIClient.getInstance().setMyPushTriggerOption(this.getUrl(), pushTriggerOption, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.this.mMyPushTriggerOption = pushTriggerOption;
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void getMyPushTriggerOption(final GroupChannelGetMyPushTriggerOptionHandler handler) {
        APIClient.getInstance().getMyPushTriggerOption(this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (response.getAsJsonObject().has("push_trigger_option")) {
                    String pushTriggerOption;
                    String string = pushTriggerOption = response.getAsJsonObject().get("push_trigger_option").isJsonNull() ? "default" : response.getAsJsonObject().get("push_trigger_option").getAsString();
                    if (pushTriggerOption.equals("all")) {
                        GroupChannel.this.mMyPushTriggerOption = PushTriggerOption.ALL;
                    } else if (pushTriggerOption.equals("off")) {
                        GroupChannel.this.mMyPushTriggerOption = PushTriggerOption.OFF;
                    } else if (pushTriggerOption.equals("mention_only")) {
                        GroupChannel.this.mMyPushTriggerOption = PushTriggerOption.MENTION_ONLY;
                    } else if (pushTriggerOption.equals("default")) {
                        GroupChannel.this.mMyPushTriggerOption = PushTriggerOption.DEFAULT;
                    } else {
                        GroupChannel.this.mMyPushTriggerOption = PushTriggerOption.DEFAULT;
                    }
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(GroupChannel.this.mMyPushTriggerOption, null);
                        }
                    });
                }
            }
        });
    }

    public void setMyCountPreference(CountPreference preference, final GroupChannelSetMyCountPreferenceHandler handler) {
        APIClient.getInstance().setMyCountPreference(this.getUrl(), preference, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                String countPreference;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (response.getAsJsonObject().has("count_preference") && (countPreference = response.getAsJsonObject().get("count_preference").getAsString()) != null) {
                    if (countPreference.equals("all")) {
                        GroupChannel.this.mMyCountPreference = CountPreference.ALL;
                    } else if (countPreference.equals("unread_message_count_only")) {
                        GroupChannel.this.mMyCountPreference = CountPreference.UNREAD_MESSAGE_COUNT_ONLY;
                    } else if (countPreference.equals("unread_mention_count_only")) {
                        GroupChannel.this.mMyCountPreference = CountPreference.UNREAD_MENTION_COUNT_ONLY;
                    } else if (countPreference.equals("off")) {
                        GroupChannel.this.mMyCountPreference = CountPreference.OFF;
                    }
                }
                if (!GroupChannel.this.isMyUnreadMessageCountEnabled()) {
                    GroupChannel.this.setUnreadMessageCount(0);
                }
                if (!GroupChannel.this.isMyUnreadMentionCountEnabled()) {
                    GroupChannel.this.setUnreadMentionCount(0);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public static void markAsReadAll(final GroupChannelMarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadAll(null, new SendBird.MarkAsReadHandler(){

            @Override
            public void onResult(SendBirdException e) {
                if (handler != null) {
                    handler.onResult(e);
                }
            }
        });
    }

    static void localMarkAsReadAll(final List<String> channelUrls, final SendBird.MarkAsReadHandler handler) {
        if (System.currentTimeMillis() - sMarkAsReadAllLastSentAt < 1000L) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("MarkAsRead rate limit exceeded.", 800160));
                    }
                });
            }
            return;
        }
        sMarkAsReadAllLastSentAt = System.currentTimeMillis();
        APIClient.getInstance().groupChannelMarkAsReadAll(channelUrls, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (channelUrls == null) {
                    for (GroupChannel channel : sCachedChannels.values()) {
                        channel.setUnreadMessageCount(0);
                        channel.setUnreadMentionCount(0);
                    }
                } else {
                    for (String channelUrl : channelUrls) {
                        GroupChannel channel = sCachedChannels.get(channelUrl);
                        if (channel == null) continue;
                        channel.setUnreadMessageCount(0);
                        channel.setUnreadMentionCount(0);
                    }
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    static void localMarkAsReadWithChannelUrls(List<String> channelUrls, final SendBird.MarkAsReadHandler handler) {
        if (channelUrls == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        GroupChannel.localMarkAsReadAll(channelUrls, handler);
    }

    protected void sendMarkAsRead(final GroupChannelMarkAsReadHandler handler) {
        Command cmd = Command.bRead(this.getUrl());
        SocketManager.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, SendBirdException e) {
                JsonObject payload;
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() != null && (payload = acked.getJsonElement().getAsJsonObject()).has("ts")) {
                    long ts = payload.get("ts").getAsLong();
                    GroupChannel.this.updateReadReceipt(SendBird.getCurrentUser().getUserId(), ts);
                }
                if (GroupChannel.this.mUnreadMessageCount > 0) {
                    GroupChannel.this.setUnreadMessageCount(0);
                    GroupChannel.this.setUnreadMentionCount(0);
                    ChannelManager.getInstance().notifyAllChannelChanged(GroupChannel.this);
                }
                if (handler != null) {
                    handler.onResult(null);
                }
            }
        });
    }

    public void markAsDelivered() {
        this.markAsDelivered(0L, 0L);
    }

    synchronized void markAsDelivered(long msgId, long createdAt) {
        Logger.d("++ request data msgId : " + msgId + ", createdAt : " + createdAt);
        DeliveredReceiptData requestData = new DeliveredReceiptData(msgId, createdAt);
        if (this.rateLimitScheduler == null) {
            this.rateLimitScheduler = new TimeoutScheduler(1000L, 1000L, false, new TimeoutScheduler.TimeoutEventhandler(){

                @Override
                public void onTimeout(Object extra) {
                    Logger.d("++ onTimeout() request Delivery receipt");
                    DeliveredReceiptData data = (DeliveredReceiptData)extra;
                    Logger.d("++ data : " + data);
                    APIClient.getInstance().groupChannelMarkAsDelivered(GroupChannel.this.getUrl(), data.msgId, data.createdAt, new APIClient.APIClientHandler(){

                        @Override
                        public void onResult(JsonElement response, SendBirdException e) {
                            JsonObject payload;
                            if (e != null) {
                                Logger.e(e);
                                return;
                            }
                            Logger.d("++ mark as delivered response : " + response);
                            if (SendBird.getCurrentUser() != null && (payload = response.getAsJsonObject()).has("ts")) {
                                long ts = payload.get("ts").getAsLong();
                                GroupChannel.this.updateDeliveryReceipt(SendBird.getCurrentUser().getUserId(), ts);
                            }
                        }
                    });
                }
            }, requestData);
        }
        Logger.d("++ isRunning : " + this.rateLimitScheduler.isRunning());
        this.rateLimitScheduler.setExtra(requestData);
        if (this.rateLimitScheduler.isRunning()) {
            Logger.d("++ change delivery datas");
            return;
        }
        this.rateLimitScheduler.start();
    }

    public void markAsRead() {
        this.sendMarkAsRead(null);
    }

    public void resetMyHistory(final GroupChannelResetMyHistoryHandler handler) {
        APIClient.getInstance().groupChannelResetMyHistory(this.getUrl(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.this.parseMessageOffset(response);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public long getLastSeenAtBy(User user) {
        if (user == null) {
            return 0L;
        }
        return this.getLastSeenAtByWithUserId(user.getUserId());
    }

    @Deprecated
    public long getLastSeenAtByWithUserId(String userId) {
        if (this.mCachedReadReceiptStatus.containsKey(userId)) {
            Long ts = this.mCachedReadReceiptStatus.get(userId);
            return ts == null ? 0L : ts;
        }
        return 0L;
    }

    long getMyReadTs() {
        String userId;
        if (SendBird.getCurrentUser() != null && this.mCachedReadReceiptStatus.containsKey(userId = SendBird.getCurrentUser().getUserId())) {
            Long ts = this.mCachedReadReceiptStatus.get(userId);
            return ts == null ? 0L : ts;
        }
        return 0L;
    }

    long getMyLastDeliveredTs() {
        if (SendBird.getCurrentUser() != null) {
            String userId = SendBird.getCurrentUser().getUserId();
            return this.getLastDeliveredTs(userId);
        }
        return 0L;
    }

    long getLastDeliveredTs(String userId) {
        if (this.mCachedDeliveryReceipt.containsKey(userId)) {
            Long ts = this.mCachedDeliveryReceipt.get(userId);
            return ts == null ? 0L : ts;
        }
        return 0L;
    }

    @Deprecated
    public synchronized List<Member> getReadMembers(BaseMessage message) {
        return this.localGetReadMembers(message, false);
    }

    public synchronized List<Member> getReadMembers(BaseMessage message, boolean includeAllMembers) {
        return this.localGetReadMembers(message, includeAllMembers);
    }

    private List<Member> localGetReadMembers(BaseMessage message, boolean includeAllMembers) {
        ArrayList<Member> readMembers = new ArrayList<Member>();
        if (message == null || message instanceof AdminMessage || this.mIsSuper) {
            return readMembers;
        }
        User me = SendBird.getCurrentUser();
        if (me == null) {
            return readMembers;
        }
        Sender sender = message.getSender();
        long createdAt = message.getCreatedAt();
        List<Member> allMembers = this.getMembers();
        for (Member member : allMembers) {
            String key = member.getUserId();
            if (!includeAllMembers && (me.getUserId().equals(key) || sender != null && sender.getUserId().equals(key))) continue;
            Long value = this.mCachedReadReceiptStatus.get(key);
            if (value == null) {
                value = 0L;
            }
            if (value < createdAt) continue;
            readMembers.add(member);
        }
        return readMembers;
    }

    @Deprecated
    public synchronized List<Member> getUnreadMembers(BaseMessage message) {
        return this.localGetUnreadMembers(message, false);
    }

    public synchronized List<Member> getUnreadMembers(BaseMessage message, boolean includeAllMembers) {
        return this.localGetUnreadMembers(message, includeAllMembers);
    }

    private List<Member> localGetUnreadMembers(BaseMessage message, boolean includeAllMembers) {
        ArrayList<Member> unreadMembers = new ArrayList<Member>();
        if (message == null || message instanceof AdminMessage || this.mIsSuper) {
            return unreadMembers;
        }
        User me = SendBird.getCurrentUser();
        if (me == null) {
            return unreadMembers;
        }
        Sender sender = message.getSender();
        long createdAt = message.getCreatedAt();
        List<Member> allMembers = this.getMembers();
        for (Member member : allMembers) {
            String key = member.getUserId();
            if (!includeAllMembers && (me.getUserId().equals(key) || sender != null && sender.getUserId().equals(key))) continue;
            Long value = this.mCachedReadReceiptStatus.get(key);
            if (value == null) {
                value = 0L;
            }
            if (value >= createdAt) continue;
            unreadMembers.add(member);
        }
        return unreadMembers;
    }

    @Deprecated
    public synchronized Map<String, ReadStatus> getReadStatus() {
        return this.localGetReadStatus(false);
    }

    public synchronized Map<String, ReadStatus> getReadStatus(boolean includeAllMembers) {
        return this.localGetReadStatus(includeAllMembers);
    }

    private Map<String, ReadStatus> localGetReadStatus(boolean includeAllMembers) {
        HashMap<String, ReadStatus> readStatus = new HashMap<String, ReadStatus>();
        User me = SendBird.getCurrentUser();
        if (me == null || this.mIsSuper) {
            return readStatus;
        }
        List<Member> allMembers = this.getMembers();
        for (Member member : allMembers) {
            String key = member.getUserId();
            if (!includeAllMembers && me.getUserId().equals(key)) continue;
            Long value = this.mCachedReadReceiptStatus.get(key);
            ReadStatus rs = new ReadStatus(member, value == null ? 0L : value);
            readStatus.put(key, rs);
        }
        return readStatus;
    }

    public long getMyLastRead() {
        return this.mMyLastRead;
    }

    public synchronized int getReadReceipt(BaseMessage message) {
        return this.getUnreadMemberCount(message);
    }

    public synchronized int getUnreadMemberCount(BaseMessage message) {
        if (message == null || message instanceof AdminMessage || this.mIsSuper) {
            return 0;
        }
        User me = SendBird.getCurrentUser();
        if (me == null) {
            return 0;
        }
        Sender sender = message.getSender();
        int unreadMemberCount = 0;
        long createdAt = message.getCreatedAt();
        List<Member> members = this.getMembers();
        for (Member member : members) {
            String key = member.getUserId();
            if (me.getUserId().equals(key) || sender != null && sender.getUserId().equals(key) || member.getMemberState() != Member.MemberState.JOINED) continue;
            Long value = this.mCachedReadReceiptStatus.get(key);
            if (value == null) {
                value = 0L;
            }
            if (value >= createdAt) continue;
            ++unreadMemberCount;
        }
        return unreadMemberCount;
    }

    protected synchronized void updateReadReceipt(String userId, long timestamp) {
        String key = userId;
        Long value = this.mCachedReadReceiptStatus.get(key);
        long newValue = timestamp;
        if (value == null || value < newValue) {
            if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(userId)) {
                this.mMyLastRead = Math.max(this.mMyLastRead, timestamp);
            }
            this.mCachedReadReceiptStatus.put(key, newValue);
        }
    }

    public synchronized int getDeliveryReceipt(BaseMessage message) {
        return this.getUndeliveredMemberCount(message);
    }

    public synchronized int getUndeliveredMemberCount(BaseMessage message) {
        if (message == null || message instanceof AdminMessage || this.mIsSuper || this.mCachedDeliveryReceipt == null || this.mCachedDeliveryReceipt.size() <= 0) {
            return 0;
        }
        User me = SendBird.getCurrentUser();
        if (me == null) {
            return 0;
        }
        Sender sender = message.getSender();
        int unDeliveredMemberCount = 0;
        long createdAt = message.getCreatedAt();
        List<Member> members = this.getMembers();
        for (Member member : members) {
            String key = member.getUserId();
            if (me.getUserId().equals(key) || sender != null && sender.getUserId().equals(key) || member.getMemberState() != Member.MemberState.JOINED) continue;
            Long value = this.mCachedDeliveryReceipt.get(key);
            if (value == null) {
                value = 0L;
            }
            if (value >= createdAt) continue;
            ++unDeliveredMemberCount;
        }
        return unDeliveredMemberCount;
    }

    synchronized void updateDeliveryReceipt(String userId, long timestamp) {
        if (this.mCachedDeliveryReceipt == null) {
            return;
        }
        Long value = this.mCachedDeliveryReceipt.get(userId);
        if (value == null || value < timestamp) {
            this.mCachedDeliveryReceipt.put(userId, timestamp);
        }
    }

    public void startTyping() {
        if (System.currentTimeMillis() - this.mStartTypingLastSentAt < (long)SendBird.Options.typingIndicatorThrottle) {
            return;
        }
        this.mEndTypingLastSentAt = 0L;
        this.mStartTypingLastSentAt = System.currentTimeMillis();
        Command cmd = Command.bTypeStart(this.getUrl(), this.mStartTypingLastSentAt);
        SendBird.getInstance().sendCommand(cmd, true, null);
    }

    public void endTyping() {
        if (System.currentTimeMillis() - this.mEndTypingLastSentAt < (long)SendBird.Options.typingIndicatorThrottle) {
            return;
        }
        this.mStartTypingLastSentAt = 0L;
        this.mEndTypingLastSentAt = System.currentTimeMillis();
        Command cmd = Command.bTypeEnd(this.getUrl(), this.mEndTypingLastSentAt);
        SendBird.getInstance().sendCommand(cmd, true, null);
    }

    protected synchronized boolean invalidateTypingStatus() {
        boolean removed = false;
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Pair<Long, User>> entry : this.mCachedTypingStatus.entrySet()) {
            if (now - (Long)entry.getValue().first < 10000L) continue;
            this.mCachedTypingStatus.remove(entry.getKey());
            removed = true;
        }
        return removed;
    }

    protected synchronized boolean updateTypingStatus(User user, boolean start) {
        if (start) {
            this.mCachedTypingStatus.put(user.getUserId(), (Pair<Long, User>)new Pair((Object)System.currentTimeMillis(), (Object)user));
            return true;
        }
        return this.mCachedTypingStatus.remove(user.getUserId()) != null;
    }

    public boolean isTyping() {
        return this.mCachedTypingStatus.size() > 0;
    }

    public List<Member> getTypingMembers() {
        ArrayList<Member> result = new ArrayList<Member>();
        Enumeration<String> userIds = this.mCachedTypingStatus.keys();
        while (userIds.hasMoreElements()) {
            String userId = userIds.nextElement();
            Member user = this.mMemberMap.get(userId);
            if (user == null) continue;
            result.add(user);
        }
        return result;
    }

    public List<User> getTypingUsers() {
        ArrayList<User> result = new ArrayList<User>();
        Collection<Pair<Long, User>> values = this.mCachedTypingStatus.values();
        for (Pair<Long, User> value : values) {
            result.add((User)value.second);
        }
        return result;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public Member.MemberState getMyMemberState() {
        return this.mMyMemberState;
    }

    public Member.Role getMyRole() {
        return this.mMyRole;
    }

    void setMyRole(Member.Role role) {
        this.mMyRole = role;
    }

    public Member.MutedState getMyMutedState() {
        return this.mMyMutedState;
    }

    void setMyMutedState(Member.MutedState myMutedState) {
        this.mMyMutedState = myMutedState;
    }

    void setMyMemberState(Member.MemberState myMemberState) {
        this.mMyMemberState = myMemberState;
    }

    public int getMessageSurvivalSeconds() {
        return this.messageSurvivalSeconds;
    }

    protected synchronized void addMember(Member member, long timestamp) {
        Member removedMember = this.removeMember(member);
        if (removedMember != null && removedMember.getMemberState() == Member.MemberState.JOINED) {
            member.setState(Member.MemberState.JOINED);
        }
        this.mMemberMap.put(member.getUserId(), member);
        this.mMembers.add(member);
        ++this.mMemberCount;
        this.updateReadReceipt(member.getUserId(), timestamp);
        this.updateDeliveryReceipt(member.getUserId(), timestamp);
    }

    protected synchronized Member removeMember(User user) {
        if (this.mMemberMap.containsKey(user.getUserId())) {
            Member removedMember = this.mMemberMap.remove(user.getUserId());
            this.mMembers.remove(removedMember);
            --this.mMemberCount;
            return removedMember;
        }
        return null;
    }

    protected synchronized void updateJoinedMemberCount() {
        int count = 0;
        for (Member member : this.mMembers) {
            if (member.getMemberState() != Member.MemberState.JOINED) continue;
            ++count;
        }
        this.mJoinedMemberCount = count;
    }

    synchronized void updateOperators(List<User> operators, long updateTs) {
        if (updateTs <= this.memberRoleUpdatedAt.get()) {
            return;
        }
        this.memberRoleUpdatedAt.set(updateTs);
        for (Member member : this.mMembers) {
            boolean operatorSet = false;
            for (User operator : operators) {
                if (!member.getUserId().equals(operator.getUserId())) continue;
                member.setRole(Member.Role.OPERATOR);
                operatorSet = true;
                break;
            }
            if (operatorSet) continue;
            member.setRole(Member.Role.NONE);
        }
    }

    void setMemberCount(JsonElement data, long ts) {
        if (this.mMemberCountUpdatedAt < ts) {
            if (data.getAsJsonObject().has("member_count")) {
                this.mMemberCount = data.getAsJsonObject().get("member_count").getAsInt();
            }
            if (data.getAsJsonObject().has("joined_member_count")) {
                this.mJoinedMemberCount = data.getAsJsonObject().get("joined_member_count").getAsInt();
            }
            this.mMemberCountUpdatedAt = ts;
        }
    }

    synchronized void updateMutedState(String userId, boolean isMuted) {
        User currentUser = SendBird.getCurrentUser();
        if (currentUser != null && currentUser.getUserId().equals(userId)) {
            this.setMyMutedState(isMuted ? Member.MutedState.MUTED : Member.MutedState.UNMUTED);
        }
        for (Member member : this.mMembers) {
            if (member == null || !member.getUserId().equals(userId)) continue;
            member.setMuted(isMuted);
            break;
        }
    }

    public BannedUserListQuery createBannedUserListQuery() {
        return new BannedUserListQuery(this);
    }

    public void banUser(User user, String description, int seconds, final GroupChannelBanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.banUserWithUserId(user.getUserId(), description, seconds, handler);
    }

    public void banUserWithUserId(String userId, String description, int seconds, final GroupChannelBanHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().banUser(false, this.getUrl(), userId, description, seconds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unbanUser(User user, final GroupChannelUnbanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unbanUserWithUserId(user.getUserId(), handler);
    }

    public void unbanUserWithUserId(String userId, final GroupChannelUnbanHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unbanUser(false, this.getUrl(), userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void muteUser(User user, final GroupChannelMuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localMuteUserWithUserId(user.getUserId(), null, null, handler);
    }

    public void muteUserWithUserId(String userId, GroupChannelMuteHandler handler) {
        this.localMuteUserWithUserId(userId, null, null, handler);
    }

    public void muteUser(User user, String description, int seconds, final GroupChannelMuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localMuteUserWithUserId(user.getUserId(), description, seconds, handler);
    }

    public void muteUserWithUserId(String userId, String description, int seconds, GroupChannelMuteHandler handler) {
        this.localMuteUserWithUserId(userId, description, seconds, handler);
    }

    private void localMuteUserWithUserId(String userId, String description, Integer seconds, final GroupChannelMuteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().muteUser(false, this.getUrl(), userId, description, seconds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unmuteUser(User user, final GroupChannelUnmuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unmuteUserWithUserId(user.getUserId(), handler);
    }

    public void unmuteUserWithUserId(String userId, final GroupChannelUnmuteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unmuteUser(false, this.getUrl(), userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void freeze(final GroupChannelFreezeHandler handler) {
        APIClient.getInstance().freezeGroupChannel(this.getUrl(), true, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.this.mFreeze = true;
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unfreeze(final GroupChannelUnfreezeHandler handler) {
        APIClient.getInstance().freezeGroupChannel(this.getUrl(), false, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.this.mFreeze = false;
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void registerScheduledUserMessage(ScheduledUserMessageParams params, final RegisterScheduledUserMessageHandler handler) {
        if (params == null || params.getScheduledString() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(null, new SendBirdException("Connection must be made before you send message.", 800101));
                    }
                });
            }
            return;
        }
        if (params.mMessage == null) {
            params.mMessage = "";
        }
        APIClient.getInstance().registerScheduledUserMessage(false, this.getUrl(), params.getScheduledString(), params.mMessage, params.mData, params.mCustomType, params.mMentionType, params.mMentionedUserIds, params.mPushNotificationDeliveryOption, params.mMetaArrays, params.mTargetLanguages, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (e != null) {
                            if (handler != null) {
                                handler.onRegistered(null, e);
                            }
                            return;
                        }
                        JsonObject responseObj = response.getAsJsonObject();
                        ScheduledUserMessage scheduledUserMessage = new ScheduledUserMessage((JsonElement)responseObj);
                        if (handler != null) {
                            handler.onRegistered(scheduledUserMessage, null);
                        }
                    }
                });
            }
        });
    }

    public void delete(final GroupChannelDeleteHandler handler) {
        final String channelUrl = this.getUrl();
        APIClient.getInstance().deleteChannel(false, channelUrl, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(e);
                    }
                    return;
                }
                GroupChannel.removeChannelFromCache(channelUrl);
                if (handler != null) {
                    handler.onResult(null);
                }
            }
        });
    }

    public User getCreator() {
        return this.createdBy;
    }

    @Override
    Member.Role getCurrentUserRole() {
        return this.getMyRole();
    }

    @Override
    public String toString() {
        return super.toString() + "\nGroupChannel{mCachedTypingStatus=" + this.mCachedTypingStatus + ", mCachedReadReceiptStatus=" + this.mCachedReadReceiptStatus + ", mCachedDeliveryReceipt=" + this.mCachedDeliveryReceipt + ", mIsSuper=" + this.mIsSuper + ", mIsPublic=" + this.mIsPublic + ", mIsDistinct=" + this.mIsDistinct + ", mIsDiscoverable=" + this.mIsDiscoverable + ", mUnreadMessageCount=" + this.mUnreadMessageCount + ", mUnreadMentionCount=" + this.mUnreadMentionCount + ", mMembers=" + this.mMembers + ", mMemberMap=" + this.mMemberMap + ", mLastMessage=" + this.mLastMessage + ", mInviter=" + this.mInviter + ", mMemberCount=" + this.mMemberCount + ", mJoinedMemberCount=" + this.mJoinedMemberCount + ", mInvitedAt=" + this.mInvitedAt + ", mStartTypingLastSentAt=" + this.mStartTypingLastSentAt + ", mEndTypingLastSentAt=" + this.mEndTypingLastSentAt + ", mMarkAsReadLastSentAt=" + this.mMarkAsReadLastSentAt + ", mMyLastRead=" + this.mMyLastRead + ", mMarkAsReadScheduled=" + this.mMarkAsReadScheduled + ", mMessageOffsetTimestamp=" + this.mMessageOffsetTimestamp + ", mCustomType='" + this.mCustomType + '\'' + ", mIsPushEnabled=" + this.mIsPushEnabled + ", mMyPushTriggerOption=" + (Object)((Object)this.mMyPushTriggerOption) + ", mMyCountPreference=" + (Object)((Object)this.mMyCountPreference) + ", mIsHidden=" + this.mIsHidden + ", mHiddenState=" + (Object)((Object)this.mHiddenState) + ", mIsAccessCodeRequired=" + this.mIsAccessCodeRequired + ", mMyMemberState=" + (Object)((Object)this.mMyMemberState) + ", mMyRole=" + (Object)((Object)this.mMyRole) + ", mMyMutedState=" + (Object)((Object)this.mMyMutedState) + ", rateLimitScheduler=" + this.rateLimitScheduler + ", isBroadcast=" + this.isBroadcast + ", mHasBeenUpdated=" + this.mHasBeenUpdated + ", mMemberCountUpdatedAt=" + this.mMemberCountUpdatedAt + ", messageSurvivalSeconds=" + this.messageSurvivalSeconds + ", createdBy=" + this.createdBy + '}';
    }

    public static int compareTo(GroupChannel c1, GroupChannel c2, GroupChannelListQuery.Order order) {
        switch (order) {
            case CHRONOLOGICAL: {
                if (c1.getCreatedAt() > c2.getCreatedAt()) {
                    return -1;
                }
                if (c1.getCreatedAt() < c2.getCreatedAt()) {
                    return 1;
                }
                return 0;
            }
            case LATEST_LAST_MESSAGE: {
                long createdAt2;
                long createdAt1;
                BaseMessage m1 = c1.getLastMessage();
                BaseMessage m2 = c2.getLastMessage();
                if (m1 != null && m2 != null) {
                    createdAt1 = m1.getCreatedAt();
                    createdAt2 = m2.getCreatedAt();
                } else if (m1 == null && m2 != null) {
                    createdAt1 = -1L;
                    createdAt2 = m2.getCreatedAt();
                } else if (m1 != null) {
                    createdAt1 = m1.getCreatedAt();
                    createdAt2 = -1L;
                } else {
                    createdAt1 = c1.getCreatedAt();
                    createdAt2 = c2.getCreatedAt();
                }
                if (createdAt1 > createdAt2) {
                    return -1;
                }
                if (createdAt1 < createdAt2) {
                    return 1;
                }
                return 0;
            }
            case CHANNEL_NAME_ALPHABETICAL: {
                return c1.getName().compareTo(c2.getName());
            }
        }
        return 0;
    }

    public static GroupChannel clone(GroupChannel channel) {
        return new GroupChannel(channel.toJson());
    }

    public static interface GroupChannelDeleteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface RegisterScheduledUserMessageHandler {
        public void onRegistered(ScheduledUserMessage var1, SendBirdException var2);
    }

    public static interface GroupChannelUnfreezeHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelFreezeHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelUnmuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelMuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelUnbanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelBanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelResetMyHistoryHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelSetMyCountPreferenceHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelGetMyPushTriggerOptionHandler {
        public void onResult(PushTriggerOption var1, SendBirdException var2);
    }

    public static interface GroupChannelSetMyPushTriggerOptionHandler {
        public void onResult(SendBirdException var1);
    }

    @Deprecated
    public static interface GroupChannelGetPushPreferenceHandler {
        @Deprecated
        public void onResult(boolean var1, SendBirdException var2);
    }

    public static interface GroupChannelSetPushPreferenceHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelChannelCountHandler {
        public void onResult(int var1, SendBirdException var2);
    }

    public static interface GroupChannelGetUnreadItemCountHandler {
        public void onResult(Map<UnreadItemKey, Integer> var1, SendBirdException var2);
    }

    public static interface GroupChannelTotalUnreadChannelCountHandler {
        public void onResult(int var1, SendBirdException var2);
    }

    public static interface GroupChannelTotalUnreadMessageCountHandler {
        public void onResult(int var1, SendBirdException var2);
    }

    public static interface GroupChannelGetHandler {
        public void onResult(GroupChannel var1, SendBirdException var2);
    }

    @Deprecated
    public static interface GroupChannelMarkAsReadHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelDeclineInvitationHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelAcceptInvitationHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelLeaveHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelInviteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelJoinHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelUnhideHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelHideHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelUpdateHandler {
        public void onResult(GroupChannel var1, SendBirdException var2);
    }

    public static interface GroupChannelCreateDistinctChannelIfNotExistHandler {
        public void onResult(GroupChannel var1, boolean var2, SendBirdException var3);
    }

    public static interface GroupChannelCreateHandler {
        public void onResult(GroupChannel var1, SendBirdException var2);
    }

    public static interface GroupChannelRefreshHandler {
        public void onResult(SendBirdException var1);
    }

    static class DeliveredReceiptData {
        private final long msgId;
        private final long createdAt;

        DeliveredReceiptData(long msgId, long createdAt) {
            this.msgId = msgId;
            this.createdAt = createdAt;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeliveredReceiptData that = (DeliveredReceiptData)o;
            return this.msgId == that.msgId && this.createdAt == that.createdAt;
        }

        public int hashCode() {
            return HashUtils.generateHashCode(this.msgId, this.createdAt);
        }

        static boolean isEquals(DeliveredReceiptData src, DeliveredReceiptData target) {
            return src != null && src.equals(target);
        }

        public String toString() {
            return "DeliveredReceiptData{msgId=" + this.msgId + ", createdAt=" + this.createdAt + '}';
        }
    }

    public static enum PushTriggerOption {
        ALL,
        OFF,
        MENTION_ONLY,
        DEFAULT;

    }

    public static enum HiddenState {
        UNHIDDEN,
        HIDDEN_ALLOW_AUTO_UNHIDE,
        HIDDEN_PREVENT_AUTO_UNHIDE;

    }

    public static enum CountPreference {
        ALL,
        UNREAD_MESSAGE_COUNT_ONLY,
        UNREAD_MENTION_COUNT_ONLY,
        OFF;

    }

    public static enum UnreadItemKey {
        GROUP_CHANNEL_UNREAD_MESSAGE_COUNT,
        GROUP_CHANNEL_UNREAD_MENTION_COUNT,
        GROUP_CHANNEL_INVITATION_COUNT,
        NONSUPER_UNREAD_MESSAGE_COUNT,
        SUPER_UNREAD_MESSAGE_COUNT,
        NONSUPER_UNREAD_MENTION_COUNT,
        SUPER_UNREAD_MENTION_COUNT,
        NONSUPER_INVITATION_COUNT,
        SUPER_INVITATION_COUNT;

    }

    @Deprecated
    public static enum MemberState {
        ALL,
        INVITED,
        INVITED_BY_FRIEND,
        INVITED_BY_NON_FRIEND,
        JOINED;

    }
}

