/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.push.RemoteMessage;
import com.sendbird.android.AbstractPushHandler;
import com.sendbird.android.OnPushTokenReceiveListener;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SendBirdPushHelper;
import com.sendbird.android.log.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SendBirdHmsPushHandler
extends AbstractPushHandler<RemoteMessage> {
    private final AtomicReference<String> pendingToken = new AtomicReference();
    private final ExecutorService tokenExecutorService = Executors.newSingleThreadExecutor();
    private volatile CountDownLatch waitLock;

    @Override
    void onTokenUpdated(String newToken) {
        this.pendingToken.set(newToken);
        if (this.waitLock != null) {
            this.waitLock.countDown();
        } else {
            SendBirdPushHelper.registerPushToken(newToken, this.isUniquePushToken(), null);
            this.onNewToken(newToken);
        }
    }

    @Override
    protected void onNewToken(String newToken) {
    }

    @Override
    protected abstract void onMessageReceived(Context var1, RemoteMessage var2);

    @Override
    protected boolean isUniquePushToken() {
        return false;
    }

    protected abstract Context getContext();

    @Override
    void getToken(final OnPushTokenReceiveListener listener) {
        Logger.d("getHmsPushToken context : " + this.getContext());
        if (this.getContext() == null || listener == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.pendingToken.get())) {
            listener.onReceived(this.pendingToken.get(), null);
            return;
        }
        String errorMessage = "getting HMS token is failed";
        this.tokenExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Context context = SendBirdHmsPushHandler.this.getContext().getApplicationContext();
                    String appId = AGConnectServicesConfig.fromContext((Context)context).getString("client/app_id");
                    String pushtoken = HmsInstanceId.getInstance((Context)context).getToken(appId, "HCM");
                    Logger.d("pushToken : " + pushtoken);
                    boolean isSuccess = true;
                    if (!TextUtils.isEmpty((CharSequence)pushtoken)) {
                        SendBirdHmsPushHandler.this.pendingToken.set(pushtoken);
                    } else {
                        SendBirdHmsPushHandler.this.waitLock = new CountDownLatch(1);
                        isSuccess = SendBirdHmsPushHandler.this.waitLock.await(5L, TimeUnit.SECONDS);
                        SendBirdHmsPushHandler.this.waitLock = null;
                    }
                    String retrievedToken = (String)SendBirdHmsPushHandler.this.pendingToken.get();
                    if (isSuccess && !TextUtils.isEmpty((CharSequence)retrievedToken)) {
                        listener.onReceived(retrievedToken, null);
                    } else {
                        Logger.i("getHmsPushToken failed", new Object[0]);
                        listener.onReceived(null, new SendBirdException("getting HMS token is failed", 800220));
                    }
                }
                catch (Exception e) {
                    Logger.i("getHmsPushToken failed, " + e, new Object[0]);
                    listener.onReceived(null, new SendBirdException("getting HMS token is failed", 800220));
                }
            }
        });
    }

    @Override
    JSONObject getPayload(RemoteMessage remoteMessage) throws JSONException {
        if (remoteMessage.getDataOfMap().containsKey("sendbird")) {
            return new JSONObject((String)remoteMessage.getDataOfMap().get("sendbird"));
        }
        return null;
    }

    @Override
    boolean isSendBirdMessage(RemoteMessage remoteMessage) {
        return remoteMessage.getDataOfMap().containsKey("sendbird");
    }

    @Override
    void registerPushToken(String token, boolean unique, SendBird.RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUserInternal(SendBird.PushTokenType.HMS, token, unique, true, handler);
    }

    @Override
    void unregisterPushToken(String token, SendBird.UnregisterPushTokenHandler handler) {
        SendBird.HMS.unregisterPushTokenForCurrentUser(token, handler);
    }
}

