/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Base64;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;

public class OGImage {
    private final String url;
    private final String secureUrl;
    private final String type;
    private final int width;
    private final int height;
    private final String alt;

    public String getUrl() {
        return this.url;
    }

    public String getSecureUrl() {
        return this.secureUrl;
    }

    public String getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getAlt() {
        return this.alt;
    }

    OGImage(JsonObject jsonObject) {
        this.url = jsonObject.has("url") ? jsonObject.get("url").getAsString() : null;
        this.secureUrl = jsonObject.has("secure_url") ? jsonObject.get("secure_url").getAsString() : null;
        this.type = jsonObject.has("type") ? jsonObject.get("type").getAsString() : null;
        this.width = jsonObject.has("width") ? jsonObject.get("width").getAsInt() : 0;
        this.height = jsonObject.has("height") ? jsonObject.get("height").getAsInt() : 0;
        this.alt = jsonObject.has("alt") ? jsonObject.get("alt").getAsString() : null;
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        if (this.url != null) {
            obj.addProperty("url", this.url);
        }
        if (this.secureUrl != null) {
            obj.addProperty("secure_url", this.secureUrl);
        }
        if (this.type != null) {
            obj.addProperty("type", this.type);
        }
        if (this.width != 0) {
            obj.addProperty("width", (Number)this.width);
        }
        if (this.height != 0) {
            obj.addProperty("height", (Number)this.height);
        }
        if (this.alt != null) {
            obj.addProperty("alt", this.alt);
        }
        return obj;
    }

    public static OGImage buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            return new OGImage(obj);
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(e);
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(e);
            return null;
        }
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.url, this.secureUrl, this.type, this.width, this.height, this.alt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OGImage)) {
            return false;
        }
        OGImage other = (OGImage)obj;
        return TextUtils.equals((CharSequence)this.url, (CharSequence)other.url) && TextUtils.equals((CharSequence)this.secureUrl, (CharSequence)other.secureUrl) && TextUtils.equals((CharSequence)this.type, (CharSequence)other.type) && this.width == other.width && this.height == other.height && TextUtils.equals((CharSequence)this.alt, (CharSequence)other.alt);
    }

    public String toString() {
        return "OGImage{url='" + this.url + '\'' + ", secureUrl='" + this.secureUrl + '\'' + ", type='" + this.type + '\'' + ", width=" + this.width + ", height=" + this.height + ", alt='" + this.alt + '\'' + '}';
    }
}

