/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android.tasks;

import com.sendbird.android.CancelableExecutorService;
import com.sendbird.android.tasks.JobResultTask;
import com.sendbird.android.tasks.JobTask;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public final class NewTaskQueue {
    private final ExecutorService executorService;

    public NewTaskQueue(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public <T> Future<T> addTask(JobTask<T> task) {
        if (!this.isEnable()) {
            throw new RuntimeException("Task has been terminated");
        }
        return this.executorService.submit(task.getCallable());
    }

    public <T> Future<T> addTask(JobResultTask<T> task) {
        if (!this.isEnable()) {
            throw new RuntimeException("Task has been terminated");
        }
        return this.executorService.submit(task.getCallable());
    }

    public void shutdown() {
        if (this.isEnable()) {
            this.executorService.shutdown();
        }
    }

    public List<Runnable> shutdownNow() {
        if (this.isEnable()) {
            return this.executorService.shutdownNow();
        }
        return Collections.emptyList();
    }

    public boolean isEnable() {
        return this.executorService != null && !this.executorService.isShutdown() && !this.executorService.isTerminated();
    }

    public void cancelAll() {
        this.cancelAll(false);
    }

    public void cancelAll(boolean mayInterruptIfRunning) {
        if (this.executorService instanceof CancelableExecutorService) {
            CancelableExecutorService service = (CancelableExecutorService)this.executorService;
            service.cancelAll(mayInterruptIfRunning);
        }
    }
}

