/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public class ReactionEvent {
    private long messageId;
    private final String key;
    private final String userId;
    private final ReactionEventAction operation;
    private final long updatedAt;

    ReactionEvent(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("msg_id")) {
            this.messageId = obj.get("msg_id").getAsLong();
        }
        this.key = obj.get("reaction").getAsString();
        this.userId = obj.get("user_id").getAsString();
        String operation = obj.get("operation").getAsString();
        this.operation = operation.equals("ADD") ? ReactionEventAction.ADD : ReactionEventAction.DELETE;
        this.updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("msg_id", (Number)this.messageId);
        if (this.key != null) {
            obj.addProperty("reaction", this.key);
        }
        if (this.userId != null) {
            obj.addProperty("user_id", this.userId);
        }
        if (this.operation == ReactionEventAction.ADD) {
            obj.addProperty("operation", "ADD");
        } else if (this.operation == ReactionEventAction.DELETE) {
            obj.addProperty("operation", "DELETE");
        }
        obj.addProperty("updated_at", (Number)this.updatedAt);
        return obj;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getKey() {
        return this.key;
    }

    public String getUserId() {
        return this.userId;
    }

    public ReactionEventAction getOperation() {
        return this.operation;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String toString() {
        return "ReactionEvent{messageId=" + this.messageId + ", key='" + this.key + '\'' + ", userId='" + this.userId + '\'' + ", operation=" + (Object)((Object)this.operation) + ", updatedAt=" + this.updatedAt + '}';
    }

    public static enum ReactionEventAction {
        ADD,
        DELETE;

    }
}

