/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SocketManager;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import java.util.LinkedHashSet;
import java.util.Set;

public class ConnectionManager {
    private static final Set<ReadyHandler> sReadyHandlers = new LinkedHashSet<ReadyHandler>();

    static void init() {
        ConnectionManager.errorAllReadyHandlers(false);
    }

    static void ready(boolean isApiCall, ReadyHandler handler) {
        boolean hasSessionKey;
        Logger.d("[ConnectionManager] ready(isApiCall:" + isApiCall + ")");
        String sessionKey = APIClient.getInstance().getSessionKey();
        boolean bl = hasSessionKey = sessionKey != null && !sessionKey.isEmpty();
        if (isApiCall && hasSessionKey) {
            Logger.d("[ConnectionManager] ready() => isApiCall && hasSessionKey => true");
            if (handler != null) {
                handler.onReady(SendBird.getCurrentUser(), false, null);
                if (SendBird.getConnectionState() == SendBird.ConnectionState.CLOSED && !SendBird.isAppBackground()) {
                    Logger.d("++ call reconnect from connection manager");
                    SendBird.reconnect();
                }
            }
            return;
        }
        ConnectionManager.addReadyHandler(handler);
        if (SocketManager.getInstance().isReconnectFromError()) {
            Logger.d("[ConnectionManager] ready() => isReconnectingFromOnError() => true");
            ConnectionManager.errorAllReadyHandlers(false);
            return;
        }
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Logger.d("[ConnectionManager] ready() => SendBird.ConnectionState.OPEN");
            ConnectionManager.processAllReadyHandlers(false, null);
        } else if (SendBird.getConnectionState() == SendBird.ConnectionState.CONNECTING) {
            Logger.d("[ConnectionManager] ready() => SendBird.ConnectionState.CONNECTING");
        } else if (SendBird.getConnectionState() == SendBird.ConnectionState.CLOSED) {
            Logger.d("[ConnectionManager] ready() => SendBird.ConnectionState.CLOSED");
            ConnectionManager.errorAllReadyHandlers(false);
        } else {
            Logger.d("[ConnectionManager] ready() => ?");
            ConnectionManager.errorAllReadyHandlers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addReadyHandler(ReadyHandler handler) {
        if (handler != null) {
            Set<ReadyHandler> set = sReadyHandlers;
            synchronized (set) {
                sReadyHandlers.add(handler);
                Logger.d("[ConnectionManager] addReadyHandler() => size:" + sReadyHandlers.size());
            }
        }
    }

    static void errorAllReadyHandlers(boolean reconnected) {
        Logger.d("[ConnectionManager] errorAllReadyHandlers(reconnected:" + reconnected + ")");
        ConnectionManager.processAllReadyHandlers(reconnected, ConnectionManager.getConnectionRequiredException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processAllReadyHandlers(boolean reconnected, SendBirdException e) {
        Logger.d("[ConnectionManager] processAllReadyHandlers()");
        LinkedHashSet<ReadyHandler> tempReadyHandlers = null;
        Set<ReadyHandler> set = sReadyHandlers;
        synchronized (set) {
            if (sReadyHandlers.size() > 0) {
                tempReadyHandlers = new LinkedHashSet<ReadyHandler>(sReadyHandlers);
                sReadyHandlers.clear();
            }
        }
        if (tempReadyHandlers != null) {
            for (ReadyHandler handler : tempReadyHandlers) {
                if (handler == null) continue;
                Logger.d("[ConnectionManager] onReady(userId:" + (SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : "") + ", reconnected:" + reconnected + ", e:" + (e != null ? e.getMessage() : "") + ")");
                handler.onReady(SendBird.getCurrentUser(), reconnected, e);
            }
        }
    }

    static SendBirdException getConnectionRequiredException() {
        return new SendBirdException("Connection must be made.", 800101);
    }

    public static void authenticate(AuthInfoRequestHandler authInfoRequestHandler, AuthenticateHandler handler) {
        Logger.d("[ConnectionManager] authenticate()");
        SocketManager.getInstance().connectFromAuthenticate(authInfoRequestHandler, handler);
    }

    public static void addNetworkHandler(String identifier, NetworkHandler handler) {
        SocketManager.getInstance().addNetworkHandler(identifier, handler);
    }

    public static void removeNetworkHandler(String identifier) {
        SocketManager.getInstance().removeNetworkHandler(identifier);
    }

    public static void removeAllNetworkHandlers() {
        SocketManager.getInstance().removeAllNetworkHandlers();
    }

    public static abstract class NetworkHandler {
        public abstract void onReconnected();
    }

    public static interface AuthenticateHandler {
        public void onAuthenticated(User var1, SendBirdException var2);
    }

    public static interface AuthInfoRequester {
        public void setAuthInfo(String var1, String var2);

        public void setAuthInfoWithHostInfo(String var1, String var2, String var3, String var4);
    }

    public static interface AuthInfoRequestHandler {
        public void onAuthInfoRequest(AuthInfoRequester var1);
    }

    static interface ReadyHandler {
        public void onReady(User var1, boolean var2, SendBirdException var3);
    }
}

