/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonObject;

class ConnectionConfig {
    private static final float DEFAULT_INTERVAL = 3.0f;
    private static final float DEFAULT_MAX_INTERVAL = 24.0f;
    private static final int DEFAULT_MULTIPLIER = 2;
    private static final int DEFAULT_RETRY_CUONT = 5;
    private static final int DEFAULT_BACKGROUND_CONNECTION_DURATION_MS = 500;
    private static final int DEFAULT_PING_INTERVAL_MS = 15000;
    private static final int DEFAULT_PONG_TIMEOUT_MS = 5000;
    private static final int DEFAULT_UNREAD_COUNT_ON_SUPER_GROUP = 1;
    private final float baseInterval;
    private final float maxInterval;
    private final int multiplier;
    private final int maxRetryCount;
    private final int pingInterval;
    private final int pongTimeout;
    private final long lastConnectedAt;
    private long bcDuration;
    private final int maxUnreadCountOnSuperGroup;

    ConnectionConfig() {
        this.pingInterval = 15000;
        this.pongTimeout = 5000;
        this.lastConnectedAt = 0L;
        this.bcDuration = 500L;
        this.baseInterval = 3.0f;
        this.maxInterval = 24.0f;
        this.multiplier = 2;
        this.maxRetryCount = 5;
        this.maxUnreadCountOnSuperGroup = 1;
    }

    ConnectionConfig(JsonObject json) {
        this.pingInterval = json.has("ping_interval") ? json.get("ping_interval").getAsInt() * 1000 : 15000;
        this.pongTimeout = json.has("pong_timeout") && json.get("pong_timeout").isJsonPrimitive() ? json.get("pong_timeout").getAsInt() * 1000 : 5000;
        this.lastConnectedAt = json.has("login_ts") && json.get("login_ts").isJsonPrimitive() ? json.get("login_ts").getAsLong() : 0L;
        this.maxUnreadCountOnSuperGroup = json.has("max_unread_cnt_on_super_group") ? json.get("max_unread_cnt_on_super_group").getAsInt() : 1;
        long l = this.bcDuration = json.has("bc_duration") && json.get("bc_duration").isJsonPrimitive() ? (long)json.get("bc_duration").getAsInt() : 0L;
        if (this.bcDuration == 0L) {
            this.bcDuration = 500L;
        } else if (this.bcDuration > 0L) {
            this.bcDuration *= 1000L;
        }
        if (json.has("reconnect") && json.get("reconnect").isJsonObject()) {
            JsonObject reconnectObj = json.get("reconnect").getAsJsonObject();
            this.baseInterval = reconnectObj.has("interval") ? (float)Math.round(reconnectObj.get("interval").getAsFloat() * 10.0f) / 10.0f : 3.0f;
            this.maxInterval = reconnectObj.has("max_interval") ? reconnectObj.get("max_interval").getAsFloat() : 24.0f;
            this.multiplier = reconnectObj.has("mul") ? reconnectObj.get("mul").getAsInt() : 2;
            this.maxRetryCount = reconnectObj.has("retry_cnt") ? reconnectObj.get("retry_cnt").getAsInt() : 5;
        } else {
            this.baseInterval = 3.0f;
            this.maxInterval = 24.0f;
            this.multiplier = 2;
            this.maxRetryCount = 5;
        }
    }

    float getBackoffPeriod() {
        return this.multiplier;
    }

    float getBaseInterval() {
        return this.baseInterval;
    }

    float getMaxInterval() {
        return this.maxInterval;
    }

    int getMultiplier() {
        return this.multiplier;
    }

    int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    int getPingInterval() {
        return this.pingInterval;
    }

    int getPongTimeout() {
        return this.pongTimeout;
    }

    long getLastConnectedAt() {
        return this.lastConnectedAt;
    }

    long getBcDuration() {
        return this.bcDuration;
    }

    float getRetryDelayMillis(int retryCount) {
        return Math.min(retryCount == 0 ? 0.0f : this.maxInterval, this.baseInterval + (float)(retryCount * this.multiplier)) * 1000.0f;
    }

    public int getMaxUnreadCountOnSuperGroup() {
        return this.maxUnreadCountOnSuperGroup;
    }

    static int getDefaultBgConnectionDurationMs() {
        return 500;
    }

    public String toString() {
        return "ConnectionConfig{DEFAULT_INTERVAL=3.0, DEFAULT_MAX_INTERVAL=24.0, DEFAULT_MULTIPLIER=2, DEFAULT_RETRY_CUONT=5, baseInterval=" + this.baseInterval + ", maxInterval=" + this.maxInterval + ", multiplier=" + this.multiplier + ", maxRetryCount=" + this.maxRetryCount + ", pingInterval=" + this.pingInterval + ", pongTimeout=" + this.pongTimeout + ", lastConnectedAt=" + this.lastConnectedAt + ", maxUnreadCountOnSuperGroup=" + this.maxUnreadCountOnSuperGroup + ", bcDuration=" + this.bcDuration + '}';
    }
}

