/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.Command;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.TimeoutScheduler;
import com.sendbird.android.log.Logger;

class AckSession
implements TimeoutScheduler.TimeoutEventhandler {
    private final Command.SendCommandHandler handler;
    private final TimeoutScheduler scheduler;

    AckSession(long timeoutMillis, Command.SendCommandHandler handler) {
        this.handler = handler;
        this.scheduler = new TimeoutScheduler(timeoutMillis, this);
    }

    void ackReceived(Command resCommand, SendBirdException e) {
        this.scheduler.stop(true);
        this.sendResult(resCommand, e);
    }

    public void start() {
        this.scheduler.start();
    }

    @Override
    public void onTimeout(Object extra) {
        Logger.d(">> AckSession::onTimeout()");
        this.sendResult(null, new SendBirdException("Command received no ack.", 800180));
    }

    public void cancel() {
        this.scheduler.stop(true);
        this.sendResult(null, new SendBirdException("Request was interrupted before receiving ack from the server. Maybe the connection was closed.", 800180));
    }

    private void sendResult(final Command result, final SendBirdException e) {
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (AckSession.this.handler != null) {
                    AckSession.this.handler.onResult(result, e);
                }
            }
        });
    }
}

