/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class UnReadMessageCount {
    private int totalCount;
    private int totalCountByCustomTypes;
    private long timestamp;
    private Map<String, Integer> customTypeMap;

    UnReadMessageCount() {
        this.init();
    }

    void init() {
        this.totalCount = 0;
        this.totalCountByCustomTypes = 0;
        if (this.customTypeMap == null) {
            this.customTypeMap = new ConcurrentHashMap<String, Integer>();
        } else {
            this.customTypeMap.clear();
        }
        this.timestamp = 0L;
    }

    boolean update(JsonObject json) {
        boolean hasChanged = false;
        JsonObject unreadCntObj = json.getAsJsonObject("unread_cnt");
        if (unreadCntObj != null) {
            long ts;
            long l = ts = unreadCntObj.has("ts") ? unreadCntObj.get("ts").getAsLong() : 0L;
            if (ts > this.timestamp) {
                int newTotalCount;
                this.timestamp = ts;
                int n = newTotalCount = unreadCntObj.has("all") ? unreadCntObj.get("all").getAsInt() : this.totalCount;
                if (newTotalCount != this.totalCount) {
                    hasChanged = true;
                    this.totalCount = newTotalCount;
                }
                if (unreadCntObj.has("custom_types")) {
                    JsonObject customTypesObj = unreadCntObj.getAsJsonObject("custom_types");
                    for (Map.Entry entry : customTypesObj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        String key = (String)entry.getKey();
                        int newValue = ((JsonElement)entry.getValue()).getAsInt();
                        if (this.customTypeMap.containsKey(key) && this.customTypeMap.get(key) == newValue) continue;
                        hasChanged = true;
                        this.customTypeMap.put(key, newValue);
                    }
                    int newTotalCountByCustomTypes = 0;
                    for (Integer count : this.customTypeMap.values()) {
                        if (count == null) continue;
                        newTotalCountByCustomTypes += count.intValue();
                    }
                    if (newTotalCountByCustomTypes != this.totalCountByCustomTypes) {
                        hasChanged = true;
                        this.totalCountByCustomTypes = newTotalCountByCustomTypes;
                    }
                }
            }
        }
        return hasChanged;
    }

    int getTotalCount() {
        return this.totalCount;
    }

    int getTotalCountByCustomTypes() {
        return this.totalCountByCustomTypes;
    }

    int getCustomTypeUnreadMessageCount(String customType) {
        int result = 0;
        if (customType != null) {
            Integer count = this.customTypeMap.get(customType);
            result = count != null ? count : result;
        }
        return result;
    }

    public Map<String, Integer> getCustomTypeMap() {
        return this.customTypeMap;
    }
}

