/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.ChannelEvent;
import com.sendbird.android.ChannelEventCategory;
import com.sendbird.android.Command;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SendBirdPushHelper;
import com.sendbird.android.Sender;
import com.sendbird.android.ThreadInfoUpdateEvent;
import com.sendbird.android.TimeoutScheduler;
import com.sendbird.android.UnReadMessageCount;
import com.sendbird.android.User;
import com.sendbird.android.UserEvent;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

class ChannelManager {
    private final Map<String, SendBird.ChannelHandler> channelHandlers = new ConcurrentHashMap<String, SendBird.ChannelHandler>();
    private static TimeoutScheduler channelWatchdog;
    private final UnReadMessageCount unReadMessageCount = new UnReadMessageCount();

    private ChannelManager() {
    }

    public static ChannelManager getInstance() {
        return ChannelHolder.INSTANCE;
    }

    UnReadMessageCount getUnReadMessageCount() {
        return this.unReadMessageCount;
    }

    void addChannelHandler(String identifier, SendBird.ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        this.channelHandlers.put(identifier, handler);
    }

    SendBird.ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return this.channelHandlers.remove(identifier);
    }

    void removeAllChannelHandlers() {
        this.channelHandlers.clear();
    }

    void notifyAllChannelChanged(BaseChannel channel) {
        for (SendBird.ChannelHandler handler : this.channelHandlers.values()) {
            handler.onChannelChanged(channel);
        }
    }

    private void sendMACK(BaseMessage msg) {
        Sender sender = msg.mSender;
        User currentUser = SendBird.getCurrentUser();
        if (sender != null && currentUser != null && !sender.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
            SendBird.getInstance().sendCommand(Command.bMsgAck(msg.getChannelUrl(), msg.mMessageId), false, new Command.SendCommandHandler(){

                @Override
                public void onResult(Command acked, SendBirdException e) {
                    Logger.d("sendCommand(MACK) => " + (e != null ? e.getMessage() : "OK"));
                }
            });
        }
    }

    void processIncomingMessage(Command command, final BaseChannel channel, boolean cacheExisted) {
        final BaseMessage msg = BaseMessage.createMessage(command);
        if (msg == null) {
            return;
        }
        Logger.d("__ cacheExisted = %s", cacheExisted);
        if (msg.isGroupChannel()) {
            this.sendMACK(msg);
            User currentUser = SendBird.getCurrentUser();
            if (BaseMessage.belongsTo(msg, currentUser)) {
                currentUser.updatePropertiesByUser(msg.mSender);
            }
            this.processIncomingMessage((GroupChannel)channel, msg, !cacheExisted);
        } else {
            if (channel == null) {
                return;
            }
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                        if (OpenChannel.isEnteredChannel(channel.getUrl())) {
                            handler.onMessageReceived(channel, msg);
                        }
                        if (!msg.isMentionedFromSomeoneToMe()) continue;
                        handler.onMentionReceived(channel, msg);
                    }
                }
            });
        }
    }

    private void processIncomingMessage(final GroupChannel channel, final BaseMessage msg, boolean withoutCache) {
        Sender sender;
        if (channel == null) {
            return;
        }
        final AtomicBoolean callChannelChanged = new AtomicBoolean();
        if (withoutCache) {
            callChannelChanged.set(!msg.isSilent() || BaseMessage.belongsTo(msg, SendBird.getCurrentUser()));
            if (channel.isEphemeral() && callChannelChanged.get()) {
                channel.setLastMessageByCreatedAt(msg);
                if (!BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                    channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                }
                if (msg.isMentionedFromSomeoneToMe()) {
                    channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                }
            }
        } else {
            channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
            callChannelChanged.set(!(msg.isSilent() && !BaseMessage.belongsTo(msg, SendBird.getCurrentUser()) || !channel.mHasBeenUpdated && channel.getLastMessage() != null && channel.getLastMessage().getCreatedAt() >= msg.getCreatedAt()));
            if (callChannelChanged.get()) {
                channel.setLastMessageByCreatedAt(msg);
                if (!BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                    channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                }
                if (msg.isMentionedFromSomeoneToMe()) {
                    channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                }
                channel.mHasBeenUpdated = true;
            }
        }
        if (msg.shouldForceUpdateLastMessage()) {
            callChannelChanged.compareAndSet(false, channel.setLastMessageByCreatedAt(msg));
        }
        if ((sender = msg.mSender) != null && channel.mMemberMap.containsKey(sender.getUserId())) {
            Member member = channel.mMemberMap.get(sender.getUserId());
            member.updatePropertiesBySender(sender);
        }
        SendBirdPushHelper.messageDelivered(msg);
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                    handler.onMessageReceived(channel, msg);
                    Logger.d("__ callChannelChanged = %s", callChannelChanged.get());
                    if (callChannelChanged.get()) {
                        handler.onChannelChanged(channel);
                    }
                    if (!msg.isMentionedFromSomeoneToMe()) continue;
                    handler.onMentionReceived(channel, msg);
                }
            }
        });
    }

    void processUpdatedMessage(Command command, final BaseChannel baseChannel, boolean cacheExisted) {
        final BaseMessage msg = BaseMessage.createMessage(command);
        if (msg == null || baseChannel == null) {
            return;
        }
        if (baseChannel instanceof GroupChannel) {
            JsonObject payload;
            final GroupChannel channel = (GroupChannel)baseChannel;
            final AtomicBoolean mentionReceived = new AtomicBoolean();
            AtomicBoolean unreadMentionCountChanged = new AtomicBoolean();
            if (SendBird.getCurrentUser() != null && msg.getCreatedAt() > channel.getMyReadTs() && (payload = command.getJsonElement().getAsJsonObject()).has("old_values")) {
                boolean currentUserWasMentioned;
                BaseMessageParams.MentionType mentionType = msg.getMentionType();
                List<String> mentionedUserIds = msg.getMentionedUserIds();
                BaseMessageParams.MentionType oldMentionType = BaseMessageParams.MentionType.USERS;
                List<String> oldMentionedUserIds = null;
                JsonObject oldValuesObject = payload.get("old_values").getAsJsonObject();
                if (oldValuesObject.has("mention_type")) {
                    String oldMentionTypeString = oldValuesObject.get("mention_type").getAsString();
                    if (oldMentionTypeString.equals("users")) {
                        oldMentionType = BaseMessageParams.MentionType.USERS;
                    } else if (oldMentionTypeString.equals("channel")) {
                        oldMentionType = BaseMessageParams.MentionType.CHANNEL;
                    }
                } else {
                    oldMentionType = mentionType;
                }
                if (oldValuesObject.has("mentioned_user_ids")) {
                    JsonArray array = oldValuesObject.get("mentioned_user_ids").getAsJsonArray();
                    if (array != null) {
                        oldMentionedUserIds = new ArrayList<String>();
                        for (int i = 0; i < array.size(); ++i) {
                            oldMentionedUserIds.add(array.get(i).getAsString());
                        }
                    }
                } else {
                    oldMentionedUserIds = mentionedUserIds;
                }
                boolean bl = currentUserWasMentioned = oldMentionedUserIds != null && oldMentionedUserIds.contains(SendBird.getCurrentUser().getUserId());
                if (oldMentionType == BaseMessageParams.MentionType.USERS && !currentUserWasMentioned && msg.isMentionedFromSomeoneToMe()) {
                    if (cacheExisted && !msg.isSilent()) {
                        channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                    }
                    unreadMentionCountChanged.set(true);
                    mentionReceived.set(true);
                }
            }
            final AtomicBoolean callChannelChanged = new AtomicBoolean();
            if (!msg.isSilent() || BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                BaseMessage lastMessage = channel.getLastMessage();
                if (unreadMentionCountChanged.get()) {
                    callChannelChanged.set(true);
                } else if (lastMessage == null || lastMessage.getCreatedAt() < msg.getCreatedAt()) {
                    callChannelChanged.set(true);
                } else if (lastMessage.getCreatedAt() == msg.getCreatedAt()) {
                    callChannelChanged.set(lastMessage.getMessageId() == msg.getMessageId() && lastMessage.getUpdatedAt() < msg.getUpdatedAt());
                }
            }
            if (callChannelChanged.get()) {
                channel.setLastMessage(msg);
            }
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                        handler.onMessageUpdated(channel, msg);
                        if (callChannelChanged.get()) {
                            handler.onChannelChanged(channel);
                        }
                        if (!mentionReceived.get()) continue;
                        handler.onMentionReceived(channel, msg);
                    }
                }
            });
        } else {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                        handler.onMessageUpdated(baseChannel, msg);
                    }
                }
            });
        }
    }

    void processReaction(Command command, final BaseChannel channel) {
        if (channel == null) {
            return;
        }
        final ReactionEvent reactionEvent = new ReactionEvent(command.getJsonElement());
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                    handler.onReactionUpdated(channel, reactionEvent);
                }
            }
        });
    }

    void processRead(Command command, BaseChannel baseChannel, boolean cacheExisted) {
        boolean callChannelChanged;
        boolean readFromMyself;
        if (baseChannel == null) {
            return;
        }
        ReadStatus rst = new ReadStatus(command.getJsonElement());
        final GroupChannel channel = (GroupChannel)baseChannel;
        if (cacheExisted) {
            channel.updateReadReceipt(rst.getReader().getUserId(), rst.getTimestamp());
            boolean bl = readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
            if (readFromMyself && (channel.getUnreadMessageCount() > 0 || channel.getUnreadMentionCount() > 0)) {
                channel.setUnreadMessageCount(0);
                channel.setUnreadMentionCount(0);
                callChannelChanged = channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0;
            } else {
                callChannelChanged = false;
            }
        } else {
            readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
            callChannelChanged = readFromMyself && (channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0);
        }
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                    if (!readFromMyself) {
                        handler.onReadReceiptUpdated(channel);
                    }
                    if (!callChannelChanged) continue;
                    handler.onChannelChanged(channel);
                }
            }
        });
    }

    void processDeliveryReceipt(Command command, BaseChannel baseChannel, boolean cacheExisted) {
        if (baseChannel == null) {
            return;
        }
        JsonObject obj = command.getJsonElement().getAsJsonObject();
        final GroupChannel channel = (GroupChannel)baseChannel;
        Logger.d("++ hasChannelCached : " + cacheExisted);
        Logger.d("++ channel : " + channel);
        if (obj.has("updated")) {
            boolean isMyReceipt;
            User currentUser;
            JsonObject updatedReceiptObj = obj.get("updated").getAsJsonObject();
            Set updatedReceiptEntrySet = updatedReceiptObj.entrySet();
            if (cacheExisted) {
                for (Map.Entry entry : updatedReceiptEntrySet) {
                    channel.updateDeliveryReceipt((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
                }
            }
            if (!((currentUser = SendBird.getCurrentUser()) == null || (isMyReceipt = updatedReceiptObj.has(currentUser.getUserId())) && updatedReceiptEntrySet.size() <= 1)) {
                Logger.d("++ isMyReceipt : " + isMyReceipt + ", receipt size : " + updatedReceiptEntrySet.size());
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onDeliveryReceiptUpdated(channel);
                        }
                    }
                });
            }
        }
    }

    void processChannelEvent(Command cmd, final BaseChannel baseChannel) {
        if (baseChannel == null) {
            return;
        }
        final ChannelEvent event = new ChannelEvent(cmd.getJsonElement());
        User currentUser = SendBird.getCurrentUser();
        switch (event.getCategory()) {
            case CHANNEL_INVITE: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                if (channel.isSuper()) {
                    channel.setMemberCount(event.getData(), event.getTs());
                }
                final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                final ArrayList<Member> invitees = new ArrayList<Member>();
                JsonArray inviteesArray = event.getData().getAsJsonObject().get("invitees").getAsJsonArray();
                for (JsonElement inviteeEl : inviteesArray) {
                    JsonObject inviteeObj = inviteeEl.getAsJsonObject();
                    String userId = inviteeObj.get("user_id").getAsString();
                    Member inviteeInCache = channel.mMemberMap.get(userId);
                    if (currentUser != null && currentUser.getUserId().equals(userId)) {
                        channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
                        if (channel.getMyMemberState() != Member.MemberState.JOINED) {
                            channel.setMyMemberState(Member.MemberState.INVITED);
                        }
                        if (event.getData().getAsJsonObject().has("invited_at")) {
                            channel.setInvitedAt(event.getData().getAsJsonObject().get("invited_at").getAsLong());
                        }
                    }
                    if (inviteeInCache == null) {
                        inviteeObj.addProperty("state", "invited");
                        Member invitee = new Member((JsonElement)inviteeObj);
                        if (!channel.isSuper()) {
                            channel.addMember(invitee, event.getTs());
                        }
                        invitees.add(invitee);
                        continue;
                    }
                    invitees.add(inviteeInCache);
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onUserReceivedInvitation(channel, inviter, invitees);
                        }
                    }
                });
                break;
            }
            case CHANNEL_DECLINE_INVITE: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                JsonElement inviteeEl = event.getData().getAsJsonObject().get("invitee");
                final Member invitee = new Member(inviteeEl);
                if (channel.isSuper()) {
                    channel.setMemberCount(event.getData(), event.getTs());
                } else {
                    channel.removeMember(invitee);
                }
                if (currentUser != null && currentUser.getUserId().equals(invitee.getUserId())) {
                    channel.setMyMemberState(Member.MemberState.NONE);
                    channel.setInvitedAt(0L);
                    if (!channel.isPublic()) {
                        GroupChannel.removeChannelFromCache(channel.getUrl());
                    }
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onUserDeclinedInvitation(channel, inviter, invitee);
                        }
                    }
                });
                break;
            }
            case CHANNEL_JOIN: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                ArrayList<Member> members = new ArrayList<Member>();
                if (event.getData().getAsJsonObject().has("users")) {
                    JsonArray membersArray = event.getData().getAsJsonObject().get("users").getAsJsonArray();
                    for (int i = 0; i < membersArray.size(); ++i) {
                        members.add(new Member(membersArray.get(i)));
                    }
                } else {
                    members.add(new Member(event.getData()));
                }
                for (int i = 0; i < members.size(); ++i) {
                    final Member member = (Member)members.get(i);
                    if (channel.isSuper()) {
                        channel.setMemberCount(event.getData(), event.getTs());
                    } else {
                        channel.addMember(member, event.getTs());
                        channel.updateJoinedMemberCount();
                    }
                    if (currentUser != null && currentUser.getUserId().equals(member.getUserId())) {
                        channel.setMyMemberState(Member.MemberState.JOINED);
                    }
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                handler.onUserJoined(channel, member);
                            }
                        }
                    });
                }
                break;
            }
            case CHANNEL_LEAVE: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                final Member member = new Member(event.getData());
                if (channel.isSuper()) {
                    channel.setMemberCount(event.getData(), event.getTs());
                } else {
                    channel.removeMember(member);
                    channel.updateJoinedMemberCount();
                }
                if (currentUser != null && currentUser.getUserId().equals(member.getUserId())) {
                    channel.setMyMemberState(Member.MemberState.NONE);
                    channel.setUnreadMessageCount(0);
                    channel.setUnreadMentionCount(0);
                    channel.setInvitedAt(0L);
                    if (!channel.isPublic()) {
                        GroupChannel.removeChannelFromCache(channel.getUrl());
                    }
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onUserLeft(channel, member);
                        }
                    }
                });
                break;
            }
            case TYPING_START: 
            case TYPING_END: {
                final GroupChannel channel = (GroupChannel)baseChannel;
                User user = new User(event.getData());
                channel.updateTypingStatus(user, event.getCategory() == ChannelEventCategory.TYPING_START);
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onTypingStatusUpdated(channel);
                        }
                    }
                });
                break;
            }
            case CHANNEL_ENTER: 
            case CHANNEL_EXIT: {
                final OpenChannel channel = (OpenChannel)baseChannel;
                JsonObject obj = event.getData().getAsJsonObject();
                if (obj.has("participant_count")) {
                    channel.setParticipantCount(obj.get("participant_count").getAsInt());
                }
                final User user = new User(event.getData());
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.CHANNEL_ENTER) {
                                handler.onUserEntered(channel, user);
                                continue;
                            }
                            handler.onUserExited(channel, user);
                        }
                    }
                });
                break;
            }
            case USER_CHANNEL_MUTE: 
            case USER_CHANNEL_UNMUTE: {
                final User user = new User(event.getData());
                if (baseChannel instanceof GroupChannel && currentUser != null && currentUser.getUserId().equals(user.getUserId())) {
                    if (event.getCategory() == ChannelEventCategory.USER_CHANNEL_MUTE) {
                        ((GroupChannel)baseChannel).setMyMutedState(Member.MutedState.MUTED);
                    } else {
                        ((GroupChannel)baseChannel).setMyMutedState(Member.MutedState.UNMUTED);
                    }
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.USER_CHANNEL_MUTE) {
                                handler.onUserMuted(baseChannel, user);
                                continue;
                            }
                            handler.onUserUnmuted(baseChannel, user);
                        }
                    }
                });
                break;
            }
            case USER_CHANNEL_BAN: 
            case USER_CHANNEL_UNBAN: {
                final User user = new User(event.getData());
                if (event.getCategory() == ChannelEventCategory.USER_CHANNEL_BAN) {
                    if (baseChannel instanceof GroupChannel) {
                        GroupChannel channel = (GroupChannel)baseChannel;
                        if (channel.isSuper()) {
                            channel.setMemberCount(event.getData(), event.getTs());
                        } else {
                            channel.removeMember(user);
                            channel.updateJoinedMemberCount();
                        }
                        if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                            channel.setMyMemberState(Member.MemberState.NONE);
                            channel.setUnreadMessageCount(0);
                            channel.setUnreadMentionCount(0);
                            channel.setInvitedAt(0L);
                            if (!channel.isPublic()) {
                                GroupChannel.removeChannelFromCache(channel.getUrl());
                            }
                        }
                    } else if (currentUser != null && currentUser.getUserId().equals(user.getUserId())) {
                        OpenChannel.removeChannelFromEntered(event.getChannelUrl());
                    }
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.USER_CHANNEL_BAN) {
                                handler.onUserBanned(baseChannel, user);
                                continue;
                            }
                            handler.onUserUnbanned(baseChannel, user);
                        }
                    }
                });
                break;
            }
            case CHANNEL_FREEZE: 
            case CHANNEL_UNFREEZE: {
                JsonObject jsonObject = event.getData().getAsJsonObject();
                if (jsonObject.has("freeze")) {
                    baseChannel.setFreeze(jsonObject.get("freeze").getAsBoolean());
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            if (event.getCategory() == ChannelEventCategory.CHANNEL_FREEZE) {
                                handler.onChannelFrozen(baseChannel);
                                continue;
                            }
                            handler.onChannelUnfrozen(baseChannel);
                        }
                    }
                });
                break;
            }
            case CHANNEL_PROP_CHANGED: {
                GroupChannel channel;
                if (baseChannel instanceof GroupChannel && !(channel = (GroupChannel)baseChannel).isMyUnreadMentionCountEnabled()) {
                    channel.setUnreadMentionCount(0);
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onChannelChanged(baseChannel);
                        }
                    }
                });
                break;
            }
            case CHANNEL_DELETED: {
                if (baseChannel instanceof GroupChannel) {
                    GroupChannel.removeChannelFromCache(event.getChannelUrl());
                } else {
                    OpenChannel.removeChannelFromCache(event.getChannelUrl());
                    OpenChannel.removeChannelFromEntered(event.getChannelUrl());
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onChannelDeleted(event.getChannelUrl(), baseChannel instanceof GroupChannel ? BaseChannel.ChannelType.GROUP : BaseChannel.ChannelType.OPEN);
                        }
                    }
                });
                break;
            }
            case CHANNEL_META_DATA_CHANGED: 
            case CHANNEL_META_COUNTERS_CHANGED: {
                this.processChannelMetaDataAndCountersChangedEvent(baseChannel, event);
                break;
            }
            case CHANNEL_HIDDEN: {
                if (!(baseChannel instanceof GroupChannel)) break;
                final GroupChannel channel = (GroupChannel)baseChannel;
                JsonObject jsonObject = event.getData().getAsJsonObject();
                if (jsonObject.has("hide_previous_messages") && jsonObject.get("hide_previous_messages").getAsBoolean()) {
                    channel.setUnreadMessageCount(0);
                    channel.setUnreadMentionCount(0);
                    channel.parseMessageOffset((JsonElement)event.toJsonObject());
                }
                if (jsonObject.has("allow_auto_unhide")) {
                    boolean allowAutoUnhide = jsonObject.get("allow_auto_unhide").getAsBoolean();
                    if (allowAutoUnhide) {
                        channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
                    } else {
                        channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_PREVENT_AUTO_UNHIDE);
                    }
                } else {
                    channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onChannelHidden(channel);
                        }
                    }
                });
                break;
            }
            case CHANNEL_UNHIDDEN: {
                if (!(baseChannel instanceof GroupChannel)) break;
                final GroupChannel channel = (GroupChannel)baseChannel;
                channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                            handler.onChannelChanged(channel);
                        }
                    }
                });
                break;
            }
            case CHANNEL_OPERATOR_CHANGED: {
                this.handleChannelOperatorsChange(event, baseChannel);
            }
        }
    }

    private void handleChannelOperatorsChange(ChannelEvent event, final BaseChannel baseChannel) {
        JsonArray operatorsObjs;
        Logger.d(">> handleChannelOperatorsChange");
        JsonObject jsonObject = event.getData().getAsJsonObject();
        ArrayList<User> operators = new ArrayList<User>();
        JsonArray jsonArray = operatorsObjs = jsonObject.has("operators") ? jsonObject.get("operators").getAsJsonArray() : null;
        if (operatorsObjs == null) {
            return;
        }
        for (int i = 0; i < operatorsObjs.size(); ++i) {
            operators.add(new User(operatorsObjs.get(i)));
        }
        if (event.isGroupChannel()) {
            GroupChannel channel = (GroupChannel)baseChannel;
            User me = SendBird.getCurrentUser();
            if (me != null) {
                channel.setMyRole(operators.contains(me) ? Member.Role.OPERATOR : Member.Role.NONE);
            }
            channel.updateOperators(operators, event.getTs());
        } else {
            OpenChannel channel = (OpenChannel)baseChannel;
            channel.updateOperators(operators, event.getTs());
        }
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                    handler.onOperatorUpdated(baseChannel);
                }
            }
        });
    }

    private void processChannelMetaDataAndCountersChangedEvent(final BaseChannel channel, ChannelEvent event) {
        try {
            JsonObject jsonObject = event.getData().getAsJsonObject();
            if (event.getCategory() == ChannelEventCategory.CHANNEL_META_DATA_CHANGED) {
                JsonObject obj;
                Cloneable result;
                if (jsonObject.has("created")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("created");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                handler.onMetaDataCreated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("updated")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                handler.onMetaDataUpdated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("deleted")) {
                    result = new ArrayList();
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        result.add(array.get(i).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((List)((Object)result)){
                        final /* synthetic */ List val$result;
                        {
                            this.val$result = list;
                        }

                        @Override
                        public void run() {
                            for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                handler.onMetaDataDeleted(channel, this.val$result);
                            }
                        }
                    });
                }
            } else {
                JsonObject obj;
                Cloneable result;
                if (jsonObject.has("created")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("created");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                handler.onMetaCountersCreated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("updated")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                handler.onMetaCountersUpdated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("deleted")) {
                    result = new ArrayList();
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        result.add(array.get(i).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((List)((Object)result)){
                        final /* synthetic */ List val$result;
                        {
                            this.val$result = list;
                        }

                        @Override
                        public void run() {
                            for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                handler.onMetaCountersDeleted(channel, this.val$result);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void processUserEvent(Command cmd) {
        UserEvent event = new UserEvent(cmd.getJsonElement());
        User user = SendBird.getCurrentUser();
        switch (event.getCategory()) {
            case USER_UNBLOCK: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (user != null && user.getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(false);
                    }
                }
                if (user == null || !user.getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(false);
                }
                break;
            }
            case USER_BLOCK: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (user != null && user.getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(true);
                    }
                }
                if (user == null || !user.getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(true);
                }
                break;
            }
            case FRIEND_DISCOVERED: {
                if (event.getData() == null || !event.getData().getAsJsonObject().has("friend_discoveries")) break;
                JsonObject result = event.getData().getAsJsonObject();
                JsonArray usersArray = result.get("friend_discoveries").getAsJsonArray();
                final ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i < usersArray.size(); ++i) {
                    users.add(new User(usersArray.get(i)));
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<SendBird.UserEventHandler> userEventHandlers = new ArrayList<SendBird.UserEventHandler>(SendBird.getInstance().mUserEventHandlers.values());
                        for (SendBird.UserEventHandler handler : userEventHandlers) {
                            handler.onFriendsDiscovered(users);
                        }
                    }
                });
                break;
            }
        }
    }

    void processDeleteMessage(Command command, final BaseChannel channel) {
        if (channel == null) {
            return;
        }
        JsonObject obj = command.getJsonElement().getAsJsonObject();
        final long msgId = obj.get("msg_id").getAsLong();
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                    handler.onMessageDeleted(channel, msgId);
                }
            }
        });
    }

    void processSubscribedUnreadMessageCount(Command cmd) {
        boolean unreadCountChanged = false;
        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
        if (obj != null && obj.has("unread_cnt")) {
            unreadCountChanged = this.unReadMessageCount.update(obj);
        }
        if (unreadCountChanged) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    ArrayList<SendBird.UserEventHandler> userEventHandlers = new ArrayList<SendBird.UserEventHandler>(SendBird.getInstance().mUserEventHandlers.values());
                    for (SendBird.UserEventHandler handler : userEventHandlers) {
                        handler.onTotalUnreadMessageCountChanged(ChannelManager.this.unReadMessageCount.getTotalCount(), ChannelManager.this.unReadMessageCount.getCustomTypeMap());
                    }
                }
            });
        }
    }

    void processThreadInfoUpdateEvent(Command cmd, final BaseChannel channel) {
        if (channel == null) {
            return;
        }
        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
        final ThreadInfoUpdateEvent threadInfoUpdateEvent = new ThreadInfoUpdateEvent((JsonElement)obj);
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                    handler.onThreadInfoUpdated(channel, threadInfoUpdateEvent);
                }
            }
        });
    }

    void clearUnreadCount() {
        this.unReadMessageCount.init();
    }

    synchronized void startWatchdog() {
        if (channelWatchdog == null) {
            channelWatchdog = new TimeoutScheduler(1000L, true, new TimeoutScheduler.TimeoutEventhandler(){

                @Override
                public void onTimeout(Object extras) {
                    for (final GroupChannel channel : GroupChannel.sCachedChannels.values()) {
                        if (!channel.invalidateTypingStatus()) continue;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (SendBird.ChannelHandler handler : ChannelManager.this.channelHandlers.values()) {
                                    handler.onTypingStatusUpdated(channel);
                                }
                            }
                        });
                    }
                }
            }, null);
        }
        if (channelWatchdog.isRunning()) {
            channelWatchdog.restart();
        } else {
            channelWatchdog.start();
        }
    }

    void stopWatchdog() {
        if (channelWatchdog != null) {
            channelWatchdog.stop();
        }
    }

    static void tryToEnterEnteredOpenChannels() throws ExecutionException, InterruptedException {
        Collection<OpenChannel> enteredOpenChannels = OpenChannel.getEnteredChannels();
        if (enteredOpenChannels.size() > 0 && !SendBird.isAppBackground()) {
            ChannelManager.tryToEnterEnteredOpenChannels(enteredOpenChannels);
        }
    }

    private static void tryToEnterEnteredOpenChannels(Collection<OpenChannel> enteredOpenChannels) throws ExecutionException, InterruptedException {
        Logger.d("Enter open channels: " + enteredOpenChannels.size());
        ArrayList<String> openChannelUrlsOnError = new ArrayList<String>();
        for (OpenChannel channel : OpenChannel.getEnteredChannels()) {
            channel.enter(false, null).get();
            String channelUrl = channel.getUrl();
            if (channelUrl == null || channelUrl.length() <= 0) continue;
            openChannelUrlsOnError.add(channelUrl);
        }
        if (openChannelUrlsOnError.size() > 0) {
            for (String channelUrl : openChannelUrlsOnError) {
                OpenChannel.removeChannelFromEntered(channelUrl);
            }
        }
    }

    private static class ChannelHolder {
        private static final ChannelManager INSTANCE = new ChannelManager();

        private ChannelHolder() {
        }
    }
}

