/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.Command;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.utils.TimeoutLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class AckSession {
    private static final int CMD_ACK_TIMEOUT = 10000;
    private Command resCommand;
    private SendBirdException error;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final TimeoutLock lock;

    AckSession(long timeoutMillis) {
        this.lock = new TimeoutLock(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    void ackReceived(Command resCommand, SendBirdException e) {
        this.resCommand = resCommand;
        this.error = e;
        this.done();
    }

    boolean hasError() {
        return this.error != null;
    }

    SendBirdException getError() {
        return this.error;
    }

    public boolean isDone() {
        return this.done.get();
    }

    public Command get() throws InterruptedException, TimeoutLock.TimeoutException {
        this.lock.await();
        return this.resCommand;
    }

    private void done() {
        this.lock.release();
        this.done.set(true);
    }
}

