/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import com.sendbird.android.APIClient;
import com.sendbird.android.Command;
import com.sendbird.android.ConnectionManager;
import com.sendbird.android.CountDownTimer;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.Request;
import com.sendbird.android.shadow.okhttp3.Response;
import com.sendbird.android.shadow.okhttp3.WebSocket;
import com.sendbird.android.shadow.okhttp3.WebSocketListener;
import com.sendbird.android.shadow.okio.ByteString;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class WSClient {
    private WSClientHandler mHandler;
    private StringBuffer mRecvBuffer;
    private CountDownTimer mWatchdog;
    private CountDownTimer mPinger;
    private long mLastActiveMillis;
    private boolean mExplicitDisconnect;
    private Request mRequest;
    private ExecutorService mWriteExecutor;
    private OkHttpClient mOkHttpClient;
    private WebSocket mWebsocket;
    private boolean mIsSessionOpened = false;
    private boolean mIsDisconnected;
    private final Object mHandlerLock = new Object();
    private final Object mIsSessionOpenedLock = new Object();
    private final Object mIsDisconnectedLock = new Object();
    private int mPingIntervalMs = 15000;
    private static final int DEFAULT_WATCHDOG_TIMEOUT_MS = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSessionOpened(boolean isSessionOpened) {
        Object object = this.mIsSessionOpenedLock;
        synchronized (object) {
            this.mIsSessionOpened = isSessionOpened;
        }
    }

    public void setEventHandler(WSClientHandler handler) {
        this.mHandler = handler;
    }

    public WSClient() {
        this.mRecvBuffer = new StringBuffer();
        this.mWatchdog = new CountDownTimer(5000);
        this.mWatchdog.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
                Logger.d("Watchdog start.");
            }

            @Override
            public void onStop() {
                Logger.d("Watchdog stop.");
            }

            @Override
            public void onCancel() {
                Logger.d("Watchdog cancel.");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeout() {
                Logger.d("Watchdog timeout.");
                Object object = WSClient.this.mHandlerLock;
                synchronized (object) {
                    if (WSClient.this.mHandler != null) {
                        WSClient.this.mHandler.onError(new SendBirdException("Server is unreachable.", 800120));
                    }
                    WSClient.this.mHandler = null;
                }
                WSClient.this.quit();
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
        this.mPinger = new CountDownTimer(1000, 100, true);
        this.mPinger.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
                Logger.d("Pinger start.");
                WSClient.this.mWatchdog.stop();
                WSClient.this.sendPing(true);
            }

            @Override
            public void onStop() {
                Logger.d("Pinger stop.");
                WSClient.this.mWatchdog.stop();
            }

            @Override
            public void onCancel() {
                Logger.d("Pinger cancel.");
            }

            @Override
            public void onTimeout() {
                WSClient.this.sendPing(false);
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
    }

    void sendPing(final boolean forcedPing) {
        if (System.currentTimeMillis() - this.mLastActiveMillis >= (long)this.mPingIntervalMs || forcedPing) {
            this.mLastActiveMillis = System.currentTimeMillis();
            Logger.d("[WSClient] sendPing(forcedPing: " + forcedPing + ")");
            this.send(Command.bPing(), false, new WSClientSendHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    Logger.d("[WSClient] sendPing(forcedPing: " + forcedPing + ") => " + (e != null ? e.getMessage() : "OK"));
                }
            });
            this.mWatchdog.start();
        }
    }

    void initWebSocket(final String userId, final String accessToken) {
        APIClient.getInstance().checkRouting(new APIClient.CheckRouting.CheckRoutingHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block15: {
                    try {
                        if (e != null) {
                            if (WSClient.this.mHandler != null) {
                                WSClient.this.mHandler.onError(e);
                            }
                            return;
                        }
                        StringBuilder sb = new StringBuilder(wsHost);
                        sb.append("/?p=Android").append("&pv=").append(SendBird.getOSVersion()).append("&sv=").append(SendBird.getSDKVersion()).append("&ai=").append(SendBird.getApplicationId());
                        sb.append("&SB-User-Agent=").append(APIClient.UrlUtil.urlEncodeUTF8(SendBird.makeExUserAgentString()));
                        sb.append("&include_extra_data=").append(APIClient.UrlUtil.urlEncodeUTF8(SendBird.getAdditionalData()));
                        Logger.i("sessionkey : " + APIClient.getInstance().getSessionKey(), new Object[0]);
                        if (SendBird.getCurrentUser() == null || TextUtils.isEmpty((CharSequence)APIClient.getInstance().getSessionKey())) {
                            sb.append("&user_id=").append(APIClient.UrlUtil.urlEncodeUTF8(userId));
                            if (accessToken != null) {
                                sb.append("&access_token=").append(accessToken);
                            }
                        } else {
                            sb.append("&key=").append(APIClient.getInstance().getSessionKey());
                        }
                        if (SendBird.getInstance() != null) {
                            sb.append("&active=").append(SendBird.getInstance().isActive());
                        }
                        WSClient.this.mRequest = new Request.Builder().header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(sb.toString()).build();
                        Logger.d("WS request: " + sb.toString());
                        WSClient.this.mOkHttpClient = new OkHttpClient.Builder().connectTimeout((long)SendBird.Options.connectionTimeout, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
                        WSClient.this.mWriteExecutor = Executors.newSingleThreadExecutor();
                        if (WSClient.this.mHandler != null) {
                            boolean callReady = true;
                            Object object = WSClient.this.mIsDisconnectedLock;
                            synchronized (object) {
                                if (WSClient.this.mIsDisconnected) {
                                    callReady = false;
                                }
                            }
                            if (callReady) {
                                WSClient.this.mHandler.onReady();
                            } else {
                                WSClient.this.mHandler.onClose();
                            }
                        }
                        APIClient.getInstance().makeDummyCallToKeepConnectionAlive(apiHost);
                    }
                    catch (Exception e1) {
                        if (WSClient.this.mHandler == null) break block15;
                        WSClient.this.mHandler.onError(new SendBirdException(e1.getMessage(), 800120));
                    }
                }
            }
        });
    }

    void setPingIntervalMs(int pingIntervalMs) {
        this.mPingIntervalMs = pingIntervalMs;
    }

    void setWatchdogTimeoutMs(int watchdogTimeoutMs) {
        if (this.mWatchdog != null) {
            this.mWatchdog.setTimeout(watchdogTimeoutMs);
        }
    }

    void startPing() {
        if (this.mPinger != null) {
            this.mPinger.start();
        }
    }

    private void active() {
        this.mLastActiveMillis = System.currentTimeMillis();
        this.mWatchdog.stop();
    }

    public synchronized void connect() {
        if (this.mOkHttpClient != null) {
            this.mWebsocket = this.mOkHttpClient.newWebSocket(this.mRequest, new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    if (response.handshake() != null) {
                        Logger.d("WSClient onOpen. TLS version = " + response.handshake().tlsVersion().javaName());
                    }
                    WSClient.this.mWebsocket = webSocket;
                    if (WSClient.this.mHandler != null) {
                        WSClient.this.mHandler.onOpen();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    if (WSClient.this.mExplicitDisconnect) {
                        Object object = WSClient.this.mHandlerLock;
                        synchronized (object) {
                            if (WSClient.this.mHandler != null) {
                                WSClient.this.mHandler.onClose();
                            }
                            WSClient.this.mHandler = null;
                        }
                    }
                    WSClient.this.quit();
                    Object object = WSClient.this.mHandlerLock;
                    synchronized (object) {
                        if (WSClient.this.mHandler != null) {
                            WSClient.this.mHandler.onError(new SendBirdException(t.getMessage(), 800120));
                        }
                        WSClient.this.mHandler = null;
                    }
                }

                public void onMessage(WebSocket webSocket, String text) {
                    int nl;
                    WSClient.this.active();
                    WSClient.this.mRecvBuffer.append(text);
                    while ((nl = WSClient.this.mRecvBuffer.indexOf("\n")) >= 0) {
                        String message = WSClient.this.mRecvBuffer.substring(0, nl);
                        WSClient.this.mRecvBuffer.delete(0, nl + 1);
                        if (WSClient.this.mHandler == null) continue;
                        Logger.d("Recv: " + message);
                        WSClient.this.mHandler.onMessage(message);
                    }
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClosed(WebSocket webSocket, int code, String reason) {
                    if (WSClient.this.mExplicitDisconnect) {
                        Object object = WSClient.this.mHandlerLock;
                        synchronized (object) {
                            if (WSClient.this.mHandler != null) {
                                WSClient.this.mHandler.onClose();
                            }
                            WSClient.this.mHandler = null;
                        }
                    }
                    WSClient.this.quit();
                    Object object = WSClient.this.mHandlerLock;
                    synchronized (object) {
                        if (WSClient.this.mHandler != null) {
                            WSClient.this.mHandler.onError(new SendBirdException("WS connection closed by server. " + code, 800200));
                        }
                        WSClient.this.mHandler = null;
                    }
                }
            });
            this.mOkHttpClient.dispatcher().executorService().shutdown();
        }
    }

    public void disconnect() {
        this.mExplicitDisconnect = true;
        this.quit();
    }

    public SendBird.ConnectionState getConnectionState() {
        if (this.mOkHttpClient != null && this.mWebsocket != null && this.mIsSessionOpened) {
            return SendBird.ConnectionState.OPEN;
        }
        if (this.mOkHttpClient != null) {
            return SendBird.ConnectionState.CONNECTING;
        }
        return SendBird.ConnectionState.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void quit() {
        Logger.d("[WSClient] quit()");
        Object object = this.mIsDisconnectedLock;
        synchronized (object) {
            if (this.mIsDisconnected) {
                return;
            }
        }
        this.mPinger.stop();
        if (this.mWriteExecutor != null) {
            try {
                this.mWriteExecutor.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mWriteExecutor = null;
            }
        }
        if (this.mWebsocket != null) {
            this.mWebsocket.cancel();
        }
        try {
            if (this.mWebsocket != null) {
                this.mWebsocket.close(1000, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSessionOpened(false);
        this.mWebsocket = null;
        this.mOkHttpClient = null;
        object = this.mIsDisconnectedLock;
        synchronized (object) {
            this.mIsDisconnected = true;
        }
    }

    public void send(final Command command, boolean lazy, final WSClientSendHandler handler) {
        if (command == null) {
            Logger.d("Send(lazy:" + lazy + ") => (command == null)");
            return;
        }
        Logger.d("Send(lazy:" + lazy + "): " + command.encode());
        if (lazy) {
            ConnectionManager.ready(false, new ConnectionManager.ReadyHandler(){

                @Override
                public void onReady(User user, boolean reconnected, SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(e);
                        }
                        return;
                    }
                    WSClient.this.send(command, handler);
                }
            });
        } else {
            this.send(command, handler);
        }
    }

    private void send(final Command command, final WSClientSendHandler handler) {
        Logger.d("Send: " + command.encode());
        if (this.mOkHttpClient != null && this.mWebsocket != null && this.mWriteExecutor != null) {
            try {
                this.mWriteExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            if (WSClient.this.mWebsocket != null) {
                                try {
                                    WSClient.this.mWebsocket.send(command.encode());
                                    if (handler != null) {
                                        handler.onResult(null);
                                    }
                                }
                                catch (Exception e) {
                                    if (handler == null) break block4;
                                    handler.onResult(new SendBirdException(e.getMessage(), 800210));
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                if (handler != null) {
                    handler.onResult(new SendBirdException(e.getMessage(), 800120));
                }
            }
        } else if (handler != null) {
            handler.onResult(new SendBirdException("Connection closed.", 800200));
        }
    }

    public static interface WSClientSendHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface WSClientHandler {
        public void onReady();

        public void onOpen();

        public void onClose();

        public void onMessage(String var1);

        public void onError(SendBirdException var1);
    }
}

