/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.sendbird.android.APIClient;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.AppInfo;
import com.sendbird.android.ApplicationUserListQuery;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.BlockedUserListQuery;
import com.sendbird.android.ChannelEvent;
import com.sendbird.android.Command;
import com.sendbird.android.ConnectionManager;
import com.sendbird.android.CountDownTimer;
import com.sendbird.android.Emoji;
import com.sendbird.android.EmojiCategory;
import com.sendbird.android.EmojiContainer;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FriendListQuery;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelChangeLogsParams;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelTotalUnreadMessageCountParams;
import com.sendbird.android.IntRangeComparableUtils;
import com.sendbird.android.Member;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SendBirdPushHelper;
import com.sendbird.android.Sender;
import com.sendbird.android.ThreadInfoUpdateEvent;
import com.sendbird.android.User;
import com.sendbird.android.UserEvent;
import com.sendbird.android.UserListQuery;
import com.sendbird.android.UserMessage;
import com.sendbird.android.WSClient;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.conscrypt.Conscrypt;

public final class SendBird {
    static String CUSTOM_WS_HOST;
    static String CUSTOM_API_HOST;
    private static SendBird sInstance;
    private static final Handler sUIThreadHandler;
    private String mAppId;
    private final Context mAppContext;
    private String mPushToken;
    private WSClient mWSClient;
    private User mCurrentUser;
    private int mReconnectDelay = 0;
    private int mReconnectCount;
    private ReconnectParams mReconnectParams = new ReconnectParams();
    private AppInfo appInfo;
    private boolean mConnecting = false;
    private boolean mReconnecting = false;
    private boolean mReconnectingFromOnError = false;
    private boolean mReconnectStartedFromOnError = false;
    private boolean mIsAppBackgroundAndDisconnected = false;
    boolean mIsAppBackground = true;
    private static final int INITIAL_DELAY = 0;
    private CountDownTimer mReconnectTimer;
    private CountDownTimer mLoginTimer;
    private CountDownTimer mGlobalTimer;
    private SendBirdException mLoginException;
    private final Object mLoginTimerLock = new Object();
    private final Object mGlobalTimerLock = new Object();
    private final Object mReconnectTimerLock = new Object();
    private final Object mWSClientLock = new Object();
    private final Object mAckStateMapLock = new Object();
    private final Object mConnectingLock = new Object();
    private final Object mReconnectingLock = new Object();
    private final Map<String, HashMap<String, Object>> mAckStateMap = new HashMap<String, HashMap<String, Object>>();
    final Map<String, ChannelHandler> mChannelHandlers = new ConcurrentHashMap<String, ChannelHandler>();
    final Map<String, UserEventHandler> mUserEventHandlers = new ConcurrentHashMap<String, UserEventHandler>();
    private final Map<String, ConnectionHandler> mConnectionHandlers = new ConcurrentHashMap<String, ConnectionHandler>();
    private final Map<String, LocalNetworkHandler> mLocalNetworkHandlers = new ConcurrentHashMap<String, LocalNetworkHandler>();
    private final Set<ConnectHandler> mConnectHandlers = new LinkedHashSet<ConnectHandler>();
    private final Set<Timer> mAuthenticationTimers = new LinkedHashSet<Timer>();
    private ApplicationStateHandler mApplicationStateHandler;
    private boolean mIsTrackingApplicationState = true;
    private boolean mIsNetworkAwarenessReconnection = true;
    private static final int DEFAULT_BACKGROUND_CONNECTION_DURATION_MS = 500;
    private int mBackgroundConnectionDurationMs = 500;
    private ConnectivityManager mConnectivityManager;
    private NetworkReceiver mNetworkReceiver;
    private String mPrefApiHost;
    private String mPrefWsHost;
    private long mLastConnectedAt = 0L;
    private int maxUnreadCountOnSuperGroup = 1;
    private static Map<ExtentionFrom, String> exUserAgent;
    private static String ekey;
    private final SubscribedUnreadMessageCount mSubscribedUnreadMessageCount = new SubscribedUnreadMessageCount();
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;
    public static final String PUSH_TEMPLATE_DEFAULT = "default";
    public static final String PUSH_TEMPLATE_ALTERNATIVE = "alternative";

    public static void addExtension(String key, String version) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)version)) {
            return;
        }
        ExtentionFrom type = ExtentionFrom.from(key);
        if (type != ExtentionFrom.None) {
            exUserAgent.put(type, version);
        }
    }

    static String getAdditionalData() {
        StringBuilder builder = new StringBuilder();
        builder.append("premium_feature_list").append(",");
        builder.append("file_upload_size_limit").append(",");
        builder.append("application_attributes").append(",");
        builder.append("emoji_hash");
        Logger.i("additionalData : " + builder.toString(), new Object[0]);
        return builder.toString();
    }

    static String makeExUserAgentString() {
        StringBuilder userAgentBuilder = new StringBuilder("Android");
        userAgentBuilder.append("/").append(ExtentionFrom.Core.getValue("3.0.142"));
        for (ExtentionFrom extention : exUserAgent.keySet()) {
            String value = exUserAgent.get((Object)extention);
            userAgentBuilder.append("/").append(extention.getValue(value));
        }
        return userAgentBuilder.toString();
    }

    static int getMaxUnreadMessageCountOnSuperGroup() {
        return SendBird.getInstance().maxUnreadCountOnSuperGroup;
    }

    protected static void runOnUIThread(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        switch (Options.mThreadOption) {
            case UI_THREAD: {
                if (sUIThreadHandler == null) break;
                sUIThreadHandler.post(runnable);
                break;
            }
            case NEW_THREAD: {
                new Thread(){

                    @Override
                    public void run() {
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                }.start();
                break;
            }
            case HANDLER: {
                if (Options.mHandlerForThreadOption == null) break;
                Options.mHandlerForThreadOption.post(runnable);
                break;
            }
            default: {
                if (sUIThreadHandler == null) break;
                sUIThreadHandler.post(runnable);
            }
        }
    }

    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getSDKVersion() {
        return "3.0.142";
    }

    public static String getApplicationId() {
        return SendBird.getInstance().mAppId;
    }

    private boolean setNewApplicationId(String newAppId) {
        boolean result = false;
        if (SendBird.getConnectionState() == ConnectionState.CLOSED) {
            this.setAppId(newAppId, true);
            result = true;
        }
        return result;
    }

    public static void setLoggerLevel(int level) {
        Logger.setLoggerLevel(level);
    }

    private void setAppId(String appId, boolean resetHosts) {
        this.mAppId = appId;
        this.mPrefApiHost = "com.sendbird." + this.mAppId + ".PREF_API_HOST";
        this.mPrefWsHost = "com.sendbird." + this.mAppId + ".PREF_WS_HOST";
        if (resetHosts) {
            APIClient.getInstance().initCheckRouting();
        }
    }

    private SendBird(String appId, Context context) {
        this.setAppId(appId, false);
        this.mAppContext = context;
        if (context != null) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.mNetworkReceiver = new NetworkReceiver();
            context.registerReceiver((BroadcastReceiver)this.mNetworkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (Build.VERSION.SDK_INT >= 14 && context instanceof Application) {
            ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    if (SendBird.this.mApplicationStateHandler == null) {
                        return;
                    }
                    Logger.d("onActivityResumed: " + activity.getPackageName() + ":" + activity.getLocalClassName());
                    SendBird.this.mApplicationStateHandler.onActivityResumed();
                }

                public void onActivityPaused(Activity activity) {
                    if (SendBird.this.mApplicationStateHandler == null) {
                        return;
                    }
                    Logger.d("onActivityPaused: " + activity.getPackageName() + ":" + activity.getLocalClassName());
                    SendBird.this.mApplicationStateHandler.onActivityPaused();
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            });
        }
        SendBird.initConscrypt();
    }

    private static void initConscrypt() {
        try {
            Security.insertProviderAt(Conscrypt.newProvider(), 1);
        }
        catch (NoClassDefFoundError error) {
            System.out.println("[SendBird] To enable TLS 1.3, do not exclude conscrypt from your build.gradle");
            error.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("[SendBird] TLS 1.3 might be disabled for some unknown reason.");
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGlobalTimer() {
        SendBird I = SendBird.getInstance();
        Object object = I.mGlobalTimerLock;
        synchronized (object) {
            if (this.mGlobalTimer != null) {
                this.mGlobalTimer.cancel();
                this.mGlobalTimer = null;
            }
            this.mGlobalTimer = new CountDownTimer(1000, 100, true);
            this.mGlobalTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                long tickCount = 0L;

                @Override
                public void onStart() {
                }

                @Override
                public void onStop() {
                }

                @Override
                public void onCancel() {
                }

                @Override
                public void onTimeout() {
                }

                @Override
                public void onTick(int timeout, int elapsed) {
                    ++this.tickCount;
                    if (this.tickCount % 10L == 0L && GroupChannel.sCachedChannels != null) {
                        for (final GroupChannel channel : GroupChannel.sCachedChannels.values()) {
                            if (!channel.invalidateTypingStatus()) continue;
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onTypingStatusUpdated(channel);
                                    }
                                }
                            });
                        }
                    }
                    if (this.tickCount % 20L == 2L) {
                        // empty if block
                    }
                    if (this.tickCount % 50L == 2L) {
                        // empty if block
                    }
                }
            });
            this.mGlobalTimer.start();
        }
    }

    protected static SendBird getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    protected static synchronized boolean isInitialized() {
        return sInstance != null;
    }

    public static synchronized boolean init(String appId, Context context) {
        boolean result = true;
        if (sInstance == null) {
            sInstance = new SendBird(appId, context.getApplicationContext());
            ConnectionManager.init();
            APIClient.init(context.getApplicationContext());
        } else {
            if (appId != null && appId.length() > 0 && SendBird.getApplicationId() != null && appId.equals(SendBird.getApplicationId())) {
                return true;
            }
            result = sInstance.setNewApplicationId(appId);
            SendBird.disconnect(true, true, null);
        }
        if (SendBird.sInstance.mApplicationStateHandler != null) {
            SendBird.sInstance.mApplicationStateHandler.stop();
        }
        SendBird.sInstance.mIsTrackingApplicationState = true;
        SendBird.sInstance.mIsNetworkAwarenessReconnection = true;
        SendBird.sInstance.mApplicationStateHandler = new ApplicationStateHandler(){
            boolean tryConnect;
            Handler handler;
            ExecutorService singleThreadPool = Executors.newSingleThreadExecutor();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    handler = new Handler();
                    Looper.loop();
                }
            };
            Runnable disconnectRunnable = new Runnable(){

                @Override
                public void run() {
                    SendBird.setIsAppBackground(true);
                    if (SendBird.getConnectionState() != ConnectionState.CLOSED || sInstance.mReconnectCount > 0) {
                        SendBird.disconnect(false, true, null);
                        tryConnect = true;
                    } else {
                        tryConnect = false;
                    }
                    sInstance.mIsAppBackgroundAndDisconnected = true;
                }
            };

            @Override
            void start() {
                this.thread.start();
            }

            @Override
            void stop() {
                if (this.handler != null && this.handler.getLooper() != null) {
                    this.handler.getLooper().quit();
                }
                this.singleThreadPool.shutdownNow();
            }

            @Override
            public void onActivityResumed() {
                Logger.d("onActivityResumed");
                this.singleThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!SendBird.getAutoBackgroundDetection()) {
                            Logger.d("getAutoBackgroundDetection() : " + SendBird.getAutoBackgroundDetection());
                            return;
                        }
                        if (handler != null) {
                            handler.removeCallbacksAndMessages(null);
                        }
                        if (SendBird.setIsAppBackground(false)) {
                            sInstance.mIsAppBackgroundAndDisconnected = false;
                            if (SendBird.getConnectionState() == ConnectionState.CLOSED && tryConnect && sInstance.mCurrentUser != null) {
                                boolean callStart = sInstance.mReconnectCount == 0;
                                SendBird.disconnect(false, true, null);
                                SendBird.reconnectWS(sInstance.mCurrentUser.getUserId(), callStart, false);
                            } else if (SendBird.getConnectionState() == ConnectionState.OPEN && sInstance.mCurrentUser != null) {
                                Logger.d("Application goes foreground with connected status.");
                                Logger.d("sendCommand(UNRD)");
                                SendBird.getInstance().sendCommand(Command.bUnrd(), false, new Command.SendCommandHandler(){

                                    @Override
                                    public void onResult(Command acked, SendBirdException e) {
                                        Logger.d("sendCommand(UNRD) => " + (e != null ? e.getMessage() : "OK"));
                                    }
                                });
                                SendBird.reconnectStarted();
                                SendBird.reconnected();
                            }
                        }
                    }
                });
            }

            @Override
            public void onActivityPaused() {
                Logger.d("__onActivityPaused");
                this.singleThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!SendBird.getAutoBackgroundDetection() || handler == null) {
                            return;
                        }
                        handler.removeCallbacksAndMessages(null);
                        if (sInstance.mBackgroundConnectionDurationMs > 500) {
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    SendBird.setIsAppBackground(true);
                                }
                            }, 500L);
                        }
                        if (sInstance.mBackgroundConnectionDurationMs >= 0) {
                            handler.postDelayed(disconnectRunnable, (long)sInstance.mBackgroundConnectionDurationMs);
                        }
                    }
                });
            }
        };
        SendBird.sInstance.mApplicationStateHandler.start();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setIsAppBackground(boolean isAppBackground) {
        Logger.d("setIsAppBackground. current : " + SendBird.sInstance.mIsAppBackground + ", set : " + isAppBackground);
        if (SendBird.sInstance.mIsAppBackground != isAppBackground) {
            SendBird.sInstance.mIsAppBackground = isAppBackground;
            if (isAppBackground) {
                Logger.d("Application is on background.");
            } else {
                Logger.d("Application is on foreground.");
            }
            Object object = SendBird.sInstance.mWSClientLock;
            synchronized (object) {
                if (SendBird.sInstance.mWSClient != null) {
                    SendBird.sInstance.mWSClient.sendPing(true);
                }
            }
            return true;
        }
        return false;
    }

    static boolean isAppBackground() {
        return sInstance != null && SendBird.sInstance.mIsAppBackground;
    }

    int isActive() {
        return this.mIsAppBackground ? 0 : 1;
    }

    private void setBackgroundConnectionDurationSec(int backgroundConnectionDurationSec) {
        if (backgroundConnectionDurationSec == -1) {
            this.mBackgroundConnectionDurationMs = -1;
        } else if (backgroundConnectionDurationSec == 0) {
            this.mBackgroundConnectionDurationMs = 500;
        } else if (backgroundConnectionDurationSec > 0) {
            this.mBackgroundConnectionDurationMs = backgroundConnectionDurationSec * 1000;
        }
    }

    public static void notifyActivityResumedForOldAndroids() {
        if (Build.VERSION.SDK_INT >= 14 || SendBird.getInstance().mApplicationStateHandler == null) {
            return;
        }
        SendBird.getInstance().mApplicationStateHandler.onActivityResumed();
    }

    public static void notifyActivityPausedForOldAndroids() {
        if (Build.VERSION.SDK_INT >= 14 || SendBird.getInstance().mApplicationStateHandler == null) {
            return;
        }
        SendBird.getInstance().mApplicationStateHandler.onActivityPaused();
    }

    public static void setAutoBackgroundDetection(boolean enable) {
        SendBird.getInstance().mIsTrackingApplicationState = enable;
    }

    public static boolean getAutoBackgroundDetection() {
        return SendBird.getInstance().mIsTrackingApplicationState;
    }

    public static void setNetworkAwarenessReconnection(boolean enable) {
        SendBird.getInstance().mIsNetworkAwarenessReconnection = enable;
    }

    public static boolean getNetworkAwarenessReconnection() {
        return SendBird.getInstance().mIsNetworkAwarenessReconnection;
    }

    public static ConnectionState getConnectionState() {
        if (!SendBird.isInitialized()) {
            return ConnectionState.CLOSED;
        }
        try {
            if (SendBird.getInstance().mConnecting || SendBird.getInstance().mReconnecting) {
                return ConnectionState.CONNECTING;
            }
            if (SendBird.getInstance().mWSClient == null) {
                return ConnectionState.CLOSED;
            }
            return SendBird.getInstance().mWSClient.getConnectionState();
        }
        catch (RuntimeException e) {
            return ConnectionState.CLOSED;
        }
    }

    public static void connect(String userId, ConnectHandler handler) {
        SendBird._connect(userId, null, null, null, handler);
    }

    public static void connect(String userId, String accessToken, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, null, null, handler);
    }

    public static void connect(String userId, String accessToken, String apiHost, String wsHost, ConnectHandler handler) {
        SendBird._connect(userId, accessToken, apiHost, wsHost, handler);
    }

    private static void _connect(String userId, String accessToken, String apiHost, String wsHost, final ConnectHandler handler) {
        CUSTOM_API_HOST = apiHost;
        CUSTOM_WS_HOST = wsHost;
        if (userId == null || userId.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnected(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getConnectionState() == ConnectionState.OPEN && SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(userId)) {
            Logger.d("_connect() in ConnectionState.OPEN");
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnected(SendBird.getCurrentUser(), null);
                    }
                });
            }
        } else if (SendBird.getInstance().mConnecting && SendBird.getInstance().mConnectHandlers.size() > 0) {
            Logger.d("_connect() in mConnecting");
            SendBird.addConnectHandler(handler);
        } else {
            Logger.d("_connect() in ConnectionState.CLOSED or mReconnecting");
            SendBird.disconnect(false, true, null);
            SendBird.addConnectHandler(handler);
            User currentUser = SendBird.getCurrentUser();
            if (currentUser == null || !currentUser.getUserId().equals(userId)) {
                if (currentUser != null && !currentUser.getUserId().equals(userId)) {
                    SendBird.disconnect(true, true, null);
                }
                APIClient.getInstance().evictAllConnections();
                SendBird.connectWS(userId, accessToken, handler);
            } else {
                APIClient.getInstance().evictAllConnections();
                SendBird.connectWS(currentUser.getUserId(), null, handler);
            }
        }
    }

    public static synchronized boolean reconnect() {
        return SendBird.reconnect(false);
    }

    static boolean reconnect(boolean fromOnError) {
        if (SendBird.getCurrentUser() == null || TextUtils.isEmpty((CharSequence)APIClient.getInstance().getSessionKey())) {
            return false;
        }
        boolean callStart = SendBird.getInstance().mReconnectCount == 0;
        SendBird.disconnect(false, true, null);
        APIClient.getInstance().evictAllConnections();
        SendBird.reconnectWS(SendBird.getCurrentUser().getUserId(), callStart, fromOnError);
        return true;
    }

    public static void addChannelHandler(String identifier, ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mChannelHandlers.put(identifier, handler);
    }

    public static ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mChannelHandlers.remove(identifier);
    }

    public static void removeAllChannelHandlers() {
        SendBird.getInstance().mChannelHandlers.clear();
    }

    public static void addUserEventHandler(String identifier, UserEventHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mUserEventHandlers.put(identifier, handler);
    }

    public static UserEventHandler removeUserEventHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mUserEventHandlers.remove(identifier);
    }

    public static void removeAllUserEventHandlers() {
        SendBird.getInstance().mUserEventHandlers.clear();
    }

    public static void addConnectionHandler(String identifier, ConnectionHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mConnectionHandlers.put(identifier, handler);
    }

    public static ConnectionHandler removeConnectionHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mConnectionHandlers.remove(identifier);
    }

    public static void removeAllConnectionHandlers() {
        SendBird.getInstance().mConnectionHandlers.clear();
    }

    static void addLocalNetworkHandler(String identifier, LocalNetworkHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mLocalNetworkHandlers.put(identifier, handler);
    }

    static LocalNetworkHandler removeLocalNetworkHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mLocalNetworkHandlers.remove(identifier);
    }

    static void removeAllLocalNetworkHandlers() {
        SendBird.getInstance().mLocalNetworkHandlers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnected() {
        SendBird I = SendBird.getInstance();
        Collection<OpenChannel> enteredOpenChannels = OpenChannel.getEnteredChannels();
        Logger.d("[SendBird] reconnected()");
        if (enteredOpenChannels.size() > 0 && !SendBird.isAppBackground()) {
            AtomicBoolean errorOnEnter = SendBird.tryToEnterEnteredOpenChannels(enteredOpenChannels);
            if (errorOnEnter.get()) {
                Logger.d("Error on enter: true");
                SendBird.disconnect(false, false, null);
                SendBird.reconnectFailed();
                if (I.mReconnectingFromOnError) {
                    Object object = I.mReconnectingLock;
                    synchronized (object) {
                        I.mReconnectingFromOnError = false;
                    }
                }
                ConnectionManager.errorAllReadyHandlers(true);
                SendBird.reconnectFailedForNetworkHandler();
            } else {
                Logger.d("Error on enter: false");
                SendBird.reconnectSucceeded();
                if (I.mReconnectingFromOnError) {
                    Object object = I.mReconnectingLock;
                    synchronized (object) {
                        I.mReconnectingFromOnError = false;
                    }
                    SendBird.reconnectSucceededFromOnErrorForNetworkHandler();
                } else {
                    ConnectionManager.processAllReadyHandlers(true, null);
                }
            }
        } else {
            Logger.d("No open channels to enter.");
            SendBird.reconnectSucceeded();
            if (I.mReconnectingFromOnError) {
                Object object = I.mReconnectingLock;
                synchronized (object) {
                    I.mReconnectingFromOnError = false;
                }
                SendBird.reconnectSucceededFromOnErrorForNetworkHandler();
            } else {
                ConnectionManager.processAllReadyHandlers(true, null);
            }
        }
    }

    private static AtomicBoolean tryToEnterEnteredOpenChannels(Collection<OpenChannel> enteredOpenChannels) {
        AtomicBoolean errorOnEnter = new AtomicBoolean(false);
        Logger.d("Enter open channels: " + enteredOpenChannels.size());
        final CountDownLatch latch = new CountDownLatch(enteredOpenChannels.size());
        final ArrayList openChannelUrlsOnError = new ArrayList();
        for (final OpenChannel channel : OpenChannel.getEnteredChannels()) {
            channel.enter(false, new OpenChannel.OpenChannelEnterHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    if (e != null) {
                        Logger.d("enter() => error: " + e.getCode());
                        String channelUrl = channel.getUrl();
                        if (channelUrl != null && channelUrl.length() > 0) {
                            openChannelUrlsOnError.add(channelUrl);
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            errorOnEnter.set(true);
        }
        if (openChannelUrlsOnError.size() > 0) {
            for (String channelUrl : openChannelUrlsOnError) {
                OpenChannel.removeChannelFromEntered(channelUrl);
            }
        }
        return errorOnEnter;
    }

    private static void reconnectStarted() {
        final SendBird I = SendBird.getInstance();
        Logger.d("[SendBird] reconnectStarted()");
        if (I.mConnectionHandlers.size() > 0) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (!SendBird.isAppBackground()) {
                        for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                            if (handler == null) continue;
                            handler.onReconnectStarted();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectSucceeded() {
        final SendBird I = SendBird.getInstance();
        Logger.d("[SendBird] reconnectSucceeded()");
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnecting = false;
        }
        if (I.mConnectionHandlers.size() > 0) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (!SendBird.isAppBackground()) {
                        for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                            if (handler == null) continue;
                            handler.onReconnectSucceeded();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectFailed() {
        final SendBird I = SendBird.getInstance();
        Logger.d("[SendBird] reconnectFailed()");
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnecting = false;
        }
        if (I.mConnectionHandlers.size() > 0) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (!SendBird.isAppBackground()) {
                        for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                            if (handler == null) continue;
                            handler.onReconnectFailed();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReconnectingFromOnError() {
        boolean result;
        Object object = this.mReconnectingLock;
        synchronized (object) {
            result = this.mReconnectingFromOnError;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectStartedFromOnErrorForNetworkHandler() {
        final SendBird I = SendBird.getInstance();
        if (!I.mReconnectStartedFromOnError) {
            Object object = I.mReconnectingLock;
            synchronized (object) {
                I.mReconnectStartedFromOnError = true;
            }
            if (I.mLocalNetworkHandlers.size() > 0) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!SendBird.isAppBackground()) {
                            for (LocalNetworkHandler handler : I.mLocalNetworkHandlers.values()) {
                                if (handler == null) continue;
                                handler.onLocalUnexpectedDisconnect();
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectSucceededFromOnErrorForNetworkHandler() {
        final SendBird I = SendBird.getInstance();
        Logger.d("[SendBird] reconnectSucceededFromOnErrorForNetworkHandler()");
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnectStartedFromOnError = false;
        }
        if (I.mLocalNetworkHandlers.size() > 0) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (!SendBird.isAppBackground()) {
                        for (LocalNetworkHandler handler : I.mLocalNetworkHandlers.values()) {
                            if (handler == null) continue;
                            handler.onLocalReconnected();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconnectFailedForNetworkHandler() {
        final SendBird I = SendBird.getInstance();
        Logger.d("[SendBird] reconnectFailedForNetworkHandler()");
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnectStartedFromOnError = false;
        }
        if (I.mLocalNetworkHandlers.size() > 0) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (!SendBird.isAppBackground()) {
                        for (LocalNetworkHandler handler : I.mLocalNetworkHandlers.values()) {
                            if (handler == null) continue;
                            handler.onLocalReconnectFailed();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addConnectHandler(ConnectHandler handler) {
        if (handler != null) {
            SendBird I = SendBird.getInstance();
            Set<ConnectHandler> set = I.mConnectHandlers;
            synchronized (set) {
                I.mConnectHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAllConnectHandlers(final SendBirdException e) {
        LinkedHashSet<ConnectHandler> tempConnectHandlers;
        SendBird I = SendBird.getInstance();
        Set<ConnectHandler> set = I.mConnectHandlers;
        synchronized (set) {
            if (I.mConnectHandlers.size() > 0) {
                tempConnectHandlers = new LinkedHashSet<ConnectHandler>(I.mConnectHandlers);
                I.mConnectHandlers.clear();
            } else {
                tempConnectHandlers = null;
            }
        }
        if (tempConnectHandlers != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectHandler handler : tempConnectHandlers) {
                        if (e != null) {
                            handler.onConnected(null, e);
                            continue;
                        }
                        handler.onConnected(SendBird.getCurrentUser(), null);
                    }
                }
            });
        }
        ConnectionManager.processAllReadyHandlers(false, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void reconnectWS(final String userId, boolean callStart, boolean fromOnError) {
        final SendBird I = SendBird.getInstance();
        Object object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnecting = true;
            I.mReconnectingFromOnError = fromOnError;
        }
        I.mReconnectDelay = Math.min(I.mReconnectDelay, (int)(I.mReconnectParams.mMaxInterval * 1000.0f));
        ++I.mReconnectCount;
        if (I.mReconnectingFromOnError) {
            SendBird.reconnectStartedFromOnErrorForNetworkHandler();
        }
        if (I.mReconnectCount == 1 && callStart) {
            Logger.d("Reconnect Started.");
            SendBird.reconnectStarted();
        }
        if (I.mReconnectParams.mRetryCount < 0 || I.mReconnectCount <= I.mReconnectParams.mRetryCount) {
            object = I.mReconnectTimerLock;
            synchronized (object) {
                if (I.mReconnectTimer == null) {
                    I.mReconnectTimer = new CountDownTimer(I.mReconnectDelay, I.mReconnectDelay == 0 ? 0 : 1000);
                    I.mReconnectTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

                        @Override
                        public void onStart() {
                            Logger.d("ReconnectTimer start.");
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onStop() {
                            Object object = I.mReconnectTimerLock;
                            synchronized (object) {
                                I.mReconnectTimer = null;
                            }
                            Logger.d("ReconnectTimer stop.");
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onCancel() {
                            Object object = I.mReconnectTimerLock;
                            synchronized (object) {
                                I.mReconnectTimer = null;
                            }
                            Logger.d("ReconnectTimer cancel.");
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onTimeout() {
                            Object object = I.mReconnectTimerLock;
                            synchronized (object) {
                                I.mReconnectTimer = null;
                            }
                            Logger.d("ReconnectTimer timeout. Try to reconnect...");
                            object = I.mWSClientLock;
                            synchronized (object) {
                                if (I.mWSClient != null) {
                                    I.mWSClient.disconnect();
                                    I.mWSClient = null;
                                }
                                I.mWSClient = new WSClient();
                                I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){

                                    @Override
                                    public void onReady() {
                                        Logger.d("WS Ready.");
                                        if (I.mWSClient != null) {
                                            I.mWSClient.connect();
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onOpen() {
                                        Logger.d("WS Open.");
                                        Object object = I.mLoginTimerLock;
                                        synchronized (object) {
                                            this.startLoginTimer();
                                        }
                                    }

                                    private void startLoginTimer() {
                                        I.mLoginTimer = new CountDownTimer(Options.wsResponseTimeoutSec * 1000, 100);
                                        I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                                            private boolean timeout;

                                            @Override
                                            public void onStart() {
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void onStop() {
                                                Object object;
                                                if (this.timeout) {
                                                    Logger.d("Reconnect login timer failed.");
                                                    SendBird.disconnect(false, false, null);
                                                    SendBird.reconnectFailed();
                                                    object = I.mReconnectingLock;
                                                    synchronized (object) {
                                                        I.mReconnectingFromOnError = false;
                                                    }
                                                    ConnectionManager.errorAllReadyHandlers(true);
                                                    SendBird.reconnectFailedForNetworkHandler();
                                                } else {
                                                    Logger.d("Reconnect login timer succeeded.");
                                                    I.mReconnectDelay = 0;
                                                    I.mReconnectCount = 0;
                                                    SendBird.reconnected();
                                                }
                                                object = I.mLoginTimerLock;
                                                synchronized (object) {
                                                    I.mLoginTimer = null;
                                                }
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void onCancel() {
                                                Logger.d("Reconnect login timer canceled.");
                                                Object object = I.mLoginTimerLock;
                                                synchronized (object) {
                                                    I.mLoginTimer = null;
                                                }
                                            }

                                            @Override
                                            public void onTimeout() {
                                                this.timeout = true;
                                            }

                                            @Override
                                            public void onTick(int timeout, int elapsed) {
                                            }
                                        });
                                        I.mLoginTimer.start();
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onClose() {
                                        Logger.d("WS onClose.");
                                        Object object = I.mReconnectingLock;
                                        synchronized (object) {
                                            I.mReconnecting = false;
                                            I.mReconnectingFromOnError = false;
                                        }
                                    }

                                    @Override
                                    public void onMessage(String message) {
                                        Logger.d("WS onMessage: " + message);
                                        I.messageReceived(message);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onError(SendBirdException e) {
                                        Logger.d("WS onError.");
                                        Logger.d(e);
                                        Object object = I.mReconnectingLock;
                                        synchronized (object) {
                                            I.mReconnecting = false;
                                            I.mReconnectingFromOnError = false;
                                        }
                                        APIClient.getInstance().cancelAllRequests();
                                        APIClient.getInstance().evictAllConnections();
                                        ConnectionManager.errorAllReadyHandlers(true);
                                        SendBird.reconnectWS(userId, I.mReconnectCount == 0, true);
                                    }
                                });
                            }
                            try {
                                if (I.mWSClient != null) {
                                    I.mWSClient.initWebSocket(userId, null);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }

                        @Override
                        public void onTick(int timeout, int elapsed) {
                            Logger.d("ReconnectTimer Tick: " + (timeout - elapsed));
                        }
                    });
                    I.mReconnectTimer.start();
                } else {
                    Logger.d("Reconnecting is in progress.");
                }
            }
            I.mReconnectDelay = I.mReconnectDelay == 0 ? (int)(I.mReconnectParams.mInterval * 1000.0f) : (I.mReconnectDelay *= I.mReconnectParams.mMultiplier);
        } else {
            Logger.d("Reconnect Failed.");
            SendBird.disconnect(false, false, null);
            SendBird.reconnectFailed();
            object = I.mReconnectingLock;
            synchronized (object) {
                I.mReconnectingFromOnError = false;
            }
            ConnectionManager.errorAllReadyHandlers(true);
            SendBird.reconnectFailedForNetworkHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectWS(final String userId, String accessToken, ConnectHandler handler) {
        final SendBird I = SendBird.getInstance();
        Object object = I.mConnectingLock;
        synchronized (object) {
            I.mConnecting = true;
        }
        object = I.mWSClientLock;
        synchronized (object) {
            if (I.mWSClient != null) {
                I.mWSClient.disconnect();
                I.mWSClient = null;
            }
            I.mWSClient = new WSClient();
            I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){

                @Override
                public void onReady() {
                    Logger.d("WS Ready.");
                    if (I.mWSClient != null) {
                        I.mWSClient.connect();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onOpen() {
                    Logger.d("WS Open.");
                    Object object = I.mLoginTimerLock;
                    synchronized (object) {
                        I.mLoginTimer = new CountDownTimer(Options.wsResponseTimeoutSec * 1000, 100);
                        I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                            private boolean timeout;

                            @Override
                            public void onStart() {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onStop() {
                                int errCode;
                                String errMsg;
                                boolean loginException;
                                Object object = I.mLoginTimerLock;
                                synchronized (object) {
                                    boolean bl = loginException = I.mLoginException != null;
                                    if (loginException) {
                                        errMsg = I.mLoginException.getMessage();
                                        errCode = I.mLoginException.getCode();
                                    } else {
                                        errMsg = "";
                                        errCode = 0;
                                    }
                                }
                                if (this.timeout) {
                                    Logger.d("Connect login timer failed.");
                                    SendBird.disconnect(true, false, null);
                                    object = I.mConnectingLock;
                                    synchronized (object) {
                                        I.mConnecting = false;
                                    }
                                    SendBird.processAllConnectHandlers(new SendBirdException("Login timeout.", 800190));
                                } else if (loginException) {
                                    Logger.d("Connect login failed.");
                                    SendBird.disconnect(true, false, null);
                                    object = I.mConnectingLock;
                                    synchronized (object) {
                                        I.mConnecting = false;
                                    }
                                    SendBird.processAllConnectHandlers(new SendBirdException(errMsg, errCode));
                                } else {
                                    Logger.d("Connect login timer succeeded.");
                                    I.mReconnectDelay = 0;
                                    I.mReconnectCount = 0;
                                    I.startGlobalTimer();
                                    object = I.mConnectingLock;
                                    synchronized (object) {
                                        I.mConnecting = false;
                                    }
                                    SendBird.processAllConnectHandlers(null);
                                }
                                object = I.mLoginTimerLock;
                                synchronized (object) {
                                    I.mLoginTimer = null;
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onCancel() {
                                Logger.d("Connect login timer canceled.");
                                Object object = I.mLoginTimerLock;
                                synchronized (object) {
                                    I.mLoginTimer = null;
                                }
                            }

                            @Override
                            public void onTimeout() {
                                this.timeout = true;
                            }

                            @Override
                            public void onTick(int timeout, int elapsed) {
                            }
                        });
                        I.mLoginTimer.start();
                        I.mLoginException = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClose() {
                    Logger.d("WS Close.");
                    Object object = I.mConnectingLock;
                    synchronized (object) {
                        I.mConnecting = false;
                    }
                }

                @Override
                public void onMessage(String message) {
                    Logger.d("WS Received: " + message);
                    I.messageReceived(message);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(SendBirdException e) {
                    Logger.d("WS Error.");
                    Logger.d(e);
                    if (SendBird.getCurrentUser() == null) {
                        SendBird.disconnect(true, false, null);
                        Object object = I.mConnectingLock;
                        synchronized (object) {
                            I.mConnecting = false;
                        }
                        SendBird.processAllConnectHandlers(e);
                        return;
                    }
                    APIClient.getInstance().cancelAllRequests();
                    APIClient.getInstance().evictAllConnections();
                    SendBird.processAllConnectHandlers(e);
                    ConnectionManager.errorAllReadyHandlers(false);
                    SendBird.reconnectWS(userId, I.mReconnectCount == 0, true);
                }
            });
        }
        if (I.mWSClient != null) {
            I.mWSClient.initWebSocket(userId, accessToken);
        }
    }

    public static void disconnect(DisconnectHandler handler) {
        SendBird.disconnect(true, true, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void disconnect(boolean logout, boolean checkConnectionCanceled, final DisconnectHandler handler) {
        Logger.d("Disconnect.");
        SendBird I = SendBird.getInstance();
        if (checkConnectionCanceled && I.mWSClient != null && I.mWSClient.getConnectionState() == ConnectionState.CONNECTING) {
            SendBird.processAllConnectHandlers(new SendBirdException("Connection has been canceled.", 800102));
        }
        I.mReconnectDelay = 0;
        I.mReconnectCount = 0;
        Object object = I.mLoginTimerLock;
        synchronized (object) {
            if (I.mLoginTimer != null) {
                I.mLoginTimer.cancel();
                I.mLoginTimer = null;
            }
        }
        object = I.mReconnectTimerLock;
        synchronized (object) {
            if (I.mReconnectTimer != null) {
                I.mReconnectTimer.cancel();
                I.mReconnectTimer = null;
            }
        }
        object = I.mWSClientLock;
        synchronized (object) {
            if (I.mWSClient != null) {
                I.mWSClient.disconnect();
                I.mWSClient = null;
            }
        }
        object = I.mConnectingLock;
        synchronized (object) {
            I.mConnecting = false;
        }
        object = I.mReconnectingLock;
        synchronized (object) {
            I.mReconnecting = false;
            I.mReconnectingFromOnError = false;
        }
        if (logout) {
            Logger.d("Clear local data.");
            object = I.mGlobalTimerLock;
            synchronized (object) {
                if (I.mGlobalTimer != null) {
                    I.mGlobalTimer.cancel();
                    I.mGlobalTimer = null;
                }
            }
            object = I.mAckStateMapLock;
            synchronized (object) {
                for (HashMap<String, Object> map : I.mAckStateMap.values()) {
                    CountDownTimer timer = (CountDownTimer)map.get("timer");
                    if (timer == null) continue;
                    timer.cancel();
                }
                I.mAckStateMap.clear();
            }
            I.mSubscribedUnreadMessageCount.init();
            APIClient.getInstance().cancelAllRequests();
            APIClient.getInstance().clearKeys();
            ekey = "";
            OpenChannel.clearEnteredChannels();
            OpenChannel.clearCache();
            GroupChannel.clearCache();
            if (I.mCurrentUser != null) {
                I.mCurrentUser = null;
            }
            I.mLastConnectedAt = 0L;
        }
        if (handler != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    handler.onDisconnected();
                }
            });
        }
    }

    public static AppInfo getAppInfo() {
        return SendBird.getInstance().appInfo;
    }

    public static User getCurrentUser() {
        return SendBird.getInstance().mCurrentUser;
    }

    public static long getLastConnectedAt() {
        if (SendBird.getConnectionState() == ConnectionState.OPEN) {
            return SendBird.getInstance().mLastConnectedAt;
        }
        return 0L;
    }

    @Deprecated
    public static UserListQuery createUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.ALL_USER);
    }

    @Deprecated
    public static UserListQuery createUserListQuery(List<String> userIds) {
        return new UserListQuery(UserListQuery.QueryType.FILTERED_USER, userIds);
    }

    public static ApplicationUserListQuery createApplicationUserListQuery() {
        return new ApplicationUserListQuery();
    }

    public static BlockedUserListQuery createBlockedUserListQuery() {
        return new BlockedUserListQuery();
    }

    public static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfoWithProfileImage(nickname, profileImage, null, handler);
    }

    private static void updateCurrentUserInfoWithProfileImage(String nickname, File profileImage, List<String> discoveryKeys, final UserInfoUpdateHandler handler) {
        APIClient.getInstance().updateUserInfo(nickname, profileImage, discoveryKeys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                if (obj.has("require_auth_for_profile_image")) {
                    user.setRequireAuth(obj.get("require_auth_for_profile_image").getAsBoolean());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static void updateCurrentUserInfo(String nickname, String profileUrl, UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfo(nickname, profileUrl, null, null, handler);
    }

    public static void updateCurrentUserInfo(List<String> preferredLanguages, final UserInfoUpdateHandler handler) {
        if (preferredLanguages == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.updateCurrentUserInfo(null, null, null, preferredLanguages, handler);
    }

    private static void updateCurrentUserInfo(String nickname, String profileUrl, List<String> discoveryKeys, List<String> preferredLanguages, final UserInfoUpdateHandler handler) {
        APIClient.getInstance().updateUserInfo(nickname, profileUrl, discoveryKeys, preferredLanguages, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                User user = SendBird.getCurrentUser();
                if (obj.has("nickname")) {
                    user.setNickname(obj.get("nickname").getAsString());
                }
                if (obj.has("profile_url")) {
                    user.setProfileUrl(obj.get("profile_url").getAsString());
                }
                user.parsePreferredLanguages(obj);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static String getPendingPushToken() {
        return SendBird.getInstance().mPushToken;
    }

    @Deprecated
    public static void registerPushTokenForCurrentUser(String gcmRegToken, final RegisterPushTokenHandler handler) {
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(PushTokenType.GCM, gcmRegToken, false, false, false, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(gcmRegToken, false, handler);
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, boolean unique, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(PushTokenType.GCM, gcmRegToken, unique, false, false, handler);
    }

    static void registerPushTokenForCurrentUserInternal(PushTokenType type, String token, boolean unique, boolean alwaysPushOn, RegisterPushTokenWithStatusHandler handler) {
        SendBird.registerPushTokenForCurrentUser(type, token, unique, alwaysPushOn, true, handler);
    }

    static void registerPushTokenForCurrentUser(PushTokenType type, String token, boolean unique, boolean alwaysPushOn, boolean isInternal, final RegisterPushTokenWithStatusHandler handler) {
        if (token == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.ERROR, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            SendBird.getInstance().mPushToken = token;
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(PushTokenRegistrationStatus.PENDING, null);
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(type, token, unique, alwaysPushOn, isInternal, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(PushTokenRegistrationStatus.ERROR, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.getInstance().mPushToken = null;
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(PushTokenRegistrationStatus.SUCCESS, null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenForCurrentUser(String gcmRegToken, UnregisterPushTokenHandler handler) {
        SendBird.unregisterPushTokenForCurrentUser(PushTokenType.GCM, gcmRegToken, handler);
    }

    static void unregisterPushTokenForCurrentUser(PushTokenType type, String token, final UnregisterPushTokenHandler handler) {
        if (token == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unregisterPushToken(type, token, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenAllForCurrentUser(final UnregisterPushTokenHandler handler) {
        APIClient.getInstance().unregisterPushTokenAll(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void getMyPushTokensByToken(String token, PushTokenType type, final GetPushTokensHandler handler) {
        if (type == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getMyPushTokens(token, type, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                final PushTokenType pushTokenType = result.has("type") ? PushTokenType.from(result.get("type").getAsString()) : PushTokenType.GCM;
                final String token = result.has("token") ? result.get("token").getAsString() : "";
                final boolean hasMore = result.has("has_more") && result.get("has_more").getAsBoolean();
                final ArrayList<String> pushTokens = new ArrayList<String>();
                JsonArray deviceTokenArray = result.get("device_tokens").getAsJsonArray();
                for (int i = 0; i < deviceTokenArray.size(); ++i) {
                    pushTokens.add(deviceTokenArray.get(i).getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(pushTokens, pushTokenType, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public static void setDoNotDisturb(boolean doNotDisturbOn, int startHour, int startMin, int endHour, int endMin, String timezone, final SetDoNotDisturbHandler handler) {
        if (startHour < 0 || startHour > 23 || startMin < 0 || startMin > 59 || endHour < 0 || endHour > 23 || endMin < 0 || endMin > 59) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setDoNotDisturb(doNotDisturbOn, startHour, startMin, endHour, endMin, timezone, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getDoNotDisturb(final GetDoNotDisturbHandler handler) {
        APIClient.getInstance().getDoNotDisturb(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, 0, 0, 0, 0, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final boolean isDisturbOn = obj.get("do_not_disturb").getAsBoolean();
                final int startHour = obj.get("start_hour").getAsInt();
                final int startMin = obj.get("start_min").getAsInt();
                final int endHour = obj.get("end_hour").getAsInt();
                final int endMin = obj.get("end_min").getAsInt();
                final String timezone = obj.get("timezone").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isDisturbOn, startHour, startMin, endHour, endMin, timezone, null);
                        }
                    });
                }
            }
        });
    }

    public static void setSnoozePeriod(boolean snoozeOn, long startTs, long endTs, final SetSnoozePeriodHandler handler) {
        if (startTs >= endTs) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setSnoozePeriod(snoozeOn, startTs, endTs, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getSnoozePeriod(final GetSnoozePeriodHandler handler) {
        APIClient.getInstance().getSnoozePeriod(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                boolean isSnoozeOn;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, 0L, 0L, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                String strStartTs = obj.has("snooze_start_ts") && !obj.get("snooze_start_ts").isJsonNull() ? obj.get("snooze_start_ts").getAsString() : "";
                String strEndTs = obj.has("snooze_end_ts") && !obj.get("snooze_end_ts").isJsonNull() ? obj.get("snooze_end_ts").getAsString() : "";
                final long startTs = strStartTs.isEmpty() ? 0L : Long.valueOf(strStartTs);
                final long endTs = strEndTs.isEmpty() ? 0L : Long.valueOf(strEndTs);
                boolean bl = isSnoozeOn = obj.has("snooze_enabled") && !obj.get("snooze_enabled").isJsonNull() && obj.get("snooze_enabled").getAsBoolean();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(isSnoozeOn, startTs, endTs, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushSound(String sound, final SetPushSoundHandler handler) {
        if (sound == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setPushSound(sound, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getPushSound(final GetPushSoundHandler handler) {
        APIClient.getInstance().getPushSound(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                String sound;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                String string = sound = obj.has("push_sound") && !obj.get("push_sound").isJsonNull() ? obj.get("push_sound").getAsString() : "";
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(sound, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushTemplate(String templateName, final SetPushTemplateHandler handler) {
        if (templateName == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().setPushTemplate(templateName, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                handler.onResult(e);
                            } else {
                                handler.onResult(null);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void getPushTemplate(final GetPushTemplateHandler handler) {
        APIClient.getInstance().getPushTemplate(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final String name = response.getAsJsonObject().get("name").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(name, null);
                        }
                    });
                }
            }
        });
    }

    public static void setPushTriggerOption(PushTriggerOption pushTriggerOption, final SetPushTriggerOptionHandler handler) {
        APIClient.getInstance().setPushTriggerOption(pushTriggerOption, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getPushTriggerOption(final GetPushTriggerOptionHandler handler) {
        APIClient.getInstance().getPushTriggerOption(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                PushTriggerOption pushTriggerOption;
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                PushTriggerOption pushTriggerOption2 = pushTriggerOption = obj.has("push_trigger_option") ? PushTriggerOption.from(obj.get("push_trigger_option").getAsString()) : PushTriggerOption.ALL;
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(pushTriggerOption, null);
                        }
                    });
                }
            }
        });
    }

    public static void setChannelInvitationPreference(boolean autoAccept, final SetChannelInvitationPreferenceHandler handler) {
        APIClient.getInstance().setAutoAcceptInvitation(autoAccept, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getChannelInvitationPreference(final GetChannelInvitationPreferenceHandler handler) {
        APIClient.getInstance().getAutoAcceptInvitation(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(false, e);
                            }
                        });
                    }
                    return;
                }
                final boolean autoAccept = response.getAsJsonObject().get("auto_accept").getAsBoolean();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(autoAccept, null);
                        }
                    });
                }
            }
        });
    }

    public static void blockUser(User userToBlock, final UserBlockHandler handler) {
        if (userToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.blockUserWithUserId(userToBlock.getUserId(), handler);
    }

    public static void blockUserWithUserId(String userIdToBlock, final UserBlockHandler handler) {
        if (userIdToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().blockUser(userIdToBlock, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onBlocked(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onBlocked(new User(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void unblockUser(User blockedUser, final UserUnblockHandler handler) {
        if (blockedUser == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.unblockUserWithUserId(blockedUser.getUserId(), handler);
    }

    public static void unblockUserWithUserId(String blockedUserId, final UserUnblockHandler handler) {
        if (blockedUserId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unblockUser(blockedUserId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnblocked(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnblocked(null);
                        }
                    });
                }
            }
        });
    }

    public static void addFriends(List<String> userIds, final AddFriendsHandler handler) {
        if (userIds == null || userIds.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().addFriends(userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    JsonArray array;
                    JsonObject obj;
                    final ArrayList<User> users = new ArrayList<User>();
                    if (response != null && (obj = response.getAsJsonObject()) != null && obj.has("users") && (array = obj.getAsJsonArray("users")) != null) {
                        for (int i = 0; i < array.size(); ++i) {
                            users.add(new User(array.get(i)));
                        }
                    }
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(users, null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriends(List<String> userIds, final DeleteFriendsHandler handler) {
        if (userIds == null || userIds.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriends(userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriend(String userId, final DeleteFriendHandler handler) {
        if (userId == null || userId.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriend(userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void uploadFriendDiscoveries(Map<String, String> discoveryMap, final UploadFriendDiscoveriesHandler handler) {
        if (discoveryMap == null || discoveryMap.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().uploadFriendDiscoveries(discoveryMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriendDiscoveries(List<String> discoveryKeys, final DeleteFriendDiscoveriesHandler handler) {
        if (discoveryKeys == null || discoveryKeys.size() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriendDiscoveries(discoveryKeys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void deleteFriendDiscovery(String discoveryKey, final DeleteFriendDiscoveryHandler handler) {
        if (discoveryKey == null || discoveryKey.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteFriendDiscovery(discoveryKey, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void getFriendChangeLogsByToken(String token, final GetFriendChangeLogsByTokenHandler handler) {
        APIClient.getInstance().getFriendChangeLogsByToken(token, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                final ArrayList<User> updatedUsers = new ArrayList<User>();
                for (int i = 0; i < updatedJsonArray.size(); ++i) {
                    updatedUsers.add(new User(updatedJsonArray.get(i)));
                }
                JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                final ArrayList<String> deletedUserIds = new ArrayList<String>();
                for (int i = 0; i < deletedJsonArray.size(); ++i) {
                    deletedUserIds.add(deletedJsonArray.get(i).getAsString());
                }
                final boolean hasMore = result.get("has_more").getAsBoolean();
                final String token = result.get("next").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(updatedUsers, deletedUserIds, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public static FriendListQuery createFriendListQuery() {
        return new FriendListQuery();
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByToken(String token, List<String> customTypes, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(token, null, customTypes, true, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByTimestamp(long ts, List<String> customTypes, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(null, ts, customTypes, true, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByToken(String token, List<String> customTypes, boolean includeEmpty, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(token, null, customTypes, includeEmpty, true, handler);
    }

    @Deprecated
    public static void getMyGroupChannelChangeLogsByTimestamp(long ts, List<String> customTypes, boolean includeEmpty, GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogs(null, ts, customTypes, includeEmpty, true, handler);
    }

    public static void getMyGroupChannelChangeLogsByTokenWithParams(String token, GroupChannelChangeLogsParams params, final GetMyGroupChannelChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.getMyGroupChannelChangeLogs(token, null, params.customTypes, params.includeEmpty, params.includeFrozen, handler);
    }

    public static void getMyGroupChannelChangeLogsByTimestampWithParams(long ts, GroupChannelChangeLogsParams params, final GetMyGroupChannelChangeLogsHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.getMyGroupChannelChangeLogs(null, ts, params.customTypes, params.includeEmpty, params.includeFrozen, handler);
    }

    private static void getMyGroupChannelChangeLogs(String token, Long ts, List<String> customTypes, boolean includeEmpty, boolean includeFrozen, final GetMyGroupChannelChangeLogsHandler handler) {
        if (ts != null && ts < 0L) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, null, false, null, new SendBirdException("Invalid Arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (customTypes != null) {
            customTypes = new ArrayList<String>(new LinkedHashSet<String>(customTypes));
        }
        GroupChannelChangeLogsParams params = new GroupChannelChangeLogsParams(customTypes, includeEmpty, includeFrozen);
        APIClient.getInstance().getMyGroupChannelChangeLogs(token, ts, params, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, null, false, null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                JsonArray updatedJsonArray = result.get("updated").getAsJsonArray();
                final ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
                for (int i = 0; i < updatedJsonArray.size(); ++i) {
                    updatedChannels.add(GroupChannel.upsert(updatedJsonArray.get(i), false));
                }
                JsonArray deletedJsonArray = result.get("deleted").getAsJsonArray();
                final ArrayList<String> deletedChannelUrls = new ArrayList<String>();
                for (int i = 0; i < deletedJsonArray.size(); ++i) {
                    deletedChannelUrls.add(deletedJsonArray.get(i).getAsString());
                }
                final boolean hasMore = result.get("has_more").getAsBoolean();
                final String token = result.get("next").getAsString();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(updatedChannels, deletedChannelUrls, hasMore, token, null);
                        }
                    });
                }
            }
        });
    }

    public static void markAsDelivered(String channelUrl) {
        Logger.d(">> markAsDelivered()");
        GroupChannel.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

            @Override
            public void onResult(GroupChannel channel, SendBirdException e) {
                if (channel != null) {
                    channel.markAsDelivered();
                }
            }
        });
    }

    public static void markAsReadAll(MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadAll(null, handler);
    }

    public static void markAsReadWithChannelUrls(List<String> channelUrls, MarkAsReadHandler handler) {
        GroupChannel.localMarkAsReadWithChannelUrls(channelUrls, handler);
    }

    public static void getAllEmoji(final GetAllEmojiHandler handler) {
        APIClient.getInstance().getAllEmoji(new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(new EmojiContainer(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void getEmojiCategory(long emojiCategoryId, final GetEmojiCategoryHandler handler) {
        if (emojiCategoryId < 0L) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getEmojiCategory(emojiCategoryId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(new EmojiCategory(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void getEmoji(String key, final GetEmojiHandler handler) {
        if (key == null || key.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getEmoji(key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(new Emoji(response), null);
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(String message) {
        final Command cmd = new Command(message);
        Logger.d("messageReceived() => " + cmd.getRequestId() + ":" + cmd.getCommand() + ":" + cmd.getPayload());
        this.processSubscribedUnreadMessageCount(cmd);
        if (cmd.hasRequestId()) {
            HashMap<String, Object> ackInfo = this.getAckInfo(cmd.getRequestId());
            if (ackInfo == null) {
                return;
            }
            CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
            Command.SendCommandHandler handler = (Command.SendCommandHandler)ackInfo.get("handler");
            if (timer != null) {
                timer.stop();
            }
            if (handler != null) {
                switch (cmd.getCommand()) {
                    case "EROR": {
                        JsonObject error = cmd.getJsonElement().getAsJsonObject();
                        int errCode = error.get("code").getAsInt();
                        String errMessage = error.get("message").getAsString();
                        handler.onResult(cmd, new SendBirdException(errMessage, errCode));
                        break;
                    }
                    case "MESG": 
                    case "FILE": {
                        final BaseMessage msg = cmd.getCommand().equals("MESG") ? new UserMessage(cmd.getJsonElement()) : new FileMessage(cmd.getJsonElement());
                        Sender sender = msg.mSender;
                        msg.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                        if (sender != null && this.mCurrentUser != null && sender.getUserId().equals(this.mCurrentUser.getUserId())) {
                            this.mCurrentUser.updatePropertiesByUser(sender);
                        }
                        if (msg.isGroupChannel()) {
                            GroupChannel.getChannelInternal(msg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                                @Override
                                public void onResult(final GroupChannel channel, SendBirdException e) {
                                    if (e == null) {
                                        channel.setLastMessageByCreatedAt(msg);
                                        SendBird.runOnUIThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                                    handler.onChannelChanged(channel);
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                        handler.onResult(cmd, null);
                        break;
                    }
                    default: {
                        handler.onResult(cmd, null);
                    }
                }
            }
            return;
        }
        if (SendBird.isAppBackground() && !cmd.getCommand().equals("LOGI")) {
            Logger.d("[ignored] messageReceived() => " + cmd.getRequestId() + ":" + cmd.getCommand() + ":" + cmd.getPayload());
            return;
        }
        block39 : switch (cmd.getCommand()) {
            case "LOGI": {
                Object handler = this.mLoginTimerLock;
                synchronized (handler) {
                    if (this.mLoginTimer != null) {
                        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                        if (obj.getAsJsonObject().has("error") && obj.getAsJsonObject().get("error").isJsonPrimitive() && obj.getAsJsonObject().get("error").getAsBoolean()) {
                            String errMsg = "";
                            int errCode = 0;
                            if (obj.getAsJsonObject().has("message") && obj.getAsJsonObject().get("message").isJsonPrimitive()) {
                                errMsg = obj.getAsJsonObject().get("message").getAsString();
                            }
                            if (obj.getAsJsonObject().has("code") && obj.getAsJsonObject().get("code").isJsonPrimitive()) {
                                errCode = obj.getAsJsonObject().get("code").getAsInt();
                            }
                            this.mLoginException = new SendBirdException(errMsg, errCode);
                        } else {
                            Object errMsg;
                            if (obj.has("user_id")) {
                                SendBird.getInstance().mCurrentUser = new User(cmd.getJsonElement());
                            }
                            if (obj.has("key")) {
                                APIClient.getInstance().setSessionKey(obj.get("key").getAsString());
                            }
                            if (obj.has("ekey")) {
                                ekey = obj.get("ekey").getAsString();
                            }
                            if (obj.has("ping_interval") && obj.get("ping_interval").isJsonPrimitive()) {
                                errMsg = this.mWSClientLock;
                                synchronized (errMsg) {
                                    if (this.mWSClient != null) {
                                        int pingInterval = obj.get("ping_interval").getAsInt();
                                        Logger.d("[LOGI] ping_interval: " + pingInterval + "sec");
                                        this.mWSClient.setPingIntervalMs(pingInterval * 1000);
                                    }
                                }
                            }
                            if (obj.has("pong_timeout") && obj.get("pong_timeout").isJsonPrimitive()) {
                                errMsg = this.mWSClientLock;
                                synchronized (errMsg) {
                                    if (this.mWSClient != null) {
                                        int pongTimeout = obj.get("pong_timeout").getAsInt();
                                        Logger.d("[LOGI] pong_timeout: " + pongTimeout + "sec");
                                        this.mWSClient.setWatchdogTimeoutMs(pongTimeout * 1000);
                                    }
                                }
                            }
                            if (obj.has("login_ts") && obj.get("login_ts").isJsonPrimitive()) {
                                this.mLastConnectedAt = obj.get("login_ts").getAsLong();
                                Logger.d("[LOGI] login_ts: " + this.mLastConnectedAt + " (" + new Date(this.mLastConnectedAt).toString() + ")");
                            }
                            if (obj.has("reconnect") && obj.get("reconnect").isJsonObject()) {
                                JsonObject reconnectObj = obj.get("reconnect").getAsJsonObject();
                                float interval = reconnectObj.has("interval") ? reconnectObj.get("interval").getAsFloat() : 3.0f;
                                this.mReconnectParams.mInterval = (float)Math.round(interval * 10.0f) / 10.0f;
                                float maxInterval = reconnectObj.has("max_interval") ? reconnectObj.get("max_interval").getAsFloat() : 24.0f;
                                this.mReconnectParams.mMaxInterval = (float)Math.round(maxInterval * 10.0f) / 10.0f;
                                this.mReconnectParams.mMultiplier = reconnectObj.has("mul") ? reconnectObj.get("mul").getAsInt() : 2;
                                int n = this.mReconnectParams.mRetryCount = reconnectObj.has("retry_cnt") ? reconnectObj.get("retry_cnt").getAsInt() : 5;
                            }
                            if (obj.has("bc_duration") && obj.get("bc_duration").isJsonPrimitive()) {
                                int bcDuration = obj.get("bc_duration").getAsInt();
                                Logger.d("[LOGI] bc_duration: " + bcDuration);
                                this.setBackgroundConnectionDurationSec(bcDuration);
                            }
                            this.maxUnreadCountOnSuperGroup = obj.has("max_unread_cnt_on_super_group") ? obj.get("max_unread_cnt_on_super_group").getAsInt() : 1;
                            this.appInfo = new AppInfo(obj);
                            this.mLoginException = null;
                            Object bcDuration = this.mWSClientLock;
                            synchronized (bcDuration) {
                                if (this.mWSClient != null) {
                                    this.mWSClient.setSessionOpened(true);
                                    this.mWSClient.startPing();
                                }
                            }
                        }
                        this.mLoginTimer.stop();
                        SendBirdPushHelper.retryPendingAction();
                    }
                    break;
                }
            }
            case "MESG": 
            case "FILE": 
            case "BRDM": 
            case "ADMM": {
                BaseMessage msg;
                switch (cmd.getCommand()) {
                    case "MESG": {
                        msg = new UserMessage(cmd.getJsonElement());
                        msg.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                        break;
                    }
                    case "FILE": {
                        msg = new FileMessage(cmd.getJsonElement());
                        msg.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                        break;
                    }
                    case "BRDM": 
                    case "ADMM": {
                        msg = new AdminMessage(cmd.getJsonElement());
                        break;
                    }
                    default: {
                        Logger.d("Discard a command: " + cmd.getCommand());
                        return;
                    }
                }
                if (msg.isGroupChannel()) {
                    String channelUrl;
                    Sender sender = msg.getSender();
                    if (sender != null && !sender.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
                        SendBird.getInstance().sendCommand(Command.bMsgAck(msg.getChannelUrl(), msg.mMessageId), false, new Command.SendCommandHandler(){

                            @Override
                            public void onResult(Command acked, SendBirdException e) {
                                Logger.d("sendCommand(MACK) => " + (e != null ? e.getMessage() : "OK"));
                            }
                        });
                    }
                    if (BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                        this.mCurrentUser.updatePropertiesByUser(msg.mSender);
                    }
                    if (!GroupChannel.sCachedChannels.containsKey(channelUrl = msg.getChannelUrl())) {
                        GroupChannel.getChannelWithoutCacheInternal(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                            @Override
                            public void onResult(final GroupChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                Sender sender = msg.mSender;
                                if (sender != null && channel.mMemberMap.containsKey(sender.getUserId())) {
                                    Member member = channel.mMemberMap.get(sender.getUserId());
                                    member.updatePropertiesBySender(sender);
                                }
                                final AtomicBoolean callChannelChanged = new AtomicBoolean(!msg.isSilent() || BaseMessage.belongsTo(msg, SendBird.getCurrentUser()));
                                if (channel.isEphemeral() && callChannelChanged.get()) {
                                    channel.setLastMessageByCreatedAt(msg);
                                    if (!BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                                        channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                                    }
                                    if (msg.isMentionedFromSomeoneToMe()) {
                                        channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                                    }
                                }
                                if (msg.shouldForceUpdateLastMessage()) {
                                    callChannelChanged.compareAndSet(false, channel.setLastMessageByCreatedAt(msg));
                                }
                                SendBirdPushHelper.messageDelivered(msg);
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageReceived(channel, msg);
                                            if (callChannelChanged.get()) {
                                                handler.onChannelChanged(channel);
                                            }
                                            if (!msg.isMentionedFromSomeoneToMe()) continue;
                                            handler.onMentionReceived(channel, msg);
                                        }
                                    }
                                });
                            }
                        });
                        break;
                    }
                    GroupChannel.getChannelInternal(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            Sender sender;
                            if (e != null) {
                                Logger.d("Discard a command.");
                                return;
                            }
                            channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
                            final AtomicBoolean callChannelChanged = new AtomicBoolean(!(msg.isSilent() && !BaseMessage.belongsTo(msg, SendBird.getCurrentUser()) || !channel.mHasBeenUpdated && channel.getLastMessage() != null && channel.getLastMessage().getCreatedAt() >= msg.getCreatedAt()));
                            if (callChannelChanged.get()) {
                                channel.setLastMessageByCreatedAt(msg);
                                if (!BaseMessage.belongsTo(msg, SendBird.getCurrentUser())) {
                                    channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                                }
                                if (msg.isMentionedFromSomeoneToMe()) {
                                    channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                                }
                                channel.mHasBeenUpdated = true;
                            }
                            if (msg.shouldForceUpdateLastMessage()) {
                                callChannelChanged.compareAndSet(false, channel.setLastMessageByCreatedAt(msg));
                            }
                            if ((sender = msg.mSender) != null && channel.mMemberMap.containsKey(sender.getUserId())) {
                                Member member = channel.mMemberMap.get(sender.getUserId());
                                member.updatePropertiesBySender(sender);
                            }
                            SendBirdPushHelper.messageDelivered(msg);
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onMessageReceived(channel, msg);
                                        if (callChannelChanged.get()) {
                                            handler.onChannelChanged(channel);
                                        }
                                        if (!msg.isMentionedFromSomeoneToMe()) continue;
                                        handler.onMentionReceived(channel, msg);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                OpenChannel.getChannelInternal(msg.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (OpenChannel.isEnteredChannel(channel.getUrl())) {
                                        handler.onMessageReceived(channel, msg);
                                    }
                                    if (!msg.isMentionedFromSomeoneToMe()) continue;
                                    handler.onMentionReceived(channel, msg);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "MEDI": 
            case "FEDI": 
            case "AEDI": {
                BaseMessage updatedMsg;
                switch (cmd.getCommand()) {
                    case "MEDI": {
                        updatedMsg = new UserMessage(cmd.getJsonElement());
                        updatedMsg.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                        break;
                    }
                    case "FEDI": {
                        updatedMsg = new FileMessage(cmd.getJsonElement());
                        updatedMsg.setSendingStatus(BaseMessage.SendingStatus.SUCCEEDED);
                        break;
                    }
                    case "AEDI": {
                        updatedMsg = new AdminMessage(cmd.getJsonElement());
                        break;
                    }
                    default: {
                        Logger.d("Discard a command: " + cmd.getCommand());
                        return;
                    }
                }
                if (updatedMsg.isGroupChannel()) {
                    final boolean isCachedChannel = GroupChannel.sCachedChannels.containsKey(updatedMsg.getChannelUrl());
                    GroupChannel.getChannelInternal(updatedMsg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            JsonObject payload;
                            if (e != null) {
                                Logger.d("Discard a command.");
                                return;
                            }
                            final AtomicBoolean mentionReceived = new AtomicBoolean();
                            AtomicBoolean unreadMentionCountChanged = new AtomicBoolean();
                            if (SendBird.getCurrentUser() != null && updatedMsg.getCreatedAt() > channel.getMyReadTs() && (payload = cmd.getJsonElement().getAsJsonObject()).has("old_values")) {
                                boolean currentUserWasMentioned;
                                BaseMessageParams.MentionType mentionType = updatedMsg.getMentionType();
                                List<String> mentionedUserIds = updatedMsg.getMentionedUserIds();
                                BaseMessageParams.MentionType oldMentionType = BaseMessageParams.MentionType.USERS;
                                List<String> oldMentionedUserIds = null;
                                JsonObject oldValuesObject = payload.get("old_values").getAsJsonObject();
                                if (oldValuesObject.has("mention_type")) {
                                    String oldMentionTypeString = oldValuesObject.get("mention_type").getAsString();
                                    if (oldMentionTypeString.equals("users")) {
                                        oldMentionType = BaseMessageParams.MentionType.USERS;
                                    } else if (oldMentionTypeString.equals("channel")) {
                                        oldMentionType = BaseMessageParams.MentionType.CHANNEL;
                                    }
                                } else {
                                    oldMentionType = mentionType;
                                }
                                if (oldValuesObject.has("mentioned_user_ids")) {
                                    JsonArray array = oldValuesObject.get("mentioned_user_ids").getAsJsonArray();
                                    if (array != null) {
                                        oldMentionedUserIds = new ArrayList<String>();
                                        for (int i = 0; i < array.size(); ++i) {
                                            oldMentionedUserIds.add(array.get(i).getAsString());
                                        }
                                    }
                                } else {
                                    oldMentionedUserIds = mentionedUserIds;
                                }
                                boolean bl = currentUserWasMentioned = oldMentionedUserIds != null && oldMentionedUserIds.contains(SendBird.getCurrentUser().getUserId());
                                if (oldMentionType == BaseMessageParams.MentionType.USERS && !currentUserWasMentioned && updatedMsg.isMentionedFromSomeoneToMe()) {
                                    if (isCachedChannel && !updatedMsg.isSilent()) {
                                        channel.setUnreadMentionCount(channel.getUnreadMentionCount() + 1);
                                    }
                                    unreadMentionCountChanged.set(true);
                                    mentionReceived.set(true);
                                }
                            }
                            final AtomicBoolean callChannelChanged = new AtomicBoolean();
                            if (!updatedMsg.isSilent() || BaseMessage.belongsTo(updatedMsg, SendBird.getCurrentUser())) {
                                BaseMessage lastMessage = channel.getLastMessage();
                                if (unreadMentionCountChanged.get()) {
                                    callChannelChanged.set(true);
                                } else if (lastMessage == null || lastMessage.getCreatedAt() < updatedMsg.getCreatedAt()) {
                                    callChannelChanged.set(true);
                                } else if (lastMessage.getCreatedAt() == updatedMsg.getCreatedAt()) {
                                    callChannelChanged.set(lastMessage.getMessageId() == updatedMsg.getMessageId() && lastMessage.getUpdatedAt() < updatedMsg.getUpdatedAt());
                                }
                            }
                            if (callChannelChanged.get()) {
                                channel.setLastMessage(updatedMsg);
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onMessageUpdated(channel, updatedMsg);
                                        if (callChannelChanged.get()) {
                                            handler.onChannelChanged(channel);
                                        }
                                        if (!mentionReceived.get()) continue;
                                        handler.onMentionReceived(channel, updatedMsg);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                OpenChannel.getChannelInternal(updatedMsg.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onMessageUpdated(channel, updatedMsg);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "MRCT": {
                String channelUrl;
                JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                String string = channelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
                if (TextUtils.isEmpty((CharSequence)channelUrl)) break;
                String channelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : "";
                boolean isGroupChannel = channelType.equals("group");
                final ReactionEvent reactionEvent = new ReactionEvent(cmd.getJsonElement());
                if (isGroupChannel) {
                    GroupChannel.getChannelInternal(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command.");
                                return;
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onReactionUpdated(channel, reactionEvent);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                OpenChannel.getChannelInternal(channelUrl, new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onReactionUpdated(channel, reactionEvent);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "READ": {
                final ReadStatus rst = new ReadStatus(cmd.getJsonElement());
                if (!GroupChannel.sCachedChannels.containsKey(rst.getChannelUrl())) {
                    GroupChannel.getChannelWithoutCacheInternal(rst.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                        @Override
                        public void onResult(final GroupChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command. ");
                                return;
                            }
                            final boolean readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
                            final boolean callChannelChanged = readFromMyself && (channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0);
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (!readFromMyself) {
                                            handler.onReadReceiptUpdated(channel);
                                        }
                                        if (!callChannelChanged) continue;
                                        handler.onChannelChanged(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelInternal(rst.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        boolean callChannelChanged;
                        boolean readFromMyself;
                        if (e != null) {
                            Logger.d("Discard a command. ");
                            return;
                        }
                        channel.updateReadReceipt(rst.getReader().getUserId(), rst.getTimestamp());
                        boolean bl = readFromMyself = SendBird.getCurrentUser() != null && rst.getReader().getUserId().equals(SendBird.getCurrentUser().getUserId());
                        if (readFromMyself && (channel.getUnreadMessageCount() > 0 || channel.getUnreadMentionCount() > 0)) {
                            channel.setUnreadMessageCount(0);
                            channel.setUnreadMentionCount(0);
                            callChannelChanged = channel.getUnreadMessageCount() == 0 || channel.getUnreadMentionCount() == 0;
                        } else {
                            callChannelChanged = false;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (!readFromMyself) {
                                        handler.onReadReceiptUpdated(channel);
                                    }
                                    if (!callChannelChanged) continue;
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case "DLVR": {
                final JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                String channelUrl = obj.get("channel_url").getAsString();
                final boolean hasChannelCached = GroupChannel.sCachedChannels.containsKey(channelUrl);
                GroupChannel.getChannelInternal(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        Logger.d("++ hasChannelCached : " + hasChannelCached);
                        Logger.d("++ channel : " + channel);
                        if (e != null) {
                            return;
                        }
                        if (obj.has("updated")) {
                            boolean isMyReceipt;
                            User currentUser;
                            JsonObject updatedReceiptObj = obj.get("updated").getAsJsonObject();
                            Set updatedReceiptEntrySet = updatedReceiptObj.entrySet();
                            if (hasChannelCached) {
                                for (Map.Entry entry : updatedReceiptEntrySet) {
                                    channel.updateDeliveryReceipt((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
                                }
                            }
                            if (!((currentUser = SendBird.getCurrentUser()) == null || (isMyReceipt = updatedReceiptObj.has(currentUser.getUserId())) && updatedReceiptEntrySet.size() <= 1)) {
                                Logger.d("++ isMyReceipt : " + isMyReceipt + ", receipt size : " + updatedReceiptEntrySet.size());
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onDeliveryReceiptUpdated(channel);
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
                break;
            }
            case "TPST": 
            case "TPEN": {
                break;
            }
            case "MTIO": {
                break;
            }
            case "SYEV": {
                this.processChannelEvent(cmd);
                break;
            }
            case "USEV": {
                this.processUserEvent(cmd);
                break;
            }
            case "DELM": {
                JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                BaseChannel.ChannelType channelType = BaseChannel.ChannelType.fromValue(obj.has("channel_type") ? obj.get("channel_type").getAsString() : "");
                String channelUrl = obj.get("channel_url").getAsString();
                final long msgId = obj.get("msg_id").getAsLong();
                switch (channelType) {
                    case OPEN: {
                        OpenChannel.getChannelInternal(channelUrl, new OpenChannel.OpenChannelGetHandler(){

                            @Override
                            public void onResult(final OpenChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break block39;
                    }
                    case GROUP: {
                        GroupChannel.getChannelInternal(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                            @Override
                            public void onResult(final GroupChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break block39;
                    }
                }
                Logger.d("Discard a command.");
                return;
            }
            case "LEAV": {
                break;
            }
            case "JOIN": {
                break;
            }
            case "MTHD": {
                this.processThreadInfoUpdateEvent(cmd);
                break;
            }
            default: {
                Logger.d("Discard a command: " + cmd.getCommand());
            }
        }
    }

    private void processThreadInfoUpdateEvent(Command cmd) {
        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
        BaseChannel.ChannelType channelType = BaseChannel.ChannelType.fromValue(obj.has("channel_type") ? obj.get("channel_type").getAsString() : "");
        String channelUrl = obj.get("channel_url").getAsString();
        final ThreadInfoUpdateEvent threadInfoUpdateEvent = new ThreadInfoUpdateEvent((JsonElement)obj);
        switch (channelType) {
            case OPEN: {
                OpenChannel.getChannelInternal(channelUrl, new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onThreadInfoUpdated(channel, threadInfoUpdateEvent);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case GROUP: {
                GroupChannel.getChannelInternal(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onThreadInfoUpdated(channel, threadInfoUpdateEvent);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private void processSubscribedUnreadMessageCount(Command cmd) {
        boolean unreadCountChanged = false;
        JsonObject obj = cmd.getJsonElement().getAsJsonObject();
        if (obj != null && obj.has("unread_cnt")) {
            unreadCountChanged = this.mSubscribedUnreadMessageCount.updateUnreadCount(obj.getAsJsonObject("unread_cnt"));
        }
        if (unreadCountChanged) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (UserEventHandler handler : SendBird.this.mUserEventHandlers.values()) {
                        handler.onTotalUnreadMessageCountChanged(((SendBird)SendBird.this).mSubscribedUnreadMessageCount.mTotalCount, ((SendBird)SendBird.this).mSubscribedUnreadMessageCount.mCustomTypeMap);
                    }
                }
            });
        }
    }

    private void processChannelEvent(final Command cmd) {
        final ChannelEvent event = new ChannelEvent(cmd.getJsonElement());
        switch (event.getCategory()) {
            case 10020: {
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        if (channel.isSuper()) {
                            channel.setMemberCount(event.getData(), event.getTs());
                        }
                        final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                        final ArrayList<Member> invitees = new ArrayList<Member>();
                        JsonArray inviteesArray = event.getData().getAsJsonObject().get("invitees").getAsJsonArray();
                        for (JsonElement inviteeEl : inviteesArray) {
                            JsonObject inviteeObj = inviteeEl.getAsJsonObject();
                            String userId = inviteeObj.get("user_id").getAsString();
                            Member inviteeInCache = channel.mMemberMap.get(userId);
                            if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(userId)) {
                                channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
                                if (channel.getMyMemberState() != Member.MemberState.JOINED) {
                                    channel.setMyMemberState(Member.MemberState.INVITED);
                                }
                                if (event.getData().getAsJsonObject().has("invited_at")) {
                                    channel.setInvitedAt(event.getData().getAsJsonObject().get("invited_at").getAsLong());
                                }
                            }
                            if (inviteeInCache == null) {
                                inviteeObj.addProperty("state", "invited");
                                Member invitee = new Member((JsonElement)inviteeObj);
                                if (!channel.isSuper()) {
                                    channel.addMember(invitee, event.getTs());
                                }
                                invitees.add(invitee);
                                continue;
                            }
                            invitees.add(inviteeInCache);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onUserReceivedInvitation(channel, inviter, invitees);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10022: {
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User inviter = new User(event.getData().getAsJsonObject().get("inviter"));
                        JsonElement inviteeEl = event.getData().getAsJsonObject().get("invitee");
                        final Member invitee = new Member(inviteeEl);
                        if (channel.isSuper()) {
                            channel.setMemberCount(event.getData(), event.getTs());
                        } else {
                            channel.removeMember(invitee);
                        }
                        if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(invitee.getUserId())) {
                            channel.setMyMemberState(Member.MemberState.NONE);
                            channel.setInvitedAt(0L);
                            if (!channel.isPublic()) {
                                GroupChannel.removeChannelFromCache(channel.getUrl());
                            }
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onUserDeclinedInvitation(channel, inviter, invitee);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10000: 
            case 10001: {
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        if (event.getCategory() == 10000) {
                            ArrayList<Member> members = new ArrayList<Member>();
                            if (event.getData().getAsJsonObject().has("users")) {
                                JsonArray membersArray = event.getData().getAsJsonObject().get("users").getAsJsonArray();
                                for (int i = 0; i < membersArray.size(); ++i) {
                                    members.add(new Member(membersArray.get(i)));
                                }
                            } else {
                                members.add(new Member(event.getData()));
                            }
                            for (int i = 0; i < members.size(); ++i) {
                                final Member member = (Member)members.get(i);
                                if (channel.isSuper()) {
                                    channel.setMemberCount(event.getData(), event.getTs());
                                } else {
                                    channel.addMember(member, event.getTs());
                                    channel.updateJoinedMemberCount();
                                }
                                if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(member.getUserId())) {
                                    channel.setMyMemberState(Member.MemberState.JOINED);
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onUserJoined(channel, member);
                                        }
                                    }
                                });
                            }
                        } else {
                            final Member member = new Member(event.getData());
                            if (channel.isSuper()) {
                                channel.setMemberCount(event.getData(), event.getTs());
                            } else {
                                channel.removeMember(member);
                                channel.updateJoinedMemberCount();
                            }
                            if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(member.getUserId())) {
                                channel.setMyMemberState(Member.MemberState.NONE);
                                channel.setUnreadMessageCount(0);
                                channel.setUnreadMentionCount(0);
                                channel.setInvitedAt(0L);
                                if (!channel.isPublic()) {
                                    GroupChannel.removeChannelFromCache(channel.getUrl());
                                }
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onUserLeft(channel, member);
                                    }
                                }
                            });
                        }
                    }
                });
                break;
            }
            case 10900: 
            case 10901: {
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        User user = new User(event.getData());
                        if (event.getCategory() == 10900) {
                            channel.updateTypingStatus(user, true);
                        } else {
                            channel.updateTypingStatus(user, false);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onTypingStatusUpdated(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10102: 
            case 10103: {
                OpenChannel.getChannelInternal(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        JsonObject obj = event.getData().getAsJsonObject();
                        if (obj.has("participant_count")) {
                            channel.setParticipantCount(obj.get("participant_count").getAsInt());
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10102) {
                                        handler.onUserEntered(channel, user);
                                        continue;
                                    }
                                    handler.onUserExited(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10200: 
            case 10201: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelInternal(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            final User user = new User(event.getData());
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (event.getCategory() == 10201) {
                                            handler.onUserMuted(channel, user);
                                            continue;
                                        }
                                        handler.onUserUnmuted(channel, user);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                            if (event.getCategory() == 10201) {
                                channel.setMyMutedState(Member.MutedState.MUTED);
                            } else {
                                channel.setMyMutedState(Member.MutedState.UNMUTED);
                            }
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10201) {
                                        handler.onUserMuted(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnmuted(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10600: 
            case 10601: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelInternal(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            final User user = new User(event.getData());
                            if (event.getCategory() == 10601 && SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                                OpenChannel.removeChannelFromEntered(channel.getUrl());
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (event.getCategory() == 10601) {
                                            handler.onUserBanned(channel, user);
                                            continue;
                                        }
                                        handler.onUserUnbanned(channel, user);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        if (event.getCategory() == 10601) {
                            if (channel.isSuper()) {
                                channel.setMemberCount(event.getData(), event.getTs());
                            } else {
                                channel.removeMember(user);
                                channel.updateJoinedMemberCount();
                            }
                            if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(user.getUserId())) {
                                channel.setMyMemberState(Member.MemberState.NONE);
                                channel.setUnreadMessageCount(0);
                                channel.setUnreadMentionCount(0);
                                channel.setInvitedAt(0L);
                                if (!channel.isPublic()) {
                                    GroupChannel.removeChannelFromCache(channel.getUrl());
                                }
                            }
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10601) {
                                        handler.onUserBanned(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnbanned(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10700: 
            case 10701: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelInternal(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            JsonObject jsonObject = event.getData().getAsJsonObject();
                            if (jsonObject.has("freeze")) {
                                channel.setFreeze(jsonObject.get("freeze").getAsBoolean());
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        if (event.getCategory() == 10701) {
                                            handler.onChannelFrozen(channel);
                                            continue;
                                        }
                                        handler.onChannelUnfrozen(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        JsonObject jsonObject = event.getData().getAsJsonObject();
                        if (jsonObject.has("freeze")) {
                            channel.setFreeze(jsonObject.get("freeze").getAsBoolean());
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10701) {
                                        handler.onChannelFrozen(channel);
                                        continue;
                                    }
                                    handler.onChannelUnfrozen(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 11000: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelWithoutCacheInternal(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onChannelChanged(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelWithoutCacheInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        if (!channel.isMyUnreadMessageCountEnabled()) {
                            channel.setUnreadMessageCount(0);
                        }
                        if (!channel.isMyUnreadMentionCountEnabled()) {
                            channel.setUnreadMentionCount(0);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 12000: {
                if (event.isOpenChannel()) {
                    OpenChannel.removeChannelFromCache(event.getChannelUrl());
                    OpenChannel.removeChannelFromEntered(event.getChannelUrl());
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onChannelDeleted(event.getChannelUrl(), BaseChannel.ChannelType.OPEN);
                            }
                        }
                    });
                    break;
                }
                GroupChannel.removeChannelFromCache(event.getChannelUrl());
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                            handler.onChannelDeleted(event.getChannelUrl(), BaseChannel.ChannelType.GROUP);
                        }
                    }
                });
                break;
            }
            case 11100: 
            case 11200: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelInternal(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            SendBird.this.processChannelMetaDataAndCountersChangedEvent(channel, event);
                        }
                    });
                    break;
                }
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        SendBird.this.processChannelMetaDataAndCountersChangedEvent(channel, event);
                    }
                });
                break;
            }
            case 13000: {
                if (!event.isGroupChannel()) break;
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        JsonObject jsonObject = event.getData().getAsJsonObject();
                        if (jsonObject.has("hide_previous_messages") && jsonObject.get("hide_previous_messages").getAsBoolean()) {
                            channel.setUnreadMessageCount(0);
                            channel.setUnreadMentionCount(0);
                            channel.parseMessageOffset((JsonElement)event.obj);
                        }
                        if (jsonObject.has("allow_auto_unhide")) {
                            boolean allowAutoUnhide = jsonObject.get("allow_auto_unhide").getAsBoolean();
                            if (allowAutoUnhide) {
                                channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
                            } else {
                                channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_PREVENT_AUTO_UNHIDE);
                            }
                        } else {
                            channel.setHiddenState(GroupChannel.HiddenState.HIDDEN_ALLOW_AUTO_UNHIDE);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onChannelHidden(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 13001: {
                if (!event.isGroupChannel()) break;
                GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        channel.setHiddenState(GroupChannel.HiddenState.UNHIDDEN);
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10002: {
                this.handleChannelOperatorsChange(event);
            }
        }
    }

    private void handleChannelOperatorsChange(final ChannelEvent event) {
        JsonArray operatorsObjs;
        JsonObject jsonObject = event.getData().getAsJsonObject();
        final ArrayList<User> operators = new ArrayList<User>();
        JsonArray jsonArray = operatorsObjs = jsonObject.has("operators") ? jsonObject.get("operators").getAsJsonArray() : null;
        if (operatorsObjs == null) {
            return;
        }
        for (int i = 0; i < operatorsObjs.size(); ++i) {
            operators.add(new User(operatorsObjs.get(i)));
        }
        if (event.isGroupChannel()) {
            GroupChannel.getChannelInternal(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                @Override
                public void onResult(final GroupChannel channel, SendBirdException e) {
                    if (e != null || channel == null) {
                        Logger.d("[handleChannelOperatorsChange()] error in GroupChannel.getChannel : " + Log.getStackTraceString((Throwable)e));
                        return;
                    }
                    User me = SendBird.getCurrentUser();
                    if (me != null) {
                        channel.setMyRole(operators.contains(me) ? Member.Role.OPERATOR : Member.Role.NONE);
                    }
                    channel.updateOperators(operators, event.getTs());
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onOperatorUpdated(channel);
                            }
                        }
                    });
                }
            });
        } else {
            OpenChannel.getChannelInternal(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                @Override
                public void onResult(final OpenChannel channel, SendBirdException e) {
                    if (e != null || channel == null) {
                        Logger.d("[handleChannelOperatorsChange()] error in OpenChannel.getChannel : " + Log.getStackTraceString((Throwable)e));
                        return;
                    }
                    channel.updateOperators(operators, event.getTs());
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onOperatorUpdated(channel);
                            }
                        }
                    });
                }
            });
        }
    }

    private void processChannelMetaDataAndCountersChangedEvent(final BaseChannel channel, ChannelEvent event) {
        try {
            JsonObject jsonObject = event.getData().getAsJsonObject();
            if (event.getCategory() == 11100) {
                JsonObject obj;
                Cloneable result;
                if (jsonObject.has("created")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("created");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaDataCreated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("updated")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaDataUpdated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("deleted")) {
                    result = new ArrayList();
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        result.add(array.get(i).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((List)((Object)result)){
                        final /* synthetic */ List val$result;
                        {
                            this.val$result = list;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaDataDeleted(channel, this.val$result);
                            }
                        }
                    });
                }
            } else {
                JsonObject obj;
                Cloneable result;
                if (jsonObject.has("created")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("created");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaCountersCreated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("updated")) {
                    result = new HashMap();
                    obj = jsonObject.getAsJsonObject("updated");
                    for (Map.Entry entry : obj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        ((HashMap)result).put(entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                    SendBird.runOnUIThread(new Runnable((HashMap)result){
                        final /* synthetic */ HashMap val$result;
                        {
                            this.val$result = hashMap;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaCountersUpdated(channel, this.val$result);
                            }
                        }
                    });
                }
                if (jsonObject.has("deleted")) {
                    result = new ArrayList();
                    JsonArray array = jsonObject.getAsJsonArray("deleted");
                    for (int i = 0; i < array.size(); ++i) {
                        if (!array.get(i).isJsonPrimitive()) continue;
                        result.add(array.get(i).getAsString());
                    }
                    SendBird.runOnUIThread(new Runnable((List)((Object)result)){
                        final /* synthetic */ List val$result;
                        {
                            this.val$result = list;
                        }

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onMetaCountersDeleted(channel, this.val$result);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processUserEvent(Command cmd) {
        UserEvent event = new UserEvent(cmd.getJsonElement());
        switch (event.getCategory()) {
            case 20000: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(false);
                    }
                }
                if (SendBird.getCurrentUser() == null || !SendBird.getCurrentUser().getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(false);
                }
                break;
            }
            case 20001: {
                Member member;
                User blocker = null;
                User blockee = null;
                if (event.getData() != null && event.getData().getAsJsonObject().has("blocker") && event.getData().getAsJsonObject().has("blockee")) {
                    blocker = new User(event.getData().getAsJsonObject().get("blocker"));
                    blockee = new User(event.getData().getAsJsonObject().get("blockee"));
                }
                if (blocker == null || blockee == null) break;
                if (SendBird.getCurrentUser() != null && SendBird.getCurrentUser().getUserId().equals(blocker.getUserId())) {
                    for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                        member = cachedChannel.getValue().mMemberMap.get(blockee.getUserId());
                        if (member == null) continue;
                        member.setIsBlockedByMe(true);
                    }
                }
                if (SendBird.getCurrentUser() == null || !SendBird.getCurrentUser().getUserId().equals(blockee.getUserId())) break;
                for (Map.Entry<String, GroupChannel> cachedChannel : GroupChannel.sCachedChannels.entrySet()) {
                    member = cachedChannel.getValue().mMemberMap.get(blocker.getUserId());
                    if (member == null) continue;
                    member.setIsBlockingMe(true);
                }
                break;
            }
            case 20900: {
                if (event.getData() == null || !event.getData().getAsJsonObject().has("friend_discoveries")) break;
                JsonObject result = event.getData().getAsJsonObject();
                JsonArray usersArray = result.get("friend_discoveries").getAsJsonArray();
                final ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i < usersArray.size(); ++i) {
                    users.add(new User(usersArray.get(i)));
                }
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (UserEventHandler handler : SendBird.this.mUserEventHandlers.values()) {
                            handler.onFriendsDiscovered(users);
                        }
                    }
                });
            }
        }
    }

    void sendCommand(final Command cmd, boolean lazy, final Command.SendCommandHandler handler) {
        if (this.mWSClient == null || this.mWSClient.getConnectionState() != ConnectionState.OPEN && !lazy) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("WS connection closed.", 800200));
            }
            return;
        }
        if (cmd.isAckRequired()) {
            this.startAckTimer(cmd, handler);
            if (this.mWSClient != null) {
                this.mWSClient.send(cmd, lazy, new WSClient.WSClientSendHandler(){

                    @Override
                    public void onResult(SendBirdException e) {
                        if (e != null) {
                            HashMap ackInfo = SendBird.this.getAckInfo(cmd.getRequestId());
                            if (ackInfo != null) {
                                CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
                                Command.SendCommandHandler handler2 = (Command.SendCommandHandler)ackInfo.get("handler");
                                timer.stop();
                            }
                            if (handler != null) {
                                handler.onResult(null, e);
                            }
                            return;
                        }
                    }
                });
            }
        } else if (this.mWSClient != null) {
            this.mWSClient.send(cmd, lazy, new WSClient.WSClientSendHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    if (handler != null) {
                        handler.onResult(null, null);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAckTimer(Command command, final Command.SendCommandHandler handler) {
        final SendBird I = SendBird.getInstance();
        final String reqId = command.getRequestId();
        CountDownTimer timer = new CountDownTimer(Options.wsResponseTimeoutSec * 1000, 100);
        timer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStop() {
                Object object = I.mAckStateMapLock;
                synchronized (object) {
                    SendBird.this.mAckStateMap.remove(reqId);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCancel() {
                Object object = I.mAckStateMapLock;
                synchronized (object) {
                    SendBird.this.mAckStateMap.remove(reqId);
                }
            }

            @Override
            public void onTimeout() {
                handler.onResult(null, new SendBirdException("Command received no ack.", 800180));
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
        Object object = I.mAckStateMapLock;
        synchronized (object) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("handler", handler);
            map.put("timer", timer);
            this.mAckStateMap.put(reqId, map);
        }
        timer.start();
    }

    private HashMap<String, Object> getAckInfo(String requestId) {
        return this.mAckStateMap.get(requestId);
    }

    private String getStringPref(String key) {
        String result = null;
        if (this.mAppContext != null) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.mAppContext);
            result = sp.getString(key, null);
        }
        return result;
    }

    private void setStringPref(String key, String value) {
        if (this.mAppContext != null) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.mAppContext);
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(key, value);
            editor.apply();
        }
    }

    String getAPIHostFromPref() {
        return this.getStringPref(this.mPrefApiHost);
    }

    void setAPIHostToPref(String apiHost) {
        this.setStringPref(this.mPrefApiHost, apiHost);
    }

    String getWSHostFromPref() {
        return this.getStringPref(this.mPrefWsHost);
    }

    void setWSHostToPref(String wsHost) {
        this.setStringPref(this.mPrefWsHost, wsHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAuthenticationTimer(Timer timer) {
        Object object = this.mAuthenticationTimers;
        synchronized (object) {
            if (timer != null) {
                this.mAuthenticationTimers.add(timer);
            }
        }
        object = this.mConnectingLock;
        synchronized (object) {
            this.mConnecting = true;
        }
        Logger.d("[ConnectionManager] addAuthenticationTimer() => " + this.mAuthenticationTimers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAuthenticationTimer(Timer timer) {
        boolean removed = false;
        Object object = this.mAuthenticationTimers;
        synchronized (object) {
            if (timer != null) {
                timer.cancel();
                removed = this.mAuthenticationTimers.remove(timer);
            }
        }
        if (this.mConnecting && this.mConnectHandlers.isEmpty() && this.mAuthenticationTimers.isEmpty()) {
            object = this.mConnectingLock;
            synchronized (object) {
                this.mConnecting = false;
            }
        }
        Logger.d("[ConnectionManager] removeAuthenticationTimer() => " + this.mAuthenticationTimers.size());
        return removed;
    }

    public static void getTotalUnreadMessageCount(GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, null, handler);
    }

    public static void getTotalUnreadMessageCount(List<String> channelCustomTypes, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(null, channelCustomTypes, handler);
    }

    public static void getTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams params, GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        SendBird.localGetTotalUnreadMessageCount(params.mSuperChannelFilter, params.mChannelCustomTypes, handler);
    }

    static void localGetTotalUnreadMessageCount(GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter superChannelFilter, List<String> channelCustomTypes, final GroupChannel.GroupChannelTotalUnreadMessageCountHandler handler) {
        APIClient.getInstance().getTotalUnreadMessageCount(superChannelFilter, channelCustomTypes, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int unreadCount = response.getAsJsonObject().get("unread_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(unreadCount, null);
                        }
                    });
                }
            }
        });
    }

    public static int getSubscribedTotalUnreadMessageCount() {
        return SendBird.getInstance().mSubscribedUnreadMessageCount.mTotalCount;
    }

    public static int getSubscribedCustomTypeTotalUnreadMessageCount() {
        return SendBird.getInstance().mSubscribedUnreadMessageCount.mTotalCountByCustomTypes;
    }

    public static int getSubscribedCustomTypeUnreadMessageCount(String customType) {
        Integer count;
        int result = 0;
        if (customType != null && (count = SendBird.getInstance().mSubscribedUnreadMessageCount.mCustomTypeMap.get(customType)) != null) {
            result = count;
        }
        return result;
    }

    public static void getUnreadItemCount(Collection<GroupChannel.UnreadItemKey> keys, final GroupChannel.GroupChannelGetUnreadItemCountHandler handler) {
        if (keys == null || keys.size() <= 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().getUnreadItemCount(keys, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject obj = response.getAsJsonObject();
                final HashMap<GroupChannel.UnreadItemKey, Integer> result = new HashMap<GroupChannel.UnreadItemKey, Integer>();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    GroupChannel.UnreadItemKey unreadItemKey = null;
                    String key = (String)entry.getKey();
                    if (key.equals("group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MENTION_COUNT;
                    } else if (key.equals("group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.GROUP_CHANNEL_INVITATION_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("super_group_channel_unread_message_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MESSAGE_COUNT;
                    } else if (key.equals("non_super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("super_group_channel_unread_mention_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_UNREAD_MENTION_COUNT;
                    } else if (key.equals("non_super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.NONSUPER_INVITATION_COUNT;
                    } else if (key.equals("super_group_channel_invitation_count")) {
                        unreadItemKey = GroupChannel.UnreadItemKey.SUPER_INVITATION_COUNT;
                    }
                    if (unreadItemKey == null) continue;
                    result.put(unreadItemKey, ((JsonElement)entry.getValue()).getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public static void getTotalUnreadChannelCount(final GroupChannel.GroupChannelTotalUnreadChannelCountHandler handler) {
        APIClient.getInstance().getTotalUnreadChannelCount(new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int unreadCount = response.getAsJsonObject().get("unread_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(unreadCount, null);
                        }
                    });
                }
            }
        });
    }

    public static void getGroupChannelCount(GroupChannelListQuery.MemberStateFilter memberStateFilter, GroupChannel.GroupChannelChannelCountHandler handler) {
        String state;
        switch (memberStateFilter) {
            case ALL: {
                state = "all";
                break;
            }
            case INVITED: {
                state = "invited";
                break;
            }
            case INVITED_BY_FRIEND: {
                state = "invited_by_friend";
                break;
            }
            case INVITED_BY_NON_FRIEND: {
                state = "invited_by_non_friend";
                break;
            }
            case JOINED: {
                state = "joined";
                break;
            }
            default: {
                state = null;
            }
        }
        SendBird.localGetGroupChannelCount(state, handler);
    }

    static void localGetGroupChannelCount(String state, final GroupChannel.GroupChannelChannelCountHandler handler) {
        APIClient.getInstance().getChannelCount(state, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(0, e);
                            }
                        });
                    }
                    return;
                }
                final int myChannelCount = response.getAsJsonObject().get("group_channel_count").getAsInt();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(myChannelCount, null);
                        }
                    });
                }
            }
        });
    }

    public static String getEkey() {
        return ekey;
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
        exUserAgent = new HashMap<ExtentionFrom, String>();
        ekey = "";
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private boolean mNeedReconnect = false;

        private NetworkReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            NetworkInfo networkInfo = null;
            try {
                networkInfo = SendBird.this.mConnectivityManager.getActiveNetworkInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (networkInfo != null && networkInfo.isConnected()) {
                if (this.mNeedReconnect && !SendBird.this.mIsAppBackgroundAndDisconnected) {
                    this.mNeedReconnect = false;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (SendBird.getNetworkAwarenessReconnection()) {
                                    SendBird.reconnect(true);
                                }
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            } else if (networkInfo == null) {
                this.mNeedReconnect = true;
                if (SendBird.getConnectionState() == ConnectionState.OPEN) {
                    SendBird.disconnect(false, true, null);
                }
            }
        }
    }

    private static abstract class ApplicationStateHandler {
        private ApplicationStateHandler() {
        }

        abstract void start();

        abstract void stop();

        abstract void onActivityResumed();

        abstract void onActivityPaused();
    }

    public static interface GetEmojiHandler {
        public void onResult(Emoji var1, SendBirdException var2);
    }

    public static interface GetEmojiCategoryHandler {
        public void onResult(EmojiCategory var1, SendBirdException var2);
    }

    public static interface GetAllEmojiHandler {
        public void onResult(EmojiContainer var1, SendBirdException var2);
    }

    static interface MarkAsDeliveredHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MarkAsReadHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetMyGroupChannelChangeLogsHandler {
        public void onResult(List<GroupChannel> var1, List<String> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface GetFriendChangeLogsByTokenHandler {
        public void onResult(List<User> var1, List<String> var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface DeleteFriendDiscoveryHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UploadFriendDiscoveriesHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface DeleteFriendsHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface AddFriendsHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }

    public static interface UserUnblockHandler {
        public void onUnblocked(SendBirdException var1);
    }

    public static interface UserBlockHandler {
        public void onBlocked(User var1, SendBirdException var2);
    }

    public static interface GetChannelInvitationPreferenceHandler {
        public void onResult(boolean var1, SendBirdException var2);
    }

    public static interface SetChannelInvitationPreferenceHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface UserInfoUpdateHandler {
        public void onUpdated(SendBirdException var1);
    }

    public static interface GetPushTriggerOptionHandler {
        public void onResult(PushTriggerOption var1, SendBirdException var2);
    }

    public static interface SetPushTriggerOptionHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushTemplateHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushTemplateHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushSoundHandler {
        public void onResult(String var1, SendBirdException var2);
    }

    public static interface SetPushSoundHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetSnoozePeriodHandler {
        public void onResult(boolean var1, long var2, long var4, SendBirdException var6);
    }

    public static interface SetSnoozePeriodHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetDoNotDisturbHandler {
        public void onResult(boolean var1, int var2, int var3, int var4, int var5, String var6, SendBirdException var7);
    }

    public static interface SetDoNotDisturbHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GetPushTokensHandler {
        public void onResult(List<String> var1, PushTokenType var2, boolean var3, String var4, SendBirdException var5);
    }

    public static interface UnregisterPushTokenHandler {
        public void onUnregistered(SendBirdException var1);
    }

    public static interface RegisterPushTokenWithStatusHandler {
        public void onRegistered(PushTokenRegistrationStatus var1, SendBirdException var2);
    }

    @Deprecated
    public static interface RegisterPushTokenHandler {
        @Deprecated
        public void onRegistered(SendBirdException var1);
    }

    public static enum PushTokenRegistrationStatus {
        SUCCESS,
        PENDING,
        ERROR;

    }

    public static class HMS {
        public static String getPendingPushToken() {
            return SendBird.getInstance().mPushToken;
        }

        public static void registerPushTokenForCurrentUser(String token, RegisterPushTokenWithStatusHandler handler) {
            HMS.registerPushTokenForCurrentUser(token, false, handler);
        }

        public static void registerPushTokenForCurrentUser(String token, boolean unique, RegisterPushTokenWithStatusHandler handler) {
            SendBird.registerPushTokenForCurrentUser(PushTokenType.HMS, token, unique, false, false, handler);
        }

        public static void unregisterPushTokenForCurrentUser(String token, UnregisterPushTokenHandler handler) {
            SendBird.unregisterPushTokenForCurrentUser(PushTokenType.HMS, token, handler);
        }

        public static void unregisterPushTokenAllForCurrentUser(UnregisterPushTokenHandler handler) {
            SendBird.unregisterPushTokenAllForCurrentUser(handler);
        }

        public static void getMyPushTokensByToken(String token, PushTokenType type, GetPushTokensHandler handler) {
            SendBird.getMyPushTokensByToken(token, type, handler);
        }

        public static void setDoNotDisturb(boolean doNotDisturbOn, int startHour, int startMin, int endHour, int endMin, String timezone, SetDoNotDisturbHandler handler) {
            SendBird.setDoNotDisturb(doNotDisturbOn, startHour, startMin, endHour, endMin, timezone, handler);
        }

        public static void getDoNotDisturb(GetDoNotDisturbHandler handler) {
            SendBird.getDoNotDisturb(handler);
        }

        public static void setSnoozePeriod(boolean snoozeOn, long startTs, long endTs, SetSnoozePeriodHandler handler) {
            SendBird.setSnoozePeriod(snoozeOn, startTs, endTs, handler);
        }

        public static void getSnoozePeriod(GetSnoozePeriodHandler handler) {
            SendBird.getSnoozePeriod(handler);
        }

        public static void setPushSound(String sound, SetPushSoundHandler handler) {
            SendBird.setPushSound(sound, handler);
        }

        public static void getPushSound(GetPushSoundHandler handler) {
            SendBird.getPushSound(handler);
        }

        public static void setPushTemplate(String templateName, SetPushTemplateHandler handler) {
            SendBird.setPushTemplate(templateName, handler);
        }

        public static void getPushTemplate(GetPushTemplateHandler handler) {
            SendBird.getPushTemplate(handler);
        }

        public static void setPushTriggerOption(PushTriggerOption pushTriggerOption, SetPushTriggerOptionHandler handler) {
            SendBird.setPushTriggerOption(pushTriggerOption, handler);
        }

        public static void getPushTriggerOption(GetPushTriggerOptionHandler handler) {
            SendBird.getPushTriggerOption(handler);
        }
    }

    public static enum PushTriggerOption {
        ALL("all"),
        OFF("off"),
        MENTION_ONLY("mention_only");

        private String value;

        private PushTriggerOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PushTriggerOption from(String value) {
            for (PushTriggerOption option : PushTriggerOption.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return ALL;
        }
    }

    public static enum PushTokenType {
        GCM("gcm"),
        APNS("apns"),
        APNS_VOIP("apns_voip"),
        HMS("huawei");

        private String value;

        private PushTokenType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PushTokenType from(String value) {
            for (PushTokenType type : PushTokenType.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            return GCM;
        }
    }

    public static interface DisconnectHandler {
        public void onDisconnected();
    }

    static interface LocalNetworkHandler {
        public void onLocalUnexpectedDisconnect();

        public void onLocalReconnected();

        public void onLocalReconnectFailed();
    }

    public static interface ConnectionHandler {
        public void onReconnectStarted();

        public void onReconnectSucceeded();

        public void onReconnectFailed();
    }

    public static abstract class UserEventHandler {
        public abstract void onFriendsDiscovered(List<User> var1);

        public void onTotalUnreadMessageCountChanged(int totalCount, Map<String, Integer> totalCountByCustomType) {
        }
    }

    public static abstract class ChannelHandler {
        public abstract void onMessageReceived(BaseChannel var1, BaseMessage var2);

        public void onMentionReceived(BaseChannel channel, BaseMessage message) {
        }

        public void onMessageDeleted(BaseChannel channel, long msgId) {
        }

        public void onMessageUpdated(BaseChannel channel, BaseMessage message) {
        }

        public void onChannelChanged(BaseChannel channel) {
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
        }

        public void onReactionUpdated(BaseChannel channel, ReactionEvent reactionEvent) {
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
        }

        public void onDeliveryReceiptUpdated(GroupChannel channel) {
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
        }

        public void onUserReceivedInvitation(GroupChannel channel, User inviter, List<User> invitees) {
        }

        public void onUserJoined(GroupChannel channel, User user) {
        }

        public void onUserDeclinedInvitation(GroupChannel channel, User inviter, User invitee) {
        }

        public void onUserLeft(GroupChannel channel, User user) {
        }

        public void onUserEntered(OpenChannel channel, User user) {
        }

        public void onUserExited(OpenChannel channel, User user) {
        }

        public void onUserMuted(BaseChannel channel, User user) {
        }

        public void onUserUnmuted(BaseChannel channel, User user) {
        }

        public void onUserBanned(BaseChannel channel, User user) {
        }

        public void onUserUnbanned(BaseChannel channel, User user) {
        }

        public void onChannelFrozen(BaseChannel channel) {
        }

        public void onChannelUnfrozen(BaseChannel channel) {
        }

        public void onMetaDataCreated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataUpdated(BaseChannel channel, Map<String, String> metaDataMap) {
        }

        public void onMetaDataDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onMetaCountersCreated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersUpdated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
        }

        public void onMetaCountersDeleted(BaseChannel channel, List<String> keys) {
        }

        public void onChannelHidden(GroupChannel channel) {
        }

        public void onOperatorUpdated(BaseChannel channel) {
        }

        public void onThreadInfoUpdated(BaseChannel channel, ThreadInfoUpdateEvent threadInfoUpdateEvent) {
        }
    }

    public static interface ConnectHandler {
        public void onConnected(User var1, SendBirdException var2);
    }

    public static class Options {
        static boolean useMemberAsMessageSender = true;
        static ThreadOption mThreadOption = ThreadOption.UI_THREAD;
        static Handler mHandlerForThreadOption;
        static int connectionTimeout;
        static int authenticationTimeout;
        static int typingIndicatorThrottle;
        static int wsResponseTimeoutSec;

        static void init() {
            useMemberAsMessageSender = true;
            mThreadOption = ThreadOption.UI_THREAD;
            connectionTimeout = 10;
            authenticationTimeout = 10;
            typingIndicatorThrottle = 1000;
        }

        public static void useMemberAsMessageSender(boolean tf) {
            useMemberAsMessageSender = tf;
        }

        @Deprecated
        public static void useUiThreadForCallbacks(boolean tf) {
            mThreadOption = tf ? ThreadOption.UI_THREAD : ThreadOption.NEW_THREAD;
        }

        @Deprecated
        public static void setHandlerForCallbacks(Handler handler) {
            if (handler != null) {
                mThreadOption = ThreadOption.HANDLER;
                mHandlerForThreadOption = handler;
            } else {
                mThreadOption = ThreadOption.UI_THREAD;
            }
        }

        public static void setThreadOption(ThreadOption threadOption, Handler handler) {
            if (threadOption != null) {
                mThreadOption = threadOption;
                if (threadOption == ThreadOption.HANDLER) {
                    mHandlerForThreadOption = handler;
                }
            }
        }

        public static void setConnectionTimeout(int connectionTimeout) {
            Options.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 10;
        }

        public static void setAuthenticationTimeout(int authenticationTimeout) {
            Options.authenticationTimeout = authenticationTimeout > 0 ? authenticationTimeout : 10;
        }

        public static void setTypingIndicatorThrottle(int msec) {
            if (msec >= 1000 && msec <= 9000) {
                typingIndicatorThrottle = msec;
            }
        }

        public static void setWebSocketResponseTimeout(int webSocketResponseTimeoutSec) {
            int MIN_TIMEOUT_SEC = 5;
            int MAX_TIMEOUT_SEC = 300;
            wsResponseTimeoutSec = IntRangeComparableUtils.coerceIn(webSocketResponseTimeoutSec, 5, 300);
        }

        static {
            connectionTimeout = 10;
            authenticationTimeout = 10;
            typingIndicatorThrottle = 1000;
            wsResponseTimeoutSec = 10;
        }

        public static enum ThreadOption {
            UI_THREAD,
            NEW_THREAD,
            HANDLER;

        }
    }

    private class ReconnectParams {
        float mInterval = 3.0f;
        float mMaxInterval = 24.0f;
        int mRetryCount = 5;
        int mMultiplier = 2;

        private ReconnectParams() {
        }
    }

    private static class SubscribedUnreadMessageCount {
        int mTotalCount;
        int mTotalCountByCustomTypes;
        Map<String, Integer> mCustomTypeMap;
        long mTimestamp;

        SubscribedUnreadMessageCount() {
            this.init();
        }

        void init() {
            this.mTotalCount = 0;
            this.mTotalCountByCustomTypes = 0;
            if (this.mCustomTypeMap == null) {
                this.mCustomTypeMap = new ConcurrentHashMap<String, Integer>();
            } else {
                this.mCustomTypeMap.clear();
            }
            this.mTimestamp = 0L;
        }

        boolean updateUnreadCount(JsonObject unreadCntObj) {
            long ts;
            boolean hasChanged = false;
            long l = ts = unreadCntObj.has("ts") ? unreadCntObj.get("ts").getAsLong() : 0L;
            if (ts > this.mTimestamp) {
                int newTotalCount;
                this.mTimestamp = ts;
                int n = newTotalCount = unreadCntObj.has("all") ? unreadCntObj.get("all").getAsInt() : this.mTotalCount;
                if (newTotalCount != this.mTotalCount) {
                    hasChanged = true;
                    this.mTotalCount = newTotalCount;
                }
                if (unreadCntObj.has("custom_types")) {
                    JsonObject customTypesObj = unreadCntObj.getAsJsonObject("custom_types");
                    for (Map.Entry entry : customTypesObj.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        String key = (String)entry.getKey();
                        int newValue = ((JsonElement)entry.getValue()).getAsInt();
                        if (this.mCustomTypeMap.containsKey(key) && this.mCustomTypeMap.get(key) == newValue) continue;
                        hasChanged = true;
                        this.mCustomTypeMap.put(key, newValue);
                    }
                    int newTotalCountByCustomTypes = 0;
                    for (Integer count : this.mCustomTypeMap.values()) {
                        if (count == null) continue;
                        newTotalCountByCustomTypes += count.intValue();
                    }
                    if (newTotalCountByCustomTypes != this.mTotalCountByCustomTypes) {
                        hasChanged = true;
                        this.mTotalCountByCustomTypes = newTotalCountByCustomTypes;
                    }
                }
            }
            return hasChanged;
        }
    }

    static enum ExtentionFrom {
        None("none", ""),
        Core("core", "c"),
        SyncManager("sb_syncmanager", "s"),
        UIKit("sb_uikit", "u");

        private String key;
        private String shortCut;

        private ExtentionFrom(String key, String shortCut) {
            this.key = key;
            this.shortCut = shortCut;
        }

        public String getValue(String value) {
            return this.shortCut + value;
        }

        public static ExtentionFrom from(String key) {
            for (ExtentionFrom value : ExtentionFrom.values()) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return None;
        }
    }

    public static enum ConnectionState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

