/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.User;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GroupChannelParams {
    List<String> mUserIds = new ArrayList<String>();
    List<String> mOperatorUserIds;
    Boolean mIsSuper;
    Boolean mIsPublic;
    Boolean mIsEphemeral;
    Boolean mIsDistinct;
    Boolean mIsDiscoverable;
    String mChannelUrl;
    String mName;
    Object mCoverUrlOrImage;
    String mData;
    String mCustomType;
    String mAccessCode;
    Boolean mStrict;
    Boolean isBroadcast;
    Integer messageSurvivalSeconds;

    public GroupChannelParams addUser(User user) {
        if (user != null && user.getUserId() != null && user.getUserId().length() > 0) {
            this.mUserIds.add(user.getUserId());
        }
        return this;
    }

    public GroupChannelParams addUsers(List<User> users) {
        if (users != null) {
            for (User user : users) {
                if (user == null || user.getUserId() == null || user.getUserId().length() <= 0) continue;
                this.mUserIds.add(user.getUserId());
            }
        }
        return this;
    }

    public GroupChannelParams addUserId(String userId) {
        if (userId != null && userId.length() > 0) {
            this.mUserIds.add(userId);
        }
        return this;
    }

    public GroupChannelParams addUserIds(List<String> userIds) {
        if (userIds != null) {
            for (String userId : userIds) {
                if (userId == null || userId.length() <= 0) continue;
                this.mUserIds.add(userId);
            }
        }
        return this;
    }

    public GroupChannelParams setSuper(boolean isSuper) {
        this.mIsSuper = isSuper;
        return this;
    }

    public GroupChannelParams setPublic(boolean isPublic) {
        this.mIsPublic = isPublic;
        return this;
    }

    public GroupChannelParams setEphemeral(boolean isEphemeral) {
        this.mIsEphemeral = isEphemeral;
        return this;
    }

    public GroupChannelParams setDistinct(boolean isDistinct) {
        this.mIsDistinct = isDistinct;
        return this;
    }

    public GroupChannelParams setDiscoverable(boolean isDiscoverable) {
        this.mIsDiscoverable = isDiscoverable;
        return this;
    }

    public GroupChannelParams setChannelUrl(String channelUrl) {
        this.mChannelUrl = channelUrl;
        return this;
    }

    public GroupChannelParams setName(String name) {
        this.mName = name;
        return this;
    }

    public GroupChannelParams setCoverUrl(String coverImageUrl) {
        this.mCoverUrlOrImage = coverImageUrl;
        return this;
    }

    public GroupChannelParams setCoverImage(File coverImageFile) {
        this.mCoverUrlOrImage = coverImageFile;
        return this;
    }

    public GroupChannelParams setData(String data) {
        this.mData = data;
        return this;
    }

    public GroupChannelParams setCustomType(String customType) {
        this.mCustomType = customType;
        return this;
    }

    public GroupChannelParams setOperators(List<User> operators) {
        if (this.mOperatorUserIds == null) {
            this.mOperatorUserIds = new ArrayList<String>();
        }
        this.mOperatorUserIds.clear();
        if (operators != null) {
            for (User user : operators) {
                if (user == null || user.getUserId() == null || user.getUserId().length() <= 0) continue;
                this.mOperatorUserIds.add(user.getUserId());
            }
        }
        return this;
    }

    public GroupChannelParams setOperatorUserIds(List<String> operatorUserIds) {
        if (this.mOperatorUserIds == null) {
            this.mOperatorUserIds = new ArrayList<String>();
        }
        this.mOperatorUserIds.clear();
        if (operatorUserIds != null) {
            for (String userId : operatorUserIds) {
                if (userId == null || userId.length() <= 0) continue;
                this.mOperatorUserIds.add(userId);
            }
        }
        return this;
    }

    public GroupChannelParams setAccessCode(String accessCode) {
        this.mAccessCode = accessCode;
        return this;
    }

    public GroupChannelParams setStrict(boolean strict) {
        this.mStrict = strict;
        return this;
    }

    public GroupChannelParams setBroadcast(boolean broadcast) {
        this.isBroadcast = broadcast;
        return this;
    }

    public GroupChannelParams setMessageSurvivalSeconds(int messageSurvivalSeconds) {
        this.messageSurvivalSeconds = messageSurvivalSeconds;
        return this;
    }

    public String toString() {
        return "GroupChannelParams{mUserIds=" + this.mUserIds + ", mOperatorUserIds=" + this.mOperatorUserIds + ", mIsSuper=" + this.mIsSuper + ", mIsPublic=" + this.mIsPublic + ", mIsEphemeral=" + this.mIsEphemeral + ", mIsDistinct=" + this.mIsDistinct + ", mIsDiscoverable=" + this.mIsDiscoverable + ", mChannelUrl='" + this.mChannelUrl + '\'' + ", mName='" + this.mName + '\'' + ", mCoverUrlOrImage=" + this.mCoverUrlOrImage + ", mData='" + this.mData + '\'' + ", mCustomType='" + this.mCustomType + '\'' + ", mAccessCode='" + this.mAccessCode + '\'' + ", mStrict=" + this.mStrict + ", isBroadcast=" + this.isBroadcast + ", messageSurvivalSeconds=" + this.messageSurvivalSeconds + '}';
    }
}

