/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.ThreadInfo;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;

public final class FileMessage
extends BaseMessage {
    private String mUrl;
    private String mName;
    private int mSize;
    private String mType;
    private String mReqId;
    private List<Thumbnail> mThumbnails;
    private boolean mRequireAuth;

    static JsonElement build(String requestId, BaseMessage.SendingStatus sendingStatus, long msgId, long rootMessageId, long parentMessageId, Sender sender, String channelUrl, String channelType, String url, String name, String type, int size, String data, String customType, String thumbnails, boolean requireAuth, long createdAt, long updatedAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String reactions, String metaArray, String metaArrayKeyOrder, String sortedMetaArray, boolean isGlobalBlocked, int errorCode, boolean isSilent, boolean forceUpdateLastMessage, int messageSurvivalSeconds, String parentMessageText, ThreadInfo threadInfo) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("request_state", sendingStatus.getValue());
        obj.addProperty("msg_id", (Number)msgId);
        obj.addProperty("root_message_id", (Number)rootMessageId);
        obj.addProperty("parent_message_id", (Number)parentMessageId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType);
        obj.addProperty("ts", (Number)createdAt);
        obj.addProperty("updated_at", (Number)updatedAt);
        obj.addProperty("url", url);
        obj.addProperty("name", name);
        obj.addProperty("type", type);
        obj.addProperty("size", (Number)size);
        if (data != null) {
            obj.addProperty("custom", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (thumbnails != null) {
            obj.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        if (requireAuth) {
            obj.addProperty("require_auth", Boolean.valueOf(requireAuth));
        }
        if (sender != null) {
            JsonObject userObj = sender.toJson().getAsJsonObject();
            obj.add("user", (JsonElement)userObj);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                if (mentionedUserId == null || mentionedUserId.length() <= 0) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", (JsonElement)array);
        }
        if (mentionedUsers != null) {
            obj.add("mentioned_users", new JsonParser().parse(mentionedUsers));
        }
        if (reactions != null) {
            obj.add("reactions", new JsonParser().parse(reactions));
        }
        if (metaArray != null) {
            obj.add("metaarray", new JsonParser().parse(metaArray));
        }
        if (metaArrayKeyOrder != null) {
            obj.add("metaarray_key_order", new JsonParser().parse(metaArrayKeyOrder));
        }
        if (sortedMetaArray != null) {
            obj.add("sorted_metaarray", new JsonParser().parse(sortedMetaArray));
        }
        obj.addProperty("is_global_block", Boolean.valueOf(isGlobalBlocked));
        obj.addProperty("error_code", (Number)errorCode);
        obj.addProperty("silent", Boolean.valueOf(isSilent));
        obj.addProperty("force_update_last_message", Boolean.valueOf(forceUpdateLastMessage));
        obj.addProperty("message_survival_seconds", (Number)messageSurvivalSeconds);
        if (parentMessageText != null) {
            obj.addProperty("parent_message_text", parentMessageText);
        }
        obj.add("thread_info", threadInfo.toJson());
        return obj;
    }

    FileMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mUrl = obj.has("url") ? obj.get("url").getAsString() : "";
        this.mName = obj.has("name") ? obj.get("name").getAsString() : "File";
        this.mSize = obj.has("size") ? obj.get("size").getAsInt() : 0;
        this.mType = obj.has("type") ? obj.get("type").getAsString() : "";
        this.mData = obj.has("custom") ? obj.get("custom").getAsString() : "";
        this.mReqId = "";
        if (obj.has("request_id")) {
            this.mReqId = obj.get("request_id").getAsString();
        }
        if (obj.has("req_id")) {
            this.mReqId = obj.get("req_id").getAsString();
        }
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mRequireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
        this.mThumbnails = new ArrayList<Thumbnail>();
        if (obj.has("thumbnails")) {
            JsonArray thumbnailsArray = obj.get("thumbnails").getAsJsonArray();
            for (JsonElement element : thumbnailsArray) {
                Thumbnail thumbnail = new Thumbnail(element, this.mRequireAuth);
                this.mThumbnails.add(thumbnail);
            }
        }
        if (this.getSendingStatus() != BaseMessage.SendingStatus.SUCCEEDED && obj.has("file")) {
            JsonObject file = obj.get("file").getAsJsonObject();
            this.mUrl = file.has("url") ? file.get("url").getAsString() : "";
            this.mName = file.has("name") ? file.get("name").getAsString() : "File";
            this.mSize = file.has("size") ? file.get("size").getAsInt() : 0;
            this.mType = file.has("type") ? file.get("type").getAsString() : "";
            this.mData = file.has("data") ? file.get("data").getAsString() : "";
        }
        this.mErrorCode = obj.has("error_code") ? obj.get("error_code").getAsInt() : 0;
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", BaseChannel.MessageTypeFilter.FILE.value());
        obj.addProperty("req_id", this.mReqId);
        JsonObject fileObj = new JsonObject();
        fileObj.addProperty("url", this.mUrl);
        fileObj.addProperty("name", this.mName);
        fileObj.addProperty("type", this.mType);
        fileObj.addProperty("size", (Number)this.mSize);
        fileObj.addProperty("data", this.mData);
        obj.add("file", (JsonElement)fileObj);
        obj.addProperty("custom_type", this.mCustomType);
        if (this.mRequireAuth) {
            obj.addProperty("require_auth", Boolean.valueOf(this.mRequireAuth));
        }
        JsonArray thumbnailObj = new JsonArray();
        for (Thumbnail thumbnail : this.mThumbnails) {
            thumbnailObj.add(thumbnail.toJson());
        }
        obj.add("thumbnails", (JsonElement)thumbnailObj);
        obj.addProperty("error_code", (Number)this.mErrorCode);
        return obj;
    }

    boolean requiredAuth() {
        return this.mRequireAuth;
    }

    @Override
    public String getMessage() {
        return "File Message";
    }

    @Override
    public String getRequestId() {
        return this.mReqId;
    }

    public String getUrl() {
        if (this.mRequireAuth) {
            return String.format("%s?auth=%s", this.mUrl, SendBird.getEkey());
        }
        return this.mUrl;
    }

    public String getPlainUrl() {
        return this.mUrl;
    }

    public String getName() {
        return this.mName;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getType() {
        return this.mType;
    }

    public List<Thumbnail> getThumbnails() {
        return this.mThumbnails;
    }

    @Deprecated
    public RequestState getRequestState() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED) {
            return RequestState.SUCCEEDED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.FAILED) {
            return RequestState.FAILED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING) {
            return RequestState.PENDING;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return RequestState.FAILED;
        }
        return RequestState.NONE;
    }

    public List<String> getRequestedMentionUserIds() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING || this.getSendingStatus() == BaseMessage.SendingStatus.FAILED || this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return this.getMentionedUserIds();
        }
        return new ArrayList<String>();
    }

    @Override
    public String toString() {
        return super.toString() + "\nFileMessage{, mUrl='" + this.mUrl + '\'' + ", mName='" + this.mName + '\'' + ", mSize=" + this.mSize + ", mType='" + this.mType + '\'' + ", mReqId='" + this.mReqId + '\'' + ", mThumbnails=" + this.mThumbnails + ", mRequireAuth=" + this.mRequireAuth + '}';
    }

    public static class ThumbnailSize {
        private int mMaxWidth;
        private int mMaxHeight;

        public ThumbnailSize(int maxWidth, int maxHeight) {
            this.mMaxWidth = maxWidth >= 0 ? maxWidth : 0;
            this.mMaxHeight = maxHeight >= 0 ? maxHeight : 0;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ThumbnailSize size = (ThumbnailSize)o;
            return this.getMaxWidth() == size.getMaxWidth() && this.getMaxHeight() == size.getMaxHeight();
        }

        public int hashCode() {
            return HashUtils.generateHashCode(this.getMaxWidth(), this.getMaxHeight());
        }

        public String toString() {
            return "ThumbnailSize{mMaxWidth=" + this.mMaxWidth + ", mMaxHeight=" + this.mMaxHeight + '}';
        }
    }

    public static class Thumbnail {
        private int mMaxWidth;
        private int mMaxHeight;
        private int mRealWidth;
        private int mRealHeight;
        private String mUrl;
        private boolean mRequireAuth;

        private Thumbnail(JsonElement el, boolean requireAuth) {
            JsonObject obj = el.getAsJsonObject();
            this.mMaxWidth = obj.has("width") ? obj.get("width").getAsInt() : 0;
            this.mMaxHeight = obj.has("height") ? obj.get("height").getAsInt() : 0;
            this.mRealWidth = obj.has("real_width") ? obj.get("real_width").getAsInt() : -1;
            this.mRealHeight = obj.has("real_height") ? obj.get("real_height").getAsInt() : -1;
            this.mUrl = obj.has("url") ? obj.get("url").getAsString() : "";
            this.mRequireAuth = requireAuth;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public int getRealWidth() {
            return this.mRealWidth;
        }

        public int getRealHeight() {
            return this.mRealHeight;
        }

        public String getUrl() {
            if (this.mRequireAuth) {
                return String.format("%s?auth=%s", this.mUrl, SendBird.getEkey());
            }
            return this.mUrl;
        }

        public String getPlainUrl() {
            return this.mUrl;
        }

        JsonElement toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("width", (Number)this.mMaxWidth);
            obj.addProperty("height", (Number)this.mMaxHeight);
            obj.addProperty("real_width", (Number)this.mRealWidth);
            obj.addProperty("real_height", (Number)this.mRealHeight);
            obj.addProperty("url", this.mUrl);
            return obj;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Thumbnail other = (Thumbnail)o;
            return this.getMaxWidth() == other.getMaxWidth() && this.getMaxHeight() == other.getMaxHeight() && this.getRealWidth() == other.getRealWidth() && this.getRealHeight() == other.getRealHeight() && this.getUrl().equals(other.getUrl()) && this.mRequireAuth == other.mRequireAuth;
        }

        public int hashCode() {
            return HashUtils.generateHashCode(this.getMaxWidth(), this.getMaxHeight(), this.getRealWidth(), this.getRealHeight(), this.getUrl(), this.mRequireAuth);
        }

        public String toString() {
            return "Thumbnail{mMaxWidth=" + this.mMaxWidth + ", mMaxHeight=" + this.mMaxHeight + ", mRealWidth=" + this.mRealWidth + ", mRealHeight=" + this.mRealHeight + ", mUrl='" + this.mUrl + '\'' + ", mRequireAuth=" + this.mRequireAuth + '}';
        }
    }

    @Deprecated
    public static enum RequestState {
        NONE,
        PENDING,
        FAILED,
        SUCCEEDED;

    }
}

