/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public class User {
    private String mNickname;
    private String mProfileUrl;
    private String mUserId;
    private ConnectionStatus mConnectionStatus;
    private long mLastSeenAt;

    static JsonElement build(String userId, String nickname, String profileUrl, boolean isOnline, long lastSeenAt) {
        JsonObject obj = new JsonObject();
        obj.addProperty("user_id", userId);
        obj.addProperty("nickname", nickname);
        obj.addProperty("profile_url", profileUrl);
        obj.addProperty("is_online", isOnline);
        obj.addProperty("last_seen_at", lastSeenAt);
        return obj;
    }

    protected User(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("guest_id")) {
            this.mUserId = obj.get("guest_id").getAsString();
        }
        if (obj.has("user_id")) {
            this.mUserId = obj.get("user_id").getAsString();
        }
        if (obj.has("name")) {
            this.mNickname = obj.get("name").getAsString();
        }
        if (obj.has("nickname")) {
            this.mNickname = obj.get("nickname").getAsString();
        }
        if (obj.has("image")) {
            this.mProfileUrl = obj.get("image").getAsString();
        }
        if (obj.has("profile_url")) {
            this.mProfileUrl = obj.get("profile_url").getAsString();
        }
        this.mConnectionStatus = obj.has("is_online") ? (obj.get("is_online").getAsBoolean() ? ConnectionStatus.ONLINE : ConnectionStatus.OFFLINE) : ConnectionStatus.NON_AVAILABLE;
        this.mLastSeenAt = obj.has("last_seen_at") ? obj.get("last_seen_at").getAsLong() : 0L;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getNickname() {
        return this.mNickname;
    }

    public String getProfileUrl() {
        return this.mProfileUrl;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.mConnectionStatus;
    }

    public long getLastSeenAt() {
        return this.mLastSeenAt;
    }

    void setUserId(String userId) {
        this.mUserId = userId;
    }

    void setNickname(String nickname) {
        this.mNickname = nickname;
    }

    void setProfileUrl(String profileUrl) {
        this.mProfileUrl = profileUrl;
    }

    public static enum ConnectionStatus {
        NON_AVAILABLE,
        ONLINE,
        OFFLINE;

    }
}

