/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.APIClient;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class User {
    private String mUserId;
    private String mNickname;
    private String mProfileUrl;
    private String mFriendDiscoveryKey;
    private String mFriendName;
    private Map<String, String> mMetaData;
    private ConnectionStatus mConnectionStatus;
    private long mLastSeenAt;
    private boolean mIsActive = true;
    private List<String> mPreferredLanguages;

    protected User(JsonElement el) {
        if (el.isJsonNull()) {
            return;
        }
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("guest_id")) {
            this.mUserId = obj.get("guest_id").getAsString();
        }
        if (obj.has("user_id")) {
            this.mUserId = obj.get("user_id").getAsString();
        }
        if (obj.has("name")) {
            this.mNickname = obj.get("name").getAsString();
        }
        if (obj.has("nickname")) {
            this.mNickname = obj.get("nickname").getAsString();
        }
        if (obj.has("image")) {
            this.mProfileUrl = obj.get("image").getAsString();
        }
        if (obj.has("profile_url")) {
            this.mProfileUrl = obj.get("profile_url").getAsString();
        }
        if (obj.has("friend_discovery_key") && !obj.get("friend_discovery_key").isJsonNull()) {
            this.mFriendDiscoveryKey = obj.get("friend_discovery_key").getAsString();
        }
        if (obj.has("friend_name") && !obj.get("friend_name").isJsonNull()) {
            this.mFriendName = obj.get("friend_name").getAsString();
        }
        this.mMetaData = new ConcurrentHashMap<String, String>();
        if (obj.has("metadata")) {
            for (Map.Entry entry : obj.get("metadata").getAsJsonObject().entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                this.mMetaData.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        this.mConnectionStatus = obj.has("is_online") ? (obj.get("is_online").getAsBoolean() ? ConnectionStatus.ONLINE : ConnectionStatus.OFFLINE) : ConnectionStatus.NON_AVAILABLE;
        this.mLastSeenAt = obj.has("last_seen_at") ? obj.get("last_seen_at").getAsLong() : 0L;
        this.mIsActive = !obj.has("is_active") || obj.get("is_active").getAsBoolean();
        this.parsePreferredLanguages(obj);
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        if (this.mUserId != null) {
            obj.addProperty("user_id", this.mUserId);
        }
        if (this.mNickname != null) {
            obj.addProperty("nickname", this.mNickname);
        }
        if (this.mProfileUrl != null) {
            obj.addProperty("profile_url", this.mProfileUrl);
        }
        if (this.mFriendDiscoveryKey != null) {
            obj.addProperty("friend_discovery_key", this.mFriendDiscoveryKey);
        }
        if (this.mFriendName != null) {
            obj.addProperty("friend_name", this.mFriendName);
        }
        if (this.mMetaData != null && this.mMetaData.size() > 0) {
            JsonObject metas = new JsonObject();
            for (Map.Entry<String, String> entry : this.mMetaData.entrySet()) {
                metas.addProperty(entry.getKey(), entry.getValue());
            }
            obj.add("metadata", (JsonElement)metas);
        }
        if (this.mConnectionStatus == ConnectionStatus.ONLINE) {
            obj.addProperty("is_online", Boolean.valueOf(true));
        } else if (this.mConnectionStatus == ConnectionStatus.OFFLINE) {
            obj.addProperty("is_online", Boolean.valueOf(false));
        }
        obj.addProperty("last_seen_at", (Number)this.mLastSeenAt);
        obj.addProperty("is_active", Boolean.valueOf(this.mIsActive));
        if (this.mPreferredLanguages != null) {
            JsonArray preferredLanguagesArray = new JsonArray();
            for (String preferredLanguage : this.mPreferredLanguages) {
                preferredLanguagesArray.add(preferredLanguage);
            }
            obj.add("preferred_languages", (JsonElement)preferredLanguagesArray);
        }
        return obj;
    }

    public static User buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new User(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getNickname() {
        return this.mNickname;
    }

    public String getProfileUrl() {
        return this.mProfileUrl;
    }

    public String getOriginalProfileUrl() {
        try {
            if (this.mProfileUrl != null) {
                URL url = new URL(this.mProfileUrl);
                String protocol = url.getProtocol();
                String host = url.getHost();
                String path = url.getPath();
                if ((protocol.toLowerCase().equals("https") || protocol.toLowerCase().equals("http")) && (host.contains("sendbird.com") || host.contains("intoz.com")) && path.contains("/profile_images/")) {
                    return this.mProfileUrl.replace("/profile_images/", "/");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getFriendDiscoveryKey() {
        return this.mFriendDiscoveryKey;
    }

    public String getFriendName() {
        return this.mFriendName;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.mConnectionStatus;
    }

    public long getLastSeenAt() {
        return this.mLastSeenAt;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    void setUserId(String userId) {
        this.mUserId = userId;
    }

    void setNickname(String nickname) {
        this.mNickname = nickname;
    }

    void setProfileUrl(String profileUrl) {
        this.mProfileUrl = profileUrl;
    }

    void setFriendDiscoveryKey(String discoveryKey) {
        this.mFriendDiscoveryKey = discoveryKey;
    }

    void setFriendName(String friendName) {
        this.mFriendName = friendName;
    }

    void setPreferredLanguages(List<String> preferredLanguages) {
        this.mPreferredLanguages = preferredLanguages;
    }

    void parsePreferredLanguages(JsonObject obj) {
        ArrayList<String> preferredLanguages = null;
        if (obj.has("preferred_languages")) {
            JsonArray array = obj.getAsJsonArray("preferred_languages");
            preferredLanguages = new ArrayList<String>();
            if (array.size() > 0) {
                for (int i = 0; i < array.size(); ++i) {
                    preferredLanguages.add(array.get(i).getAsString());
                }
            }
        }
        this.setPreferredLanguages(preferredLanguages);
    }

    void updatePropertiesByUser(User destUser) {
        if (!this.getNickname().equals(destUser.getNickname())) {
            this.setNickname(destUser.getNickname());
        }
        if (!this.getProfileUrl().equals(destUser.getProfileUrl())) {
            this.setProfileUrl(destUser.getProfileUrl());
        }
        if (!this.getMetaData().equals(destUser.getMetaData())) {
            this.getMetaData().putAll(destUser.getMetaData());
        }
    }

    public void createMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().createUserMetaData(this.mUserId, metaDataMap, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap result = new HashMap();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    User.this.mMetaData.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public void updateMetaData(Map<String, String> metaDataMap, final MetaDataHandler handler) {
        if (metaDataMap == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateUserMetaData(this.mUserId, metaDataMap, true, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final HashMap result = new HashMap();
                JsonObject obj = response.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    result.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    User.this.mMetaData.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(result, null);
                        }
                    });
                }
            }
        });
    }

    public String getMetaData(String key) {
        return this.mMetaData.get(key);
    }

    public Map<String, String> getMetaData() {
        return this.mMetaData;
    }

    public List<String> getPreferredLanguages() {
        return this.mPreferredLanguages;
    }

    public void deleteMetaData(final String key, final DeleteMetaDataHandler handler) {
        if (key == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().deleteUserMetaData(this.mUserId, key, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                User.this.mMetaData.remove(key);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void deleteAllMetaData(final DeleteMetaDataHandler handler) {
        APIClient.getInstance().deleteAllUserMetaData(this.mUserId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null && handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(e);
                        }
                    });
                }
                User.this.mMetaData.clear();
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.getUserId().equals(user.getUserId());
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getUserId());
    }

    public String toString() {
        return "User{mUserId='" + this.mUserId + '\'' + ", mNickname='" + this.mNickname + '\'' + ", mProfileUrl='" + this.mProfileUrl + '\'' + ", mFriendDiscoveryKey='" + this.mFriendDiscoveryKey + '\'' + ", mFriendName='" + this.mFriendName + '\'' + ", mMetaData=" + this.mMetaData + ", mConnectionStatus=" + (Object)((Object)this.mConnectionStatus) + ", mLastSeenAt=" + this.mLastSeenAt + ", mIsActive=" + this.mIsActive + ", mPreferredLanguages=" + this.mPreferredLanguages + '}';
    }

    public static interface DeleteMetaDataHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface MetaDataHandler {
        public void onResult(Map<String, String> var1, SendBirdException var2);
    }

    public static enum ConnectionStatus {
        NON_AVAILABLE,
        ONLINE,
        OFFLINE;

    }
}

