/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

class HashUtils {
    HashUtils() {
    }

    static int generateHashCode(Object ... values) {
        int result = 17;
        for (Object element : values) {
            result = 31 * result + (element == null ? 0 : HashUtils.generateSingleHashCode(element));
        }
        return result;
    }

    private static int generateSingleHashCode(Object value) {
        if (value instanceof Integer || value instanceof Character || value instanceof Short || value instanceof Byte) {
            return (Integer)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1231 : 1237;
        }
        if (value instanceof Float) {
            return Float.floatToIntBits(((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return HashUtils.generateLongHashCode((Long)value);
        }
        if (value instanceof Double) {
            return HashUtils.generateDoubleHashCode((Double)value);
        }
        return value.hashCode();
    }

    private static int generateLongHashCode(Long value) {
        return (int)(value ^ value >>> 32);
    }

    private static int generateDoubleHashCode(Double value) {
        return HashUtils.generateLongHashCode(Double.doubleToLongBits(value));
    }
}

