/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.HashUtils;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBird;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Reaction
implements Comparable<Reaction> {
    private final String key;
    private long updatedAt;
    private final List<String> userIds = new ArrayList<String>();
    private final Map<String, Long> reactionUpdateMap = new ConcurrentHashMap<String, Long>();

    Reaction(ReactionEvent reactionEvent) {
        this.key = reactionEvent.getKey();
        this.updatedAt = reactionEvent.getUpdatedAt();
        this.userIds.add(reactionEvent.getUserId());
        this.reactionUpdateMap.put(reactionEvent.getUserId(), reactionEvent.getUpdatedAt());
    }

    Reaction(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.key = obj.get("key").getAsString();
        long l = this.updatedAt = obj.has("latest_updated_at") ? obj.get("latest_updated_at").getAsLong() : 0L;
        if (obj.has("user_ids")) {
            JsonArray array = obj.getAsJsonArray("user_ids");
            for (int i = 0; i < array.size(); ++i) {
                if (array.get(i) == null) continue;
                String userId = array.get(i).getAsString();
                this.userIds.add(userId);
                this.reactionUpdateMap.put(userId, this.updatedAt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("key", this.key);
        obj.addProperty("latest_updated_at", (Number)this.updatedAt);
        List<String> list = this.userIds;
        synchronized (list) {
            if (this.userIds.size() > 0) {
                JsonArray array = new JsonArray();
                for (String userId : this.userIds) {
                    if (userId == null) continue;
                    array.add(userId);
                }
                obj.add("user_ids", (JsonElement)array);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean merge(ReactionEvent reactionEvent) {
        Long userUpdatedAt;
        if (this.updatedAt < reactionEvent.getUpdatedAt()) {
            this.updatedAt = reactionEvent.getUpdatedAt();
        }
        if ((userUpdatedAt = this.reactionUpdateMap.get(reactionEvent.getUserId())) == null) {
            userUpdatedAt = 0L;
        }
        if (userUpdatedAt > reactionEvent.getUpdatedAt()) {
            return false;
        }
        userUpdatedAt = reactionEvent.getUpdatedAt();
        this.reactionUpdateMap.put(reactionEvent.getUserId(), userUpdatedAt);
        List<String> list = this.userIds;
        synchronized (list) {
            this.userIds.remove(reactionEvent.getUserId());
            if (reactionEvent.getOperation() == ReactionEvent.ReactionEventAction.ADD) {
                this.userIds.add(reactionEvent.getUserId());
            }
        }
        return true;
    }

    public static Reaction buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new Reaction(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getKey() {
        return this.key;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public List<String> getUserIds() {
        return Collections.unmodifiableList(this.userIds);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Reaction reaction = (Reaction)o;
        return this.getKey().equals(reaction.getKey());
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getKey());
    }

    public String toString() {
        return "Reaction{key='" + this.key + '\'' + ", updatedAt=" + this.updatedAt + ", userIds=" + this.userIds + '}';
    }

    @Override
    public int compareTo(Reaction reaction) {
        return (int)(this.updatedAt - reaction.updatedAt);
    }

    public static Reaction clone(Reaction reaction) {
        return new Reaction(reaction.toJson());
    }
}

