/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.HashUtils;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public final class ReadStatus {
    private User mReader;
    private long mTimestamp;
    private String mChannelUrl;
    private String mChannelType;

    ReadStatus(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mReader = new User(obj.get("user"));
        this.mTimestamp = obj.get("ts").getAsLong();
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.mChannelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : BaseChannel.ChannelType.GROUP.value();
    }

    ReadStatus(User user, long timestamp) {
        this.mReader = user;
        this.mTimestamp = timestamp;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public User getReader() {
        return this.mReader;
    }

    String getChannelUrl() {
        return this.mChannelUrl;
    }

    String getChannelType() {
        return this.mChannelType;
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getChannelUrl(), this.getTimestamp(), this.getReader());
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ReadStatus status = (ReadStatus)o;
        return this.getChannelUrl().equals(status.getChannelUrl()) && this.getTimestamp() == status.getTimestamp() && this.getReader().equals(status.getReader());
    }

    public String toString() {
        return "ReadStatus{mReader=" + this.mReader + ", mTimestamp=" + this.mTimestamp + ", mChannelUrl='" + this.mChannelUrl + '\'' + ", mChannelType='" + this.mChannelType + '\'' + '}';
    }
}

