/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ThreadInfo {
    private final List<User> mostRepliedUsers;
    private long lastRepliedAt;
    private int replyCount;
    private long updatedAt;

    protected ThreadInfo() {
        this.mostRepliedUsers = new ArrayList<User>();
        this.lastRepliedAt = 0L;
        this.updatedAt = 0L;
        this.replyCount = 0;
    }

    protected ThreadInfo(JsonElement jsonElement) {
        JsonArray arr;
        JsonObject obj = jsonElement.getAsJsonObject();
        ArrayList<User> members = new ArrayList<User>();
        JsonArray jsonArray = arr = obj.has("most_replies") ? obj.get("most_replies").getAsJsonArray() : null;
        if (arr != null) {
            for (JsonElement element : arr) {
                members.add(new User(element));
            }
        }
        this.mostRepliedUsers = members;
        this.lastRepliedAt = obj.has("last_replied_at") ? obj.get("last_replied_at").getAsLong() : 0L;
        this.updatedAt = obj.has("updated_at") ? (long)obj.get("updated_at").getAsInt() : 0L;
        this.replyCount = obj.has("reply_count") ? obj.get("reply_count").getAsInt() : 0;
    }

    synchronized JsonElement toJson() {
        JsonObject obj = new JsonObject();
        if (this.mostRepliedUsers != null && !this.mostRepliedUsers.isEmpty()) {
            JsonArray array = new JsonArray();
            for (User user : this.mostRepliedUsers) {
                if (user == null) continue;
                array.add(user.toJson());
            }
            obj.add("most_replies", (JsonElement)array);
        }
        obj.addProperty("last_replied_at", (Number)this.lastRepliedAt);
        obj.addProperty("updated_at", (Number)this.updatedAt);
        obj.addProperty("reply_count", (Number)this.replyCount);
        return obj;
    }

    synchronized boolean merge(ThreadInfo threadInfo) {
        if (threadInfo.getUpdatedAt() < this.updatedAt) {
            return false;
        }
        this.mostRepliedUsers.clear();
        this.mostRepliedUsers.addAll(threadInfo.getMostRepliedUsers());
        this.lastRepliedAt = threadInfo.getLastRepliedAt();
        this.replyCount = threadInfo.getReplyCount();
        this.updatedAt = threadInfo.getUpdatedAt();
        return true;
    }

    public static ThreadInfo buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            return new ThreadInfo((JsonElement)obj);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<User> getMostRepliedUsers() {
        return Collections.unmodifiableList(this.mostRepliedUsers);
    }

    public long getLastRepliedAt() {
        return this.lastRepliedAt;
    }

    public int getReplyCount() {
        return this.replyCount;
    }

    long getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ThreadInfo that = (ThreadInfo)o;
        return this.lastRepliedAt == that.lastRepliedAt && this.replyCount == that.replyCount && this.mostRepliedUsers.equals(that.mostRepliedUsers);
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.mostRepliedUsers, this.lastRepliedAt, this.replyCount);
    }

    public String toString() {
        return "ThreadInfo{mostRepliedUsers=" + this.mostRepliedUsers + ", lastRepliedAt=" + this.lastRepliedAt + ", replyCount=" + this.replyCount + ", updatedAt=" + this.updatedAt + '}';
    }
}

