/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.Emoji;
import com.sendbird.android.HashUtils;
import com.sendbird.android.SendBird;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmojiCategory {
    private final String id;
    private final String name;
    private final String url;
    private final List<Emoji> emojis = new ArrayList<Emoji>();

    EmojiCategory(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.id = obj.has("id") ? obj.get("id").getAsString() : "";
        this.name = obj.has("name") ? obj.get("name").getAsString() : "";
        String string = this.url = obj.has("url") ? obj.get("url").getAsString() : "";
        if (obj.has("emojis")) {
            JsonArray array = obj.getAsJsonArray("emojis");
            for (int i = 0; i < array.size(); ++i) {
                if (array.get(i) == null) continue;
                JsonObject emoji = array.get(i).getAsJsonObject();
                this.emojis.add(new Emoji((JsonElement)emoji));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", this.id);
        obj.addProperty("name", this.name);
        obj.addProperty("url", this.url);
        List<Emoji> list = this.emojis;
        synchronized (list) {
            if (this.emojis.size() > 0) {
                JsonArray array = new JsonArray();
                for (Emoji emoji : this.emojis) {
                    if (emoji == null) continue;
                    array.add(emoji.toJson());
                }
                obj.add("emojis", (JsonElement)array);
            }
        }
        return obj;
    }

    public static EmojiCategory buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new EmojiCategory(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Emoji> getEmojis() {
        return Collections.unmodifiableList(this.emojis);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        EmojiCategory emojiCategory = (EmojiCategory)o;
        return this.getId().equals(emojiCategory.getId());
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getId());
    }

    public String toString() {
        return "EmojiCategory{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", emojis=" + this.emojis + '}';
    }
}

