/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.HashUtils;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.Gson;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.List;

class Command {
    private static long requestIdSeed = System.currentTimeMillis();
    private static final Gson sGson = new Gson();
    private String command;
    private String payload;
    private String requestId;

    protected static synchronized String generateRequestId() {
        return String.valueOf(++requestIdSeed);
    }

    public Command(String data) {
        JsonElement el;
        if (data == null || data.length() <= 4) {
            this.command = "NOOP";
            this.payload = "{}";
            return;
        }
        data = data.trim();
        this.command = data.substring(0, 4);
        this.payload = data.substring(4);
        if (this.isRequestIdCommand() && (el = this.getJsonElement()) != null && el.isJsonObject()) {
            JsonObject obj = el.getAsJsonObject();
            this.requestId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
        }
    }

    public Command(String command, JsonElement payload) {
        this(command, payload, null);
    }

    public Command(String command, JsonElement payload, String reqId) {
        this.command = command;
        this.requestId = reqId;
        if (this.requestId == null && this.isRequestIdCommand()) {
            this.requestId = Command.generateRequestId();
        }
        payload.getAsJsonObject().addProperty("req_id", this.requestId);
        this.payload = sGson.toJson(payload);
    }

    protected boolean isAckRequired() {
        return this.command.equals("MESG") || this.command.equals("FILE") || this.command.equals("ENTR") || this.command.equals("EXIT") || this.command.equals("READ") || this.command.equals("MEDI") || this.command.equals("FEDI");
    }

    protected boolean isRequestIdCommand() {
        return this.isAckRequired() || this.command.equals("EROR");
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String encode() {
        return this.command + this.payload + "\n";
    }

    private void decode(String command) {
        command = command.trim();
        this.command = command.substring(0, 4);
        this.payload = command.substring(4);
    }

    public String getCommand() {
        return this.command;
    }

    public String getPayload() {
        return this.payload;
    }

    public JsonElement getJsonElement() {
        return new JsonParser().parse(this.getPayload());
    }

    public static Command bMessage(String requestId, long rootMessageId, long parentMessageId, String channelUrl, String message, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays, List<String> targetLanguages) {
        JsonArray array;
        JsonObject obj = new JsonObject();
        if (parentMessageId > 0L) {
            obj.addProperty("root_message_id", (Number)parentMessageId);
            obj.addProperty("parent_message_id", (Number)parentMessageId);
        }
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("message", message);
        obj.addProperty("data", data);
        obj.addProperty("custom_type", customType);
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
            if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                array = new JsonArray();
                for (String userId : mentionedUserIds) {
                    array.add(userId);
                }
                obj.add("mentioned_user_ids", (JsonElement)array);
            }
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
            obj.addProperty("push_option", "suppress");
        }
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonArray sortedMetaArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                sortedMetaArray.add((JsonElement)metaArray.toJson());
            }
            obj.add("metaarray", (JsonElement)sortedMetaArray);
        }
        if (targetLanguages != null && targetLanguages.size() > 0) {
            array = new JsonArray();
            for (String targetLanguage : targetLanguages) {
                array.add(targetLanguage);
            }
            obj.add("target_langs", (JsonElement)array);
        }
        return new Command(BaseChannel.MessageTypeFilter.USER.value(), (JsonElement)obj, requestId);
    }

    public static Command bUpdateMessage(String channelUrl, long messageId, String message, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, List<MessageMetaArray> metaArrays, Boolean addMetaArray, Boolean metaArrayKey) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("msg_id", (Number)messageId);
        if (message != null) {
            obj.addProperty("message", message);
        }
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
            if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                JsonArray array = new JsonArray();
                for (String userId : mentionedUserIds) {
                    array.add(userId);
                }
                obj.add("mentioned_user_ids", (JsonElement)array);
            }
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonObject metaArrayObj = new JsonObject();
            JsonArray sortedMetaArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                sortedMetaArray.add((JsonElement)metaArray.toJson());
            }
            metaArrayObj.add("array", (JsonElement)sortedMetaArray);
            if (addMetaArray.booleanValue()) {
                metaArrayObj.addProperty("mode", "add");
            } else {
                metaArrayObj.addProperty("mode", "remove");
            }
            metaArrayObj.addProperty("upsert", Boolean.valueOf(true));
            obj.add("metaarray", (JsonElement)metaArrayObj);
        }
        return new Command("MEDI", (JsonElement)obj);
    }

    public static Command bTypeStart(String channelUrl, long time) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("time", (Number)time);
        return new Command("TPST", (JsonElement)obj);
    }

    public static Command bTypeEnd(String channelUrl, long time) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("time", (Number)time);
        return new Command("TPEN", (JsonElement)obj);
    }

    public static Command bRead(String channelUrl) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        return new Command("READ", (JsonElement)obj);
    }

    public static Command bMsgAck(String channelUrl, long msgId) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("msg_id", (Number)msgId);
        return new Command("MACK", (JsonElement)obj);
    }

    public static Command bFile(String requestId, long rootMessageId, long parentMessageId, String channelUrl, String url, String name, String type, int size, String data, String customType, String thumbnails, boolean requireAuth, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, List<MessageMetaArray> metaArrays) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        if (parentMessageId > 0L) {
            obj.addProperty("root_message_id", (Number)parentMessageId);
            obj.addProperty("parent_message_id", (Number)parentMessageId);
        }
        obj.addProperty("url", url);
        obj.addProperty("name", name);
        obj.addProperty("type", type);
        obj.addProperty("size", (Number)size);
        obj.addProperty("custom", data);
        obj.addProperty("custom_type", customType);
        if (thumbnails != null) {
            obj.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        if (requireAuth) {
            obj.addProperty("require_auth", Boolean.valueOf(requireAuth));
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
            if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                JsonArray array = new JsonArray();
                for (String mentionedUserId : mentionedUserIds) {
                    array.add(mentionedUserId);
                }
                obj.add("mentioned_user_ids", (JsonElement)array);
            }
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
            obj.addProperty("push_option", "suppress");
        }
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonArray sortedMetaArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                sortedMetaArray.add((JsonElement)metaArray.toJson());
            }
            obj.add("metaarray", (JsonElement)sortedMetaArray);
        }
        return new Command(BaseChannel.MessageTypeFilter.FILE.value(), (JsonElement)obj, requestId);
    }

    public static Command bUpdateFile(String channelUrl, long messageId, String data, String customType, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, List<MessageMetaArray> metaArrays, Boolean addMetaArray, Boolean metaArrayKey) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("msg_id", (Number)messageId);
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
            if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                JsonArray array = new JsonArray();
                for (String mentionedUserId : mentionedUserIds) {
                    array.add(mentionedUserId);
                }
                obj.add("mentioned_user_ids", (JsonElement)array);
            }
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (metaArrays != null && metaArrays.size() > 0) {
            JsonObject metaArrayObj = new JsonObject();
            JsonArray sortedMetaArray = new JsonArray();
            for (MessageMetaArray metaArray : metaArrays) {
                sortedMetaArray.add((JsonElement)metaArray.toJson());
            }
            metaArrayObj.add("array", (JsonElement)sortedMetaArray);
            if (addMetaArray.booleanValue()) {
                metaArrayObj.addProperty("mode", "add");
            } else {
                metaArrayObj.addProperty("mode", "remove");
            }
            metaArrayObj.addProperty("upsert", Boolean.valueOf(true));
            obj.add("metaarray", (JsonElement)metaArrayObj);
        }
        return new Command("FEDI", (JsonElement)obj);
    }

    public static Command bPing() {
        if (SendBird.getInstance() == null) {
            return null;
        }
        JsonObject obj = new JsonObject();
        if (SendBird.getInstance() != null) {
            obj.addProperty("active", (Number)SendBird.getInstance().isActive());
        }
        return new Command("PING", (JsonElement)obj);
    }

    public static Command bEnter(String channelUrl) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        return new Command("ENTR", (JsonElement)obj);
    }

    public static Command bExit(String channelUrl) {
        JsonObject obj = new JsonObject();
        obj.addProperty("channel_url", channelUrl);
        return new Command("EXIT", (JsonElement)obj);
    }

    public static Command bUnrd() {
        JsonObject obj = new JsonObject();
        return new Command("UNRD", (JsonElement)obj);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Command command = (Command)o;
        return this.getCommand().equals(command.getCommand()) && this.getRequestId().equals(command.getRequestId());
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getCommand(), this.getRequestId());
    }

    public String toString() {
        return "Command{command='" + this.command + '\'' + ", payload='" + this.payload + '\'' + ", requestId='" + this.requestId + '\'' + '}';
    }

    protected boolean hasRequestId() {
        return this.requestId != null && this.requestId.length() > 0;
    }

    public static interface SendCommandHandler {
        public void onResult(Command var1, SendBirdException var2);
    }
}

