/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class AppInfo {
    private final long UNIT_MB = 0x100000L;
    private final String emojiHash;
    private final long uploadSizeLimit;
    private final boolean useReaction;
    private final List<String> premiumFeatureList = new ArrayList<String>();

    AppInfo(JsonObject json) {
        this.emojiHash = json.has("emoji_hash") ? json.get("emoji_hash").getAsString() : "";
        this.uploadSizeLimit = json.has("file_upload_size_limit") ? (long)json.get("file_upload_size_limit").getAsInt() * 0x100000L : Long.MAX_VALUE;
        boolean bl = this.useReaction = json.has("use_reaction") && json.get("use_reaction").getAsBoolean();
        if (json.has("premium_feature_list")) {
            JsonArray featureList = json.getAsJsonArray("premium_feature_list");
            for (JsonElement feature : featureList) {
                this.premiumFeatureList.add(feature.getAsString());
            }
        }
    }

    public String getEmojiHash() {
        return this.emojiHash;
    }

    public long getUploadSizeLimit() {
        return this.uploadSizeLimit;
    }

    public boolean useReaction() {
        return this.useReaction;
    }

    public List<String> getPremiumFeatureList() {
        return this.premiumFeatureList;
    }

    public boolean needUpdateEmoji(String prevEmojiHash) {
        return this.emojiHash == null || !this.emojiHash.equals(prevEmojiHash);
    }

    public String toString() {
        return "AppInfo{emojiHash='" + this.emojiHash + '\'' + ", uploadSizeLimit=" + this.uploadSizeLimit + ", useReaction=" + this.useReaction + ", premiumFeatureList=" + this.premiumFeatureList + '}';
    }
}

