/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;

public final class FileMessage
extends BaseMessage {
    private User mSender;
    private String mUrl;
    private String mName;
    private int mSize;
    private String mType;
    private String mData;
    private String mReqId = "";
    private String mCustomType = "";
    private List<Thumbnail> mThumbnails;

    static JsonElement build(String requestId, long msgId, User user, BaseChannel channel, String url, String name, String type, int size, String data, String customType, String thumbnails, long createdAt) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("msg_id", msgId);
        obj.addProperty("channel_url", channel.getUrl());
        obj.addProperty("channel_type", channel instanceof OpenChannel ? "open" : "group");
        obj.addProperty("ts", createdAt);
        obj.addProperty("url", url);
        obj.addProperty("name", name);
        obj.addProperty("type", type);
        obj.addProperty("size", size);
        if (data != null) {
            obj.addProperty("custom", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (thumbnails != null) {
            obj.add("thumbnails", new JsonParser().parse(thumbnails));
        }
        JsonObject userObj = new JsonObject();
        userObj.addProperty("user_id", user.getUserId());
        userObj.addProperty("nickname", user.getNickname());
        userObj.addProperty("profile_url", user.getProfileUrl());
        obj.add("user", userObj);
        return obj;
    }

    FileMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mSender = new User(obj.get("user"));
        this.mUrl = obj.get("url").getAsString();
        this.mName = obj.has("name") ? obj.get("name").getAsString() : "File";
        this.mSize = obj.get("size").getAsInt();
        this.mType = obj.get("type").getAsString();
        this.mData = obj.has("custom") ? obj.get("custom").getAsString() : "";
        this.mReqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mThumbnails = new ArrayList<Thumbnail>();
        if (obj.has("thumbnails")) {
            JsonArray thumbnailsArray = obj.get("thumbnails").getAsJsonArray();
            for (JsonElement element : thumbnailsArray) {
                Thumbnail thumbnail = new Thumbnail(element);
                this.mThumbnails.add(thumbnail);
            }
        }
    }

    public String getRequestId() {
        return this.mReqId;
    }

    public User getSender() {
        return this.mSender;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getName() {
        return this.mName;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getType() {
        return this.mType;
    }

    public String getData() {
        return this.mData;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public List<Thumbnail> getThumbnails() {
        return this.mThumbnails;
    }

    public static class Thumbnail {
        private int mMaxWidth;
        private int mMaxHeight;
        private String mUrl;

        private Thumbnail(JsonElement el) {
            JsonObject obj = el.getAsJsonObject();
            this.mMaxWidth = obj.has("width") ? obj.get("width").getAsInt() : 0;
            this.mMaxHeight = obj.has("height") ? obj.get("height").getAsInt() : 0;
            this.mUrl = obj.has("url") ? obj.get("url").getAsString() : "";
        }

        public Thumbnail(int maxWidth, int maxHeight) {
            this.mMaxWidth = maxWidth >= 0 ? maxWidth : 0;
            this.mMaxHeight = maxHeight >= 0 ? maxHeight : 0;
            this.mUrl = "";
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public String getUrl() {
            return this.mUrl;
        }
    }
}

